/*
 * Decompiled with CFR 0.152.
 */
package com.displee.cache;

import com.displee.cache.ProgressListener;
import com.displee.cache.index.Index;
import com.displee.cache.index.Index255;
import com.displee.cache.index.Index317;
import com.displee.cache.index.ReferenceTable;
import com.displee.cache.index.archive.Archive;
import com.displee.cache.index.archive.ArchiveSector;
import com.displee.cache.index.archive.file.File;
import com.displee.compress.CompressionType;
import com.displee.compress.type.Compressors;
import com.displee.io.Buffer;
import com.displee.io.impl.OutputBuffer;
import com.displee.util.OtherExtKt;
import com.displee.util.Whirlpool;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 [2\u00020\u0001:\u0001[B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010-\u001a\u00020.J\u0018\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u001f2\b\b\u0002\u00101\u001a\u00020\u0005Jb\u0010/\u001a\u00020\u001f2\b\b\u0002\u00102\u001a\u0002032\b\b\u0002\u00104\u001a\u00020\u001a2\b\b\u0002\u00105\u001a\u00020\u001a2\b\b\u0002\u00106\u001a\u00020\u00052\b\b\u0002\u0010)\u001a\u00020\u00052\b\b\u0002\u00107\u001a\u00020\u00052\b\b\u0002\u00108\u001a\u00020\u00052\b\b\u0002\u00101\u001a\u00020\u00052\b\b\u0002\u00109\u001a\u00020\u001aH\u0007J0\u0010:\u001a\u0004\u0018\u00010;2\u0006\u00100\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u001a2\b\b\u0002\u0010=\u001a\u00020\u001a2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010?H\u0007J.\u0010:\u001a\u0004\u0018\u00010;2\u0006\u00100\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u001a2\u0006\u0010=\u001a\u00020\u00032\n\b\u0002\u0010>\u001a\u0004\u0018\u00010?H\u0007J.\u0010:\u001a\u0004\u0018\u00010;2\u0006\u00100\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u001a2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010?H\u0007J&\u0010:\u001a\u0004\u0018\u00010;2\u0006\u00100\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u00032\n\b\u0002\u0010>\u001a\u0004\u0018\u00010?H\u0007J.\u0010:\u001a\u0004\u0018\u00010;2\u0006\u00100\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u00032\n\b\u0002\u0010>\u001a\u0004\u0018\u00010?H\u0007J\u0006\u0010@\u001a\u00020.J\u000e\u0010A\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u001aJ\b\u0010B\u001a\u0004\u0018\u00010\u001fJ\u000e\u0010C\u001a\u00020.2\u0006\u0010D\u001a\u00020\u0005J*\u0010E\u001a\u00020;2\b\b\u0002\u0010F\u001a\u00020\u00052\n\b\u0002\u0010G\u001a\u0004\u0018\u00010H2\n\b\u0002\u0010I\u001a\u0004\u0018\u00010HH\u0007J\u000e\u00100\u001a\u00020\u001f2\u0006\u00109\u001a\u00020\u001aJ\u0011\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0J\u00a2\u0006\u0002\u0010KJ\b\u0010L\u001a\u00020.H\u0002J\u0006\u0010M\u001a\u00020\u0005J\u0006\u0010N\u001a\u00020\u0005J\u0006\u0010O\u001a\u00020\u0005J\b\u0010P\u001a\u0004\u0018\u00010\u001fJ\b\u0010Q\u001a\u00020.H\u0002J\b\u0010R\u001a\u00020.H\u0002J,\u0010S\u001a\u00020T2\u0006\u00100\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u001a2\u0006\u0010:\u001a\u00020;2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010?H\u0007J4\u0010S\u001a\u00020U2\u0006\u00100\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u001a2\u0006\u0010=\u001a\u00020\u001a2\u0006\u0010:\u001a\u00020;2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010?H\u0007J4\u0010S\u001a\u00020U2\u0006\u00100\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u001a2\u0006\u0010=\u001a\u00020\u00032\u0006\u0010:\u001a\u00020;2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010?H\u0007J,\u0010S\u001a\u00020T2\u0006\u00100\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u00032\u0006\u0010:\u001a\u00020;2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010?H\u0007J4\u0010S\u001a\u00020U2\u0006\u00100\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u00032\u0006\u0010:\u001a\u00020;2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010?H\u0007J\u000e\u0010V\u001a\u00020.2\u0006\u0010W\u001a\u00020XJ\u0006\u0010Y\u001a\u00020.J\u0018\u0010Z\u001a\u0004\u0018\u00010T2\u0006\u00100\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u001aJ \u0010Z\u001a\u0004\u0018\u00010U2\u0006\u00100\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u001a2\u0006\u0010=\u001a\u00020\u001aJ \u0010Z\u001a\u0004\u0018\u00010U2\u0006\u00100\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u001a2\u0006\u0010=\u001a\u00020\u0003J\u0018\u0010Z\u001a\u0004\u0018\u00010T2\u0006\u00100\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u0003J \u0010Z\u001a\u0004\u0018\u00010U2\u0006\u00100\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u0003J\u0006\u0010D\u001a\u00020.R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020!X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006\\"}, d2={"Lcom/displee/cache/CacheLibrary;", "", "path", "", "clearDataAfterUpdate", "", "listener", "Lcom/displee/cache/ProgressListener;", "(Ljava/lang/String;ZLcom/displee/cache/ProgressListener;)V", "getClearDataAfterUpdate", "()Z", "closed", "getClosed", "setClosed", "(Z)V", "compressors", "Lcom/displee/compress/type/Compressors;", "getCompressors", "()Lcom/displee/compress/type/Compressors;", "index255", "Lcom/displee/cache/index/Index255;", "getIndex255", "()Lcom/displee/cache/index/Index255;", "setIndex255", "(Lcom/displee/cache/index/Index255;)V", "indexCount", "", "getIndexCount", "()I", "indices", "Ljava/util/SortedMap;", "Lcom/displee/cache/index/Index;", "mainFile", "Ljava/io/RandomAccessFile;", "getMainFile", "()Ljava/io/RandomAccessFile;", "setMainFile", "(Ljava/io/RandomAccessFile;)V", "getPath", "()Ljava/lang/String;", "rs3", "whirlpool", "Lcom/displee/util/Whirlpool;", "getWhirlpool", "()Lcom/displee/util/Whirlpool;", "close", "", "createIndex", "index", "writeReferenceTable", "compressionType", "Lcom/displee/compress/CompressionType;", "version", "revision", "named", "flag4", "flag8", "id", "data", "", "archive", "file", "xtea", "", "deleteLastIndex", "exists", "first", "fixCrcs", "update", "generateUkeys", "writeWhirlpool", "exponent", "Ljava/math/BigInteger;", "modulus", "", "()[Lcom/displee/cache/index/Index;", "init", "is317", "isOSRS", "isRS3", "last", "load", "load317", "put", "Lcom/displee/cache/index/archive/Archive;", "Lcom/displee/cache/index/archive/file/File;", "rebuild", "directory", "Ljava/io/File;", "reload", "remove", "Companion", "rs-cache-library"})
@SourceDebugExtension(value={"SMAP\nCacheLibrary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheLibrary.kt\ncom/displee/cache/CacheLibrary\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,391:1\n1#2:392\n1855#3,2:393\n1855#3,2:395\n37#4,2:397\n*S KotlinDebug\n*F\n+ 1 CacheLibrary.kt\ncom/displee/cache/CacheLibrary\n*L\n331#1:393,2\n345#1:395,2\n377#1:397,2\n*E\n"})
public class CacheLibrary {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String path;
    private final boolean clearDataAfterUpdate;
    @Nullable
    private final ProgressListener listener;
    public RandomAccessFile mainFile;
    @NotNull
    private final SortedMap<Integer, Index> indices;
    @NotNull
    private final Compressors compressors;
    @NotNull
    private final Whirlpool whirlpool;
    @Nullable
    private Index255 index255;
    private boolean rs3;
    private boolean closed;
    @NotNull
    public static final String CACHE_FILE_NAME = "main_file_cache";

    public CacheLibrary(@NotNull String path, boolean clearDataAfterUpdate, @Nullable ProgressListener listener) {
        Intrinsics.checkNotNullParameter(path, "path");
        this.path = path;
        this.clearDataAfterUpdate = clearDataAfterUpdate;
        this.listener = listener;
        this.indices = new TreeMap();
        this.compressors = new Compressors();
        this.whirlpool = new Whirlpool();
        this.init();
    }

    public /* synthetic */ CacheLibrary(String string2, boolean bl, ProgressListener progressListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            progressListener = null;
        }
        this(string2, bl, progressListener);
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final boolean getClearDataAfterUpdate() {
        return this.clearDataAfterUpdate;
    }

    @NotNull
    public final RandomAccessFile getMainFile() {
        RandomAccessFile randomAccessFile = this.mainFile;
        if (randomAccessFile != null) {
            return randomAccessFile;
        }
        Intrinsics.throwUninitializedPropertyAccessException("mainFile");
        return null;
    }

    public final void setMainFile(@NotNull RandomAccessFile randomAccessFile) {
        Intrinsics.checkNotNullParameter(randomAccessFile, "<set-?>");
        this.mainFile = randomAccessFile;
    }

    @NotNull
    public final Compressors getCompressors() {
        return this.compressors;
    }

    @NotNull
    public final Whirlpool getWhirlpool() {
        return this.whirlpool;
    }

    @Nullable
    public final Index255 getIndex255() {
        return this.index255;
    }

    public final void setIndex255(@Nullable Index255 index255) {
        this.index255 = index255;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void setClosed(boolean bl) {
        this.closed = bl;
    }

    private final int getIndexCount() {
        Set<Integer> set = this.indices.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        Integer n = (Integer)CollectionsKt.maxOrThrow((Iterable)set);
        return n == null ? 0 : n;
    }

    private final void init() {
        java.io.File mainFile317 = new java.io.File(this.path, "main_file_cache.dat");
        java.io.File index255 = new java.io.File(this.path, "main_file_cache.idx255");
        if (mainFile317.exists() && !index255.exists()) {
            this.load317();
        } else {
            this.load();
        }
    }

    public final void reload() {
        this.indices.clear();
        this.init();
    }

    private final void load() throws IOException {
        Index255 index255;
        java.io.File main = new java.io.File(this.path, "main_file_cache.dat2");
        if (!main.exists()) {
            ProgressListener progressListener = this.listener;
            if (progressListener != null) {
                progressListener.notify(-1.0, "Error, main file could not be found");
            }
            throw new FileNotFoundException("File[path=" + main.getAbsolutePath() + "] could not be found.");
        }
        this.setMainFile(new RandomAccessFile(main, "rw"));
        java.io.File index255File = new java.io.File(this.path, "main_file_cache.idx255");
        if (!index255File.exists()) {
            ProgressListener progressListener = this.listener;
            if (progressListener != null) {
                progressListener.notify(-1.0, "Error, checksum file could not be found.");
            }
            throw new FileNotFoundException("File[path=" + index255File.getAbsolutePath() + "] could not be found.");
        }
        this.index255 = index255 = new Index255(this, new RandomAccessFile(index255File, "rw"));
        ProgressListener progressListener = this.listener;
        if (progressListener != null) {
            progressListener.notify(0.0, "Reading indices...");
        }
        int indicesLength = (int)index255.getRaf().length() / 6;
        this.rs3 = indicesLength > 39;
        for (int i = 0; i < indicesLength; ++i) {
            java.io.File file = new java.io.File(this.path, "main_file_cache.idx" + i);
            double progress = (double)i / ((double)indicesLength - 1.0);
            if (!file.exists()) {
                ProgressListener progressListener2 = this.listener;
                if (progressListener2 != null) {
                    progressListener2.notify(progress, "Could not load index " + i + ", missing idx file.");
                }
                continue;
            }
            try {
                Integer n = i;
                ((Map)this.indices).put(n, new Index(this, i, new RandomAccessFile(file, "rw")));
                ProgressListener progressListener3 = this.listener;
                if (progressListener3 == null) continue;
                progressListener3.notify(progress, "Loaded index " + i + '.');
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                ProgressListener progressListener4 = this.listener;
                if (progressListener4 == null) continue;
                progressListener4.notify(progress, "Failed to load index " + i + '.');
                continue;
            }
        }
    }

    private final void load317() throws IOException {
        java.io.File main = new java.io.File(this.path, "main_file_cache.dat");
        if (!main.exists()) {
            ProgressListener progressListener = this.listener;
            if (progressListener != null) {
                progressListener.notify(-1.0, "Error, main file could not be found");
            }
            throw new FileNotFoundException("File[path=" + main.getAbsolutePath() + "] could not be found.");
        }
        this.setMainFile(new RandomAccessFile(main, "rw"));
        java.io.File[] indexFiles = new java.io.File(this.path).listFiles(CacheLibrary::load317$lambda$0);
        if (!(indexFiles != null)) {
            boolean bl = false;
            String string2 = "Files are null. Check your cache path.";
            throw new IllegalStateException(string2.toString());
        }
        ProgressListener progressListener = this.listener;
        if (progressListener != null) {
            progressListener.notify(0.0, "Reading indices...");
        }
        int n = indexFiles.length;
        for (int i = 0; i < n; ++i) {
            java.io.File file = new java.io.File(this.path, "main_file_cache.idx" + i);
            double progress = (double)i / ((double)indexFiles.length - 1.0);
            if (!file.exists()) continue;
            try {
                Integer n2 = i;
                ((Map)this.indices).put(n2, new Index317(this, i, new RandomAccessFile(file, "rw")));
                ProgressListener progressListener2 = this.listener;
                if (progressListener2 == null) continue;
                progressListener2.notify(progress, "Loaded index " + i + " .");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                ProgressListener progressListener3 = this.listener;
                if (progressListener3 == null) continue;
                progressListener3.notify(progress, "Failed to load index " + i + '.');
                continue;
            }
        }
    }

    @JvmOverloads
    @NotNull
    public final Index createIndex(@NotNull CompressionType compressionType, int version, int revision, boolean named, boolean whirlpool, boolean flag4, boolean flag8, boolean writeReferenceTable, int id) {
        Index index;
        Intrinsics.checkNotNullParameter((Object)compressionType, "compressionType");
        RandomAccessFile raf = new RandomAccessFile(new java.io.File(this.path, "main_file_cache.idx" + id), "rw");
        Index it = index = this.is317() ? (Index)new Index317(this, id, raf) : new Index(this, id, raf);
        boolean bl = false;
        Integer n = id;
        ((Map)this.indices).put(n, it);
        Index index2 = index;
        if (!writeReferenceTable) {
            return index2;
        }
        index2.setVersion(version);
        index2.setRevision(revision);
        index2.setCompressionType(compressionType);
        if (named) {
            index2.flagMask(1);
        }
        if (whirlpool) {
            index2.flagMask(2);
        }
        if (this.isRS3()) {
            if (flag4) {
                index2.flagMask(4);
            }
            if (flag8) {
                index2.flagMask(8);
            }
        }
        index2.flag();
        if (!Index.update$default(index2, null, 1, null)) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        return index2;
    }

    public static /* synthetic */ Index createIndex$default(CacheLibrary cacheLibrary, CompressionType compressionType, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createIndex");
        }
        if ((n4 & 1) != 0) {
            compressionType = CompressionType.GZIP;
        }
        if ((n4 & 2) != 0) {
            n = 6;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            bl = false;
        }
        if ((n4 & 0x10) != 0) {
            bl2 = false;
        }
        if ((n4 & 0x20) != 0) {
            bl3 = false;
        }
        if ((n4 & 0x40) != 0) {
            bl4 = false;
        }
        if ((n4 & 0x80) != 0) {
            bl5 = true;
        }
        if ((n4 & 0x100) != 0) {
            n3 = cacheLibrary.indices.isEmpty() ? 0 : cacheLibrary.getIndexCount() + 1;
        }
        return cacheLibrary.createIndex(compressionType, n, n2, bl, bl2, bl3, bl4, bl5, n3);
    }

    @NotNull
    public final Index createIndex(@NotNull Index index, boolean writeReferenceTable) {
        Intrinsics.checkNotNullParameter(index, "index");
        return this.createIndex(index.getCompressionType(), index.getVersion(), index.getRevision(), index.isNamed(), index.hasWhirlpool(), index.hasFlag4(), index.hasFlag8(), writeReferenceTable, index.getId());
    }

    public static /* synthetic */ Index createIndex$default(CacheLibrary cacheLibrary, Index index, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createIndex");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return cacheLibrary.createIndex(index, bl);
    }

    public final boolean exists(int id) {
        return this.indices.containsKey(id);
    }

    @NotNull
    public final Index index(int id) {
        Index index = (Index)this.indices.get(id);
        if (index == null) {
            boolean bl = false;
            String string2 = "Index " + id + " doesn't exist. Please use the {@link exists(int) exists} function to verify whether an index exists.";
            throw new IllegalStateException(string2.toString());
        }
        return index;
    }

    @JvmOverloads
    @NotNull
    public final File put(int index, int archive, int file, @NotNull byte[] data2, @Nullable int[] xtea) {
        Intrinsics.checkNotNullParameter(data2, "data");
        return Archive.add$default(ReferenceTable.add$default((ReferenceTable)this.index(index), archive, 0, xtea, false, 10, null), file, data2, 0, false, 12, null);
    }

    public static /* synthetic */ File put$default(CacheLibrary cacheLibrary, int n, int n2, int n3, byte[] byArray, int[] nArray, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: put");
        }
        if ((n4 & 0x10) != 0) {
            nArray = null;
        }
        return cacheLibrary.put(n, n2, n3, byArray, nArray);
    }

    @JvmOverloads
    @NotNull
    public final Archive put(int index, int archive, @NotNull byte[] data2, @Nullable int[] xtea) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Archive currentArchive = ReferenceTable.add$default((ReferenceTable)this.index(index), archive, -1, xtea, false, 8, null);
        Archive.add$default(currentArchive, 0, data2, 0, false, 12, null);
        return currentArchive;
    }

    public static /* synthetic */ Archive put$default(CacheLibrary cacheLibrary, int n, int n2, byte[] byArray, int[] nArray, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: put");
        }
        if ((n3 & 8) != 0) {
            nArray = null;
        }
        return cacheLibrary.put(n, n2, byArray, nArray);
    }

    @JvmOverloads
    @NotNull
    public final File put(int index, int archive, @NotNull String file, @NotNull byte[] data2, @Nullable int[] xtea) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(data2, "data");
        return Archive.add$default(ReferenceTable.add$default((ReferenceTable)this.index(index), archive, 0, xtea, false, 10, null), file, data2, false, 4, null);
    }

    public static /* synthetic */ File put$default(CacheLibrary cacheLibrary, int n, int n2, String string2, byte[] byArray, int[] nArray, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: put");
        }
        if ((n3 & 0x10) != 0) {
            nArray = null;
        }
        return cacheLibrary.put(n, n2, string2, byArray, nArray);
    }

    @JvmOverloads
    @NotNull
    public final Archive put(int index, @NotNull String archive, @NotNull byte[] data2, @Nullable int[] xtea) {
        Intrinsics.checkNotNullParameter(archive, "archive");
        Intrinsics.checkNotNullParameter(data2, "data");
        Archive currentArchive = this.index(index).add(archive, xtea);
        Archive.add$default(currentArchive, 0, data2, 0, false, 12, null);
        return currentArchive;
    }

    public static /* synthetic */ Archive put$default(CacheLibrary cacheLibrary, int n, String string2, byte[] byArray, int[] nArray, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: put");
        }
        if ((n2 & 8) != 0) {
            nArray = null;
        }
        return cacheLibrary.put(n, string2, byArray, nArray);
    }

    @JvmOverloads
    @NotNull
    public final File put(int index, @NotNull String archive, @NotNull String file, @NotNull byte[] data2, @Nullable int[] xtea) {
        Intrinsics.checkNotNullParameter(archive, "archive");
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(data2, "data");
        return Archive.add$default(this.index(index).add(archive, xtea), file, data2, false, 4, null);
    }

    public static /* synthetic */ File put$default(CacheLibrary cacheLibrary, int n, String string2, String string3, byte[] byArray, int[] nArray, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: put");
        }
        if ((n2 & 0x10) != 0) {
            nArray = null;
        }
        return cacheLibrary.put(n, string2, string3, byArray, nArray);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, int archive, int file, @Nullable int[] xtea) {
        Comparable<Archive> comparable = ReferenceTable.archive$default((ReferenceTable)this.index(index), archive, xtea, false, 4, null);
        return comparable != null && (comparable = ((Archive)comparable).file(file)) != null ? ((File)comparable).getData() : null;
    }

    public static /* synthetic */ byte[] data$default(CacheLibrary cacheLibrary, int n, int n2, int n3, int[] nArray, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: data");
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        if ((n4 & 8) != 0) {
            nArray = null;
        }
        return cacheLibrary.data(n, n2, n3, nArray);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, int archive, @NotNull String file, @Nullable int[] xtea) {
        Intrinsics.checkNotNullParameter(file, "file");
        Comparable<Archive> comparable = ReferenceTable.archive$default((ReferenceTable)this.index(index), archive, xtea, false, 4, null);
        return comparable != null && (comparable = ((Archive)comparable).file(file)) != null ? ((File)comparable).getData() : null;
    }

    public static /* synthetic */ byte[] data$default(CacheLibrary cacheLibrary, int n, int n2, String string2, int[] nArray, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: data");
        }
        if ((n3 & 8) != 0) {
            nArray = null;
        }
        return cacheLibrary.data(n, n2, string2, nArray);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, @NotNull String archive, int file, @Nullable int[] xtea) {
        Intrinsics.checkNotNullParameter(archive, "archive");
        Comparable<Archive> comparable = ReferenceTable.archive$default((ReferenceTable)this.index(index), archive, xtea, false, 4, null);
        return comparable != null && (comparable = ((Archive)comparable).file(file)) != null ? ((File)comparable).getData() : null;
    }

    public static /* synthetic */ byte[] data$default(CacheLibrary cacheLibrary, int n, String string2, int n2, int[] nArray, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: data");
        }
        if ((n3 & 8) != 0) {
            nArray = null;
        }
        return cacheLibrary.data(n, string2, n2, nArray);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, @NotNull String archive, @NotNull String file, @Nullable int[] xtea) {
        Intrinsics.checkNotNullParameter(archive, "archive");
        Intrinsics.checkNotNullParameter(file, "file");
        Comparable<Archive> comparable = ReferenceTable.archive$default((ReferenceTable)this.index(index), archive, xtea, false, 4, null);
        return comparable != null && (comparable = ((Archive)comparable).file(file)) != null ? ((File)comparable).getData() : null;
    }

    public static /* synthetic */ byte[] data$default(CacheLibrary cacheLibrary, int n, String string2, String string3, int[] nArray, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: data");
        }
        if ((n2 & 8) != 0) {
            nArray = null;
        }
        return cacheLibrary.data(n, string2, string3, nArray);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, @NotNull String archive, @Nullable int[] xtea) {
        Intrinsics.checkNotNullParameter(archive, "archive");
        return this.data(index, archive, 0, xtea);
    }

    public static /* synthetic */ byte[] data$default(CacheLibrary cacheLibrary, int n, String string2, int[] nArray, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: data");
        }
        if ((n2 & 4) != 0) {
            nArray = null;
        }
        return cacheLibrary.data(n, string2, nArray);
    }

    @Nullable
    public final File remove(int index, int archive, int file) {
        Archive archive2 = ReferenceTable.archive$default((ReferenceTable)this.index(index), archive, false, 2, null);
        return archive2 != null ? archive2.remove(file) : null;
    }

    @Nullable
    public final File remove(int index, int archive, @NotNull String file) {
        Intrinsics.checkNotNullParameter(file, "file");
        Archive archive2 = ReferenceTable.archive$default((ReferenceTable)this.index(index), archive, false, 2, null);
        return archive2 != null ? archive2.remove(file) : null;
    }

    @Nullable
    public final File remove(int index, @NotNull String archive, @NotNull String file) {
        Intrinsics.checkNotNullParameter(archive, "archive");
        Intrinsics.checkNotNullParameter(file, "file");
        Archive archive2 = ReferenceTable.archive$default((ReferenceTable)this.index(index), archive, false, 2, null);
        return archive2 != null ? archive2.remove(file) : null;
    }

    @Nullable
    public final Archive remove(int index, int archive) {
        return this.index(index).remove(archive);
    }

    @Nullable
    public final Archive remove(int index, @NotNull String archive) {
        Intrinsics.checkNotNullParameter(archive, "archive");
        return this.index(index).remove(archive);
    }

    public final void update() {
        for (Index index : this.indices.values()) {
            if (index.flaggedArchives().length == 0 && !index.flagged()) continue;
            Intrinsics.checkNotNull(index);
            Index.update$default(index, null, 1, null);
        }
    }

    public final void deleteLastIndex() throws RuntimeException {
        if (this.is317()) {
            throw new UnsupportedOperationException("317 not supported to remove indices yet.");
        }
        int id = this.getIndexCount() - 1;
        Index index = (Index)this.indices.get(id);
        if (index == null) {
            return;
        }
        Index index2 = index;
        index2.close();
        java.io.File file = new java.io.File(this.path, "main_file_cache.idx" + id);
        if (!file.exists() || !file.delete()) {
            throw new RuntimeException("Failed to remove the random access file of the argued index[id=" + id + ", file exists=" + file.exists() + ']');
        }
        Object object = this.index255;
        if (object != null && (object = ((Index)object).getRaf()) != null) {
            ((RandomAccessFile)object).setLength((long)id * 6L);
        }
        this.indices.remove(id);
    }

    @JvmOverloads
    @NotNull
    public final byte[] generateUkeys(boolean writeWhirlpool, @Nullable BigInteger exponent, @Nullable BigInteger modulus) {
        OutputBuffer buffer = new OutputBuffer(6 + this.getIndexCount() * 72);
        if (writeWhirlpool) {
            buffer.writeByte(this.getIndexCount());
        }
        byte[] emptyWhirlpool = new byte[64];
        for (Index index : this.indices()) {
            buffer.writeInt(index.getCrc()).writeInt(index.getRevision());
            if (!writeWhirlpool) continue;
            byte[] byArray = index.getWhirlpool();
            if (byArray == null) {
                byArray = emptyWhirlpool;
            }
            buffer.writeBytes(byArray);
        }
        if (writeWhirlpool) {
            byte[] indexData = Buffer.array$default(buffer, 0, 0, 3, null);
            OutputBuffer whirlpoolBuffer = new OutputBuffer(65).writeByte(0).writeBytes(OtherExtKt.generateWhirlpool(indexData, this.whirlpool, 5, indexData.length - 5));
            if (exponent != null && modulus != null) {
                buffer.writeBytes(Buffer.Companion.cryptRSA(Buffer.array$default(whirlpoolBuffer, 0, 0, 3, null), exponent, modulus));
            }
        }
        return Buffer.array$default(buffer, 0, 0, 3, null);
    }

    public static /* synthetic */ byte[] generateUkeys$default(CacheLibrary cacheLibrary, boolean bl, BigInteger bigInteger, BigInteger bigInteger2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateUkeys");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bigInteger = null;
        }
        if ((n & 4) != 0) {
            bigInteger2 = null;
        }
        return cacheLibrary.generateUkeys(bl, bigInteger, bigInteger2);
    }

    public final void rebuild(@NotNull java.io.File directory) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        new java.io.File(directory.getPath()).mkdirs();
        if (this.is317()) {
            new java.io.File(directory.getPath(), "main_file_cache.dat").createNewFile();
        } else {
            new java.io.File(directory.getPath(), "main_file_cache.idx255").createNewFile();
            new java.io.File(directory.getPath(), "main_file_cache.dat2").createNewFile();
        }
        int indicesSize = this.indices.values().size();
        String string2 = directory.getPath();
        Intrinsics.checkNotNullExpressionValue(string2, "getPath(...)");
        CacheLibrary newLibrary = new CacheLibrary(string2, false, null, 6, null);
        for (Index index : this.indices.values()) {
            int id = index.getId();
            System.out.print((Object)("\rBuilding index " + id + '/' + indicesSize + "..."));
            Index255 index255 = this.index255;
            ArchiveSector archiveSector = index255 != null ? index255.readArchiveSector(id) : null;
            boolean writeReferenceTable = true;
            if (!this.is317() && archiveSector == null) {
                writeReferenceTable = false;
            }
            Intrinsics.checkNotNull(index);
            Index newIndex = newLibrary.createIndex(index, writeReferenceTable);
            for (int i : index.archiveIds()) {
                Object object = index.readArchiveSector(i);
                if (object == null) continue;
                byte[] byArray = ((ArchiveSector)object).getData();
                object = byArray;
                if (byArray == null) {
                    continue;
                }
                Object data2 = object;
                newIndex.writeArchiveSector(i, (byte[])data2);
            }
            if (archiveSector == null) continue;
            Index255 index2552 = newLibrary.index255;
            if (index2552 == null) continue;
            index2552.writeArchiveSector(id, archiveSector.getData());
        }
        newLibrary.close();
        System.out.println((Object)("\rFinished building " + indicesSize + " indices."));
    }

    public final void fixCrcs(boolean update2) {
        Collection<Index> collection = this.indices.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Index it = (Index)element$iv;
            boolean bl = false;
            if (it.archiveIds().length == 0) continue;
            it.fixCRCs(update2);
        }
    }

    public final void close() {
        if (this.closed) {
            return;
        }
        this.getMainFile().close();
        Index255 index255 = this.index255;
        if (index255 != null) {
            index255.close();
        }
        Collection<Index> collection = this.indices.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Index it = (Index)element$iv;
            boolean bl = false;
            it.close();
        }
        this.closed = true;
    }

    @Nullable
    public final Index first() {
        if (this.indices.isEmpty()) {
            return null;
        }
        return (Index)this.indices.get(this.indices.firstKey());
    }

    @Nullable
    public final Index last() {
        if (this.indices.isEmpty()) {
            return null;
        }
        return (Index)this.indices.get(this.indices.lastKey());
    }

    public final boolean is317() {
        return this.index255 == null;
    }

    public final boolean isOSRS() {
        Index index = this.index(2);
        return index.getRevision() >= 300 && this.getIndexCount() <= 23;
    }

    public final boolean isRS3() {
        return this.rs3;
    }

    @NotNull
    public final Index[] indices() {
        Collection<Index> collection = this.indices.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Collection<Index> $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection<Index> thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Index[0]);
    }

    @JvmOverloads
    @NotNull
    public final Index createIndex(@NotNull CompressionType compressionType, int version, int revision, boolean named, boolean whirlpool, boolean flag4, boolean flag8, boolean writeReferenceTable) {
        Intrinsics.checkNotNullParameter((Object)compressionType, "compressionType");
        return CacheLibrary.createIndex$default(this, compressionType, version, revision, named, whirlpool, flag4, flag8, writeReferenceTable, 0, 256, null);
    }

    @JvmOverloads
    @NotNull
    public final Index createIndex(@NotNull CompressionType compressionType, int version, int revision, boolean named, boolean whirlpool, boolean flag4, boolean flag8) {
        Intrinsics.checkNotNullParameter((Object)compressionType, "compressionType");
        return CacheLibrary.createIndex$default(this, compressionType, version, revision, named, whirlpool, flag4, flag8, false, 0, 384, null);
    }

    @JvmOverloads
    @NotNull
    public final Index createIndex(@NotNull CompressionType compressionType, int version, int revision, boolean named, boolean whirlpool, boolean flag4) {
        Intrinsics.checkNotNullParameter((Object)compressionType, "compressionType");
        return CacheLibrary.createIndex$default(this, compressionType, version, revision, named, whirlpool, flag4, false, false, 0, 448, null);
    }

    @JvmOverloads
    @NotNull
    public final Index createIndex(@NotNull CompressionType compressionType, int version, int revision, boolean named, boolean whirlpool) {
        Intrinsics.checkNotNullParameter((Object)compressionType, "compressionType");
        return CacheLibrary.createIndex$default(this, compressionType, version, revision, named, whirlpool, false, false, false, 0, 480, null);
    }

    @JvmOverloads
    @NotNull
    public final Index createIndex(@NotNull CompressionType compressionType, int version, int revision, boolean named) {
        Intrinsics.checkNotNullParameter((Object)compressionType, "compressionType");
        return CacheLibrary.createIndex$default(this, compressionType, version, revision, named, false, false, false, false, 0, 496, null);
    }

    @JvmOverloads
    @NotNull
    public final Index createIndex(@NotNull CompressionType compressionType, int version, int revision) {
        Intrinsics.checkNotNullParameter((Object)compressionType, "compressionType");
        return CacheLibrary.createIndex$default(this, compressionType, version, revision, false, false, false, false, false, 0, 504, null);
    }

    @JvmOverloads
    @NotNull
    public final Index createIndex(@NotNull CompressionType compressionType, int version) {
        Intrinsics.checkNotNullParameter((Object)compressionType, "compressionType");
        return CacheLibrary.createIndex$default(this, compressionType, version, 0, false, false, false, false, false, 0, 508, null);
    }

    @JvmOverloads
    @NotNull
    public final Index createIndex(@NotNull CompressionType compressionType) {
        Intrinsics.checkNotNullParameter((Object)compressionType, "compressionType");
        return CacheLibrary.createIndex$default(this, compressionType, 0, 0, false, false, false, false, false, 0, 510, null);
    }

    @JvmOverloads
    @NotNull
    public final Index createIndex() {
        return CacheLibrary.createIndex$default(this, null, 0, 0, false, false, false, false, false, 0, 511, null);
    }

    @JvmOverloads
    @NotNull
    public final File put(int index, int archive, int file, @NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        return CacheLibrary.put$default(this, index, archive, file, data2, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final Archive put(int index, int archive, @NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        return CacheLibrary.put$default(this, index, archive, data2, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final File put(int index, int archive, @NotNull String file, @NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(data2, "data");
        return CacheLibrary.put$default(this, index, archive, file, data2, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final Archive put(int index, @NotNull String archive, @NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter(archive, "archive");
        Intrinsics.checkNotNullParameter(data2, "data");
        return CacheLibrary.put$default(this, index, archive, data2, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final File put(int index, @NotNull String archive, @NotNull String file, @NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter(archive, "archive");
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(data2, "data");
        return CacheLibrary.put$default(this, index, archive, file, data2, null, 16, null);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, int archive, int file) {
        return CacheLibrary.data$default(this, index, archive, file, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, int archive) {
        return CacheLibrary.data$default(this, index, archive, 0, null, 12, null);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, int archive, @NotNull String file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return CacheLibrary.data$default(this, index, archive, file, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, @NotNull String archive, int file) {
        Intrinsics.checkNotNullParameter(archive, "archive");
        return CacheLibrary.data$default(this, index, archive, file, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, @NotNull String archive, @NotNull String file) {
        Intrinsics.checkNotNullParameter(archive, "archive");
        Intrinsics.checkNotNullParameter(file, "file");
        return CacheLibrary.data$default(this, index, archive, file, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, @NotNull String archive) {
        Intrinsics.checkNotNullParameter(archive, "archive");
        return CacheLibrary.data$default(this, index, archive, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final byte[] generateUkeys(boolean writeWhirlpool, @Nullable BigInteger exponent) {
        return CacheLibrary.generateUkeys$default(this, writeWhirlpool, exponent, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final byte[] generateUkeys(boolean writeWhirlpool) {
        return CacheLibrary.generateUkeys$default(this, writeWhirlpool, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final byte[] generateUkeys() {
        return CacheLibrary.generateUkeys$default(this, false, null, null, 7, null);
    }

    private static final boolean load317$lambda$0(java.io.File file, String name) {
        Intrinsics.checkNotNullParameter(file, "<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter(name, "name");
        return StringsKt.startsWith$default(name, "main_file_cache.idx", false, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CacheLibrary create(@NotNull String path, boolean clearDataAfterUpdate, @Nullable ProgressListener listener) {
        return Companion.create(path, clearDataAfterUpdate, listener);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CacheLibrary create(@NotNull String path, boolean clearDataAfterUpdate) {
        return Companion.create(path, clearDataAfterUpdate);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CacheLibrary create(@NotNull String path) {
        return Companion.create(path);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/displee/cache/CacheLibrary$Companion;", "", "()V", "CACHE_FILE_NAME", "", "create", "Lcom/displee/cache/CacheLibrary;", "path", "clearDataAfterUpdate", "", "listener", "Lcom/displee/cache/ProgressListener;", "rs-cache-library"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final CacheLibrary create(@NotNull String path, boolean clearDataAfterUpdate, @Nullable ProgressListener listener) {
            Intrinsics.checkNotNullParameter(path, "path");
            return new CacheLibrary(path, clearDataAfterUpdate, listener);
        }

        public static /* synthetic */ CacheLibrary create$default(Companion companion, String string2, boolean bl, ProgressListener progressListener, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                progressListener = null;
            }
            return companion.create(string2, bl, progressListener);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final CacheLibrary create(@NotNull String path, boolean clearDataAfterUpdate) {
            Intrinsics.checkNotNullParameter(path, "path");
            return com.displee.cache.CacheLibrary$Companion.create$default(this, path, clearDataAfterUpdate, null, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final CacheLibrary create(@NotNull String path) {
            Intrinsics.checkNotNullParameter(path, "path");
            return com.displee.cache.CacheLibrary$Companion.create$default(this, path, false, null, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

