/*
 * Decompiled with CFR 0.152.
 */
package com.displee.cache.index;

import com.displee.cache.CacheLibrary;
import com.displee.cache.ProgressListener;
import com.displee.cache.index.Index255;
import com.displee.cache.index.ReferenceTable;
import com.displee.cache.index.archive.Archive;
import com.displee.cache.index.archive.ArchiveSector;
import com.displee.compress.CompressionExtKt;
import com.displee.compress.CompressionType;
import com.displee.compress.type.Compressor;
import com.displee.compress.type.EmptyCompressor;
import com.displee.io.Buffer;
import com.displee.io.impl.InputBuffer;
import com.displee.io.impl.OutputBuffer;
import com.displee.util.OtherExtKt;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 C2\u00020\u0001:\u0001CB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u00020.J\u0006\u00100\u001a\u00020.J\u000e\u00101\u001a\u00020.2\u0006\u00102\u001a\u00020\nJ\u0011\u00103\u001a\b\u0012\u0004\u0012\u00020504\u00a2\u0006\u0002\u00106J\u0010\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u0005H\u0014J\b\u00109\u001a\u00020.H\u0014J\u0010\u0010:\u001a\u00020\n2\u0006\u00108\u001a\u00020\u0005H\u0014J\u0010\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010=\u001a\u00020\"H\u0016J\u0006\u0010>\u001a\u00020.J\u0014\u00102\u001a\u00020\n2\n\b\u0002\u0010?\u001a\u0004\u0018\u00010@H\u0017J\u0016\u0010A\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010B\u001a\u00020(R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u0006D"}, d2={"Lcom/displee/cache/index/Index;", "Lcom/displee/cache/index/ReferenceTable;", "origin", "Lcom/displee/cache/CacheLibrary;", "id", "", "raf", "Ljava/io/RandomAccessFile;", "(Lcom/displee/cache/CacheLibrary;ILjava/io/RandomAccessFile;)V", "cached", "", "closed", "getClosed", "()Z", "setClosed", "(Z)V", "compressionType", "Lcom/displee/compress/CompressionType;", "getCompressionType", "()Lcom/displee/compress/CompressionType;", "setCompressionType", "(Lcom/displee/compress/CompressionType;)V", "compressor", "Lcom/displee/compress/type/Compressor;", "getCompressor", "()Lcom/displee/compress/type/Compressor;", "setCompressor", "(Lcom/displee/compress/type/Compressor;)V", "crc", "getCrc", "()I", "setCrc", "(I)V", "info", "", "getInfo", "()Ljava/lang/String;", "getRaf", "()Ljava/io/RandomAccessFile;", "whirlpool", "", "getWhirlpool", "()[B", "setWhirlpool", "([B)V", "cache", "", "clear", "close", "fixCRCs", "update", "flaggedArchives", "", "Lcom/displee/cache/index/archive/Archive;", "()[Lcom/displee/cache/index/archive/Archive;", "indexToWrite", "index", "init", "isIndexValid", "readArchiveSector", "Lcom/displee/cache/index/archive/ArchiveSector;", "toString", "unCache", "listener", "Lcom/displee/cache/ProgressListener;", "writeArchiveSector", "data", "Companion", "rs-cache-library"})
@SourceDebugExtension(value={"SMAP\nIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Index.kt\ncom/displee/cache/index/Index\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,323:1\n1#2:324\n1855#3,2:325\n766#3:329\n857#3,2:330\n13309#4,2:327\n37#5,2:332\n*S KotlinDebug\n*F\n+ 1 Index.kt\ncom/displee/cache/index/Index\n*L\n51#1:325,2\n297#1:329\n297#1:330,2\n73#1:327,2\n297#1:332,2\n*E\n"})
public class Index
extends ReferenceTable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RandomAccessFile raf;
    private int crc;
    @Nullable
    private byte[] whirlpool;
    @NotNull
    private CompressionType compressionType;
    @NotNull
    private Compressor compressor;
    private boolean cached;
    private boolean closed;
    public static final int INDEX_SIZE = 6;
    public static final int SECTOR_HEADER_SIZE_SMALL = 8;
    public static final int SECTOR_DATA_SIZE_SMALL = 512;
    public static final int SECTOR_HEADER_SIZE_BIG = 10;
    public static final int SECTOR_DATA_SIZE_BIG = 510;
    public static final int SECTOR_SIZE = 520;
    public static final int WHIRLPOOL_SIZE = 64;

    public Index(@NotNull CacheLibrary origin, int id, @NotNull RandomAccessFile raf) {
        Intrinsics.checkNotNullParameter(origin, "origin");
        Intrinsics.checkNotNullParameter(raf, "raf");
        super(origin, id);
        this.raf = raf;
        this.compressionType = CompressionType.NONE;
        this.compressor = EmptyCompressor.INSTANCE;
        this.init();
    }

    @NotNull
    public final RandomAccessFile getRaf() {
        return this.raf;
    }

    public final int getCrc() {
        return this.crc;
    }

    public final void setCrc(int n) {
        this.crc = n;
    }

    @Nullable
    public final byte[] getWhirlpool() {
        return this.whirlpool;
    }

    public final void setWhirlpool(@Nullable byte[] byArray) {
        this.whirlpool = byArray;
    }

    @NotNull
    public final CompressionType getCompressionType() {
        return this.compressionType;
    }

    public final void setCompressionType(@NotNull CompressionType compressionType) {
        Intrinsics.checkNotNullParameter((Object)compressionType, "<set-?>");
        this.compressionType = compressionType;
    }

    @NotNull
    public final Compressor getCompressor() {
        return this.compressor;
    }

    public final void setCompressor(@NotNull Compressor compressor) {
        Intrinsics.checkNotNullParameter(compressor, "<set-?>");
        this.compressor = compressor;
    }

    protected final boolean getClosed() {
        return this.closed;
    }

    protected final void setClosed(boolean bl) {
        this.closed = bl;
    }

    @NotNull
    public final String getInfo() {
        return "Index[id=" + this.getId() + ", archives=" + this.getArchives().size() + ", compression=" + (Object)((Object)this.compressionType) + ']';
    }

    protected void init() {
        if (this.getId() < 0 || this.getId() >= 255) {
            return;
        }
        Object object = this.getOrigin().getIndex255();
        if (object == null || (object = ((Index)object).readArchiveSector(this.getId())) == null) {
            return;
        }
        Object archiveSector = object;
        byte[] archiveSectorData = ((ArchiveSector)archiveSector).getData();
        this.crc = OtherExtKt.generateCrc$default(archiveSectorData, 0, 0, 3, null);
        this.whirlpool = OtherExtKt.generateWhirlpool$default(archiveSectorData, this.getOrigin().getWhirlpool(), 0, 0, 6, null);
        this.read(new InputBuffer(CompressionExtKt.decompress$default((ArchiveSector)archiveSector, this.getOrigin().getCompressors(), null, 2, null)));
        this.compressionType = ((ArchiveSector)archiveSector).getCompressionType();
        this.compressor = ((ArchiveSector)archiveSector).getCompressor();
    }

    public final void cache() {
        if (!(!this.closed)) {
            boolean $i$a$-check-Index$cache$22 = false;
            String $i$a$-check-Index$cache$22 = "Index is closed.";
            throw new IllegalStateException($i$a$-check-Index$cache$22.toString());
        }
        if (this.cached) {
            return;
        }
        Collection<Archive> collection = this.getArchives().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Archive it = (Archive)element$iv;
            boolean bl = false;
            try {
                this.archive(it.getId(), it.getXtea(), false);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        }
        this.cached = true;
    }

    public final void unCache() {
        for (Archive archive : this.archives()) {
            archive.restore();
        }
        this.cached = false;
    }

    @JvmOverloads
    public boolean update(@Nullable ProgressListener listener) {
        block8: {
            if (!(!this.closed)) {
                boolean bl = false;
                String string2 = "Index is closed.";
                throw new IllegalStateException(string2.toString());
            }
            Archive[] flaggedArchives = this.flaggedArchives();
            double i = 0.0;
            Archive[] $this$forEach$iv2 = flaggedArchives;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv2.length;
            for (int j = 0; j < n; ++j) {
                Archive element$iv;
                Archive it = element$iv = $this$forEach$iv2[j];
                boolean bl = false;
                i += 1.0;
                int n2 = it.getRevision();
                it.setRevision(n2 + 1);
                it.unFlag();
                ProgressListener progressListener = listener;
                if (progressListener != null) {
                    progressListener.notify(i / (double)flaggedArchives.length * 0.8, "Repacking archive " + it.getId() + "...");
                }
                byte[] compressed = CompressionExtKt.compress(it.write(), it.getCompressionType(), it.getCompressor(), it.getXtea(), it.getRevision());
                it.setCrc(OtherExtKt.generateCrc$default(compressed, 0, compressed.length - 2, 1, null));
                it.setWhirlpool(OtherExtKt.generateWhirlpool$default(compressed, this.getOrigin().getWhirlpool(), 0, compressed.length - 2, 2, null));
                boolean written = this.writeArchiveSector(it.getId(), compressed);
                if (!written) {
                    boolean bl2 = false;
                    String string3 = "Unable to write data to archive sector. Your cache may be corrupt.";
                    throw new IllegalStateException(string3.toString());
                }
                if (!this.getOrigin().getClearDataAfterUpdate()) continue;
                it.restore();
            }
            ProgressListener progressListener = listener;
            if (progressListener != null) {
                progressListener.notify(0.85, "Updating checksum table for index " + this.getId() + "...");
            }
            if (!(flaggedArchives.length == 0) && !this.flagged()) {
                this.flag();
            }
            if (this.flagged()) {
                boolean written;
                this.unFlag();
                int $this$forEach$iv2 = this.getRevision();
                this.setRevision($this$forEach$iv2 + 1);
                byte[] indexData = CompressionExtKt.compress$default(this.write(), this.compressionType, this.compressor, null, 0, 12, null);
                this.crc = OtherExtKt.generateCrc$default(indexData, 0, 0, 3, null);
                this.whirlpool = OtherExtKt.generateWhirlpool$default(indexData, this.getOrigin().getWhirlpool(), 0, 0, 6, null);
                Index255 index255 = this.getOrigin().getIndex255();
                boolean bl = written = index255 != null ? index255.writeArchiveSector(this.getId(), indexData) : false;
                if (!written) {
                    boolean bl3 = false;
                    String string4 = "Unable to write data to checksum table. Your cache may be corrupt.";
                    throw new IllegalStateException(string4.toString());
                }
            }
            ProgressListener progressListener2 = listener;
            if (progressListener2 == null) break block8;
            progressListener2.notify(1.0, "Successfully updated index " + this.getId() + '.');
        }
        return true;
    }

    public static /* synthetic */ boolean update$default(Index index, ProgressListener progressListener, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 1) != 0) {
            progressListener = null;
        }
        return index.update(progressListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final ArchiveSector readArchiveSector(int id) {
        if (!(!this.closed)) {
            boolean bl = false;
            String string2 = "Index is closed.";
            throw new IllegalStateException(string2.toString());
        }
        RandomAccessFile randomAccessFile = this.getOrigin().getMainFile();
        synchronized (randomAccessFile) {
            block21: {
                int sectorDataSize;
                block20: {
                    boolean bl = false;
                    try {
                        if (this.getOrigin().getMainFile().length() >= (long)(6 * id + 6)) break block20;
                        ArchiveSector archiveSector = null;
                        return archiveSector;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Unit unit = Unit.INSTANCE;
                        break block21;
                    }
                }
                byte[] sectorData = new byte[520];
                this.raf.seek((long)id * (long)6);
                this.raf.read(sectorData, 0, 6);
                boolean bigSector = id > 65535;
                InputBuffer buffer = new InputBuffer(sectorData);
                ArchiveSector archiveSector = new ArchiveSector(bigSector, buffer.read24BitInt(), buffer.read24BitInt(), 0, 0, 24, null);
                if (archiveSector.getSize() < 0 || archiveSector.getPosition() <= 0 || (long)archiveSector.getPosition() > this.getOrigin().getMainFile().length() / (long)520) {
                    ArchiveSector archiveSector2 = null;
                    return archiveSector2;
                }
                int read2 = 0;
                int chunk = 0;
                int sectorHeaderSize = bigSector ? 10 : 8;
                int n = sectorDataSize = bigSector ? 510 : 512;
                while (read2 < archiveSector.getSize()) {
                    if (archiveSector.getPosition() == 0) {
                        ArchiveSector archiveSector3 = null;
                        return archiveSector3;
                    }
                    int requiredToRead = archiveSector.getSize() - read2;
                    if (requiredToRead > sectorDataSize) {
                        requiredToRead = sectorDataSize;
                    }
                    this.getOrigin().getMainFile().seek((long)archiveSector.getPosition() * (long)520);
                    this.getOrigin().getMainFile().read(buffer.raw(), 0, requiredToRead + sectorHeaderSize);
                    buffer.setOffset(0);
                    archiveSector.read(buffer);
                    if (!this.isIndexValid(archiveSector.getIndex()) || id != archiveSector.getId() || chunk != archiveSector.getChunk()) {
                        ArchiveSector archiveSector4 = null;
                        return archiveSector4;
                    }
                    if (archiveSector.getNextPosition() < 0 || (long)archiveSector.getNextPosition() > this.getOrigin().getMainFile().length() / (long)520) {
                        ArchiveSector archiveSector5 = null;
                        return archiveSector5;
                    }
                    byte[] bufferData = buffer.raw();
                    int n2 = requiredToRead;
                    for (int i = 0; i < n2; ++i) {
                        archiveSector.getData()[read2++] = bufferData[i + sectorHeaderSize];
                    }
                    archiveSector.setPosition(archiveSector.getNextPosition());
                    ++chunk;
                }
                ArchiveSector archiveSector6 = archiveSector;
                return archiveSector6;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean writeArchiveSector(int id, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter(data, "data");
        if (!(this.closed == false)) {
            $i$a$-check-Index$writeArchiveSector$1 = false;
            var3_4 = "Index is closed.";
            throw new IllegalStateException(var3_4.toString());
        }
        var3_5 = this.getOrigin().getMainFile();
        synchronized (var3_5) {
            $i$a$-synchronized-Index$writeArchiveSector$2 = false;
            try {
                position = 0;
                archive = null;
                archiveSector = this.readArchiveSector(id);
                if (this.getId() != 255) {
                    archive = this.archive(id, null, true);
                }
                if (this.getId() == 255 && archiveSector != null) ** GOTO lbl-1000
                v0 = archive;
                v1 = v0 != null ? !v0.getNew() : false;
                if (v1) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = false;
                }
                overWrite = v2;
                sectorData = new byte[520];
                v3 = bigSector = id > 65535;
                if (overWrite) {
                    if ((long)(6 * id + 6) > this.raf.length()) {
                        return false;
                    }
                    this.raf.seek((long)id * (long)6);
                    this.raf.read(sectorData, 0, 6);
                    buffer = new InputBuffer(sectorData);
                    buffer.setOffset(buffer.getOffset() + 3);
                    position = buffer.read24BitInt();
                    if (position <= 0) return false;
                    if ((long)position > this.getOrigin().getMainFile().length() / (long)520) {
                        return false;
                    }
                } else {
                    position = (int)((this.getOrigin().getMainFile().length() + (long)519) / (long)520);
                    if (position == 0) {
                        position = 1;
                    }
                    archiveSector = new ArchiveSector(bigSector, data.length, position, id, this.indexToWrite(this.getId()));
                }
                if (archiveSector == null) {
                    return false;
                }
                buffer = new OutputBuffer(6);
                buffer.write24BitInt(data.length);
                buffer.write24BitInt(position);
                this.raf.seek((long)id * (long)6);
                this.raf.write(Buffer.array$default(buffer, 0, 0, 3, null), 0, 6);
                written = 0;
                chunk = 0;
                archiveHeaderSize = bigSector != false ? 10 : 8;
                archiveDataSize = bigSector != false ? 510 : 512;
                while (written < data.length) {
                    currentPosition = 0;
                    if (overWrite) {
                        this.getOrigin().getMainFile().seek((long)position * (long)520);
                        this.getOrigin().getMainFile().read(sectorData, 0, archiveHeaderSize);
                        archiveSector.read(new InputBuffer(sectorData));
                        currentPosition = archiveSector.getNextPosition();
                        if (archiveSector.getId() != id) return false;
                        if (archiveSector.getChunk() != chunk) return false;
                        if (!this.isIndexValid(archiveSector.getIndex())) {
                            return false;
                        }
                        if (currentPosition < 0) return false;
                        if (this.getOrigin().getMainFile().length() / (long)520 < (long)currentPosition) {
                            return false;
                        }
                    }
                    if (currentPosition == 0) {
                        overWrite = false;
                        currentPosition = (int)((this.getOrigin().getMainFile().length() + (long)519) / (long)520);
                        if (currentPosition == 0) {
                            ++currentPosition;
                        }
                        if (currentPosition == position) {
                            ++currentPosition;
                        }
                    }
                    if (data.length - written <= archiveDataSize) {
                        currentPosition = 0;
                    }
                    archiveSector.setChunk(chunk);
                    archiveSector.setPosition(currentPosition);
                    this.getOrigin().getMainFile().seek((long)position * (long)520);
                    this.getOrigin().getMainFile().write(archiveSector.write(), 0, archiveHeaderSize);
                    length = data.length - written;
                    if (length > archiveDataSize) {
                        length = archiveDataSize;
                    }
                    this.getOrigin().getMainFile().write(data, written, length);
                    written += length;
                    position = currentPosition;
                    ++chunk;
                }
                return true;
            }
            catch (Throwable t) {
                t.printStackTrace();
                return false;
            }
        }
    }

    public final void fixCRCs(boolean update2) {
        Object object;
        boolean flag;
        block11: {
            block10: {
                if (!(!this.closed)) {
                    boolean $i$a$-check-Index$fixCRCs$22 = false;
                    String $i$a$-check-Index$fixCRCs$22 = "Index is closed.";
                    throw new IllegalStateException($i$a$-check-Index$fixCRCs$22.toString());
                }
                if (this.is317()) {
                    return;
                }
                int[] archiveIds = this.archiveIds();
                flag = false;
                for (int i : archiveIds) {
                    Archive archive;
                    int currentCRC;
                    ArchiveSector sector;
                    if (this.readArchiveSector(i) == null) continue;
                    int correctCRC = OtherExtKt.generateCrc$default(sector.getData(), 0, sector.getData().length - 2, 1, null);
                    if (ReferenceTable.archive$default((ReferenceTable)this, i, false, 2, null) == null || (currentCRC = archive.getCrc()) == correctCRC) continue;
                    System.out.println((Object)("Incorrect CRC in index " + this.getId() + " -> archive " + i + ", current_crc=" + currentCRC + ", correct_crc=" + correctCRC));
                    archive.flag();
                    flag = true;
                }
                object = this.getOrigin().getIndex255();
                if (object == null || (object = ((Index)object).readArchiveSector(this.getId())) == null) break block10;
                byte[] byArray = ((ArchiveSector)object).getData();
                object = byArray;
                if (byArray != null) break block11;
            }
            return;
        }
        Object sectorData = object;
        int indexCRC = OtherExtKt.generateCrc$default((byte[])sectorData, 0, 0, 3, null);
        if (this.crc != indexCRC) {
            flag = true;
        }
        if (flag && update2) {
            Index.update$default(this, null, 1, null);
        } else if (!flag) {
            System.out.println((Object)"No invalid CRCs found.");
            return;
        }
        this.unCache();
    }

    public final void clear() {
        this.getArchives().clear();
        this.crc = 0;
        this.whirlpool = new byte[64];
    }

    public final void close() {
        if (this.closed) {
            return;
        }
        this.raf.close();
        this.closed = true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Archive[] flaggedArchives() {
        void $this$filterTo$iv$iv;
        Collection<Archive> collection = this.getArchives().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Archive it = (Archive)element$iv$iv;
            boolean bl = false;
            if (!it.flagged()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Archive[0]);
    }

    protected boolean isIndexValid(int index) {
        return this.getId() == index;
    }

    protected int indexToWrite(int index) {
        return index;
    }

    @NotNull
    public String toString() {
        return "Index " + this.getId();
    }

    @JvmOverloads
    public final boolean update() {
        return Index.update$default(this, null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/displee/cache/index/Index$Companion;", "", "()V", "INDEX_SIZE", "", "SECTOR_DATA_SIZE_BIG", "SECTOR_DATA_SIZE_SMALL", "SECTOR_HEADER_SIZE_BIG", "SECTOR_HEADER_SIZE_SMALL", "SECTOR_SIZE", "WHIRLPOOL_SIZE", "rs-cache-library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

