/*
 * Decompiled with CFR 0.152.
 */
package com.displee.cache.index;

import com.displee.cache.CacheLibrary;
import com.displee.cache.ProgressListener;
import com.displee.cache.index.Index;
import com.displee.cache.index.Index317;
import com.displee.cache.index.ReferenceTable;
import com.displee.cache.index.archive.Archive;
import com.displee.cache.index.archive.Archive317;
import com.displee.cache.index.archive.file.File;
import com.displee.io.Buffer;
import com.displee.io.impl.InputBuffer;
import com.displee.io.impl.OutputBuffer;
import com.displee.util.OtherExtKt;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0002!\"B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0014J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0005H\u0014J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0015H\u0016J\u0012\u0010\u001a\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006#"}, d2={"Lcom/displee/cache/index/Index317;", "Lcom/displee/cache/index/Index;", "origin", "Lcom/displee/cache/CacheLibrary;", "id", "", "raf", "Ljava/io/RandomAccessFile;", "(Lcom/displee/cache/CacheLibrary;ILjava/io/RandomAccessFile;)V", "indexToWrite", "index", "init", "", "isIndexValid", "", "read", "buffer", "Lcom/displee/io/impl/InputBuffer;", "readArchiveProperties", "", "fileId", "", "type", "Lcom/displee/cache/index/Index317$BufferType;", "toHash", "name", "update", "listener", "Lcom/displee/cache/ProgressListener;", "write", "", "writeArchiveProperties", "properties", "BufferType", "Companion", "rs-cache-library"})
@SourceDebugExtension(value={"SMAP\nIndex317.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Index317.kt\ncom/displee/cache/index/Index317\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,161:1\n1#2:162\n13309#3,2:163\n13330#3,2:165\n*S KotlinDebug\n*F\n+ 1 Index317.kt\ncom/displee/cache/index/Index317\n*L\n56#1:163,2\n122#1:165,2\n*E\n"})
public final class Index317
extends Index {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int CONFIG_INDEX = 0;
    private static final int VERSION_ARCHIVE = 5;
    @NotNull
    private static final List<String> VERSION_FILES;
    @NotNull
    private static final List<String> CRC_FILES;

    public Index317(@NotNull CacheLibrary origin, int id, @NotNull RandomAccessFile raf) {
        Intrinsics.checkNotNullParameter(origin, "origin");
        Intrinsics.checkNotNullParameter(raf, "raf");
        super(origin, id, raf);
    }

    @Override
    protected void init() {
        int n;
        try {
            n = (int)(this.getRaf().length() / 6L);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        int archiveLength = n;
        int[] versions = null;
        int[] crcs = null;
        if (this.getId() != 0 && this.getId() < VERSION_FILES.size()) {
            versions = this.readArchiveProperties(VERSION_FILES.get(this.getId() - 1), BufferType.SHORT);
            crcs = this.readArchiveProperties(CRC_FILES.get(this.getId() - 1), BufferType.INT);
        }
        for (int i = 0; i < archiveLength; ++i) {
            if (this.readArchiveSector(i) == null) continue;
            Archive317 archive = new Archive317(this.getOrigin().getCompressors().getBzip2(), i);
            Integer n2 = i;
            ((Map)this.getArchives()).put(n2, archive);
            if (versions == null || crcs == null || i >= versions.length || i >= crcs.length) continue;
            archive.setRevision(versions[i]);
            archive.setCrc(crcs[i]);
        }
    }

    @Override
    public void read(@NotNull InputBuffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
    }

    @Override
    @NotNull
    public byte[] write() {
        return new byte[0];
    }

    @Override
    public boolean update(@Nullable ProgressListener listener) {
        block7: {
            if (!(!this.getClosed())) {
                boolean $i$a$-check-Index317$update$22 = false;
                String $i$a$-check-Index317$update$22 = "Index is closed.";
                throw new IllegalStateException($i$a$-check-Index317$update$22.toString());
            }
            Archive[] flaggedArchives = this.flaggedArchives();
            Archive[] archives = this.archives();
            double i = 0.0;
            Archive[] $this$forEach$iv = flaggedArchives;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                Archive element$iv;
                Archive it = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                i += 1.0;
                int n2 = it.getRevision();
                it.setRevision(n2 + 1);
                it.unFlag();
                ProgressListener progressListener = listener;
                if (progressListener != null) {
                    progressListener.notify(i / (double)flaggedArchives.length * 0.8, "Repacking archive " + it.getId() + "...");
                }
                byte[] compressed = it.write();
                it.setCrc(OtherExtKt.generateCrc$default(compressed, 0, 0, 3, null));
                it.setWhirlpool(OtherExtKt.generateWhirlpool$default(compressed, this.getOrigin().getWhirlpool(), 0, 0, 6, null));
                boolean written = this.writeArchiveSector(it.getId(), compressed);
                if (!written) {
                    boolean bl2 = false;
                    String string2 = "Unable to write data to archive sector. Your cache may be corrupt.";
                    throw new IllegalStateException(string2.toString());
                }
                if (!this.getOrigin().getClearDataAfterUpdate()) continue;
                it.restore();
            }
            ProgressListener progressListener = listener;
            if (progressListener != null) {
                progressListener.notify(0.85, "Updating version archives for index " + this.getId() + "...");
            }
            if (!(flaggedArchives.length == 0) && !this.flagged()) {
                this.flag();
            }
            if (this.getId() != 0 && this.flagged()) {
                int[] nArray = Arrays.stream(archives).mapToInt(arg_0 -> Index317.update$lambda$3(update.3.INSTANCE, arg_0)).toArray();
                Intrinsics.checkNotNullExpressionValue(nArray, "toArray(...)");
                this.writeArchiveProperties(nArray, VERSION_FILES.get(this.getId() - 1), BufferType.SHORT);
                int[] nArray2 = Arrays.stream(archives).mapToInt(arg_0 -> Index317.update$lambda$4(update.4.INSTANCE, arg_0)).toArray();
                Intrinsics.checkNotNullExpressionValue(nArray2, "toArray(...)");
                this.writeArchiveProperties(nArray2, CRC_FILES.get(this.getId() - 1), BufferType.INT);
            }
            ProgressListener progressListener2 = listener;
            if (progressListener2 == null) break block7;
            progressListener2.notify(1.0, "Successfully updated index " + this.getId() + '.');
        }
        return true;
    }

    private final int[] readArchiveProperties(String fileId, BufferType type2) {
        Function0 function0;
        Object object;
        block11: {
            block10: {
                if (this.getId() == 0 || this.getId() > VERSION_FILES.size()) {
                    return null;
                }
                object = ReferenceTable.archive$default((ReferenceTable)this.getOrigin().index(0), 5, false, 2, null);
                if (object == null || (object = ((Archive)object).file(fileId)) == null) break block10;
                byte[] byArray = ((File)object).getData();
                object = byArray;
                if (byArray != null) break block11;
            }
            return null;
        }
        Object data2 = object;
        InputBuffer buffer = new InputBuffer((byte[])data2);
        int[] properties2 = new int[((Object)data2).length / (1 << type2.ordinal())];
        switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: {
                function0 = new Function0<Integer>(buffer){
                    final /* synthetic */ InputBuffer $buffer;
                    {
                        this.$buffer = $buffer;
                        super(0);
                    }

                    @NotNull
                    public final Integer invoke() {
                        return this.$buffer.readUnsignedByte();
                    }
                };
                break;
            }
            case 2: {
                function0 = new Function0<Integer>(buffer){
                    final /* synthetic */ InputBuffer $buffer;
                    {
                        this.$buffer = $buffer;
                        super(0);
                    }

                    @NotNull
                    public final Integer invoke() {
                        return this.$buffer.readUnsignedShort();
                    }
                };
                break;
            }
            case 3: {
                function0 = new Function0<Integer>(buffer){
                    final /* synthetic */ InputBuffer $buffer;
                    {
                        this.$buffer = $buffer;
                        super(0);
                    }

                    @NotNull
                    public final Integer invoke() {
                        return this.$buffer.readInt();
                    }
                };
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Function0 bufferFun2 = function0;
        int n = properties2.length;
        for (int i = 0; i < n; ++i) {
            properties2[i] = ((Number)bufferFun2.invoke()).intValue();
        }
        return properties2;
    }

    private final boolean writeArchiveProperties(int[] properties2, String fileId, BufferType type2) {
        Index index;
        block7: {
            Function1 function1;
            if (this.getId() == 0 || this.getId() > VERSION_FILES.size()) {
                return false;
            }
            OutputBuffer buffer = new OutputBuffer(properties2.length);
            switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
                case 1: {
                    function1 = new Function1<Integer, Unit>(buffer){
                        final /* synthetic */ OutputBuffer $buffer;
                        {
                            this.$buffer = $buffer;
                            super(1);
                        }

                        public final void invoke(int it) {
                            this.$buffer.writeByte(it);
                        }
                    };
                    break;
                }
                case 2: {
                    function1 = new Function1<Integer, Unit>(buffer){
                        final /* synthetic */ OutputBuffer $buffer;
                        {
                            this.$buffer = $buffer;
                            super(1);
                        }

                        public final void invoke(int it) {
                            this.$buffer.writeShort(it);
                        }
                    };
                    break;
                }
                case 3: {
                    function1 = new Function1<Integer, Unit>(buffer){
                        final /* synthetic */ OutputBuffer $buffer;
                        {
                            this.$buffer = $buffer;
                            super(1);
                        }

                        public final void invoke(int it) {
                            this.$buffer.writeInt(it);
                        }
                    };
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Function1 bufferFun2 = function1;
            int[] $this$forEach$iv = properties2;
            boolean $i$f$forEach = false;
            for (int element$iv : $this$forEach$iv) {
                bufferFun2.invoke(element$iv);
            }
            index = this.getOrigin().index(0);
            Archive archive = ReferenceTable.archive$default((ReferenceTable)index, 5, false, 2, null);
            if (archive == null) break block7;
            Archive.add$default(archive, fileId, Buffer.array$default(buffer, 0, 0, 3, null), false, 4, null);
        }
        return Index.update$default(index, null, 1, null);
    }

    @Override
    public int toHash(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return OtherExtKt.hashCode317(name);
    }

    @Override
    protected boolean isIndexValid(int index) {
        return this.getId() == index - 1;
    }

    @Override
    protected int indexToWrite(int index) {
        return index + 1;
    }

    private static final int update$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final int update$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    @JvmStatic
    public static final void addMetaFiles(@NotNull String versionFile, @NotNull String crcFile) {
        Companion.addMetaFiles(versionFile, crcFile);
    }

    static {
        String[] stringArray = new String[]{"model_version", "anim_version", "midi_version", "map_version"};
        VERSION_FILES = CollectionsKt.mutableListOf(stringArray);
        stringArray = new String[]{"model_crc", "anim_crc", "midi_crc", "map_crc"};
        CRC_FILES = CollectionsKt.mutableListOf(stringArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/displee/cache/index/Index317$BufferType;", "", "(Ljava/lang/String;I)V", "BYTE", "SHORT", "INT", "rs-cache-library"})
    private static final class BufferType
    extends Enum<BufferType> {
        public static final /* enum */ BufferType BYTE = new BufferType();
        public static final /* enum */ BufferType SHORT = new BufferType();
        public static final /* enum */ BufferType INT = new BufferType();
        private static final /* synthetic */ BufferType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static BufferType[] values() {
            return (BufferType[])$VALUES.clone();
        }

        public static BufferType valueOf(String value) {
            return Enum.valueOf(BufferType.class, value);
        }

        @NotNull
        public static EnumEntries<BufferType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = bufferTypeArray = new BufferType[]{BufferType.BYTE, BufferType.SHORT, BufferType.INT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/displee/cache/index/Index317$Companion;", "", "()V", "CONFIG_INDEX", "", "CRC_FILES", "", "", "VERSION_ARCHIVE", "VERSION_FILES", "addMetaFiles", "", "versionFile", "crcFile", "rs-cache-library"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void addMetaFiles(@NotNull String versionFile, @NotNull String crcFile) {
            Intrinsics.checkNotNullParameter(versionFile, "versionFile");
            Intrinsics.checkNotNullParameter(crcFile, "crcFile");
            VERSION_FILES.add(versionFile);
            CRC_FILES.add(crcFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BufferType.values().length];
            try {
                nArray[BufferType.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferType.SHORT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferType.INT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

