/*
 * Decompiled with CFR 0.152.
 */
package com.displee.cache.index.archive;

import com.displee.cache.index.archive.file.File;
import com.displee.compress.CompressionType;
import com.displee.compress.type.Compressor;
import com.displee.compress.type.EmptyCompressor;
import com.displee.compress.type.GZIPCompressor;
import com.displee.io.Buffer;
import com.displee.io.impl.InputBuffer;
import com.displee.io.impl.OutputBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010E\u001a\u00020\u001e2\u0006\u0010F\u001a\u00020\u001e2\b\b\u0002\u0010G\u001a\u00020.H\u0007J1\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001e0H2\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0H\"\u00020\u001e2\b\b\u0002\u0010G\u001a\u00020.H\u0007\u00a2\u0006\u0002\u0010IJ\u000e\u0010E\u001a\u00020\u001e2\u0006\u0010J\u001a\u00020;J,\u0010E\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010J\u001a\u00020;2\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010G\u001a\u00020.H\u0007J\"\u0010E\u001a\u00020\u001e2\u0006\u0010K\u001a\u00020L2\u0006\u0010J\u001a\u00020;2\b\b\u0002\u0010G\u001a\u00020.H\u0007J\u0006\u0010M\u001a\u00020NJ\u0011\u0010O\u001a\u00020\u00032\u0006\u0010P\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010Q\u001a\u00020.2\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010Q\u001a\u00020.2\u0006\u0010K\u001a\u00020LJ\u0006\u0010R\u001a\u00020.J\u0011\u0010S\u001a\b\u0012\u0004\u0012\u00020\u001e0H\u00a2\u0006\u0002\u0010TJ\u0010\u0010F\u001a\u0004\u0018\u00010\u001e2\u0006\u0010J\u001a\u00020;J\u0010\u0010F\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010F\u001a\u0004\u0018\u00010\u001e2\u0006\u0010K\u001a\u00020LJ\u000e\u0010U\u001a\u00020\u00032\u0006\u0010K\u001a\u00020LJ\u0006\u0010V\u001a\u00020\tJ\u0011\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0H\u00a2\u0006\u0002\u0010TJ\b\u0010W\u001a\u0004\u0018\u00010\u001eJ\u0006\u0010X\u001a\u00020NJ\u0006\u0010Y\u001a\u00020.J\b\u0010Z\u001a\u0004\u0018\u00010\u001eJ\u0006\u0010[\u001a\u00020\u0003J\u0010\u00104\u001a\u00020N2\u0006\u0010\\\u001a\u00020]H\u0016J\u0010\u0010^\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010^\u001a\u0004\u0018\u00010\u001e2\u0006\u0010K\u001a\u00020LJ\u0006\u0010_\u001a\u00020NJ\u0010\u0010`\u001a\u00020\u00032\u0006\u0010K\u001a\u00020LH\u0016J\b\u0010a\u001a\u00020LH\u0016J\u0006\u0010b\u001a\u00020NJ\b\u0010c\u001a\u00020;H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0012\u0010\b\u001a\u00020N2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u0004R\u001d\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001e0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001a\"\u0004\b#\u0010\u0004R\u001a\u0010$\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001a\"\u0004\b&\u0010\u0004R\u001a\u0010'\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u001a\"\u0004\b)\u0010\u0004R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u001a\"\u0004\b+\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001aR\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00101\"\u0004\b6\u00103R\u001a\u00107\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u001a\"\u0004\b9\u0010\u0004R\u001c\u0010:\u001a\u0004\u0018\u00010;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R(\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010@\u001a\u0004\u0018\u00010\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bA\u0010B\"\u0004\bC\u0010D\u00a8\u0006d"}, d2={"Lcom/displee/cache/index/archive/Archive;", "", "id", "", "(I)V", "archive", "(Lcom/displee/cache/index/archive/Archive;)V", "hashName", "xtea", "", "(II[I)V", "_xtea", "compressionType", "Lcom/displee/compress/CompressionType;", "getCompressionType", "()Lcom/displee/compress/CompressionType;", "setCompressionType", "(Lcom/displee/compress/CompressionType;)V", "compressor", "Lcom/displee/compress/type/Compressor;", "getCompressor", "()Lcom/displee/compress/type/Compressor;", "setCompressor", "(Lcom/displee/compress/type/Compressor;)V", "crc", "getCrc", "()I", "setCrc", "files", "Ljava/util/SortedMap;", "Lcom/displee/cache/index/archive/file/File;", "getFiles", "()Ljava/util/SortedMap;", "flag4Value1", "getFlag4Value1", "setFlag4Value1", "flag4Value2", "getFlag4Value2", "setFlag4Value2", "flag8Value", "getFlag8Value", "setFlag8Value", "getHashName", "setHashName", "getId", "needUpdate", "", "new", "getNew", "()Z", "setNew", "(Z)V", "read", "getRead", "setRead", "revision", "getRevision", "setRevision", "whirlpool", "", "getWhirlpool", "()[B", "setWhirlpool", "([B)V", "value", "getXtea", "()[I", "setXtea", "([I)V", "add", "file", "overwrite", "", "([Lcom/displee/cache/index/archive/file/File;Z)[Lcom/displee/cache/index/archive/file/File;", "data", "name", "", "clear", "", "compareTo", "other", "contains", "containsData", "copyFiles", "()[Lcom/displee/cache/index/archive/file/File;", "fileId", "fileIds", "first", "flag", "flagged", "last", "nextId", "buffer", "Lcom/displee/io/impl/InputBuffer;", "remove", "restore", "toHash", "toString", "unFlag", "write", "rs-cache-library"})
@SourceDebugExtension(value={"SMAP\nArchive.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Archive.kt\ncom/displee/cache/index/archive/Archive\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,306:1\n13309#2,2:307\n13309#2,2:309\n13309#2,2:311\n37#3,2:313\n37#3,2:332\n37#3,2:334\n1#4:315\n494#5,7:316\n494#5,7:323\n1855#6,2:330\n*S KotlinDebug\n*F\n+ 1 Archive.kt\ncom/displee/cache/index/archive/Archive\n*L\n103#1:307,2\n109#1:309,2\n134#1:311,2\n135#1:313,2\n247#1:332,2\n285#1:334,2\n187#1:316,7\n191#1:323,7\n228#1:330,2\n*E\n"})
public class Archive
implements Comparable<Archive> {
    private final int id;
    private int hashName;
    @NotNull
    private CompressionType compressionType;
    @NotNull
    private Compressor compressor;
    private int revision;
    private boolean needUpdate;
    @NotNull
    private final SortedMap<Integer, File> files;
    private int crc;
    @Nullable
    private byte[] whirlpool;
    private int flag8Value;
    private int flag4Value1;
    private int flag4Value2;
    @Nullable
    private int[] _xtea;
    private boolean read;
    private boolean new;

    public Archive(int id, int hashName, @Nullable int[] xtea) {
        this.id = id;
        this.hashName = hashName;
        this.compressionType = CompressionType.GZIP;
        this.compressor = EmptyCompressor.INSTANCE;
        this.files = new TreeMap();
        this._xtea = xtea;
    }

    public /* synthetic */ Archive(int n, int n2, int[] nArray, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            nArray = null;
        }
        this(n, n2, nArray);
    }

    public final int getId() {
        return this.id;
    }

    public final int getHashName() {
        return this.hashName;
    }

    public final void setHashName(int n) {
        this.hashName = n;
    }

    @NotNull
    public final CompressionType getCompressionType() {
        return this.compressionType;
    }

    public final void setCompressionType(@NotNull CompressionType compressionType) {
        Intrinsics.checkNotNullParameter((Object)compressionType, "<set-?>");
        this.compressionType = compressionType;
    }

    @NotNull
    public final Compressor getCompressor() {
        return this.compressor;
    }

    public final void setCompressor(@NotNull Compressor compressor) {
        Intrinsics.checkNotNullParameter(compressor, "<set-?>");
        this.compressor = compressor;
    }

    public final int getRevision() {
        return this.revision;
    }

    public final void setRevision(int n) {
        this.revision = n;
    }

    @NotNull
    public final SortedMap<Integer, File> getFiles() {
        return this.files;
    }

    public final int getCrc() {
        return this.crc;
    }

    public final void setCrc(int n) {
        this.crc = n;
    }

    @Nullable
    public final byte[] getWhirlpool() {
        return this.whirlpool;
    }

    public final void setWhirlpool(@Nullable byte[] byArray) {
        this.whirlpool = byArray;
    }

    public final int getFlag8Value() {
        return this.flag8Value;
    }

    public final void setFlag8Value(int n) {
        this.flag8Value = n;
    }

    public final int getFlag4Value1() {
        return this.flag4Value1;
    }

    public final void setFlag4Value1(int n) {
        this.flag4Value1 = n;
    }

    public final int getFlag4Value2() {
        return this.flag4Value2;
    }

    public final void setFlag4Value2(int n) {
        this.flag4Value2 = n;
    }

    @Nullable
    public final int[] getXtea() {
        return this._xtea;
    }

    public final void setXtea(@Nullable int[] value) {
        this._xtea = value;
        if (this.read) {
            this.compressionType = CompressionType.GZIP;
            this.compressor = new GZIPCompressor();
            this.flag();
        }
    }

    public final boolean getRead() {
        return this.read;
    }

    public final void setRead(boolean bl) {
        this.read = bl;
    }

    public final boolean getNew() {
        return this.new;
    }

    public final void setNew(boolean bl) {
        this.new = bl;
    }

    public Archive(int id) {
        this(id, 0, null, 4, null);
    }

    public Archive(@NotNull Archive archive) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(archive, "archive");
        this(archive.id, archive.hashName, null, 4, null);
        for (File file : archive.files()) {
            ((Map)this.files).put(file.getId(), new File(file));
        }
        this.revision = archive.revision;
        this.crc = archive.crc;
        if (archive.whirlpool != null) {
            byArray = (byte[])archive.whirlpool.clone();
        } else {
            byte[] cfr_ignored_0 = archive.whirlpool;
            byArray = null;
        }
        this.whirlpool = byArray;
        int[] nArray = archive.getXtea();
        this.setXtea((int[])(nArray != null ? (int[])nArray.clone() : null));
    }

    @Override
    public int compareTo(@NotNull Archive other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Intrinsics.compare(this.id, other.id);
    }

    public void read(@NotNull InputBuffer buffer) {
        int i;
        int n;
        int fileIndex;
        int offset;
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        this.read = true;
        byte[] rawArray = buffer.raw();
        if (this.files.size() == 1) {
            File file = this.first();
            if (file != null) {
                file.setData(rawArray);
            }
            return;
        }
        int[] fileIds = this.fileIds();
        int fileDataSizesOffset = rawArray.length;
        int chunkSize = rawArray[--fileDataSizesOffset] & 0xFF;
        int[] fileDataSizes = new int[fileIds.length];
        buffer.setOffset(fileDataSizesOffset -= chunkSize * (fileIds.length * 4));
        for (int i2 = 0; i2 < chunkSize; ++i2) {
            offset = 0;
            fileIndex = 0;
            n = fileIds.length;
            while (fileIndex < n) {
                int n2 = fileIndex++;
                fileDataSizes[n2] = fileDataSizes[n2] + (offset += buffer.readInt());
            }
        }
        byte[][] filesData = new byte[fileIds.length][];
        fileIndex = fileIds.length;
        for (int i3 = 0; i3 < fileIndex; ++i3) {
            filesData[i3] = new byte[fileDataSizes[i3]];
            fileDataSizes[i3] = 0;
        }
        buffer.setOffset(fileDataSizesOffset);
        offset = 0;
        for (i = 0; i < chunkSize; ++i) {
            int read2 = 0;
            int j = 0;
            int n3 = fileIds.length;
            while (j < n3) {
                System.arraycopy(rawArray, offset, filesData[j], fileDataSizes[j], read2 += buffer.readInt());
                offset += read2;
                int n4 = j++;
                fileDataSizes[n4] = fileDataSizes[n4] + read2;
            }
        }
        n = fileIds.length;
        for (i = 0; i < n; ++i) {
            File file = this.file(fileIds[i]);
            if (file == null) continue;
            file.setData(filesData[i]);
        }
    }

    @NotNull
    public byte[] write() {
        int n;
        byte[] emptyByteArray;
        OutputBuffer buffer;
        File[] files;
        block9: {
            Object object;
            block11: {
                block10: {
                    files = this.files();
                    int size = 0;
                    File[] $this$forEach$iv = files;
                    boolean $i$f$forEach = false;
                    int n2 = $this$forEach$iv.length;
                    for (int i = 0; i < n2; ++i) {
                        File element$iv;
                        File it = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        byte[] byArray = it.getData();
                        size += byArray != null ? byArray.length : 0;
                    }
                    buffer = new OutputBuffer(size + files.length * 4);
                    emptyByteArray = new byte[]{};
                    if (files.length != 1) break block9;
                    object = this.first();
                    if (object == null) break block10;
                    byte[] byArray = ((File)object).getData();
                    object = byArray;
                    if (byArray != null) break block11;
                }
                object = emptyByteArray;
            }
            return object;
        }
        File[] $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        int it = $this$forEach$iv.length;
        for (n = 0; n < it; ++n) {
            File element$iv;
            File it2 = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            byte[] byArray = it2.getData();
            if (byArray == null) {
                byArray = emptyByteArray;
            }
            buffer.writeBytes(byArray);
        }
        int chunks = 1;
        n = files.length;
        for (int i = 0; i < n; ++i) {
            int n3;
            int fileDataSize;
            File file = files[i];
            byte[] byArray = file.getData();
            int n4 = fileDataSize = byArray != null ? byArray.length : 0;
            if (i == 0) {
                n3 = 0;
            } else {
                byte[] byArray2 = files[i - 1].getData();
                n3 = byArray2 != null ? byArray2.length : 0;
            }
            int previousFileDataSize = n3;
            buffer.writeInt(fileDataSize - previousFileDataSize);
        }
        buffer.writeByte(chunks);
        return Buffer.array$default(buffer, 0, 0, 3, null);
    }

    public final boolean containsData() {
        for (File entry : this.files.values()) {
            if (entry.getData() == null) continue;
            return true;
        }
        return false;
    }

    @JvmOverloads
    @NotNull
    public final File[] add(@NotNull File[] files, boolean overwrite) {
        Intrinsics.checkNotNullParameter(files, "files");
        ArrayList<File> newFiles = new ArrayList<File>(files.length);
        File[] $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            File element$iv;
            File it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            newFiles.add(this.add(it, overwrite));
        }
        Collection $this$toTypedArray$iv = newFiles;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new File[0]);
    }

    public static /* synthetic */ File[] add$default(Archive archive, File[] fileArray, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: add");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return archive.add(fileArray, bl);
    }

    @JvmOverloads
    @NotNull
    public final File add(@NotNull File file, boolean overwrite) {
        byte[] fileData;
        Intrinsics.checkNotNullParameter(file, "file");
        byte[] byArray = fileData = file.getData();
        if (fileData == null) {
            boolean bl = false;
            String string2 = "File data is null.";
            throw new IllegalStateException(string2.toString());
        }
        return this.add(file.getId(), fileData, file.getHashName(), overwrite);
    }

    public static /* synthetic */ File add$default(Archive archive, File file, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: add");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return archive.add(file, bl);
    }

    @NotNull
    public final File add(@NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        return Archive.add$default(this, this.nextId(), data2, 0, false, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final File add(@NotNull String name, @NotNull byte[] data2, boolean overwrite) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(data2, "data");
        int id = this.fileId(name);
        if (id == -1) {
            id = this.nextId();
        }
        return this.add(id, data2, this.toHash(name), overwrite);
    }

    public static /* synthetic */ File add$default(Archive archive, String string2, byte[] byArray, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: add");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return archive.add(string2, byArray, bl);
    }

    @JvmOverloads
    @NotNull
    public final File add(int id, @NotNull byte[] data2, int hashName, boolean overwrite) {
        Intrinsics.checkNotNullParameter(data2, "data");
        File file = (File)this.files.get(id);
        if (file == null) {
            file = new File(id, data2, hashName == -1 ? 0 : hashName);
            Integer n = id;
            ((Map)this.files).put(n, file);
            this.flag();
        } else if (overwrite) {
            boolean flag = false;
            if (!Arrays.equals(file.getData(), data2)) {
                file.setData(data2);
                flag = true;
            }
            if (hashName != -1 && file.getHashName() != hashName) {
                file.setHashName(hashName);
                flag = true;
            }
            if (flag) {
                this.flag();
            }
        }
        return file;
    }

    public static /* synthetic */ File add$default(Archive archive, int n, byte[] byArray, int n2, boolean bl, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: add");
        }
        if ((n3 & 4) != 0) {
            n2 = -1;
        }
        if ((n3 & 8) != 0) {
            bl = true;
        }
        return archive.add(n, byArray, n2, bl);
    }

    @Nullable
    public final File file(int id) {
        return (File)this.files.get(id);
    }

    @Nullable
    public final File file(@NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Map $this$filterValues$iv = this.files;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            File it = (File)entry$iv.getValue();
            boolean bl = false;
            if (!Arrays.equals(it.getData(), data2)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return (File)CollectionsKt.firstOrNull(((Map)result$iv).values());
    }

    @Nullable
    public final File file(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Map $this$filterValues$iv = this.files;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            File it = (File)entry$iv.getValue();
            boolean bl = false;
            if (!(it.getHashName() == this.toHash(name))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return (File)CollectionsKt.firstOrNull(((Map)result$iv).values());
    }

    public final boolean contains(int id) {
        return this.files.containsKey(id);
    }

    public final boolean contains(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.fileId(name) != -1;
    }

    @Nullable
    public final File remove(int id) {
        File file = (File)this.files.remove(id);
        if (file == null) {
            return null;
        }
        File file2 = file;
        this.flag();
        return file2;
    }

    @Nullable
    public final File remove(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.remove(this.fileId(name));
    }

    @Nullable
    public final File first() {
        if (this.files.isEmpty()) {
            return null;
        }
        Integer n = this.files.firstKey();
        Intrinsics.checkNotNullExpressionValue(n, "firstKey(...)");
        return this.file(((Number)n).intValue());
    }

    @Nullable
    public final File last() {
        if (this.files.isEmpty()) {
            return null;
        }
        return (File)this.files.get(this.files.lastKey());
    }

    public final int fileId(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        int hashName = this.toHash(name);
        Collection<File> collection = this.files.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (it.getHashName() != hashName) continue;
            return it.getId();
        }
        return -1;
    }

    public final int nextId() {
        File last;
        File file = last = this.last();
        return file == null ? 0 : file.getId() + 1;
    }

    @NotNull
    public final File[] copyFiles() {
        File[] files = this.files();
        ArrayList<File> copy2 = new ArrayList<File>(files.length);
        int n = files.length;
        for (int i = 0; i < n; ++i) {
            copy2.add(i, new File(files[i]));
        }
        Collection $this$toTypedArray$iv = copy2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new File[0]);
    }

    public final void flag() {
        this.needUpdate = true;
    }

    public final boolean flagged() {
        return this.needUpdate;
    }

    public final void unFlag() {
        if (!this.flagged()) {
            return;
        }
        this.needUpdate = false;
    }

    public final void restore() {
        for (File file : this.files.values()) {
            file.setData(null);
        }
        this.read = false;
        this.new = false;
    }

    public final void clear() {
        this.files.clear();
    }

    @NotNull
    public final int[] fileIds() {
        Set<Integer> set = this.files.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        return CollectionsKt.toIntArray((Collection<Integer>)set);
    }

    @NotNull
    public final File[] files() {
        Collection<File> collection = this.files.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Collection<File> $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection<File> thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new File[0]);
    }

    @Deprecated(message="Use property syntax", replaceWith=@ReplaceWith(expression="xtea", imports={}))
    public final void xtea(@Nullable int[] xtea) {
        this.setXtea(xtea);
    }

    @Deprecated(message="Use property syntax", replaceWith=@ReplaceWith(expression="xtea", imports={}))
    @Nullable
    public final int[] xtea() {
        return this.getXtea();
    }

    public int toHash(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return name.hashCode();
    }

    @NotNull
    public String toString() {
        return "Archive[id=" + this.id + ", hash_name=" + this.hashName + ", revision=" + this.revision + ", crc=" + this.crc + ", has_whirlpool=" + (this.whirlpool != null) + ", read=" + this.read + ", files_size=" + this.files.size() + ']';
    }

    @JvmOverloads
    @NotNull
    public final File[] add(File ... files) {
        Intrinsics.checkNotNullParameter(files, "files");
        return Archive.add$default(this, files, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final File add(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return Archive.add$default(this, file, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final File add(@NotNull String name, @NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(data2, "data");
        return Archive.add$default(this, name, data2, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final File add(int id, @NotNull byte[] data2, int hashName) {
        Intrinsics.checkNotNullParameter(data2, "data");
        return Archive.add$default(this, id, data2, hashName, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final File add(int id, @NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        return Archive.add$default(this, id, data2, 0, false, 12, null);
    }
}

