/*
 * Decompiled with CFR 0.152.
 */
package com.displee.cache.index.archive;

import com.displee.cache.index.archive.Archive;
import com.displee.cache.index.archive.file.File;
import com.displee.compress.CompressionType;
import com.displee.compress.type.BZIP2Compressor;
import com.displee.compress.type.Compressor;
import com.displee.compress.type.EmptyCompressor;
import com.displee.compress.type.GZIPCompressor;
import com.displee.io.Buffer;
import com.displee.io.impl.InputBuffer;
import com.displee.io.impl.OutputBuffer;
import com.displee.util.OtherExtKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/displee/cache/index/archive/Archive317;", "Lcom/displee/cache/index/archive/Archive;", "bzip2", "Lcom/displee/compress/type/BZIP2Compressor;", "id", "", "(Lcom/displee/compress/type/BZIP2Compressor;I)V", "name", "(Lcom/displee/compress/type/BZIP2Compressor;II)V", "extracted", "", "read", "", "buffer", "Lcom/displee/io/impl/InputBuffer;", "toHash", "", "write", "", "rs-cache-library"})
public final class Archive317
extends Archive {
    @NotNull
    private final BZIP2Compressor bzip2;
    private boolean extracted;

    public Archive317(@NotNull BZIP2Compressor bzip22, int id, int name) {
        Intrinsics.checkNotNullParameter(bzip22, "bzip2");
        super(id, name, null, 4, null);
        this.bzip2 = bzip22;
    }

    public Archive317(@NotNull BZIP2Compressor bzip22, int id) {
        Intrinsics.checkNotNullParameter(bzip22, "bzip2");
        this(bzip22, id, 0);
    }

    @Override
    public void read(@NotNull InputBuffer buffer) {
        int compressedLength;
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        this.setRead(true);
        if (this.getCompressionType() == CompressionType.GZIP) {
            Map map = this.getFiles();
            Integer n = 0;
            Compressor compressor = this.getCompressor();
            Intrinsics.checkNotNull(compressor, "null cannot be cast to non-null type com.displee.compress.type.GZIPCompressor");
            File file = new File(0, ((GZIPCompressor)compressor).deflate317(buffer.raw()), 0, 4, null);
            map.put(n, file);
            return;
        }
        int decompressedLength = buffer.read24BitInt();
        if (decompressedLength != (compressedLength = buffer.read24BitInt())) {
            this.extracted = true;
        }
        Compressor compressor = this.extracted ? (Compressor)this.bzip2 : (Compressor)EmptyCompressor.INSTANCE;
        byte[] decompressed = compressor.decompress(buffer, compressedLength, decompressedLength);
        InputBuffer metaBuffer = new InputBuffer(decompressed);
        int filesLength = metaBuffer.readUnsignedShort();
        InputBuffer filesBuffer = new InputBuffer(decompressed);
        filesBuffer.setOffset(metaBuffer.getOffset() + filesLength * 10);
        compressor = this.extracted ? (Compressor)EmptyCompressor.INSTANCE : (Compressor)this.bzip2;
        for (int i = 0; i < filesLength; ++i) {
            int fileName = metaBuffer.readInt();
            decompressedLength = metaBuffer.read24BitInt();
            compressedLength = metaBuffer.read24BitInt();
            byte[] data2 = compressor.decompress(filesBuffer, compressedLength, decompressedLength);
            Integer n = i;
            ((Map)this.getFiles()).put(n, new File(i, data2, fileName));
        }
    }

    @Override
    @NotNull
    public byte[] write() {
        block3: {
            Object object;
            Compressor compressor;
            block5: {
                block4: {
                    if (this.getCompressionType() != CompressionType.GZIP) break block3;
                    compressor = this.getCompressor();
                    object = this.first();
                    if (object == null) break block4;
                    byte[] byArray = ((File)object).getData();
                    object = byArray;
                    if (byArray != null) break block5;
                }
                object = new byte[0];
            }
            return compressor.compress((byte[])object);
        }
        OutputBuffer metaBuffer = new OutputBuffer(2 + this.getFiles().size() * 10);
        metaBuffer.writeShort(this.getFiles().size());
        OutputBuffer filesBuffer = new OutputBuffer(2048);
        Compressor compressor = this.extracted ? (Compressor)EmptyCompressor.INSTANCE : (Compressor)this.bzip2;
        for (File file : this.getFiles().values()) {
            byte[] fileData;
            if (file.getData() == null) continue;
            metaBuffer.writeInt(file.getHashName()).write24BitInt(fileData.length);
            byte[] toWrite = compressor.compress(fileData);
            metaBuffer.write24BitInt(toWrite.length);
            filesBuffer.writeBytes(toWrite);
        }
        metaBuffer.writeBytes(Buffer.array$default(filesBuffer, 0, 0, 3, null));
        byte[] decompressed = Buffer.array$default(metaBuffer, 0, 0, 3, null);
        compressor = this.extracted ? (Compressor)this.bzip2 : (Compressor)EmptyCompressor.INSTANCE;
        byte[] compressed = compressor.compress(decompressed);
        OutputBuffer buffer = new OutputBuffer(compressed.length + 6);
        buffer.write24BitInt(decompressed.length).write24BitInt(compressed.length).writeBytes(compressed);
        return Buffer.array$default(buffer, 0, 0, 3, null);
    }

    @Override
    public int toHash(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return OtherExtKt.hashCode317(name);
    }
}

