/*
 * Decompiled with CFR 0.152.
 */
package com.displee.compress;

import com.displee.cache.index.archive.ArchiveSector;
import com.displee.compress.CompressionType;
import com.displee.compress.type.Compressor;
import com.displee.compress.type.Compressors;
import com.displee.io.Buffer;
import com.displee.io.impl.InputBuffer;
import com.displee.io.impl.OutputBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a0\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u001e\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\u000f"}, d2={"compress", "", "compressionType", "Lcom/displee/compress/CompressionType;", "compressor", "Lcom/displee/compress/type/Compressor;", "xteas", "", "revision", "", "decompress", "Lcom/displee/cache/index/archive/ArchiveSector;", "compressors", "Lcom/displee/compress/type/Compressors;", "keys", "rs-cache-library"})
@SourceDebugExtension(value={"SMAP\nCompressionExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompressionExt.kt\ncom/displee/compress/CompressionExtKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n1#2:43\n*E\n"})
public final class CompressionExtKt {
    @NotNull
    public static final byte[] compress(@NotNull byte[] $this$compress, @NotNull CompressionType compressionType, @NotNull Compressor compressor, @Nullable int[] xteas, int revision) {
        Intrinsics.checkNotNullParameter($this$compress, "<this>");
        Intrinsics.checkNotNullParameter((Object)compressionType, "compressionType");
        Intrinsics.checkNotNullParameter(compressor, "compressor");
        byte[] compressed = compressor.compress($this$compress);
        int compressedSize = compressed.length;
        OutputBuffer buffer = new OutputBuffer(9 + compressedSize + (revision == -1 ? 0 : 2));
        buffer.writeByte(compressionType.ordinal()).writeInt(compressedSize);
        if (compressionType != CompressionType.NONE) {
            buffer.writeInt($this$compress.length);
        }
        buffer.writeBytes(compressed);
        if (xteas != null && (xteas[0] != 0 || xteas[1] != 0 || xteas[2] != 0 || xteas[3] != 0)) {
            if (!(compressionType != CompressionType.BZIP2)) {
                boolean bl = false;
                String string2 = "BZIP2 compression doesn't work with xtea encryption.";
                throw new IllegalStateException(string2.toString());
            }
            buffer.encryptXTEA(xteas, 5, buffer.getOffset());
        }
        if (revision != -1) {
            buffer.writeShort(revision);
        }
        return Buffer.array$default(buffer, 0, 0, 3, null);
    }

    public static /* synthetic */ byte[] compress$default(byte[] byArray, CompressionType compressionType, Compressor compressor, int[] nArray, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            nArray = null;
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        return CompressionExtKt.compress(byArray, compressionType, compressor, nArray, n);
    }

    @NotNull
    public static final byte[] decompress(@NotNull ArchiveSector $this$decompress, @NotNull Compressors compressors, @Nullable int[] keys2) {
        int compressedSize;
        Intrinsics.checkNotNullParameter($this$decompress, "<this>");
        Intrinsics.checkNotNullParameter(compressors, "compressors");
        byte[] compressedData = $this$decompress.getData();
        InputBuffer buffer = new InputBuffer(compressedData);
        if (keys2 != null && (keys2[0] != 0 || keys2[1] != 0 || keys2[2] != 0 || keys2[3] != 0)) {
            buffer.decryptXTEA(keys2, 5, compressedData.length);
        }
        int type2 = buffer.readUnsignedByte();
        $this$decompress.setCompressionType(CompressionType.Companion.getCompressionTypes()[type2]);
        $this$decompress.setCompressor(compressors.get($this$decompress.getCompressionType()));
        int decompressedSize = compressedSize = buffer.readInt() & 0xFFFFFF;
        if ($this$decompress.getCompressionType() != CompressionType.NONE) {
            decompressedSize = buffer.readInt() & 0xFFFFFF;
        }
        return $this$decompress.getCompressor().decompress(buffer, compressedSize, decompressedSize);
    }

    public static /* synthetic */ byte[] decompress$default(ArchiveSector archiveSector, Compressors compressors, int[] nArray, int n, Object object) {
        if ((n & 2) != 0) {
            nArray = null;
        }
        return CompressionExtKt.decompress(archiveSector, compressors, nArray);
    }
}

