/*
 * Decompiled with CFR 0.152.
 */
package com.displee.compress.type;

import com.displee.compress.type.Compressor;
import com.displee.io.impl.InputBuffer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0016J \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/displee/compress/type/GZIPCompressor;", "Lcom/displee/compress/type/Compressor;", "()V", "gzipBuffer", "", "inflater", "Ljava/util/zip/Inflater;", "compress", "bytes", "decompress", "buffer", "Lcom/displee/io/impl/InputBuffer;", "compressedSize", "", "decompressedSize", "deflate317", "data", "inflate", "rs-cache-library"})
@SourceDebugExtension(value={"SMAP\nGZIPCompressor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GZIPCompressor.kt\ncom/displee/compress/type/GZIPCompressor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class GZIPCompressor
implements Compressor {
    @Nullable
    private Inflater inflater;
    @Nullable
    private byte[] gzipBuffer;

    @Override
    @NotNull
    public byte[] decompress(@NotNull InputBuffer buffer, int compressedSize, int decompressedSize) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        return this.inflate(buffer, decompressedSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] inflate(InputBuffer buffer, int decompressedSize) {
        byte[] byArray;
        int offset;
        byte[] bytes = buffer.raw();
        if (bytes[offset = buffer.getOffset()] != 31 || bytes[offset + 1] != -117) {
            return new byte[0];
        }
        Inflater inflater = this.inflater;
        if (inflater == null) {
            Inflater inflater2;
            Inflater it = inflater2 = new Inflater(true);
            boolean bl = false;
            this.inflater = it;
            inflater = inflater2;
        }
        Inflater inflater3 = inflater;
        try {
            inflater3.setInput(bytes, offset + 10, bytes.length - (10 + offset + 8));
            byte[] decompressed = new byte[decompressedSize];
            inflater3.inflate(decompressed);
            byArray = decompressed;
        }
        catch (Exception exception) {
            byArray = new byte[]{};
        }
        finally {
            inflater3.reset();
        }
        return byArray;
    }

    @Override
    @NotNull
    public byte[] compress(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        ByteArrayOutputStream compressed = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(compressed);
            gzipOutputStream.write(bytes);
            gzipOutputStream.finish();
            gzipOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte[] byArray = compressed.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
        return byArray;
    }

    @NotNull
    public final byte[] deflate317(@Nullable byte[] data2) {
        int read2 = 0;
        try {
            GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(data2));
            byte[] gzipBuffer = this.gzipBuffer;
            if (gzipBuffer == null) {
                this.gzipBuffer = gzipBuffer = new byte[1000000];
            }
            while (true) {
                if (read2 == gzipBuffer.length) {
                    throw new RuntimeException("buffer overflow!");
                }
                int length = gis.read(gzipBuffer, read2, gzipBuffer.length - read2);
                if (length != -1) {
                    read2 += length;
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("error unzipping");
        }
        byte[] deflated = new byte[read2];
        System.arraycopy(this.gzipBuffer, 0, deflated, 0, deflated.length);
        return deflated;
    }
}

