/*
 * Decompiled with CFR 0.152.
 */
package com.displee.compress.type;

import com.displee.compress.type.Compressor;
import com.displee.io.impl.InputBuffer;
import com.displee.io.impl.OutputBuffer;
import com.displee.util.OtherExtKt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import lzma.sdk.lzma.Decoder;
import lzma.sdk.lzma.Encoder;
import lzma.streams.LzmaEncoderWrapper;
import lzma.streams.LzmaOutputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J \u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0016\u0010\f\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/displee/compress/type/LZMACompressor;", "Lcom/displee/compress/type/Compressor;", "()V", "DECODER", "Llzma/sdk/lzma/Decoder;", "ENCODER", "Llzma/sdk/lzma/Encoder;", "ENCODER_WRAPPER", "Llzma/streams/LzmaEncoderWrapper;", "compress", "", "bytes", "decompress", "buffer", "Lcom/displee/io/impl/InputBuffer;", "compressedSize", "", "decompressedSize", "input", "Ljava/io/ByteArrayInputStream;", "decompressedLength", "rs-cache-library"})
public final class LZMACompressor
implements Compressor {
    @NotNull
    private final Decoder DECODER = new Decoder();
    @NotNull
    private final Encoder ENCODER;
    @NotNull
    private final LzmaEncoderWrapper ENCODER_WRAPPER;

    public LZMACompressor() {
        Encoder encoder = this.ENCODER = new Encoder();
        this.ENCODER_WRAPPER = new LzmaEncoderWrapper(this, encoder){
            final /* synthetic */ LZMACompressor this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void code(@NotNull InputStream inputStream2, @NotNull OutputStream outputStream2) throws IOException {
                Intrinsics.checkNotNullParameter(inputStream2, "inputStream");
                Intrinsics.checkNotNullParameter(outputStream2, "outputStream");
                LZMACompressor.access$getENCODER$p(this.this$0).writeCoderProperties(outputStream2);
                LZMACompressor.access$getENCODER$p(this.this$0).code(inputStream2, outputStream2, -1L, -1L, null);
            }
        };
        this.ENCODER.setDictionarySize(0x800000);
        this.ENCODER.setNumFastBytes(110);
        this.ENCODER.setMatchFinder(0);
        this.ENCODER.setLcLpPb(3, 0, 2);
        this.ENCODER.setEndMarkerMode(false);
    }

    @Override
    @NotNull
    public byte[] compress(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            LzmaOutputStream lzma2 = new LzmaOutputStream((OutputStream)baos, this.ENCODER_WRAPPER);
            OtherExtKt.writeTo(bais, lzma2);
            baos.close();
            lzma2.close();
            bais.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] byArray = baos.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
        return byArray;
    }

    @Override
    @NotNull
    public byte[] decompress(@NotNull InputBuffer buffer, int compressedSize, int decompressedSize) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        OutputBuffer output = new OutputBuffer(buffer.remaining());
        output.writeBytes(buffer.raw(), buffer.getOffset(), buffer.remaining());
        try {
            byArray = this.decompress(new ByteArrayInputStream(output.raw()), decompressedSize);
        }
        catch (IOException e) {
            e.printStackTrace();
            byArray = new byte[]{};
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] decompress(@NotNull ByteArrayInputStream input, int decompressedLength) throws IOException {
        Intrinsics.checkNotNullParameter(input, "input");
        byte[] properties2 = new byte[5];
        if (input.read(properties2) != 5) {
            throw new IOException("LZMA: Bad input.");
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream(decompressedLength);
        Decoder decoder = this.DECODER;
        synchronized (decoder) {
            boolean bl = false;
            if (!this.DECODER.setDecoderProperties(properties2)) {
                throw new IOException("LZMA: Bad properties.");
            }
            boolean bl2 = this.DECODER.code(input, output, decompressedLength);
        }
        output.flush();
        byte[] byArray = output.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
        return byArray;
    }

    public static final /* synthetic */ Encoder access$getENCODER$p(LZMACompressor $this) {
        return $this.ENCODER;
    }
}

