/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.BindingAnnotation;
import com.google.inject.Key;
import com.google.inject.ScopeAnnotation;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.util.Classes;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.inject.Qualifier;
import javax.inject.Scope;

public class Annotations {
    private static final LoadingCache<Class<? extends Annotation>, Annotation> cache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<? extends Annotation>, Annotation>(){

        @Override
        public Annotation load(Class<? extends Annotation> input) {
            return Annotations.generateAnnotationImpl(input);
        }
    });
    private static final Joiner.MapJoiner JOINER = Joiner.on(", ").withKeyValueSeparator("=");
    private static final AnnotationToStringConfig ANNOTATION_TO_STRING_CONFIG = Annotations.determineAnnotationToStringConfig();
    private static final AnnotationChecker scopeChecker = new AnnotationChecker(Arrays.asList(ScopeAnnotation.class, Scope.class));
    private static final AnnotationChecker bindingAnnotationChecker = new AnnotationChecker(Arrays.asList(BindingAnnotation.class, Qualifier.class));

    public static boolean isMarker(Class<? extends Annotation> annotationType) {
        return annotationType.getDeclaredMethods().length == 0;
    }

    public static boolean isAllDefaultMethods(Class<? extends Annotation> annotationType) {
        boolean hasMethods = false;
        for (Method m4 : annotationType.getDeclaredMethods()) {
            hasMethods = true;
            if (m4.getDefaultValue() != null) continue;
            return false;
        }
        return hasMethods;
    }

    public static <T extends Annotation> T generateAnnotation(Class<T> annotationType) {
        Preconditions.checkState(Annotations.isAllDefaultMethods(annotationType), "%s is not all default methods", annotationType);
        return (T)cache.getUnchecked(annotationType);
    }

    private static <T extends Annotation> T generateAnnotationImpl(final Class<T> annotationType) {
        final ImmutableMap<String, Object> members2 = Annotations.resolveMembers(annotationType);
        return (T)((Annotation)annotationType.cast(Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args2) throws Exception {
                String name = method.getName();
                if (name.equals("annotationType")) {
                    return annotationType;
                }
                if (name.equals("toString")) {
                    return Annotations.annotationToString(annotationType, members2);
                }
                if (name.equals("hashCode")) {
                    return Annotations.annotationHashCode(annotationType, members2);
                }
                if (name.equals("equals")) {
                    return Annotations.annotationEquals(annotationType, members2, args2[0]);
                }
                return members2.get(name);
            }
        })));
    }

    private static ImmutableMap<String, Object> resolveMembers(Class<? extends Annotation> annotationType) {
        ImmutableMap.Builder<String, Object> result2 = ImmutableMap.builder();
        for (Method method : annotationType.getDeclaredMethods()) {
            result2.put(method.getName(), method.getDefaultValue());
        }
        return result2.build();
    }

    private static boolean annotationEquals(Class<? extends Annotation> type2, Map<String, Object> members2, Object other) throws Exception {
        if (!type2.isInstance(other)) {
            return false;
        }
        for (Method method : type2.getDeclaredMethods()) {
            String name = method.getName();
            if (Arrays.deepEquals(new Object[]{method.invoke(other, new Object[0])}, new Object[]{members2.get(name)})) continue;
            return false;
        }
        return true;
    }

    private static int annotationHashCode(Class<? extends Annotation> type2, Map<String, Object> members2) throws Exception {
        int result2 = 0;
        for (Method method : type2.getDeclaredMethods()) {
            String name = method.getName();
            Object value = members2.get(name);
            result2 += 127 * name.hashCode() ^ Arrays.deepHashCode(new Object[]{value}) - 31;
        }
        return result2;
    }

    private static String annotationToString(Class<? extends Annotation> type2, Map<String, Object> members2) throws Exception {
        StringBuilder sb = new StringBuilder().append("@").append(type2.getName()).append("(");
        JOINER.appendTo(sb, Maps.transformValues(members2, arg -> {
            String s2 = Arrays.deepToString(new Object[]{arg});
            return s2.substring(1, s2.length() - 1);
        }));
        return sb.append(")").toString();
    }

    public static boolean isRetainedAtRuntime(Class<? extends Annotation> annotationType) {
        Retention retention = annotationType.getAnnotation(Retention.class);
        return retention != null && retention.value() == RetentionPolicy.RUNTIME;
    }

    public static Class<? extends Annotation> findScopeAnnotation(Errors errors, Class<?> implementation) {
        return Annotations.findScopeAnnotation(errors, implementation.getAnnotations());
    }

    public static Class<? extends Annotation> findScopeAnnotation(Errors errors, Annotation[] annotations2) {
        Class<? extends Annotation> found = null;
        for (Annotation annotation : annotations2) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!Annotations.isScopeAnnotation(annotationType)) continue;
            if (found != null) {
                errors.duplicateScopeAnnotations(found, annotationType);
                continue;
            }
            found = annotationType;
        }
        return found;
    }

    static boolean containsComponentAnnotation(Annotation[] annotations2) {
        for (Annotation annotation : annotations2) {
            if (!annotation.annotationType().getSimpleName().equals("Component")) continue;
            return true;
        }
        return false;
    }

    public static String memberValueString(String value) {
        return Annotations.ANNOTATION_TO_STRING_CONFIG.quote ? new StringBuilder(2 + String.valueOf(value).length()).append("\"").append(value).append("\"").toString() : value;
    }

    public static String memberValueString(String memberName, Object value) {
        StringBuilder sb = new StringBuilder();
        boolean quote = Annotations.ANNOTATION_TO_STRING_CONFIG.quote;
        boolean includeMemberName = Annotations.ANNOTATION_TO_STRING_CONFIG.includeMemberName;
        if (includeMemberName) {
            sb.append(memberName).append('=');
        }
        if (quote && value instanceof String) {
            sb.append('\"').append(value).append('\"');
        } else {
            sb.append(value);
        }
        return sb.toString();
    }

    @TestAnnotation(value="determineAnnotationToStringConfig")
    private static AnnotationToStringConfig determineAnnotationToStringConfig() {
        try {
            String annotation = Annotations.class.getDeclaredMethod("determineAnnotationToStringConfig", new Class[0]).getAnnotation(TestAnnotation.class).toString();
            boolean quote = annotation.contains("\"determineAnnotationToStringConfig\"");
            boolean includeMemberName = annotation.contains("value=");
            return new AnnotationToStringConfig(quote, includeMemberName);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static boolean isScopeAnnotation(Class<? extends Annotation> annotationType) {
        return scopeChecker.hasAnnotations(annotationType);
    }

    public static void checkForMisplacedScopeAnnotations(Class<?> type2, Object source2, Errors errors) {
        if (Classes.isConcrete(type2)) {
            return;
        }
        Class<? extends Annotation> scopeAnnotation = Annotations.findScopeAnnotation(errors, type2);
        if (scopeAnnotation != null && !Annotations.containsComponentAnnotation(type2.getAnnotations())) {
            errors.withSource(type2).scopeAnnotationOnAbstractType(scopeAnnotation, type2, source2);
        }
    }

    public static Key<?> getKey(TypeLiteral<?> type2, Member member, Annotation[] annotations2, Errors errors) throws ErrorsException {
        int numErrorsBefore = errors.size();
        Annotation found = Annotations.findBindingAnnotation(errors, member, annotations2);
        errors.throwIfNewErrors(numErrorsBefore);
        return found == null ? Key.get(type2) : Key.get(type2, found);
    }

    public static Annotation findBindingAnnotation(Errors errors, Member member, Annotation[] annotations2) {
        Annotation found = null;
        for (Annotation annotation : annotations2) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!Annotations.isBindingAnnotation(annotationType)) continue;
            if (found != null) {
                errors.duplicateBindingAnnotations(member, found.annotationType(), annotationType);
                continue;
            }
            found = annotation;
        }
        return found;
    }

    public static boolean isBindingAnnotation(Class<? extends Annotation> annotationType) {
        return bindingAnnotationChecker.hasAnnotations(annotationType);
    }

    public static Annotation canonicalizeIfNamed(Annotation annotation) {
        if (annotation instanceof javax.inject.Named) {
            return Names.named(((javax.inject.Named)annotation).value());
        }
        return annotation;
    }

    public static Class<? extends Annotation> canonicalizeIfNamed(Class<? extends Annotation> annotationType) {
        if (annotationType == javax.inject.Named.class) {
            return Named.class;
        }
        return annotationType;
    }

    public static String nameOf(Key<?> key) {
        Annotation annotation = key.getAnnotation();
        Class<Annotation> annotationType = key.getAnnotationType();
        if (annotation != null && !Annotations.isMarker(annotationType)) {
            return key.getAnnotation().toString();
        }
        if (key.getAnnotationType() != null) {
            String string2 = String.valueOf(key.getAnnotationType().getName());
            return string2.length() != 0 ? "@".concat(string2) : new String("@");
        }
        return "";
    }

    static class AnnotationChecker {
        private final Collection<Class<? extends Annotation>> annotationTypes;
        private CacheLoader<Class<? extends Annotation>, Boolean> hasAnnotations = new CacheLoader<Class<? extends Annotation>, Boolean>(){

            @Override
            public Boolean load(Class<? extends Annotation> annotationType) {
                for (Annotation annotation : annotationType.getAnnotations()) {
                    if (!annotationTypes.contains(annotation.annotationType())) continue;
                    return true;
                }
                return false;
            }
        };
        final LoadingCache<Class<? extends Annotation>, Boolean> cache = CacheBuilder.newBuilder().weakKeys().build(this.hasAnnotations);

        AnnotationChecker(Collection<Class<? extends Annotation>> annotationTypes) {
            this.annotationTypes = annotationTypes;
        }

        boolean hasAnnotations(Class<? extends Annotation> annotated) {
            return this.cache.getUnchecked(annotated);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface TestAnnotation {
        public String value();
    }

    private static class AnnotationToStringConfig {
        final boolean quote;
        final boolean includeMemberName;

        AnnotationToStringConfig(boolean quote, boolean includeMemberName) {
            this.quote = quote;
            this.includeMemberName = includeMemberName;
        }
    }
}

