/*
 * Decompiled with CFR 0.152.
 */
package com.hazy;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class AudioDebugUtil {
    public static void playTestTone(int durationMs) {
        new Thread(() -> {
            try {
                float sampleRate = 44100.0f;
                double frequency = 880.0;
                byte[] buffer = new byte[(int)((float)durationMs * sampleRate / 1000.0f) * 2];
                for (int i = 0; i < buffer.length / 2; ++i) {
                    double angle = (double)i / ((double)sampleRate / frequency) * 2.0 * Math.PI;
                    short sample = (short)(Math.sin(angle) * 32767.0);
                    buffer[2 * i] = (byte)(sample & 0xFF);
                    buffer[2 * i + 1] = (byte)(sample >> 8 & 0xFF);
                }
                AudioFormat format = new AudioFormat(sampleRate, 16, 1, true, false);
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
                try (SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);){
                    line.open(format);
                    line.start();
                    line.write(buffer, 0, buffer.length);
                    line.drain();
                    line.stop();
                }
            }
            catch (Exception e) {
                System.err.println("[AudioDebug] \u26a0\ufe0f Could not play tone: " + e.getMessage());
            }
        }, "VolumeTestToneThread").start();
    }
}

