/*
 * Decompiled with CFR 0.152.
 */
package com.hazy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public final class AudioUtils {
    private AudioUtils() {
    }

    public static byte[] toWav(byte[] rawPcmData, int sampleRate) throws IOException {
        if (rawPcmData == null || rawPcmData.length == 0) {
            return null;
        }
        int dataLength = rawPcmData.length;
        int totalLength = dataLength + 36;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write("RIFF".getBytes());
        AudioUtils.writeInt(out, totalLength);
        out.write("WAVEfmt ".getBytes());
        AudioUtils.writeInt(out, 16);
        AudioUtils.writeShort(out, (short)1);
        AudioUtils.writeShort(out, (short)1);
        AudioUtils.writeInt(out, sampleRate);
        AudioUtils.writeInt(out, sampleRate);
        AudioUtils.writeShort(out, (short)1);
        AudioUtils.writeShort(out, (short)8);
        out.write("data".getBytes());
        AudioUtils.writeInt(out, dataLength);
        out.write(rawPcmData);
        return out.toByteArray();
    }

    private static void writeInt(ByteArrayOutputStream out, int value) throws IOException {
        out.write(value & 0xFF);
        out.write(value >> 8 & 0xFF);
        out.write(value >> 16 & 0xFF);
        out.write(value >> 24 & 0xFF);
    }

    private static void writeShort(ByteArrayOutputStream out, short value) throws IOException {
        out.write(value & 0xFF);
        out.write(value >> 8 & 0xFF);
    }
}

