/*
 * Decompiled with CFR 0.152.
 */
package com.hazy;

import com.hazy.Client;
import com.hazy.sign.SignLink;
import com.hazy.util.Unzip;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.logging.Logger;

public class BattlePassDownloader
implements Runnable {
    private static final Logger log = Logger.getLogger(BattlePassDownloader.class.getName());
    private static final String BATTLEPASS_DOWNLOAD_LINK = "https://www.eldoriarsps.com/Battlepass.zip";
    public static int battlePassVersionRemote;
    public static int battlePassVersionLocal;
    private final Client client;
    private static final int BUFFER = 1024;
    private final Path fileLocation;

    public BattlePassDownloader(Client client) {
        Objects.requireNonNull(SignLink.getCacheDirectory());
        this.client = client;
        this.fileLocation = Paths.get(SignLink.getCacheDirectory(), this.getArchivedName());
    }

    public void writeVersion(int version) {
        File versionFile = new File(SignLink.getCacheDirectory() + File.separator + "battlepass_version.dat");
        if (versionFile.exists()) {
            versionFile.delete();
        }
        try (BufferedWriter br = new BufferedWriter(new FileWriter(versionFile));){
            br.write("" + version);
            br.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteZip() {
        try {
            Files.deleteIfExists(this.fileLocation);
        }
        catch (IOException ex) {
            log.severe("Cannot delete battlepass zip file.");
            ex.printStackTrace();
        }
    }

    public BattlePassDownloader downloadBattlePass() {
        block5: {
            try {
                File battlepassDir = new File(SignLink.getCacheDirectory() + "/battlepass");
                File version = new File(SignLink.getCacheDirectory() + "/battlepass_version.dat");
                battlePassVersionRemote = Integer.parseInt("50");
                log.info("Checking battlepass update - Remote version: " + battlePassVersionRemote);
                log.info("Battlepass directory exists: " + battlepassDir.exists());
                log.info("Version file exists: " + version.exists());
                if (!battlepassDir.exists() || !version.exists()) {
                    log.info("Battlepass does not exist, downloading.");
                    this.update();
                    break block5;
                }
                battlePassVersionLocal = BattlePassDownloader.getLocalVersion();
                log.info("Battlepass version local=" + battlePassVersionLocal + ", remote=" + battlePassVersionRemote);
                if (battlePassVersionRemote != battlePassVersionLocal) {
                    log.info("Battlepass version mismatch, updating.");
                    if (battlepassDir.exists()) {
                        log.info("Deleting existing battlepass folder for clean update.");
                        this.deleteDirectory(battlepassDir);
                    }
                    this.update();
                    break block5;
                }
                log.info("Battlepass is up to date, skipping download.");
                return null;
            }
            catch (Exception e) {
                log.severe("Error in downloadBattlePass: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return null;
    }

    private void update() {
        this.downloadFile(this.getArchivedName());
        Unzip.unZipIt(this.fileLocation.toString(), SignLink.getCacheDirectory() + "/battlepass", true);
        this.writeVersion(battlePassVersionRemote);
        this.deleteZip();
    }

    private void downloadFile(String localFileName) {
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(Paths.get(SignLink.getCacheDirectory() + "/" + localFileName, new String[0]), new OpenOption[0]));){
            URL url = new URL(BATTLEPASS_DOWNLOAD_LINK);
            URLConnection conn = url.openConnection();
            try (InputStream in = conn.getInputStream();){
                int numRead;
                byte[] data2 = new byte[1024];
                long numWritten = 0L;
                int fileSize = conn.getContentLength();
                long startTime = System.currentTimeMillis();
                while ((numRead = in.read(data2)) != -1) {
                    ((OutputStream)out).write(data2, 0, numRead);
                    int percentage = (int)((double)(numWritten += (long)numRead) / (double)fileSize * 100.0);
                    long elapsedTime = System.currentTimeMillis() - startTime;
                    int downloadSpeed = (int)(numWritten / 1024L / (1L + elapsedTime / 1000L));
                    float speedInBytes = 1000.0f * (float)numWritten / (float)elapsedTime;
                    int timeRemaining = (int)((float)((long)fileSize - numWritten) / speedInBytes);
                    this.client.draw_loadup(percentage, "Eldoria - Downloading Battlepass " + percentage + "%");
                }
            }
            ((OutputStream)out).flush();
        }
        catch (IOException ex) {
            log.severe("Failed to download battlepass: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private String getArchivedName() {
        int lastSlashIndex = BATTLEPASS_DOWNLOAD_LINK.lastIndexOf(47);
        int lastQuestionmarkIndex = BATTLEPASS_DOWNLOAD_LINK.lastIndexOf(63);
        if (lastSlashIndex >= 0) {
            if (lastQuestionmarkIndex >= 0) {
                return BATTLEPASS_DOWNLOAD_LINK.substring(lastSlashIndex + 1, lastQuestionmarkIndex);
            }
            return BATTLEPASS_DOWNLOAD_LINK.substring(lastSlashIndex + 1);
        }
        System.err.println("error retrieving archived name.");
        return "battlepass.zip";
    }

    @Override
    public void run() {
        this.downloadBattlePass();
    }

    public static boolean battlePassExists() {
        File battlepassDir = new File(SignLink.getCacheDirectory() + "/battlepass");
        return battlepassDir.exists() && battlepassDir.isDirectory();
    }

    public static String getBattlePassDirectory() {
        return SignLink.getCacheDirectory() + "/battlepass";
    }

    public static boolean battlePassNeedsUpdate() {
        try {
            int localVersion = -1;
            try (BufferedReader fr = new BufferedReader(new FileReader(SignLink.getCacheDirectory() + File.separator + "battlepass_version.dat"));){
                localVersion = Integer.parseInt(fr.readLine());
            }
            catch (Exception e) {
                return true;
            }
            int remoteVersion = Integer.parseInt("50");
            return remoteVersion != localVersion;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static int getBattlePassVersion() {
        return BattlePassDownloader.getLocalVersion();
    }

    private static int getLocalVersion() {
        int n;
        BufferedReader fr = new BufferedReader(new FileReader(SignLink.getCacheDirectory() + File.separator + "battlepass_version.dat"));
        try {
            n = Integer.parseInt(fr.readLine());
        }
        catch (Throwable throwable) {
            try {
                try {
                    fr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return -1;
            }
        }
        fr.close();
        return n;
    }

    private void deleteDirectory(File dir) {
        if (dir.exists()) {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        this.deleteDirectory(file);
                        continue;
                    }
                    file.delete();
                }
            }
            dir.delete();
        }
    }
}

