/*
 * Decompiled with CFR 0.152.
 */
package com.hazy;

import com.google.common.base.Preconditions;
import com.hazy.Client;
import com.hazy.util.Unzip;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import net.runelite.client.RuneLite;

public class CacheDownloader
implements Runnable {
    private static final Logger log = Logger.getLogger(CacheDownloader.class.getName());
    private static final String CACHE_DOWNLOAD_LINK = "https://hazyrealm.com/client/osrs.zip";
    public static int cacheVersionRemote;
    public static int cacheVersionLocal;
    private final Client client;
    private static final int BUFFER = 1024;
    private final Path fileLocation;

    public CacheDownloader(Client client) {
        RuneLite.CACHE_DIR_OSRS.mkdir();
        Objects.requireNonNull(RuneLite.CACHE_DIR_OSRS.getAbsolutePath());
        this.client = client;
        this.fileLocation = Paths.get(RuneLite.CACHE_DIR_OSRS.getAbsolutePath(), this.getArchivedName());
    }

    private int getLocalVersion() {
        int n;
        BufferedReader fr = new BufferedReader(new FileReader(RuneLite.CACHE_DIR_OSRS.getAbsolutePath() + File.separator + "version.dat"));
        try {
            n = Integer.parseInt(fr.readLine());
        }
        catch (Throwable throwable) {
            try {
                try {
                    fr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return -1;
            }
        }
        fr.close();
        return n;
    }

    public void writeVersion(int version) {
        File versionFile = new File(RuneLite.CACHE_DIR_OSRS.getAbsolutePath() + File.separator + "version.dat");
        if (versionFile.exists()) {
            versionFile.delete();
        }
        try (BufferedWriter br = new BufferedWriter(new FileWriter(versionFile));){
            br.write("" + version);
            br.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteZip() {
        try {
            Files.deleteIfExists(this.fileLocation);
        }
        catch (IOException ex) {
            log.severe("Cannot delete cache zip file.");
            ex.printStackTrace();
        }
    }

    public CacheDownloader downloadCache() {
        block4: {
            try {
                File location = new File(RuneLite.CACHE_DIR_OSRS.getAbsolutePath());
                File version = new File(RuneLite.CACHE_DIR_OSRS.getAbsolutePath() + "/version.dat");
                cacheVersionRemote = 31;
                if (!location.exists() || !version.exists()) {
                    log.info("Cache does not exist, downloading.");
                    this.update();
                    break block4;
                }
                cacheVersionLocal = this.getLocalVersion();
                log.info("Cache version local=" + cacheVersionLocal + ", remote=" + cacheVersionRemote);
                if (cacheVersionRemote != cacheVersionLocal) {
                    this.update();
                    break block4;
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void update() {
        this.downloadFile(this.getArchivedName());
        Unzip.unZipIt(this.fileLocation.toString(), RuneLite.CACHE_DIR_OSRS.getAbsolutePath(), true);
        this.writeVersion(cacheVersionRemote);
        this.deleteZip();
    }

    private void downloadFile(String localFileName) {
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(Paths.get(RuneLite.CACHE_DIR_OSRS.getAbsolutePath() + "/" + localFileName, new String[0]), new OpenOption[0]));){
            URL url = new URL(CACHE_DOWNLOAD_LINK);
            URLConnection conn = url.openConnection();
            try (InputStream in = conn.getInputStream();){
                int numRead;
                byte[] data2 = new byte[1024];
                long numWritten = 0L;
                int fileSize = conn.getContentLength();
                long startTime = System.currentTimeMillis();
                while ((numRead = in.read(data2)) != -1) {
                    ((OutputStream)out).write(data2, 0, numRead);
                    int percentage = (int)((double)(numWritten += (long)numRead) / (double)fileSize * 100.0);
                    long elapsedTime = System.currentTimeMillis() - startTime;
                    int downloadSpeed = (int)(numWritten / 1024L / (1L + elapsedTime / 1000L));
                    float speedInBytes = 1000.0f * (float)numWritten / (float)elapsedTime;
                    int timeRemaining = (int)((float)((long)fileSize - numWritten) / speedInBytes);
                    this.client.draw_loadup(percentage, "Eldoria - Downloading OSRS Cache ");
                }
            }
            ((OutputStream)out).flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private String getArchivedName() {
        int lastSlashIndex = CACHE_DOWNLOAD_LINK.lastIndexOf(47);
        if (lastSlashIndex >= 0) {
            String u = CACHE_DOWNLOAD_LINK.substring(lastSlashIndex + 1);
            return u.replace("?dl=1", "");
        }
        System.err.println("error retrieving archived name.");
        return "";
    }

    private void unZip() throws IOException {
        ZipEntry e;
        BufferedInputStream in = new BufferedInputStream(Files.newInputStream(Paths.get(this.fileLocation.toString(), new String[0]), new OpenOption[0]));
        ZipInputStream zin = new ZipInputStream(in);
        int files = CacheDownloader.countRegularFiles(new ZipFile(this.fileLocation.toString()));
        int numWritten = 0;
        while ((e = zin.getNextEntry()) != null) {
            String fileName = e.getName();
            File newFile = new File(RuneLite.CACHE_DIR_OSRS.getAbsolutePath() + File.separator + fileName);
            if (e.isDirectory()) {
                new File(RuneLite.CACHE_DIR_OSRS.getAbsolutePath() + e.getName()).mkdir();
                continue;
            }
            int percentage = (int)((double)numWritten++ / (double)files * 100.0);
            this.client.draw_loadup(percentage, "Eldoria - Installing Cache " + percentage + "%");
            if (e.getName().equals(this.fileLocation.toString())) {
                this.unzip(zin, RuneLite.CACHE_DIR_OSRS.getAbsolutePath());
                break;
            }
            File file = new File(newFile.getParent());
            if (!file.exists()) {
                Preconditions.checkState(file.mkdirs(), "Cannot create file.");
            }
            this.unzip(zin, RuneLite.CACHE_DIR_OSRS.getAbsolutePath() + e.getName());
        }
        ((InputStream)in).close();
        zin.close();
    }

    private static int countRegularFiles(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        int numRegularFiles = 0;
        while (entries.hasMoreElements()) {
            if (entries.nextElement().isDirectory()) continue;
            ++numRegularFiles;
        }
        log.info("Number of regular files in zip: " + numRegularFiles);
        return numRegularFiles;
    }

    private void unzip(ZipInputStream zin, String s2) throws IOException {
        try (FileOutputStream out = new FileOutputStream(s2);){
            int len;
            byte[] b = new byte[1024];
            while ((len = zin.read(b)) != -1) {
                out.write(b, 0, len);
            }
            out.flush();
        }
    }

    @Override
    public void run() {
        this.downloadCache();
    }
}

