/*
 * Decompiled with CFR 0.152.
 */
package com.hazy;

import java.awt.Color;

public class PlayerNameEffect {
    private final String playerName;
    private final EffectType effectType;
    private final Color baseColor;
    private final Color fromColor;
    private final Color toColor;
    private final double speed;
    private long lastUpdateTime;

    public PlayerNameEffect(String playerName, EffectType effectType, Color fromColor, Color toColor, double speed) {
        this(playerName, effectType, null, fromColor, toColor, speed);
    }

    public void update(long now) {
        this.lastUpdateTime = now;
    }

    private PlayerNameEffect(String playerName, EffectType effectType, Color baseColor, Color fromColor, Color toColor, double speed) {
        this.playerName = playerName;
        this.effectType = effectType;
        this.baseColor = baseColor;
        this.fromColor = fromColor;
        this.toColor = toColor;
        this.speed = speed;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public EffectType getEffectType() {
        return this.effectType;
    }

    public int getCurrentColor(long currentTime, int charIndex) {
        switch (this.effectType) {
            case RAINBOW: {
                return this.rainbowColor(currentTime, charIndex);
            }
            case COLOR_PULSE: {
                return this.pulsingColor(currentTime);
            }
            case COLOR_GRADIENT: {
                return this.gradientColor(currentTime, charIndex);
            }
            case BLOOD_SURGE: {
                return this.bloodSurge(currentTime, charIndex);
            }
        }
        return this.baseColor != null ? this.rgbToInt(this.baseColor) : 0xFFFFFF;
    }

    private int rainbowColor(long t2, int index) {
        float baseHue = (float)(t2 % 5000L) / 5000.0f;
        float hue = (baseHue + (float)index * 0.05f) % 1.0f;
        float brightness = (float)(0.85 + 0.15 * Math.sin((double)t2 / 500.0 + (double)index * 0.3));
        Color rainbow = Color.getHSBColor(hue, 0.9f, brightness);
        return this.rgbToInt(rainbow);
    }

    private int pulsingColor(long t2) {
        if (this.fromColor == null) {
            return 0xFFFFFF;
        }
        float[] hsb = Color.RGBtoHSB(this.fromColor.getRed(), this.fromColor.getGreen(), this.fromColor.getBlue(), null);
        float pulseBrightness = (float)((double)hsb[2] * (0.85 + 0.15 * Math.sin((double)t2 / 600.0 * this.speed)));
        Color pulsing = Color.getHSBColor(hsb[0], hsb[1], Math.min(1.0f, pulseBrightness));
        return this.rgbToInt(pulsing);
    }

    private int gradientColor(long t2, int index) {
        if (this.fromColor == null || this.toColor == null) {
            return 0xFFFFFF;
        }
        double wave = Math.sin((double)t2 / 1000.0 + (double)index * 0.4);
        double phase = (wave + 1.0) / 2.0;
        phase = 0.5 - 0.5 * Math.cos(phase * Math.PI);
        int r = (int)((double)this.fromColor.getRed() + (double)(this.toColor.getRed() - this.fromColor.getRed()) * phase);
        int g2 = (int)((double)this.fromColor.getGreen() + (double)(this.toColor.getGreen() - this.fromColor.getGreen()) * phase);
        int b = (int)((double)this.fromColor.getBlue() + (double)(this.toColor.getBlue() - this.fromColor.getBlue()) * phase);
        float[] hsb = Color.RGBtoHSB(r, g2, b, null);
        float shimmer = (float)(0.9 + 0.1 * Math.sin((double)t2 / 600.0 + (double)index * 0.6));
        hsb[2] = Math.min(1.0f, hsb[2] * shimmer);
        hsb[1] = Math.max(0.4f, hsb[1] * 0.85f);
        Color flowing = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        return this.rgbToInt(flowing);
    }

    private int bloodSurge(long t2, int index) {
        double pulse = 0.7 + 0.3 * Math.sin((double)t2 / 200.0 + (double)index * 0.6);
        Color c = new Color((int)((double)this.fromColor.getRed() * pulse), (int)((double)this.fromColor.getGreen() * pulse), (int)((double)this.fromColor.getBlue() * pulse));
        if (Math.random() < 0.03) {
            c = new Color(255, 255, 255);
        }
        return this.rgbToInt(c);
    }

    private int lightningStreak(long t2, int index) {
        Color c = this.fromColor;
        if ((t2 / 120L + (long)index) % 20L < 1L && Math.random() < 0.3) {
            return 0xFFFFFF;
        }
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        hsb[2] = (float)(0.8 + 0.2 * Math.sin((double)t2 / 250.0 + (double)index));
        return this.rgbToInt(Color.getHSBColor(hsb[0], hsb[1], hsb[2]));
    }

    private int rgbToInt(Color c) {
        return c.getRed() << 16 | c.getGreen() << 8 | c.getBlue();
    }

    public static enum EffectType {
        NONE,
        RAINBOW,
        COLOR_PULSE,
        COLOR_GRADIENT,
        BLOOD_SURGE;

    }
}

