/*
 * Decompiled with CFR 0.152.
 */
package com.hazy;

import com.hazy.PlayerNameEffect;
import com.hazy.cache.graphics.widget.Widget;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlayerNameEffectManager {
    private static final Map<String, PlayerNameEffect> effects = new HashMap<String, PlayerNameEffect>();
    private static final List<PlayerNameEffect> baseEffects = new ArrayList<PlayerNameEffect>();

    public static void applyColorEffect(String username, int colorId, int from, int to) {
        PlayerNameEffect.EffectType effectType;
        if (username == null || username.isEmpty()) {
            return;
        }
        boolean speed = true;
        switch (colorId) {
            case 1: {
                effectType = PlayerNameEffect.EffectType.RAINBOW;
                break;
            }
            case 2: {
                effectType = PlayerNameEffect.EffectType.COLOR_PULSE;
                break;
            }
            case 3: {
                effectType = PlayerNameEffect.EffectType.COLOR_GRADIENT;
                break;
            }
            case 4: {
                effectType = PlayerNameEffect.EffectType.BLOOD_SURGE;
                break;
            }
            default: {
                effectType = PlayerNameEffect.EffectType.NONE;
            }
        }
        Color fromColor = new Color(from & 0xFFFFFF);
        Color toColor = new Color(to & 0xFFFFFF);
        PlayerNameEffect effect = new PlayerNameEffect(username, effectType, fromColor, toColor, (double)speed);
        effects.put(username.toLowerCase(), effect);
    }

    public static void addEffect(String playerName, PlayerNameEffect.EffectType type2, Color color, Color color2) {
        effects.put(playerName.toLowerCase(), new PlayerNameEffect(playerName, type2, color, color2, 1.0));
    }

    public static PlayerNameEffect getEffect(String playerName) {
        return playerName == null ? null : effects.get(playerName.toLowerCase());
    }

    public static PlayerNameEffect getEffect(int index) {
        PlayerNameEffect.EffectType[] types = PlayerNameEffect.EffectType.values();
        if (index < 0 || index >= types.length) {
            return null;
        }
        PlayerNameEffect.EffectType type2 = types[index];
        Color from = Widget.customIndexFromColor;
        Color to = Widget.customIndexToColor;
        double speed = 0.8;
        return new PlayerNameEffect("", type2, from, to, speed);
    }

    public static Map<String, PlayerNameEffect> getAllEffects() {
        return effects;
    }

    public static List<PlayerNameEffect> getBaseEffects() {
        return baseEffects;
    }

    public static void updateEffects() {
        long now = System.currentTimeMillis();
        for (PlayerNameEffect effect : effects.values()) {
            effect.update(now);
        }
    }

    static {
        PlayerNameEffectManager.addEffect("Vanity", PlayerNameEffect.EffectType.BLOOD_SURGE, new Color(106, 22, 242), new Color(255, 215, 0));
        PlayerNameEffectManager.addEffect("Smokesletsgo", PlayerNameEffect.EffectType.COLOR_GRADIENT, new Color(106, 22, 242), new Color(255, 215, 0));
        PlayerNameEffectManager.addEffect("what bow", PlayerNameEffect.EffectType.BLOOD_SURGE, new Color(106, 22, 242), new Color(255, 215, 0));
        PlayerNameEffectManager.addEffect("Jake", PlayerNameEffect.EffectType.RAINBOW, new Color(106, 22, 242), new Color(255, 215, 0));
        PlayerNameEffectManager.addEffect("James", PlayerNameEffect.EffectType.RAINBOW, new Color(106, 22, 242), new Color(255, 215, 0));
    }
}

