/*
 * Decompiled with CFR 0.152.
 */
package com.hazy;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class RemoteAssetUpdater {
    private static final String ASSET_URL = "https://www.dropbox.com/scl/fi/hunnwvplz25f3q2hsitso/cache.zip?rlkey=7h7nlsjsuni9undeuys6039f8&st=f9w9s75q&dl=1";
    private static final String VERSION_URL = "https://eldoriarsps.com/CacheVersion.txt";
    private static final Path ASSET_DIR = Paths.get(System.getProperty("user.home"), ".twisted", "cache");
    private static final Path LOCAL_VERSION_FILE = ASSET_DIR.resolve("version.dat");

    public void checkAndUpdate() throws IOException {
        String localVersion;
        String remoteVersion = this.fetchRemoteVersion();
        if (!remoteVersion.equals(localVersion = this.readLocalVersion())) {
            System.out.println("New version detected (" + remoteVersion + "), downloading...");
            Files.createDirectories(ASSET_DIR, new FileAttribute[0]);
            Path archivePath = ASSET_DIR.resolve("cache.rar");
            this.downloadFile(ASSET_URL, archivePath);
            this.unzip(archivePath.toFile(), ASSET_DIR.toFile());
            Files.deleteIfExists(archivePath);
            this.writeLocalVersion(remoteVersion);
            System.out.println("Cache updated to version " + remoteVersion);
        } else {
            System.out.println("Cache up to date (version " + localVersion + ")");
        }
    }

    private String fetchRemoteVersion() throws IOException {
        URLConnection conn = new URL(VERSION_URL).openConnection();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String string2 = br.readLine().trim();
            return string2;
        }
    }

    private String readLocalVersion() {
        if (Files.exists(LOCAL_VERSION_FILE, new LinkOption[0])) {
            try {
                return Files.readString(LOCAL_VERSION_FILE).trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "0.0.0";
    }

    private void writeLocalVersion(String v) throws IOException {
        Files.createDirectories(ASSET_DIR, new FileAttribute[0]);
        Files.writeString(LOCAL_VERSION_FILE, (CharSequence)v, new OpenOption[0]);
    }

    private void downloadFile(String urlString, Path dest) throws IOException {
        Files.createDirectories(dest.getParent(), new FileAttribute[0]);
        try (InputStream in = new URL(urlString).openStream();){
            Files.copy(in, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        System.out.println("Downloaded to " + String.valueOf(dest));
    }

    private void unzip(File zipFile, File targetDir) throws IOException {
        try (FileInputStream fis = new FileInputStream(zipFile);
             BufferedInputStream bis = new BufferedInputStream(fis);
             ZipInputStream zis = new ZipInputStream(bis);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                File newFile = new File(targetDir, entry.getName());
                if (entry.isDirectory()) {
                    newFile.mkdirs();
                } else {
                    newFile.getParentFile().mkdirs();
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int len;
                        byte[] buffer = new byte[1024];
                        while ((len = zis.read(buffer)) != -1) {
                            fos.write(buffer, 0, len);
                        }
                    }
                }
                zis.closeEntry();
            }
        }
    }
}

