/*
 * Decompiled with CFR 0.152.
 */
package com.hazy;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class TestAudioBeep {
    public static void testAudioBeep() {
        Thread t2 = new Thread(() -> {
            try {
                System.out.println("[AudioTest] Generating stereo test tone...");
                float sampleRate = 44100.0f;
                double frequency = 440.0;
                int durationMs = 3000;
                byte[] buffer = new byte[(int)((float)durationMs * sampleRate / 1000.0f) * 4];
                for (int i = 0; i < buffer.length / 4; ++i) {
                    double angle = (double)i / ((double)sampleRate / frequency) * 2.0 * Math.PI;
                    short sample = (short)(Math.sin(angle) * 32767.0);
                    buffer[4 * i] = (byte)(sample & 0xFF);
                    buffer[4 * i + 1] = (byte)(sample >> 8 & 0xFF);
                    buffer[4 * i + 2] = (byte)(sample & 0xFF);
                    buffer[4 * i + 3] = (byte)(sample >> 8 & 0xFF);
                }
                AudioFormat format = new AudioFormat(sampleRate, 16, 2, true, false);
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
                Mixer.Info targetMixerInfo = null;
                for (Mixer.Info mi : AudioSystem.getMixerInfo()) {
                    System.out.println("[MixerTest] Checking: " + mi.getName() + " \u2014 " + mi.getDescription());
                    if (!mi.getName().contains("Primary Sound Driver") && !mi.getName().contains("Direct Audio Device")) continue;
                    targetMixerInfo = mi;
                    break;
                }
                if (targetMixerInfo == null) {
                    System.out.println("[AudioTest] \u26a0\ufe0f Logitech playback mixer not found, using default.");
                } else {
                    System.out.println("[AudioTest] \ud83c\udfa7 Using mixer: " + targetMixerInfo.getName());
                }
                Mixer mixer = targetMixerInfo != null ? AudioSystem.getMixer(targetMixerInfo) : AudioSystem.getMixer(null);
                try (SourceDataLine line = (SourceDataLine)mixer.getLine(info);){
                    line.open(format);
                    line.start();
                    System.out.println("[AudioTest] \u2705 Playing stereo 440 Hz tone...");
                    line.write(buffer, 0, buffer.length);
                    line.drain();
                    line.stop();
                    System.out.println("[AudioTest] \u2705 Test complete.");
                }
            }
            catch (Exception e) {
                System.err.println("[AudioTest] \u26a0\ufe0f Audio test failed:");
                e.printStackTrace();
            }
        }, "BeepTestThread");
        t2.start();
    }
}

