/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.hazy.cache.Archive;
import com.hazy.cache.def.SpriteDefinition;
import com.hazy.cache.def.loaders.SpriteLoader;
import com.hazy.cache.def.provider.SpriteProvider;
import java.io.IOException;

public class SpriteManager
implements SpriteProvider {
    private final Archive fileArchive;
    private final Multimap<Integer, SpriteDefinition> sprites = LinkedListMultimap.create();

    public SpriteManager(Archive fileArchive) {
        this.fileArchive = fileArchive;
    }

    public void load() throws IOException {
        SpriteDefinition[] defs;
        SpriteLoader loader = new SpriteLoader();
        for (SpriteDefinition sprite : defs = loader.load(317, this.fileArchive.get("mapscene.dat"))) {
            this.sprites.put(sprite.getId(), sprite);
        }
    }

    @Override
    public SpriteDefinition provide(int spriteId, int frameId) {
        return this.findSprite(spriteId, frameId);
    }

    private SpriteDefinition findSprite(int spriteId, int frameId) {
        for (SpriteDefinition sprite : this.sprites.get(spriteId)) {
            if (sprite.getFrame() != frameId) continue;
            return sprite;
        }
        return null;
    }
}

