/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.anim;

import com.hazy.cache.Archive;
import com.hazy.cache.skeletal.AnimationBoneWrapper;
import com.hazy.collection.Cacheable;
import com.hazy.io.Buffer;
import com.hazy.util.FileUtils;
import java.io.IOException;
import java.util.Arrays;
import net.runelite.api.Skeleton;
import net.runelite.rs.api.RSNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FrameBase
extends Cacheable
implements Skeleton {
    private static final Logger log = LoggerFactory.getLogger(FrameBase.class);
    public final int id;
    public final int[] types;
    public final int[][] frameMaps;
    public final int length;
    public final AnimationBoneWrapper animationBoneWrapper;
    public static final FrameBase[] frameBases = new FrameBase[32768];

    public FrameBase(int id, Buffer buffer) {
        int i;
        this.id = id;
        int length = this.length = buffer.readUnsignedByte();
        int[] types = this.types = new int[length];
        int[][] nArrayArray = new int[length][];
        this.frameMaps = nArrayArray;
        int[][] frameMaps = nArrayArray;
        for (i = 0; i < length; ++i) {
            types[i] = buffer.readUnsignedByte();
        }
        for (i = 0; i < length; ++i) {
            frameMaps[i] = new int[buffer.readUnsignedByte()];
        }
        for (i = 0; i < length; ++i) {
            int[] frameMap = frameMaps[i];
            for (int j = 0; j < frameMap.length; ++j) {
                frameMap[j] = buffer.readUnsignedByte();
            }
        }
        this.animationBoneWrapper = FrameBase.loadABW(buffer);
    }

    private static AnimationBoneWrapper loadABW(Buffer in) {
        if (in.pos < in.payload.length) {
            int abwLength = in.readUnsignedShort();
            return abwLength > 0 ? new AnimationBoneWrapper(in, abwLength) : null;
        }
        return null;
    }

    public AnimationBoneWrapper getAbw() {
        return this.animationBoneWrapper;
    }

    @Override
    public int getCount() {
        return this.length;
    }

    @Override
    public int[] getTypes() {
        return this.types;
    }

    @Override
    public int[][] getList() {
        return this.frameMaps;
    }

    public static void loadFrameBases(Archive streamLoader) throws IOException {
        byte[] rawData = streamLoader.get("framebases.dat");
        byte[] uncompressedData = FileUtils.gZipDecompress(rawData);
        Buffer stream = new Buffer(uncompressedData);
        int count = stream.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            int fileId = stream.readUnsignedShort();
            int fileSize = stream.readUnsignedShort();
            byte[] fileData = stream.readBytes(fileSize);
            Buffer fileBuffer = new Buffer(fileData);
            FrameBase.frameBases[fileId] = new FrameBase(fileId, fileBuffer);
        }
    }

    @Override
    public RSNode getNext() {
        return null;
    }

    @Override
    public RSNode getPrevious() {
        return null;
    }

    @Override
    public void unlink() {
    }

    @Override
    public long getHash() {
        return 0L;
    }

    public int getId() {
        return this.id;
    }

    public int[][] getFrameMaps() {
        return this.frameMaps;
    }

    public int getLength() {
        return this.length;
    }

    public AnimationBoneWrapper getAnimationBoneWrapper() {
        return this.animationBoneWrapper;
    }

    public String toString() {
        return "FrameBase(id=" + this.getId() + ", types=" + Arrays.toString(this.getTypes()) + ", frameMaps=" + Arrays.deepToString((Object[])this.getFrameMaps()) + ", length=" + this.getLength() + ", animationBoneWrapper=" + String.valueOf(this.getAnimationBoneWrapper()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FrameBase)) {
            return false;
        }
        FrameBase other = (FrameBase)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof FrameBase;
    }

    public int hashCode() {
        boolean result2 = true;
        return 1;
    }
}

