/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.anim;

import com.hazy.cache.Archive;
import com.hazy.cache.anim.NormalFrame;
import com.hazy.cache.anim.SeqFrame;
import com.hazy.cache.skeletal.SkeletalFrame;
import com.hazy.collection.Cacheable;
import com.hazy.io.Buffer;
import com.hazy.util.FileUtils;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SeqDefinition
extends Cacheable {
    private static final Logger log = LoggerFactory.getLogger(SeqDefinition.class);
    public static SeqDefinition[] animations;
    public int frameCount;
    public final int animId;
    public int modelId;
    public int[] primaryFrameIds;
    public int[] frameModelIds;
    public int[] secondaryFrames;
    public int[] delays;
    public int[] interleaveOrder;
    public int frameStep;
    public boolean stretches;
    public boolean isEmpty;
    public int forcedPriority;
    public int leftHandItem;
    public int rightHandItem;
    public int resetCycle;
    public boolean shouldResetCycle;
    public int moveStyle;
    public int idleStyle;
    public int delayType;
    private int skeletalRangeBegin;
    private int skeletalRangeEnd;
    private int skeletalId = -1;
    private boolean[] masks = new boolean[256];
    public Int2IntMap skeletalSounds;

    public static void init(Archive streamLoader) throws IOException {
        byte[] rawData = streamLoader.get("seq.dat");
        byte[] uncompressedData = FileUtils.gZipDecompress(rawData);
        Buffer buffer = new Buffer(uncompressedData);
        int highestFileId = buffer.readUnsignedShort();
        SeqDefinition[] animations = SeqDefinition.animations;
        if (animations == null) {
            animations = SeqDefinition.animations = new SeqDefinition[highestFileId + 1 + 5000];
        }
        for (int i = 0; i <= highestFileId; ++i) {
            int id = buffer.readUnsignedShort();
            int animLength = buffer.readUnsignedShort();
            byte[] animData = buffer.readBytes(animLength);
            SeqDefinition animation = animations[id];
            if (animation == null) {
                animation = animations[id] = new SeqDefinition(id);
            }
            animation.readValues(new Buffer(animData), id);
            animation.postDecode();
            SeqDefinition.customAnimations(id);
            if (id >= highestFileId) break;
        }
    }

    private static void customAnimations(int id) {
        if (id == 3186) {
            SeqDefinition.animations[id].forcedPriority = 6;
            SeqDefinition.animations[id].moveStyle = 2;
            SeqDefinition.animations[id].idleStyle = 2;
            SeqDefinition.animations[id].resetCycle = 1;
            for (int a = 0; a < SeqDefinition.animations[id].delays.length; ++a) {
                if (SeqDefinition.animations[id].delays[a] != 9) continue;
                SeqDefinition.animations[id].delays[a] = 25;
            }
        }
        if (id == 5061 || id == 11901 || id == 5061 || id == 5061 || id == 7644 || id == 10656 || id == 6605) {
            SeqDefinition anim = animations[id];
            anim.modelId = -1;
            anim.leftHandItem = -1;
            anim.rightHandItem = -1;
        }
    }

    public int duration(int i) {
        SeqFrame frame;
        if (i > this.delays.length) {
            return 1;
        }
        int j = 0;
        try {
            j = this.delays[i];
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        if (j == 0 && (frame = SeqFrame.getFrame(this.primaryFrameIds[i])) instanceof NormalFrame) {
            j = this.delays[i] = ((NormalFrame)frame).defaultFrameLength;
        }
        if (j == 0) {
            j = 1;
        }
        return j;
    }

    public boolean areFramesEmpty() {
        return this.primaryFrameIds == null;
    }

    public static SeqDefinition get(int id) {
        return animations[id];
    }

    private void readValues(Buffer buffer, int animId) {
        int opcode;
        int lastOpcode = -1;
        while ((opcode = buffer.readUnsignedByte()) != 0) {
            if (opcode == 1) {
                int i;
                this.frameCount = buffer.readUnsignedShort();
                this.primaryFrameIds = new int[this.frameCount];
                this.secondaryFrames = new int[this.frameCount];
                this.delays = new int[this.frameCount];
                this.frameModelIds = new int[this.frameCount];
                for (i = 0; i < this.frameCount; ++i) {
                    this.delays[i] = buffer.readUnsignedShort();
                }
                for (i = 0; i < this.frameCount; ++i) {
                    this.primaryFrameIds[i] = buffer.readUnsignedShort();
                    this.secondaryFrames[i] = -1;
                }
                i = 0;
                while (i < this.frameCount) {
                    int frameBase = buffer.readUnsignedShort();
                    int n = i;
                    this.frameModelIds[n] = this.frameModelIds[n] + frameBase;
                    int n2 = i++;
                    this.primaryFrameIds[n2] = this.primaryFrameIds[n2] + (frameBase << 16);
                }
            } else if (opcode == 2) {
                this.frameStep = buffer.readUnsignedShort();
            } else if (opcode == 3) {
                int len = buffer.readUnsignedByte();
                int[] interleaveOrder = this.interleaveOrder = new int[len + 1];
                boolean[] masks = this.masks;
                for (int i = 0; i < len; ++i) {
                    int mask;
                    interleaveOrder[i] = mask = buffer.readUnsignedByte();
                    masks[mask] = true;
                }
                interleaveOrder[len] = 9999999;
            } else if (opcode == 4) {
                this.stretches = true;
            } else if (opcode == 5) {
                this.forcedPriority = buffer.readUnsignedByte();
            } else if (opcode == 6) {
                this.leftHandItem = buffer.readUnsignedShort();
            } else if (opcode == 7) {
                this.rightHandItem = buffer.readUnsignedShort();
            } else if (opcode == 8) {
                this.resetCycle = buffer.readUnsignedByte();
                this.shouldResetCycle = true;
            } else if (opcode == 9) {
                this.moveStyle = buffer.readUnsignedByte();
            } else if (opcode == 10) {
                this.idleStyle = buffer.readUnsignedByte();
            } else if (opcode == 11) {
                this.delayType = buffer.readUnsignedByte();
            } else if (opcode == 12) {
                int i;
                int len = buffer.readUnsignedByte();
                for (i = 0; i < len; ++i) {
                    buffer.readUnsignedShort();
                }
                for (i = 0; i < len; ++i) {
                    buffer.readUnsignedShort();
                }
            } else if (opcode == 13) {
                int len = buffer.readUnsignedByte();
                for (int i = 0; i < len; ++i) {
                    buffer.readUShort();
                    buffer.readUnsignedByte();
                    buffer.readUnsignedByte();
                    buffer.readUnsignedByte();
                }
            } else if (opcode == 14) {
                int skeletalId = this.skeletalId = buffer.readInt();
                SkeletalFrame.skeletalFrameIds.add(skeletalId >>> 16);
            } else if (opcode == 15) {
                int count = buffer.readUnsignedShort();
                for (int index = 0; index < count; ++index) {
                    buffer.readUnsignedShort();
                    buffer.readUShort();
                    buffer.readUnsignedByte();
                    buffer.readUnsignedByte();
                    buffer.readUnsignedByte();
                }
            } else if (opcode == 16) {
                this.skeletalRangeBegin = buffer.readUnsignedShort();
                this.skeletalRangeEnd = buffer.readUnsignedShort();
            } else if (opcode == 17) {
                boolean[] masks = this.masks = new boolean[256];
                Arrays.fill(masks, false);
                int len = buffer.readUnsignedByte();
                for (int i = 0; i < len; ++i) {
                    masks[buffer.readUnsignedByte()] = true;
                }
            } else {
                throw new IllegalStateException("Error unrecognised seq config code: " + opcode + ", last opcode: " + lastOpcode);
            }
            lastOpcode = opcode;
        }
        if (this.frameCount == 0) {
            this.frameCount = 1;
            this.primaryFrameIds = new int[]{-1};
            this.secondaryFrames = new int[]{-1};
            this.delays = new int[]{-1};
            this.isEmpty = true;
        }
        if (this.moveStyle == -1) {
            this.moveStyle = this.interleaveOrder == null ? 0 : 2;
            int n = this.moveStyle;
        }
        if (this.idleStyle == -1) {
            this.idleStyle = this.interleaveOrder == null ? 0 : 2;
            int n = this.idleStyle;
        }
        if (animId == 6600) {
            this.delayType = 2;
        }
        if (animId == 9168) {
            this.delayType = 2;
            this.moveStyle = 0;
            this.idleStyle = 0;
        }
        if (animId == 9162) {
            this.moveStyle = 1;
            this.idleStyle = 1;
        }
        switch (animId) {
            case 4117: {
                this.delays = new int[]{500, 500, 400, 400, 400, 400, 6, 8, 8};
                break;
            }
            case 4103: {
                this.delays = new int[]{5, 4, 4, 4, 4, 2, 2, 5};
                break;
            }
            case 7471: {
                this.delays = new int[]{3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            }
        }
    }

    private SeqDefinition(int animId) {
        this.animId = animId;
        this.frameStep = -1;
        this.skeletalId = -1;
        this.stretches = false;
        this.forcedPriority = 5;
        this.leftHandItem = -1;
        this.rightHandItem = -1;
        this.resetCycle = 99;
        this.moveStyle = -1;
        this.idleStyle = -1;
        this.delayType = 1;
    }

    public void postDecode() {
        if (this.moveStyle == -1) {
            this.moveStyle = this.masks == null && this.masks == null ? 0 : 2;
        }
        if (this.idleStyle == -1) {
            this.idleStyle = this.masks == null && this.masks == null ? 0 : 2;
        }
    }

    public boolean isSkeletalAnimation() {
        return this.skeletalId >= 0;
    }

    public int getSkeletalLength() {
        return this.skeletalRangeEnd - this.skeletalRangeBegin;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int getAnimId() {
        return this.animId;
    }

    public int getModelId() {
        return this.modelId;
    }

    public int[] getPrimaryFrameIds() {
        return this.primaryFrameIds;
    }

    public int[] getFrameModelIds() {
        return this.frameModelIds;
    }

    public int[] getSecondaryFrames() {
        return this.secondaryFrames;
    }

    public int[] getDelays() {
        return this.delays;
    }

    public int[] getInterleaveOrder() {
        return this.interleaveOrder;
    }

    public boolean isStretches() {
        return this.stretches;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public int getForcedPriority() {
        return this.forcedPriority;
    }

    public int getLeftHandItem() {
        return this.leftHandItem;
    }

    public int getRightHandItem() {
        return this.rightHandItem;
    }

    public int getResetCycle() {
        return this.resetCycle;
    }

    public boolean isShouldResetCycle() {
        return this.shouldResetCycle;
    }

    public int getMoveStyle() {
        return this.moveStyle;
    }

    public int getIdleStyle() {
        return this.idleStyle;
    }

    public int getDelayType() {
        return this.delayType;
    }

    public int getSkeletalRangeBegin() {
        return this.skeletalRangeBegin;
    }

    public int getSkeletalRangeEnd() {
        return this.skeletalRangeEnd;
    }

    public Int2IntMap getSkeletalSounds() {
        return this.skeletalSounds;
    }

    public void setFrameCount(int frameCount) {
        this.frameCount = frameCount;
    }

    public void setModelId(int modelId) {
        this.modelId = modelId;
    }

    public void setPrimaryFrameIds(int[] primaryFrameIds) {
        this.primaryFrameIds = primaryFrameIds;
    }

    public void setFrameModelIds(int[] frameModelIds) {
        this.frameModelIds = frameModelIds;
    }

    public void setSecondaryFrames(int[] secondaryFrames) {
        this.secondaryFrames = secondaryFrames;
    }

    public void setDelays(int[] delays) {
        this.delays = delays;
    }

    public void setInterleaveOrder(int[] interleaveOrder) {
        this.interleaveOrder = interleaveOrder;
    }

    public void setFrameStep(int frameStep) {
        this.frameStep = frameStep;
    }

    public void setStretches(boolean stretches) {
        this.stretches = stretches;
    }

    public void setEmpty(boolean isEmpty) {
        this.isEmpty = isEmpty;
    }

    public void setForcedPriority(int forcedPriority) {
        this.forcedPriority = forcedPriority;
    }

    public void setLeftHandItem(int leftHandItem) {
        this.leftHandItem = leftHandItem;
    }

    public void setRightHandItem(int rightHandItem) {
        this.rightHandItem = rightHandItem;
    }

    public void setResetCycle(int resetCycle) {
        this.resetCycle = resetCycle;
    }

    public void setShouldResetCycle(boolean shouldResetCycle) {
        this.shouldResetCycle = shouldResetCycle;
    }

    public void setMoveStyle(int moveStyle) {
        this.moveStyle = moveStyle;
    }

    public void setIdleStyle(int idleStyle) {
        this.idleStyle = idleStyle;
    }

    public void setDelayType(int delayType) {
        this.delayType = delayType;
    }

    public void setSkeletalRangeBegin(int skeletalRangeBegin) {
        this.skeletalRangeBegin = skeletalRangeBegin;
    }

    public void setSkeletalRangeEnd(int skeletalRangeEnd) {
        this.skeletalRangeEnd = skeletalRangeEnd;
    }

    public void setSkeletalId(int skeletalId) {
        this.skeletalId = skeletalId;
    }

    public void setMasks(boolean[] masks) {
        this.masks = masks;
    }

    public void setSkeletalSounds(Int2IntMap skeletalSounds) {
        this.skeletalSounds = skeletalSounds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeqDefinition)) {
            return false;
        }
        SeqDefinition other = (SeqDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFrameCount() != other.getFrameCount()) {
            return false;
        }
        if (this.getAnimId() != other.getAnimId()) {
            return false;
        }
        if (this.getModelId() != other.getModelId()) {
            return false;
        }
        if (this.getFrameStep() != other.getFrameStep()) {
            return false;
        }
        if (this.isStretches() != other.isStretches()) {
            return false;
        }
        if (this.isEmpty() != other.isEmpty()) {
            return false;
        }
        if (this.getForcedPriority() != other.getForcedPriority()) {
            return false;
        }
        if (this.getLeftHandItem() != other.getLeftHandItem()) {
            return false;
        }
        if (this.getRightHandItem() != other.getRightHandItem()) {
            return false;
        }
        if (this.getResetCycle() != other.getResetCycle()) {
            return false;
        }
        if (this.isShouldResetCycle() != other.isShouldResetCycle()) {
            return false;
        }
        if (this.getMoveStyle() != other.getMoveStyle()) {
            return false;
        }
        if (this.getIdleStyle() != other.getIdleStyle()) {
            return false;
        }
        if (this.getDelayType() != other.getDelayType()) {
            return false;
        }
        if (this.getSkeletalRangeBegin() != other.getSkeletalRangeBegin()) {
            return false;
        }
        if (this.getSkeletalRangeEnd() != other.getSkeletalRangeEnd()) {
            return false;
        }
        if (this.getSkeletalId() != other.getSkeletalId()) {
            return false;
        }
        if (!Arrays.equals(this.getPrimaryFrameIds(), other.getPrimaryFrameIds())) {
            return false;
        }
        if (!Arrays.equals(this.getFrameModelIds(), other.getFrameModelIds())) {
            return false;
        }
        if (!Arrays.equals(this.getSecondaryFrames(), other.getSecondaryFrames())) {
            return false;
        }
        if (!Arrays.equals(this.getDelays(), other.getDelays())) {
            return false;
        }
        if (!Arrays.equals(this.getInterleaveOrder(), other.getInterleaveOrder())) {
            return false;
        }
        if (!Arrays.equals(this.getMasks(), other.getMasks())) {
            return false;
        }
        Int2IntMap this$skeletalSounds = this.getSkeletalSounds();
        Int2IntMap other$skeletalSounds = other.getSkeletalSounds();
        return !(this$skeletalSounds == null ? other$skeletalSounds != null : !this$skeletalSounds.equals(other$skeletalSounds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SeqDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        result2 = result2 * 59 + this.getFrameCount();
        result2 = result2 * 59 + this.getAnimId();
        result2 = result2 * 59 + this.getModelId();
        result2 = result2 * 59 + this.getFrameStep();
        result2 = result2 * 59 + (this.isStretches() ? 79 : 97);
        result2 = result2 * 59 + (this.isEmpty() ? 79 : 97);
        result2 = result2 * 59 + this.getForcedPriority();
        result2 = result2 * 59 + this.getLeftHandItem();
        result2 = result2 * 59 + this.getRightHandItem();
        result2 = result2 * 59 + this.getResetCycle();
        result2 = result2 * 59 + (this.isShouldResetCycle() ? 79 : 97);
        result2 = result2 * 59 + this.getMoveStyle();
        result2 = result2 * 59 + this.getIdleStyle();
        result2 = result2 * 59 + this.getDelayType();
        result2 = result2 * 59 + this.getSkeletalRangeBegin();
        result2 = result2 * 59 + this.getSkeletalRangeEnd();
        result2 = result2 * 59 + this.getSkeletalId();
        result2 = result2 * 59 + Arrays.hashCode(this.getPrimaryFrameIds());
        result2 = result2 * 59 + Arrays.hashCode(this.getFrameModelIds());
        result2 = result2 * 59 + Arrays.hashCode(this.getSecondaryFrames());
        result2 = result2 * 59 + Arrays.hashCode(this.getDelays());
        result2 = result2 * 59 + Arrays.hashCode(this.getInterleaveOrder());
        result2 = result2 * 59 + Arrays.hashCode(this.getMasks());
        Int2IntMap $skeletalSounds = this.getSkeletalSounds();
        result2 = result2 * 59 + ($skeletalSounds == null ? 43 : $skeletalSounds.hashCode());
        return result2;
    }

    public String toString() {
        return "SeqDefinition(frameCount=" + this.getFrameCount() + ", animId=" + this.getAnimId() + ", modelId=" + this.getModelId() + ", primaryFrameIds=" + Arrays.toString(this.getPrimaryFrameIds()) + ", frameModelIds=" + Arrays.toString(this.getFrameModelIds()) + ", secondaryFrames=" + Arrays.toString(this.getSecondaryFrames()) + ", delays=" + Arrays.toString(this.getDelays()) + ", interleaveOrder=" + Arrays.toString(this.getInterleaveOrder()) + ", frameStep=" + this.getFrameStep() + ", stretches=" + this.isStretches() + ", isEmpty=" + this.isEmpty() + ", forcedPriority=" + this.getForcedPriority() + ", leftHandItem=" + this.getLeftHandItem() + ", rightHandItem=" + this.getRightHandItem() + ", resetCycle=" + this.getResetCycle() + ", shouldResetCycle=" + this.isShouldResetCycle() + ", moveStyle=" + this.getMoveStyle() + ", idleStyle=" + this.getIdleStyle() + ", delayType=" + this.getDelayType() + ", skeletalRangeBegin=" + this.getSkeletalRangeBegin() + ", skeletalRangeEnd=" + this.getSkeletalRangeEnd() + ", skeletalId=" + this.getSkeletalId() + ", masks=" + Arrays.toString(this.getMasks()) + ", skeletalSounds=" + String.valueOf(this.getSkeletalSounds()) + ")";
    }

    public int getFrameStep() {
        return this.frameStep;
    }

    public int getSkeletalId() {
        return this.skeletalId;
    }

    public boolean[] getMasks() {
        return this.masks;
    }
}

