/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.anim;

import com.hazy.cache.Archive;
import com.hazy.cache.anim.SeqDefinition;
import com.hazy.collection.TempCache;
import com.hazy.entity.model.Model;
import com.hazy.io.Buffer;
import net.runelite.rs.api.RSModel;
import net.runelite.rs.api.RSSpotAnimationDefinition;

public final class SpotAnimation
implements RSSpotAnimationDefinition {
    public int gfxId;
    public static SpotAnimation[] spotAnims;
    public int modelId;
    public int animationId = -1;
    public SeqDefinition seq;
    public short[] originalModelColors;
    public short[] modifiedModelColors;
    public short[] textureToFind;
    public short[] textureToReplace;
    public int model_scale_x = 128;
    public int model_scale_y = 128;
    public int rotation = 0;
    public int ambient = 0;
    public int contrast = 0;
    public static TempCache model_cache;

    private SpotAnimation(int gfxId) {
        this.gfxId = gfxId;
        this.animationId = -1;
        this.originalModelColors = new short[6];
        this.modifiedModelColors = new short[6];
        this.model_scale_x = 128;
        this.model_scale_y = 128;
    }

    public static void init(Archive archive) {
        int id;
        Buffer buffer = new Buffer(archive.get("spotanim.dat"));
        int graphicCount = buffer.readUnsignedShort();
        SpotAnimation[] spotAnims = SpotAnimation.spotAnims;
        if (spotAnims == null) {
            spotAnims = SpotAnimation.spotAnims = new SpotAnimation[graphicCount + 1 + 2000];
        }
        for (int i = 0; i <= graphicCount && (id = buffer.readUnsignedShort()) != 65535; ++i) {
            SpotAnimation spotAnim = spotAnims[id];
            if (spotAnim == null) {
                spotAnim = spotAnims[id] = new SpotAnimation(id);
            }
            int dataSize = buffer.readUnsignedShort();
            byte[] data2 = buffer.readBytes(dataSize);
            Buffer dataBuffer = new Buffer(data2);
            spotAnim.decoder(dataBuffer);
            SpotAnimation.unpack(spotAnim.gfxId);
        }
    }

    public static void unpack(int graphic) {
        if (graphic == 5000) {
            SpotAnimation.spotAnims[graphic] = new SpotAnimation();
            SpotAnimation.spotAnims[graphic].gfxId = graphic;
            SpotAnimation.spotAnims[graphic].animationId = 6960;
            SpotAnimation.spotAnims[graphic].seq = SeqDefinition.get(6960);
            SpotAnimation.spotAnims[graphic].modelId = 58928;
            SpotAnimation.spotAnims[graphic].model_scale_x = 180;
            SpotAnimation.spotAnims[graphic].model_scale_y = 180;
        }
        if (graphic == 5001) {
            SpotAnimation.spotAnims[graphic] = new SpotAnimation();
            SpotAnimation.spotAnims[graphic].gfxId = graphic;
            SpotAnimation.spotAnims[graphic].animationId = 465;
            SpotAnimation.spotAnims[graphic].seq = SeqDefinition.get(465);
            SpotAnimation.spotAnims[graphic].modelId = 58925;
            SpotAnimation.spotAnims[graphic].model_scale_x = 80;
            SpotAnimation.spotAnims[graphic].model_scale_y = 80;
        }
        if (graphic == 5002) {
            SpotAnimation.spotAnims[graphic] = new SpotAnimation();
            SpotAnimation.spotAnims[graphic].gfxId = graphic;
            SpotAnimation.spotAnims[graphic].animationId = 7080;
            SpotAnimation.spotAnims[graphic].seq = SeqDefinition.get(7080);
            SpotAnimation.spotAnims[graphic].modelId = 58926;
        }
        if (graphic == 5061) {
            SpotAnimation.spotAnims[graphic].modelId = -1;
        }
        if (graphic == 10656) {
            SpotAnimation.spotAnims[graphic].modelId = -1;
        }
        if (graphic == 5004) {
            SpotAnimation.spotAnims[graphic] = new SpotAnimation();
            SpotAnimation.spotAnims[graphic].gfxId = graphic;
            SpotAnimation.spotAnims[graphic].animationId = 8287;
            SpotAnimation.spotAnims[graphic].seq = SeqDefinition.get(8287);
            SpotAnimation.spotAnims[graphic].modelId = 58929;
        }
        if (graphic == 5005) {
            SpotAnimation.spotAnims[graphic] = new SpotAnimation();
            SpotAnimation.spotAnims[graphic].gfxId = graphic;
            SpotAnimation.spotAnims[graphic].animationId = 5358;
            SpotAnimation.spotAnims[graphic].seq = SeqDefinition.get(5358);
            SpotAnimation.spotAnims[graphic].modelId = 58930;
        }
        if (graphic == 10006) {
            SpotAnimation.spotAnims[graphic] = new SpotAnimation();
            SpotAnimation.spotAnims[graphic].gfxId = graphic;
            SpotAnimation.spotAnims[graphic].modelId = 3479;
            SpotAnimation.spotAnims[graphic].animationId = 1061;
            SpotAnimation.spotAnims[graphic].seq = SeqDefinition.get(1061);
            SpotAnimation.spotAnims[graphic].ambient = 50;
            SpotAnimation.spotAnims[graphic].contrast = 50;
            SpotAnimation.spotAnims[graphic].originalModelColors = new short[]{960};
            SpotAnimation.spotAnims[graphic].modifiedModelColors = new short[]{-12535};
        }
        if (graphic == 10004) {
            SpotAnimation.spotAnims[graphic] = new SpotAnimation();
            SpotAnimation.spotAnims[graphic].gfxId = graphic;
            SpotAnimation.spotAnims[graphic].modelId = 42604;
            SpotAnimation.spotAnims[graphic].ambient = 40;
            SpotAnimation.spotAnims[graphic].contrast = 120;
            SpotAnimation.spotAnims[graphic].originalModelColors = new short[]{-32539, 127};
            SpotAnimation.spotAnims[graphic].modifiedModelColors = new short[]{-32535, -32541};
        }
        if (graphic == 10005) {
            SpotAnimation.spotAnims[graphic] = new SpotAnimation();
            SpotAnimation.spotAnims[graphic].gfxId = graphic;
            SpotAnimation.spotAnims[graphic].modelId = 42603;
            SpotAnimation.spotAnims[graphic].animationId = 366;
            SpotAnimation.spotAnims[graphic].seq = SeqDefinition.get(366);
            SpotAnimation.spotAnims[graphic].ambient = 40;
            SpotAnimation.spotAnims[graphic].contrast = 120;
            SpotAnimation.spotAnims[graphic].originalModelColors = new short[]{-32539, 127};
            SpotAnimation.spotAnims[graphic].modifiedModelColors = new short[]{-32535, -32541};
        }
        if (graphic == 2283) {
            System.out.println(SpotAnimation.spotAnims[graphic].seq.animId + " " + String.valueOf(SpotAnimation.spotAnims[graphic].seq));
        }
        if (graphic == 61) {
            SpotAnimation.spotAnims[graphic] = new SpotAnimation();
            SpotAnimation.spotAnims[graphic].gfxId = graphic;
            SpotAnimation.spotAnims[graphic].modelId = 69837;
        }
        if (graphic == 60) {
            SpotAnimation.spotAnims[graphic] = new SpotAnimation();
            SpotAnimation.spotAnims[graphic].gfxId = graphic;
            SpotAnimation.spotAnims[graphic].modelId = 69837;
            SpotAnimation.spotAnims[graphic].animationId = 366;
            SpotAnimation.spotAnims[graphic].seq = SeqDefinition.get(366);
            SpotAnimation.spotAnims[graphic].ambient = 40;
            SpotAnimation.spotAnims[graphic].contrast = 120;
        }
    }

    public void decoder(Buffer buffer) {
        int opcode;
        while ((opcode = buffer.readUnsignedByte()) != 0) {
            this.decodeNext(buffer, opcode);
        }
    }

    public void decodeNext(Buffer var1, int var2) {
        block3: {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            if (var2 != 1) break block2;
                                            this.modelId = var1.readUnsignedShort();
                                            break block3;
                                        }
                                        if (var2 != 2) break block4;
                                        this.animationId = var1.readUnsignedShort();
                                        this.seq = SeqDefinition.get(this.animationId);
                                        break block3;
                                    }
                                    if (var2 != 4) break block5;
                                    this.model_scale_x = var1.readUnsignedShort();
                                    break block3;
                                }
                                if (var2 != 5) break block6;
                                this.model_scale_y = var1.readUnsignedShort();
                                break block3;
                            }
                            if (var2 != 6) break block7;
                            this.rotation = var1.readUnsignedShort();
                            break block3;
                        }
                        if (var2 != 7) break block8;
                        this.ambient = var1.readUnsignedByte();
                        break block3;
                    }
                    if (var2 != 8) break block9;
                    this.contrast = var1.readUnsignedByte();
                    break block3;
                }
                if (var2 != 40) break block10;
                int var3 = var1.readUnsignedByte();
                this.originalModelColors = new short[var3];
                this.modifiedModelColors = new short[var3];
                for (int var4 = 0; var4 < var3; ++var4) {
                    this.originalModelColors[var4] = (short)var1.readUnsignedShort();
                    this.modifiedModelColors[var4] = (short)var1.readUnsignedShort();
                }
                break block3;
            }
            if (var2 != 41) break block3;
            int var3 = var1.readUnsignedByte();
            this.textureToFind = new short[var3];
            this.textureToReplace = new short[var3];
            for (int var4 = 0; var4 < var3; ++var4) {
                this.textureToFind[var4] = (short)var1.readUnsignedShort();
                this.textureToReplace[var4] = (short)var1.readUnsignedShort();
            }
        }
    }

    public final Model get(int var1) {
        Model baseModel = this.get_model();
        if (baseModel == null) {
            System.err.println("[SpotAnim " + this.gfxId + "] Missing base model (modelId=" + this.modelId + ")");
            return null;
        }
        Model model = this.seq != null && this.seq.animId != -1 && var1 != -1 ? Model.get(this.modelId).toSharedSpotAnimationModel(true) : baseModel.toSharedSpotAnimationModel(true);
        if (this.model_scale_x != 128 || this.model_scale_y != 128) {
            System.out.println("[SpotAnim " + this.gfxId + "] Scaling model (scaleX=" + this.model_scale_x + ", scaleY=" + this.model_scale_y + ")");
            model.scale(this.model_scale_x, this.model_scale_y, this.model_scale_x);
        }
        if (this.rotation != 0) {
            System.out.println("[SpotAnim " + this.gfxId + "] Rotating model by " + this.rotation + " degrees");
            if (this.rotation == 90) {
                model.rotateY90Ccw();
            } else if (this.rotation == 180) {
                model.rotateY90Ccw();
                model.rotateY90Ccw();
            } else if (this.rotation == 270) {
                model.rotateY90Ccw();
                model.rotateY90Ccw();
                model.rotateY90Ccw();
            }
        }
        return model;
    }

    public Model get_model() {
        int index;
        Model model = (Model)model_cache.get(this.gfxId);
        if (model != null) {
            return model;
        }
        model = Model.get(this.modelId);
        if (model == null) {
            return null;
        }
        if (this.originalModelColors != null) {
            for (index = 0; index < this.originalModelColors.length; ++index) {
                if (this.originalModelColors[0] == 0) continue;
                model.recolor(this.originalModelColors[index], this.modifiedModelColors[index]);
            }
        }
        if (this.textureToFind != null) {
            for (index = 0; index < this.textureToFind.length; ++index) {
                if (this.textureToFind[0] == 0) continue;
                model.retexture(this.textureToFind[index], this.textureToReplace[index]);
            }
        }
        model_cache.put(model, this.gfxId);
        return model;
    }

    public SpotAnimation() {
    }

    @Override
    public RSModel getModel(int var1) {
        return this.get_model();
    }

    @Override
    public void setRecolorFrom(short[] from) {
        this.originalModelColors = from;
    }

    @Override
    public void setRecolorTo(short[] to) {
        this.modifiedModelColors = to;
    }

    @Override
    public int getSequence() {
        return this.seq.animId;
    }

    static {
        model_cache = new TempCache(30);
    }
}

