/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.anims.datastructure;

import com.hazy.cache.anims.datastructure.IterableNodeHashTableIterator;
import com.hazy.cache.anims.datastructure.Node;
import java.util.Iterator;

public final class IterableNodeHashTable
implements Iterable {
    int size;
    Node[] buckets;
    Node currentGet;
    Node current;
    int index = 0;

    public IterableNodeHashTable(int var1) {
        this.size = var1;
        this.buckets = new Node[var1];
        for (int var2 = 0; var2 < var1; ++var2) {
            Node var3;
            var3.previous = var3 = (this.buckets[var2] = new Node());
            var3.next = var3;
        }
    }

    public Node get(long var1) {
        Node var3 = this.buckets[(int)(var1 & (long)(this.size - 1))];
        this.currentGet = var3.previous;
        while (var3 != this.currentGet) {
            if (this.currentGet.key == var1) {
                Node var4 = this.currentGet;
                this.currentGet = this.currentGet.previous;
                return var4;
            }
            this.currentGet = this.currentGet.previous;
        }
        this.currentGet = null;
        return null;
    }

    public void put(Node var1, long var2) {
        if (var1.next != null) {
            var1.remove();
        }
        Node var4 = this.buckets[(int)(var2 & (long)(this.size - 1))];
        var1.next = var4.next;
        var1.previous = var4;
        var1.next.previous = var1;
        var1.previous.next = var1;
        var1.key = var2;
    }

    public void clear() {
        for (int var1 = 0; var1 < this.size; ++var1) {
            Node var3;
            Node var2 = this.buckets[var1];
            while ((var3 = var2.previous) != var2) {
                var3.remove();
            }
        }
        this.currentGet = null;
        this.current = null;
    }

    public Node first() {
        this.index = 0;
        return this.next();
    }

    public Node next() {
        Node var1;
        if (this.index > 0 && this.buckets[this.index - 1] != this.current) {
            Node var12 = this.current;
            this.current = var12.previous;
            return var12;
        }
        do {
            if (this.index < this.size) continue;
            return null;
        } while ((var1 = this.buckets[this.index++].previous) == this.buckets[this.index - 1]);
        this.current = var1.previous;
        return var1;
    }

    public Iterator iterator() {
        return new IterableNodeHashTableIterator(this);
    }
}

