/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.def;

import com.hazy.Client;
import com.hazy.cache.Archive;
import com.hazy.cache.graphics.SimpleImage;
import com.hazy.io.Buffer;
import java.util.HashMap;

public final class AreaDefinition {
    public static int size;
    public int[] field3292;
    public static int mapFunctionsSize;
    public static AreaDefinition[] cache;
    public static HashMap<Integer, SimpleImage> sprites;
    private static int cacheIndex;
    private static Buffer area_data;
    private static int[] indices;
    public int id = -1;
    public int spriteId = -1;
    public int field3294 = -1;
    public String name = "";
    public int fontColor = -1;
    public int field3297 = -1;
    public String[] actions;
    public int field3310 = -1;
    public int field3296;
    public String[] field3298 = new String[5];
    public int[] field3300;
    public String field3308;
    public byte[] field3309;

    public static void init(Archive archive) {
        int _ctr;
        area_data = new Buffer(archive.get("areas.dat"));
        Buffer stream = new Buffer(archive.get("areas.idx"));
        size = stream.readUnsignedShort();
        System.out.println("areas " + size);
        indices = new int[size];
        int offset = 2;
        for (_ctr = 0; _ctr < size; ++_ctr) {
            AreaDefinition.indices[_ctr] = offset;
            offset += stream.readUnsignedShort();
        }
        cache = new AreaDefinition[10];
        for (_ctr = 0; _ctr < 10; ++_ctr) {
            AreaDefinition.cache[_ctr] = new AreaDefinition();
        }
        System.out.println("Areas read -> " + size);
    }

    public static SimpleImage getImage(int sprite) {
        return sprites.get(sprite);
    }

    public static AreaDefinition lookup(int area) {
        for (int count = 0; count < 10; ++count) {
            if (AreaDefinition.cache[count].id != area) continue;
            return cache[count];
        }
        cacheIndex = (cacheIndex + 1) % 10;
        AreaDefinition data2 = cache[cacheIndex];
        if (area >= 0) {
            int opcode;
            AreaDefinition.area_data.pos = indices[area];
            while ((opcode = area_data.readUnsignedByte()) != 0) {
                data2.processOpcode(area_data, opcode);
            }
            if (!sprites.containsKey(data2.spriteId)) {
                try {
                    sprites.put(data2.spriteId, new SimpleImage(Client.instance.mediaStreamLoader, "mapfunction", data2.spriteId));
                }
                catch (Exception e) {
                    System.out.println("Missing Sprite: " + data2.spriteId + " Using Shop Icon");
                    sprites.put(data2.spriteId, new SimpleImage(Client.instance.mediaStreamLoader, "mapfunction", 0));
                }
            }
        }
        return data2;
    }

    private AreaDefinition() {
    }

    public static void clear() {
        indices = null;
        cache = null;
        area_data = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processOpcode(Buffer in, int opcode) {
        if (opcode == 1) {
            this.spriteId = in.readBigSmart2();
            return;
        } else if (opcode == 2) {
            this.field3294 = in.readBigSmart2();
            return;
        } else if (opcode == 3) {
            this.name = in.readString();
            return;
        } else if (opcode == 4) {
            this.field3296 = in.read24Int();
            return;
        } else if (opcode == 5) {
            in.read24Int();
            return;
        } else if (opcode == 6) {
            this.field3310 = in.readUnsignedByte();
            return;
        } else {
            if (opcode == 7) {
                int var3 = in.readUnsignedByte();
                if ((var3 & 1) == 0) {
                    // empty if block
                }
                if ((var3 & 2) != 2) return;
            }
            if (opcode == 8) {
                in.readUnsignedByte();
                return;
            } else if (opcode >= 10 && opcode <= 14) {
                this.field3298[opcode - 10] = in.readString();
                return;
            } else if (opcode == 15) {
                int var5;
                int var4;
                int var3 = in.readUnsignedByte();
                this.field3300 = new int[var3 * 2];
                for (var4 = 0; var4 < var3 * 2; ++var4) {
                    this.field3300[var4] = in.readShort();
                }
                in.readInt();
                var4 = in.readUnsignedByte();
                this.field3292 = new int[var4];
                for (var5 = 0; var5 < this.field3292.length; ++var5) {
                    this.field3292[var5] = in.readInt();
                }
                this.field3309 = new byte[var3];
                for (var5 = 0; var5 < var3; ++var5) {
                    this.field3309[var5] = in.readByte();
                }
                return;
            } else {
                if (opcode == 16) return;
                if (opcode == 17) {
                    this.field3308 = in.readString();
                    return;
                } else if (opcode == 18) {
                    in.readBigSmart2();
                    return;
                } else if (opcode == 19) {
                    this.field3297 = in.readUnsignedShort();
                    return;
                } else if (opcode == 21) {
                    in.readInt();
                    return;
                } else if (opcode == 22) {
                    in.readInt();
                    return;
                } else if (opcode == 23) {
                    in.readUnsignedByte();
                    in.readUnsignedByte();
                    in.readUnsignedByte();
                    return;
                } else if (opcode == 24) {
                    in.readShort();
                    in.readShort();
                    return;
                } else if (opcode == 25) {
                    in.readBigSmart2();
                    return;
                } else if (opcode == 28) {
                    in.readUnsignedByte();
                    return;
                } else if (opcode == 29) {
                    in.readUnsignedByte();
                    return;
                } else {
                    if (opcode != 30) return;
                    in.readUnsignedByte();
                }
            }
        }
    }

    public void readValues(Buffer buffer) {
        int opCode;
        while ((opCode = buffer.readUnsignedByte()) != 0) {
            if (opCode == 1) {
                this.spriteId = buffer.readBigSmart2();
                continue;
            }
            if (opCode == 2) {
                this.field3294 = buffer.readBigSmart2();
                continue;
            }
            if (opCode == 3) {
                this.name = buffer.readString();
                continue;
            }
            if (opCode == 4) {
                this.fontColor = buffer.read24Int();
                continue;
            }
            if (opCode == 5) {
                this.field3297 = buffer.read24Int();
                continue;
            }
            if (opCode != 6) continue;
            this.fontColor = buffer.readUnsignedByte();
        }
        return;
    }

    static {
        sprites = new HashMap();
    }
}

