/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.def;

import com.hazy.cache.Archive;
import java.nio.ByteBuffer;

public class FloorDefinition {
    public static FloorDefinition[] overlays;
    public static FloorDefinition[] underlays;
    public int rgb = 0;
    public int texture = -1;
    public boolean hideUnderlay = true;
    public int secondaryRgb = -1;
    public int hue;
    public int saturation;
    public int lightness;
    public int secondaryHue;
    public int secondarySaturation;
    public int secondaryLightness;
    public int luminance;
    public int anotherHue;
    public int anotherSaturation;
    public int anotherLuminance;
    public int blendHue;
    public int blendHueMultiplier;
    public int hsl16;

    public static void init(Archive archive) {
        ByteBuffer buffer = ByteBuffer.wrap(archive.get("flo.dat"));
        int underlayAmount = buffer.getShort();
        underlays = new FloorDefinition[underlayAmount];
        for (int i = 0; i < underlayAmount; ++i) {
            if (underlays[i] == null) {
                FloorDefinition.underlays[i] = new FloorDefinition();
            }
            underlays[i].readValuesUnderlay(buffer);
            underlays[i].generateHsl(true);
        }
        int overlayAmount = buffer.getShort();
        overlays = new FloorDefinition[overlayAmount];
        for (int i = 0; i < overlayAmount; ++i) {
            if (overlays[i] == null) {
                FloorDefinition.overlays[i] = new FloorDefinition();
            }
            overlays[i].readValuesOverlay(buffer);
            overlays[i].postDecode();
        }
        System.out.println("Floors read -> (" + underlayAmount + " underlays) | (" + overlayAmount + " overlays)");
    }

    private FloorDefinition() {
    }

    private void generateHsl(boolean isUnderlay) {
        if (this.secondaryRgb != -1) {
            this.rgbToHsl(this.secondaryRgb);
            this.anotherHue = this.hue;
            this.anotherSaturation = this.saturation;
            this.anotherLuminance = this.luminance;
        }
        int color = this.rgb;
        this.rgbToHsl(color);
    }

    private void readValuesUnderlay(ByteBuffer buffer) {
        byte opcode;
        while ((opcode = buffer.get()) != 0) {
            if (opcode == 1) {
                this.rgb = ((buffer.get() & 0xFF) << 16) + ((buffer.get() & 0xFF) << 8) + (buffer.get() & 0xFF);
                continue;
            }
            System.out.println("Error unrecognised underlay code: " + opcode);
        }
    }

    private void readValuesOverlay(ByteBuffer buffer) {
        byte opcode;
        while ((opcode = buffer.get()) != 0) {
            if (opcode == 1) {
                this.rgb = ((buffer.get() & 0xFF) << 16) + ((buffer.get() & 0xFF) << 8) + (buffer.get() & 0xFF);
                continue;
            }
            if (opcode == 2) {
                this.texture = buffer.get() & 0xFF;
                continue;
            }
            if (opcode == 5) {
                this.hideUnderlay = false;
                continue;
            }
            if (opcode == 7) {
                this.secondaryRgb = ((buffer.get() & 0xFF) << 16) + ((buffer.get() & 0xFF) << 8) + (buffer.get() & 0xFF);
                continue;
            }
            System.out.println("Error unrecognised overlay code: " + opcode);
        }
    }

    public void postDecode() {
        if (this.secondaryRgb != -1) {
            this.setHsl(this.secondaryRgb);
            this.secondaryHue = this.hue;
            this.secondarySaturation = this.saturation;
            this.secondaryLightness = this.lightness;
        }
        this.setHsl(this.rgb);
    }

    void setHsl(int var1) {
        double var2 = (double)(var1 >> 16 & 0xFF) / 256.0;
        double var4 = (double)(var1 >> 8 & 0xFF) / 256.0;
        double var6 = (double)(var1 & 0xFF) / 256.0;
        double var8 = var2;
        if (var4 < var2) {
            var8 = var4;
        }
        if (var6 < var8) {
            var8 = var6;
        }
        double var10 = var2;
        if (var4 > var2) {
            var10 = var4;
        }
        if (var6 > var10) {
            var10 = var6;
        }
        double var12 = 0.0;
        double var14 = 0.0;
        double var16 = (var10 + var8) / 2.0;
        if (var10 != var8) {
            if (var16 < 0.5) {
                var14 = (var10 - var8) / (var8 + var10);
            }
            if (var16 >= 0.5) {
                var14 = (var10 - var8) / (2.0 - var10 - var8);
            }
            if (var10 == var2) {
                var12 = (var4 - var6) / (var10 - var8);
            } else if (var4 == var10) {
                var12 = 2.0 + (var6 - var2) / (var10 - var8);
            } else if (var6 == var10) {
                var12 = 4.0 + (var2 - var4) / (var10 - var8);
            }
        }
        this.hue = (int)(256.0 * (var12 /= 6.0));
        this.saturation = (int)(256.0 * var14);
        this.lightness = (int)(256.0 * var16);
        if (this.saturation < 0) {
            this.saturation = 0;
        } else if (this.saturation > 255) {
            this.saturation = 255;
        }
        if (this.lightness < 0) {
            this.lightness = 0;
        } else if (this.lightness > 255) {
            this.lightness = 255;
        }
    }

    private void rgbToHsl(int rgb) {
        double max;
        double r = (double)(rgb >> 16 & 0xFF) / 256.0;
        double g2 = (double)(rgb >> 8 & 0xFF) / 256.0;
        double b = (double)(rgb & 0xFF) / 256.0;
        double min2 = r;
        if (g2 < min2) {
            min2 = g2;
        }
        if (b < min2) {
            min2 = b;
        }
        if (g2 > (max = r)) {
            max = g2;
        }
        if (b > max) {
            max = b;
        }
        double h2 = 0.0;
        double s2 = 0.0;
        double l = (min2 + max) / 2.0;
        if (min2 != max) {
            if (l < 0.5) {
                s2 = (max - min2) / (max + min2);
            }
            if (l >= 0.5) {
                s2 = (max - min2) / (2.0 - max - min2);
            }
            if (r == max) {
                h2 = (g2 - b) / (max - min2);
            } else if (g2 == max) {
                h2 = 2.0 + (b - r) / (max - min2);
            } else if (b == max) {
                h2 = 4.0 + (r - g2) / (max - min2);
            }
        }
        this.hue = (int)((h2 /= 6.0) * 256.0);
        this.saturation = (int)(s2 * 256.0);
        this.luminance = (int)(l * 256.0);
        if (this.saturation < 0) {
            this.saturation = 0;
        } else if (this.saturation > 255) {
            this.saturation = 255;
        }
        if (this.luminance < 0) {
            this.luminance = 0;
        } else if (this.luminance > 255) {
            this.luminance = 255;
        }
        this.blendHueMultiplier = l > 0.5 ? (int)((1.0 - l) * s2 * 512.0) : (int)(l * s2 * 512.0);
        if (this.blendHueMultiplier < 1) {
            this.blendHueMultiplier = 1;
        }
        this.blendHue = (int)(h2 * (double)this.blendHueMultiplier);
        this.hsl16 = FloorDefinition.hsl24to16(this.hue, this.saturation, this.luminance);
    }

    private static final int hsl24to16(int h2, int s2, int l) {
        if (l > 179) {
            s2 /= 2;
        }
        if (l > 192) {
            s2 /= 2;
        }
        if (l > 217) {
            s2 /= 2;
        }
        if (l > 243) {
            s2 /= 2;
        }
        return (h2 / 4 << 10) + (s2 / 32 << 7) + l / 2;
    }
}

