/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.def;

import com.hazy.cache.Archive;
import com.hazy.cache.def.impl.items.CustomItems;
import com.hazy.cache.factory.ItemSpriteFactory;
import com.hazy.collection.TempCache;
import com.hazy.entity.model.Model;
import com.hazy.io.Buffer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ItemDefinition {
    private static final Logger log = LoggerFactory.getLogger(ItemDefinition.class);
    private int shiftClickDropIndex = -2;
    private int category;
    public int placeholderId;
    public int placeholderTemplateId;
    public HashMap<Integer, Object> params;
    public static int length;
    private static int cache_index;
    private static Buffer data_buffer;
    private static ItemDefinition[] cache;
    private static int[] pos;
    public static TempCache model_cache;
    public String unknown1;
    public int wearPos1;
    public int wearPos2;
    public int wearPos3;
    public int cost;
    public int id = -1;
    public int team;
    public int weight;
    public int zoom2d;
    public int yan2d;
    public int xan2d;
    public int zan2d;
    public int inventoryModel;
    public int maleModel0;
    public int maleModel1;
    public int maleModel2;
    public int femaleModel0;
    public int femaleModel1;
    public int femaleModel2;
    public int maleHeadModel;
    private int maleHeadModel2;
    public int maleOffset;
    public int femaleHeadModel;
    private int femaleHeadModel2;
    public int femaleOffset;
    public int xOffset2d;
    public int yOffset2d;
    private int resizeX;
    private int resizeY;
    private int resizeZ;
    public int notedTemplate;
    public int notedID;
    public int ambient;
    public int contrast;
    public int[] countObj;
    public int[] countCo;
    public short[] colorFind;
    public short[] colorReplace;
    public short[] textureFind;
    public short[] textureReplace;
    public String[][] subops;
    public String examine;
    public String[] interfaceOptions;
    public String[] options;
    public String name;
    public String description;
    public static boolean members;
    public boolean stackable;
    public boolean animateInventory;
    public boolean isTradeable;
    public int boughtId;
    public int boughtTemplateId;
    public int modelCustomColor = 0;
    public int modelCustomColor2 = 0;
    public int modelCustomColor3 = 0;
    public int modelCustomColor4 = 0;
    public int modelSetColor = 0;

    public static void init(Archive archive) {
        int size;
        data_buffer = new Buffer(archive.get("obj.dat"));
        Buffer idxBuffer = new Buffer(archive.get("obj.idx"));
        length = idxBuffer.readUnsignedShort();
        pos = new int[length + 30000];
        int offset = 0;
        for (int i = 0; i < length && (size = idxBuffer.readUnsignedShort()) != 65535; ++i) {
            ItemDefinition.pos[i] = offset;
            offset += size;
        }
        cache = new ItemDefinition[10];
        for (int _ctr = 0; _ctr < 10; ++_ctr) {
            ItemDefinition.cache[_ctr] = new ItemDefinition();
        }
    }

    void decode(Buffer buffer) {
        int op;
        while ((op = buffer.readUnsignedByte()) != 0) {
            this.decodeValues(op, buffer);
        }
    }

    private void decodeValues(int opcode, Buffer stream) {
        try {
            if (stream == null) {
                System.out.println("decodeValues: null stream for itemId=" + this.id);
                this.name = "Unknown (ID: " + this.id + ")";
                this.zoom2d = 2000;
                this.xan2d = 0;
                this.yan2d = 0;
                this.zan2d = 0;
                this.xOffset2d = 0;
                this.yOffset2d = 0;
                this.countObj = new int[10];
                this.countCo = new int[10];
                return;
            }
            if (opcode == 1) {
                this.inventoryModel = stream.readUnsignedShort();
            } else if (opcode == 2) {
                this.name = stream.readStringCp1252NullTerminated();
                if (this.name == null || this.name.equals("null")) {
                    System.out.println("decodeValues: null or invalid name for itemId=" + this.id);
                    this.name = "Unknown (ID: " + this.id + ")";
                }
            } else if (opcode == 3) {
                this.examine = stream.readStringCp1252NullTerminated();
            } else if (opcode == 4) {
                this.zoom2d = stream.readUnsignedShort();
            } else if (opcode == 5) {
                this.xan2d = stream.readUnsignedShort();
            } else if (opcode == 6) {
                this.yan2d = stream.readUnsignedShort();
            } else if (opcode == 7) {
                this.xOffset2d = stream.readUnsignedShort();
                if (this.xOffset2d > Short.MAX_VALUE) {
                    this.xOffset2d -= 65536;
                }
            } else if (opcode == 8) {
                this.yOffset2d = stream.readUnsignedShort();
                if (this.yOffset2d > Short.MAX_VALUE) {
                    this.yOffset2d -= 65536;
                }
            } else if (opcode == 9) {
                this.unknown1 = stream.readStringCp1252NullTerminated();
            } else if (opcode == 11) {
                this.stackable = true;
            } else if (opcode == 12) {
                this.cost = stream.readInt();
            } else if (opcode == 13) {
                this.wearPos1 = stream.readByte();
            } else if (opcode == 14) {
                this.wearPos2 = stream.readByte();
            } else if (opcode == 16) {
                members = true;
            } else if (opcode == 23) {
                this.maleModel0 = stream.readUnsignedShort();
                this.maleOffset = stream.readUnsignedByte();
            } else if (opcode == 24) {
                this.maleModel1 = stream.readUnsignedShort();
            } else if (opcode == 25) {
                this.femaleModel0 = stream.readUnsignedShort();
                this.femaleOffset = stream.readUnsignedByte();
            } else if (opcode == 26) {
                this.femaleModel1 = stream.readUnsignedShort();
            } else if (opcode == 27) {
                this.wearPos3 = stream.readByte();
            } else if (opcode >= 30 && opcode < 35) {
                if (this.options == null) {
                    this.options = new String[5];
                }
                this.options[opcode - 30] = stream.readStringCp1252NullTerminated();
                if (this.options[opcode - 30].equalsIgnoreCase("Hidden")) {
                    this.options[opcode - 30] = null;
                }
            } else if (opcode >= 35 && opcode < 40) {
                if (this.interfaceOptions == null) {
                    this.interfaceOptions = new String[5];
                }
                this.interfaceOptions[opcode - 35] = stream.readStringCp1252NullTerminated();
            } else if (opcode == 40) {
                int var5 = stream.readUnsignedByte();
                this.colorFind = new short[var5];
                this.colorReplace = new short[var5];
                for (int var4 = 0; var4 < var5; ++var4) {
                    this.colorFind[var4] = (short)stream.readUnsignedShort();
                    this.colorReplace[var4] = (short)stream.readUnsignedShort();
                }
            } else if (opcode == 41) {
                int var5 = stream.readUnsignedByte();
                this.textureFind = new short[var5];
                this.textureReplace = new short[var5];
                for (int var4 = 0; var4 < var5; ++var4) {
                    this.textureFind[var4] = (short)stream.readUnsignedShort();
                    this.textureReplace[var4] = (short)stream.readUnsignedShort();
                }
            } else if (opcode == 42) {
                this.shiftClickDropIndex = stream.readByte();
            } else if (opcode == 43) {
                int subopId;
                boolean valid;
                int opId = stream.readUnsignedByte();
                if (this.subops == null) {
                    this.subops = new String[5][];
                }
                boolean bl = valid = opId >= 0 && opId < 5;
                if (valid && this.subops[opId] == null) {
                    this.subops[opId] = new String[20];
                }
                while ((subopId = stream.readUnsignedByte() - 1) != -1) {
                    String op = stream.readStringCp1252NullTerminated();
                    if (!valid || subopId < 0 || subopId >= 20) continue;
                    this.subops[opId][subopId] = op;
                }
            } else if (opcode == 65) {
                this.isTradeable = true;
            } else if (opcode == 75) {
                this.weight = stream.readShort();
            } else if (opcode == 78) {
                this.maleModel2 = stream.readUnsignedShort();
            } else if (opcode == 79) {
                this.femaleModel2 = stream.readUnsignedShort();
            } else if (opcode == 90) {
                this.maleHeadModel = stream.readUnsignedShort();
            } else if (opcode == 91) {
                this.femaleHeadModel = stream.readUnsignedShort();
            } else if (opcode == 92) {
                this.maleHeadModel2 = stream.readUnsignedShort();
            } else if (opcode == 93) {
                this.femaleHeadModel2 = stream.readUnsignedShort();
            } else if (opcode == 94) {
                this.category = stream.readUnsignedShort();
            } else if (opcode == 95) {
                this.zan2d = stream.readUnsignedShort();
            } else if (opcode == 97) {
                this.notedID = stream.readUnsignedShort();
            } else if (opcode == 98) {
                this.notedTemplate = stream.readUnsignedShort();
            } else if (opcode >= 100 && opcode < 110) {
                if (this.countObj == null) {
                    this.countObj = new int[10];
                    this.countCo = new int[10];
                }
                this.countObj[opcode - 100] = stream.readUnsignedShort();
                this.countCo[opcode - 100] = stream.readUnsignedShort();
            } else if (opcode == 110) {
                this.resizeX = stream.readUnsignedShort();
            } else if (opcode == 111) {
                this.resizeY = stream.readUnsignedShort();
            } else if (opcode == 112) {
                this.resizeZ = stream.readUnsignedShort();
            } else if (opcode == 113) {
                this.ambient = stream.readByte();
            } else if (opcode == 114) {
                this.contrast = stream.readByte();
            } else if (opcode == 115) {
                this.team = stream.readUnsignedByte();
            } else if (opcode == 139) {
                this.boughtId = stream.readUnsignedShort();
            } else if (opcode == 140) {
                this.boughtTemplateId = stream.readUnsignedShort();
            } else if (opcode == 148) {
                this.placeholderId = stream.readUnsignedShort();
            } else if (opcode == 149) {
                this.placeholderTemplateId = stream.readUnsignedShort();
            } else if (opcode == 249) {
                int length = stream.readUnsignedByte();
                this.params = new HashMap(length);
                for (int i = 0; i < length; ++i) {
                    boolean isString = stream.readUnsignedByte() == 1;
                    int key = stream.read24BitInt();
                    Object value = isString ? stream.readStringCp1252NullTerminated() : Integer.valueOf(stream.readInt());
                    this.params.put(key, value);
                }
            } else {
                log.warn("Unrecognized opcode {} for itemId={}", (Object)opcode, (Object)this.id);
            }
        }
        catch (Exception e) {
            System.out.println("Exception in decodeValues for itemId=" + this.id + ", opcode=" + opcode);
            e.printStackTrace();
            this.name = "Unknown (ID: " + this.id + ")";
            this.zoom2d = 2000;
            this.xan2d = 0;
            this.yan2d = 0;
            this.zan2d = 0;
            this.xOffset2d = 0;
            this.yOffset2d = 0;
            this.countObj = new int[10];
            this.countCo = new int[10];
        }
    }

    private void post() {
        if (this.stackable) {
            this.weight = 0;
        }
    }

    public void set_defaultsCustom() {
        this.resizeX = 128;
        this.resizeY = 128;
        this.resizeZ = 128;
    }

    public static void copyInventory(ItemDefinition itemDef, int id) {
        ItemDefinition copy2 = ItemDefinition.get(id);
        itemDef.inventoryModel = copy2.inventoryModel;
        itemDef.zoom2d = copy2.zoom2d;
        itemDef.xan2d = copy2.xan2d;
        itemDef.yan2d = copy2.yan2d;
        itemDef.zan2d = copy2.zan2d;
        itemDef.resizeX = copy2.resizeX;
        itemDef.resizeY = copy2.resizeY;
        itemDef.resizeZ = copy2.resizeZ;
        itemDef.xOffset2d = copy2.xOffset2d;
        itemDef.yOffset2d = copy2.yOffset2d;
        itemDef.interfaceOptions = copy2.interfaceOptions;
        itemDef.cost = copy2.cost;
        itemDef.stackable = copy2.stackable;
        if (itemDef.textureFind != null) {
            itemDef.textureFind = copy2.textureFind;
        }
        if (itemDef.textureReplace != null) {
            itemDef.textureReplace = copy2.textureReplace;
        }
        if (itemDef.colorFind != null) {
            itemDef.colorFind = copy2.colorFind;
        }
    }

    public static void copyEquipment(ItemDefinition itemDef, int id) {
        ItemDefinition copy2 = ItemDefinition.get(id);
        itemDef.maleModel0 = copy2.maleModel0;
        itemDef.maleModel1 = copy2.maleModel1;
        itemDef.femaleModel0 = copy2.femaleModel0;
        itemDef.femaleModel1 = copy2.femaleModel1;
        itemDef.maleOffset = copy2.maleOffset;
        itemDef.femaleOffset = copy2.femaleOffset;
    }

    public static void printStatement(String text) {
        System.out.println(text + ";");
    }

    public static void printDefinitions(ItemDefinition definition) {
        ItemDefinition.printStatement("definition.name = \"" + definition.name + "\"");
        ItemDefinition.printStatement("definition.model_zoom = " + definition.zoom2d);
        ItemDefinition.printStatement("definition.rotation_y = " + definition.xan2d);
        ItemDefinition.printStatement("definition.rotation_x = " + definition.yan2d);
        ItemDefinition.printStatement("definition.translate_x = " + definition.xOffset2d);
        ItemDefinition.printStatement("definition.translate_y = " + definition.yOffset2d);
        ItemDefinition.printStatement("definition.inventory_model = " + definition.inventoryModel);
        ItemDefinition.printStatement("definition.male_equip_main = " + definition.maleModel0);
        ItemDefinition.printStatement("definition.female_equip_main = " + definition.femaleModel0);
        ItemDefinition.printStatement("definition.color_to_replace = " + Arrays.toString(definition.colorFind));
        ItemDefinition.printStatement("definition.color_to_replace_with = " + Arrays.toString(definition.colorReplace));
    }

    public static void dump() {
        File f = new File(System.getProperty("user.home") + "/Desktop/items.txt");
        try {
            f.createNewFile();
            BufferedWriter bf = new BufferedWriter(new FileWriter(f));
            for (int id = 20000; id <= 30000; ++id) {
                ItemDefinition definition = ItemDefinition.get(id);
                bf.write("case " + id + ":");
                bf.write(System.getProperty("line.separator"));
                if (definition.name == null || definition.name.equals("null") || definition.name.isEmpty()) continue;
                bf.write("definition[id].name = " + definition.name + ";");
                bf.write(System.getProperty("line.separator"));
                if (definition.inventoryModel != 0) {
                    bf.write("definition[id].inventory_model = " + definition.inventoryModel + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.colorFind != null) {
                    bf.write("definition[id].color_to_replace = new int[] " + Arrays.toString(definition.colorFind).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.colorReplace != null) {
                    bf.write("definition[id].color_to_replace_with = new int[] " + Arrays.toString(definition.colorReplace).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.textureFind != null) {
                    bf.write("definition[id].src_texture = new int[] " + Arrays.toString(definition.textureFind).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.textureReplace != null) {
                    bf.write("definition[id].dst_texture = new int[] " + Arrays.toString(definition.textureReplace).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.zoom2d != 2000) {
                    bf.write("definition[id].model_zoom = " + definition.zoom2d + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.xan2d != 0) {
                    bf.write("definition[id].rotation_y = " + definition.xan2d + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.yan2d != 0) {
                    bf.write("definition[id].rotation_x = " + definition.yan2d + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.zan2d != 0) {
                    bf.write("definition[id].rotation_z = " + definition.zan2d + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.xOffset2d != -1) {
                    bf.write("definition[id].translate_x = " + definition.xOffset2d + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.yOffset2d != -1) {
                    bf.write("definition[id].translate_y = " + definition.yOffset2d + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                bf.write("definition[id].stackable = " + definition.stackable + ";");
                bf.write(System.getProperty("line.separator"));
                if (definition.options != null) {
                    bf.write("definition[id].scene_actions = new int[] " + Arrays.toString(definition.options).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.interfaceOptions != null) {
                    bf.write("definition[id].widget_actions = new int[] " + Arrays.toString(definition.interfaceOptions).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.maleModel0 != -1) {
                    bf.write("definition[id].male_equip_main = " + definition.maleModel0 + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.maleModel1 != -1) {
                    bf.write("definition[id].male_equip_attachment = " + definition.maleModel1 + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.maleOffset != 0) {
                    bf.write("definition[id].male_equip_translate_y = " + definition.maleOffset + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.femaleModel0 != -1) {
                    bf.write("definition[id].female_equip_main = " + definition.femaleModel0 + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.femaleModel1 != -1) {
                    bf.write("definition[id].female_equip_attachment = " + definition.femaleModel1 + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.femaleOffset != 0) {
                    bf.write("definition[id].female_equip_translate_y = " + definition.femaleOffset + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.maleModel2 != -1) {
                    bf.write("definition[id].male_equip_emblem = " + definition.maleModel2 + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.femaleModel2 != -1) {
                    bf.write("definition[id].female_equip_emblem = " + definition.femaleModel2 + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.maleHeadModel != -1) {
                    bf.write("definition[id].male_dialogue_head = " + definition.maleHeadModel + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.maleHeadModel2 != -1) {
                    bf.write("definition[id].male_dialogue_headgear = " + definition.maleHeadModel2 + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.femaleHeadModel != -1) {
                    bf.write("definition[id].female_dialogue_head = " + definition.femaleHeadModel + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.femaleHeadModel2 != -1) {
                    bf.write("definition[id].female_dialogue_headgear = " + definition.femaleHeadModel2 + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.countObj != null) {
                    bf.write("definition[id].stack_variant_id = new int[] " + Arrays.toString(definition.countObj).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.countCo != null) {
                    bf.write("definition[id].stack_variant_size = new int[] " + Arrays.toString(definition.countCo).replace("[", "{").replace("]", "}") + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.notedID != -1) {
                    bf.write("definition[id].unnoted_item_id = " + definition.notedID + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.notedTemplate != -1) {
                    bf.write("definition[id].model_scale_xy = " + definition.notedTemplate + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.resizeX != 128) {
                    bf.write("definition[id].model_scale_x = " + definition.resizeX + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.resizeY != 128) {
                    bf.write("definition[id].model_scale_y = " + definition.resizeY + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.resizeZ != 128) {
                    bf.write("definition[id].model_scale_z = " + definition.resizeZ + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.ambient != 0) {
                    bf.write("definition[id].ambient = " + definition.ambient + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                if (definition.contrast != 0) {
                    bf.write("definition[id].contrast = " + definition.contrast + ";");
                    bf.write(System.getProperty("line.separator"));
                }
                bf.write("break;");
                bf.write(System.getProperty("line.separator"));
                bf.write(System.getProperty("line.separator"));
            }
            bf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ItemDefinition get(int id) {
        if (id == -1) {
            return null;
        }
        for (int j = 0; j < 10; ++j) {
            if (ItemDefinition.cache[j].id != id) continue;
            return cache[j];
        }
        cache_index = (cache_index + 1) % 10;
        ItemDefinition def = cache[cache_index];
        ItemDefinition.data_buffer.pos = pos[id];
        def.id = id;
        def.set_defaults();
        def.decode(data_buffer);
        def.post();
        if (def.name != null && (def.name.contains("Max cape") || def.name.contains("max cape"))) {
            def.interfaceOptions = new String[]{null, "Wear", "Features", null, "Drop"};
        }
        if (def.name != null && (def.name.contains("slayer helmet") || def.name.contains("Slayer helmet"))) {
            def.interfaceOptions = new String[]{null, "Wear", null, "Disassemble", "Drop"};
        }
        if (id == 6199) {
            def.interfaceOptions = new String[]{"Open", null, null, null, null};
        }
        if (id == 24131) {
            def.name = "Donator boss voucher";
            def.stackable = true;
        }
        if (id == 31060) {
            ItemDefinition.copyInventory(def, 11259);
            ItemDefinition.copyEquipment(def, 11259);
            def.name = "Ruby net";
            def.interfaceOptions = new String[]{null, "Wield", null, null, "Drop"};
        }
        if (id == 30170) {
            ItemDefinition.copyInventory(def, 11179);
            def.name = "Ruby token";
            def.stackable = true;
            def.interfaceOptions = new String[]{null, null, "Exchange", null, "Drop"};
        }
        if (id == 30171) {
            ItemDefinition.copyInventory(def, 11179);
            def.name = "Diamond token";
            def.stackable = true;
            def.interfaceOptions = new String[]{null, null, "Exchange", null, "Drop"};
        }
        if (id == 30172) {
            ItemDefinition.copyInventory(def, 11179);
            def.name = "Onyx token";
            def.stackable = true;
            def.interfaceOptions = new String[]{null, null, "Exchange", null, "Drop"};
        }
        if (id == 30173) {
            ItemDefinition.copyInventory(def, 11179);
            def.name = "Zenyte token";
            def.stackable = true;
            def.interfaceOptions = new String[]{null, null, "Exchange", null, "Drop"};
        }
        if (id == 10538) {
            def.name = "Elder corp horn";
            def.stackable = true;
            def.interfaceOptions = new String[]{null, null, "Summon", null, "Drop"};
        }
        if (id == 10530) {
            def.name = "Elder nex horn";
            def.stackable = true;
            def.interfaceOptions = new String[]{null, null, "Summon", null, "Drop"};
        }
        if (id == 31061) {
            ItemDefinition.copyInventory(def, 11259);
            ItemDefinition.copyEquipment(def, 11259);
            def.name = "Diamond net";
            def.interfaceOptions = new String[]{null, "Wield", null, null, "Drop"};
        }
        if (id == 31062) {
            ItemDefinition.copyInventory(def, 11259);
            ItemDefinition.copyEquipment(def, 11259);
            def.name = "Onyx net";
            def.interfaceOptions = new String[]{null, "Wield", null, null, "Drop"};
        }
        if (id == 31063) {
            ItemDefinition.copyInventory(def, 11259);
            ItemDefinition.copyEquipment(def, 11259);
            def.name = "Zenyte net";
            def.interfaceOptions = new String[]{null, "Wield", null, null, "Drop"};
        }
        if (id == 7775) {
            def.name = "<col=65280>Combat xp token";
            def.interfaceOptions = new String[]{null, null, null, null, null};
        }
        if (id == 7776) {
            def.name = "<col=65280>Skilling xp token";
            def.interfaceOptions = new String[]{null, null, null, null, null};
        }
        if (id == 7774) {
            def.name = "<col=65280>Double drop token";
            def.interfaceOptions = new String[]{null, null, null, null, null};
        }
        if (id == 7777) {
            ItemDefinition.copyInventory(def, 7774);
            def.name = "<col=65280>Triple drop token";
            def.interfaceOptions = new String[]{null, null, null, null, null};
        }
        if (id == 30112) {
            def.name = "<col=65280>Enchanted boots";
            def.femaleModel0 = 59096;
            def.interfaceOptions = new String[]{null, "Wear", null, null, "Drop"};
            def.inventoryModel = 59095;
            def.maleModel0 = 59097;
            def.xOffset2d = 5;
            def.yOffset2d = -5;
            def.xan2d = 147;
            def.yan2d = 279;
            def.zoom2d = 976;
            def.colorFind = new short[]{-18025, -16112, 126};
            def.colorReplace = new short[]{933, 933, 933};
        }
        if (id == 30113) {
            ItemDefinition.copyInventory(def, 22981);
            ItemDefinition.copyEquipment(def, 22981);
            def.name = "@gre@Enchanted gloves";
            def.colorFind = new short[]{13493, 10411, 12484, 10394, 30643};
            def.colorReplace = new short[]{933, 933, 933, 933, 933};
        }
        if (id == 30188) {
            def.animateInventory = true;
            def.name = "<col=65280>Winter mystery chest";
            def.interfaceOptions = new String[]{"Open", null, null, null, "Drop"};
            def.inventoryModel = ItemDefinition.get((int)8151).inventoryModel;
            def.xOffset2d = 0;
            def.yOffset2d = 0;
            def.xan2d = 114;
            def.yan2d = 1883;
            def.zoom2d = 2640;
        }
        if (id == 27440) {
            ItemDefinition.copyInventory(def, 10834);
            def.name = "<col=65280>100M cash bag";
            def.interfaceOptions = new String[]{null, null, "Coin-Exchange", null, "Drop"};
            def.stackable = true;
            def.isTradeable = true;
        }
        if (id == 995 || id == 996 || id == 997 || id == 998) {
            def.interfaceOptions = new String[]{null, null, "Bag-Exchange", null, "Drop"};
        }
        if (id == 30107) {
            ItemDefinition.copyInventory(def, 25739);
            ItemDefinition.copyEquipment(def, 25739);
            def.animateInventory = true;
            def.name = "<col=56005b>Mylie's Darkness Incarnate";
        }
        if (id == 30100) {
            def.name = "<col=65280>Winter sara sword";
            ItemDefinition.copyInventory(def, 11838);
            ItemDefinition.copyEquipment(def, 11838);
        }
        if (id == 30115) {
            def.name = "<col=65280>Cursed Nihil shards";
            ItemDefinition.copyInventory(def, 26231);
            ItemDefinition.copyEquipment(def, 26231);
            def.stackable = true;
        }
        if (id == 30105) {
            def.interfaceOptions = new String[]{null, "Equip", null, null, null};
            def.name = "<col=65280>Winter Vesta's platebody";
            ItemDefinition.copyInventory(def, 22616);
            ItemDefinition.copyEquipment(def, 22616);
        }
        if (id == 30106) {
            def.interfaceOptions = new String[]{null, "Equip", null, null, null};
            def.name = "<col=65280>Winter Vesta's plateskirt";
            ItemDefinition.copyInventory(def, 22619);
            ItemDefinition.copyEquipment(def, 22619);
        }
        if (id == 28751) {
            ItemDefinition.copyInventory(def, 6199);
            def.stackable = true;
            def.name = "Point mystery box";
            def.interfaceOptions = new String[]{"Quick-open", null, null, "Open-all", null};
            def.animateInventory = true;
        }
        if (id == 24225) {
            def.interfaceOptions = new String[]{null, "Wield", null, null, null};
        }
        CustomItems.unpack(id);
        if (def.notedTemplate != -1) {
            def.set_noted_values();
        }
        int[] items = new int[]{534, 536, 6812, 6729, 6666, 4084, 7534, 7535, 11020, 11022, 11019, 11021, 9005, 1506, 10629, 6188, 7053, 9921, 9922, 9925, 9923, 9924, 7053, 5608, 5609, 7918, 5607, 4566, 1037};
        Object name = def.name;
        if (name != null) {
            if (!((String)name).startsWith("<col=65280>")) {
                for (int item_id : items) {
                    if (id != item_id) continue;
                    name = "<col=65280>" + (String)name;
                    break;
                }
            }
            if (!((String)name).startsWith("<col=65280>")) {
                String lowercase = ((String)name).toLowerCase();
                if (lowercase.contains("pet") || lowercase.contains("3rd") || lowercase.contains("toxic") || lowercase.contains("occult") || lowercase.contains("anguish") || lowercase.contains("torture") || lowercase.contains("avernic") || lowercase.contains("serpentine") || lowercase.contains("tanzanite") || lowercase.contains("magma") || lowercase.contains("ancestral") || lowercase.contains("armadyl") || lowercase.contains("void") || lowercase.contains("bandos") || lowercase.contains("pegasian") || lowercase.contains("primordial") || lowercase.contains("eternal") || lowercase.contains("partyhat") || lowercase.contains("staff of light") || lowercase.contains("infernal") || lowercase.contains("slayer helm") || lowercase.contains("dragon hunter") || lowercase.contains("spectral") || lowercase.contains("ballista") || lowercase.contains("justiciar") || lowercase.contains("dragon claws") || lowercase.contains("bulwark") || lowercase.contains("dragon warhammer") || lowercase.contains("blessed sword") || lowercase.contains("godsword") || lowercase.contains("ward") || lowercase.contains("wyvern shield") || lowercase.contains("morrigan") || lowercase.contains("vesta") || lowercase.contains("zuriel") || lowercase.contains("statius") || lowercase.contains("dragon crossbow") || lowercase.contains("abyssal dagger") || lowercase.contains("ghrazi") || lowercase.contains("elder maul") || lowercase.contains("tormented") || lowercase.contains("infinity") || lowercase.contains("dragonfire") || lowercase.contains("blessed spirit shield") || lowercase.contains("of the dead") || lowercase.contains("ice arrow") || lowercase.contains("dragon javelin") || lowercase.contains("dragon knife") || lowercase.contains("dragon thrownaxe") || lowercase.contains("abyssal tentacle") || lowercase.contains("dark bow") || lowercase.contains("fremennik kilt") || lowercase.contains("spiked manacles") || lowercase.contains("fury") || lowercase.contains("dragon boots") || lowercase.contains("ranger boots") || lowercase.contains("mage's book") || lowercase.contains("master wand") || lowercase.contains("granite maul") || lowercase.contains("tome of fire") || lowercase.contains("recoil") || lowercase.contains("dharok") || lowercase.contains("karil") || lowercase.contains("guthan") || lowercase.contains("torag") || lowercase.contains("verac") || lowercase.contains("ahrim") || lowercase.contains("fire cape") || lowercase.contains("max cape") || lowercase.contains("blighted") || lowercase.contains("dragon defender") || lowercase.contains("healer hat") || lowercase.contains("fighter hat") || lowercase.contains("runner hat") || lowercase.contains("ranger hat") || lowercase.contains("fighter torso") || lowercase.contains("runner boots") || lowercase.contains("penance skirt") || lowercase.contains("looting bag") || lowercase.contains("rune pouch") || lowercase.contains("stamina") || lowercase.contains("anti-venom") || lowercase.contains("zamorakian") || lowercase.contains("blood money") || lowercase.contains("hydra") || lowercase.contains("ferocious") || lowercase.contains("jar of") || lowercase.contains("brimstone") || lowercase.contains("crystal") || lowercase.contains("dagon") || lowercase.contains("dragon pickaxe") || lowercase.contains("tyrannical") || lowercase.contains("dragon 2h") || lowercase.contains("elysian") || lowercase.contains("holy elixer") || lowercase.contains("odium") || lowercase.contains("malediction") || lowercase.contains("fedora") || lowercase.contains("suffering") || lowercase.contains("mole") || lowercase.contains("vampyre dust") || lowercase.contains("bludgeon") || lowercase.contains("kbd heads") || lowercase.contains("trident") || lowercase.contains("nightmare") || lowercase.contains("kodai wand") || lowercase.contains("dragon sword") || lowercase.contains("dragon harpoon") || lowercase.contains("mystery box") || lowercase.contains("crystal key") || lowercase.contains("volatile") || lowercase.contains("eldritch") || lowercase.contains("harmonised") || lowercase.contains("inquisitor") || lowercase.contains("treasonous") || lowercase.contains("ring of the gods") || lowercase.contains("vorkath") || lowercase.contains("dragonbone") || lowercase.contains("uncut onyx") || lowercase.contains("zulrah") || lowercase.contains("zul-andra") || lowercase.contains("sanguinesti") || lowercase.contains("blade of saeldor") || lowercase.contains("barrelchest anchor") || lowercase.contains("staff of balance") || lowercase.contains("twisted bow") || lowercase.contains("facegaurd") || lowercase.contains("guardian") || lowercase.contains("twisted buckler") || lowercase.contains("dragon dart") || lowercase.contains("guthix rest") || lowercase.contains("obsidian") || lowercase.contains("regen bracelet") || lowercase.contains("rangers'") || lowercase.contains("dragon scimitar (or)") || lowercase.contains("Hazy coins") || lowercase.contains("divine") || lowercase.contains("super antifire") || lowercase.contains("robin hood hat") || lowercase.contains("ankou") || lowercase.contains("santa") || lowercase.contains("halloween") || lowercase.contains("present") || lowercase.contains("sack of presents") || lowercase.contains("dye")) {
                    name = "<col=65280>" + (String)name;
                }
                if (lowercase.contains("berserker ring") || lowercase.contains("seers") || lowercase.contains("archers") || lowercase.contains("warrior ring")) {
                    name = "<col=65280>" + (String)name;
                }
                if (lowercase.contains("scythe")) {
                    name = "<col=65280>" + (String)name;
                }
                if (lowercase.contains("gilded")) {
                    name = "<col=65280>" + (String)name;
                }
                if (lowercase.contains("bunny")) {
                    name = "<col=65280>" + (String)name;
                }
                if (lowercase.contains("zanik")) {
                    name = "<col=65280>" + (String)name;
                }
                if (lowercase.contains("ele'")) {
                    name = "<col=65280>" + (String)name;
                }
                if (lowercase.contains("prince")) {
                    name = "<col=65280>" + (String)name;
                }
                if (lowercase.contains("zombie")) {
                    name = "<col=65280>" + (String)name;
                }
                if (lowercase.contains("mithril seeds")) {
                    name = "<col=65280>" + (String)name;
                }
                if (lowercase.contains("tribal")) {
                    name = "<col=65280>" + (String)name;
                }
                if (lowercase.contains("broodoo")) {
                    name = "<col=65280>" + (String)name;
                }
                if (lowercase.contains("scarf") || lowercase.contains("woolly") || lowercase.contains("bobble")) {
                    name = "<col=65280>" + (String)name;
                }
                if (lowercase.contains("cane")) {
                    name = "<col=65280>" + (String)name;
                }
                if (lowercase.contains("jester")) {
                    name = "<col=65280>" + (String)name;
                }
                if (lowercase.contains("(g)")) {
                    name = "<col=65280>" + (String)name;
                }
                if (lowercase.contains("(t)") && !lowercase.endsWith("cape(t)")) {
                    name = "<col=65280>" + (String)name;
                }
                if (lowercase.contains("camo") || lowercase.contains("boxing glove")) {
                    name = "<col=65280>" + (String)name;
                }
                if (lowercase.contains("dharok")) {
                    name = "<col=65280>" + (String)name;
                }
                if (lowercase.contains("dragon spear")) {
                    name = "<col=65280>" + (String)name;
                }
                if (lowercase.contains("phoenix neck")) {
                    name = "<col=65280>" + (String)name;
                }
                if (lowercase.contains("dragon bolts (e)")) {
                    name = "<col=65280>" + (String)name;
                }
            }
        }
        return def;
    }

    private void set_defaults() {
        this.inventoryModel = 0;
        this.name = null;
        this.description = null;
        this.colorFind = null;
        this.colorReplace = null;
        this.textureFind = null;
        this.textureReplace = null;
        this.zoom2d = 2000;
        this.xan2d = 0;
        this.yan2d = 0;
        this.zan2d = 0;
        this.xOffset2d = 0;
        this.yOffset2d = 0;
        this.stackable = false;
        this.cost = 1;
        members = false;
        this.options = null;
        this.interfaceOptions = null;
        this.maleModel0 = -1;
        this.maleModel1 = -1;
        this.maleOffset = 0;
        this.femaleModel0 = -1;
        this.femaleModel1 = -1;
        this.femaleOffset = 0;
        this.maleModel2 = -1;
        this.femaleModel2 = -1;
        this.maleHeadModel = -1;
        this.maleHeadModel2 = -1;
        this.femaleHeadModel = -1;
        this.femaleHeadModel2 = -1;
        this.countObj = null;
        this.countCo = null;
        this.notedID = -1;
        this.notedTemplate = -1;
        this.resizeX = 128;
        this.resizeY = 128;
        this.resizeZ = 128;
        this.ambient = 0;
        this.contrast = 0;
        this.team = 0;
        this.modelCustomColor = 0;
        this.modelCustomColor2 = 0;
        this.modelCustomColor3 = 0;
        this.modelCustomColor4 = 0;
        this.modelSetColor = 0;
    }

    private void set_noted_values() {
        ItemDefinition noted = ItemDefinition.get(this.notedTemplate);
        if (noted == null) {
            return;
        }
        this.inventoryModel = noted.inventoryModel;
        this.zoom2d = noted.zoom2d;
        this.xan2d = noted.xan2d;
        this.yan2d = noted.yan2d;
        this.zan2d = noted.zan2d;
        this.xOffset2d = noted.xOffset2d;
        this.yOffset2d = noted.yOffset2d;
        this.colorFind = noted.colorFind;
        this.colorReplace = noted.colorReplace;
        ItemDefinition unnoted = ItemDefinition.get(this.notedID);
        if (unnoted == null) {
            return;
        }
        this.name = unnoted.name;
        this.cost = unnoted.cost;
        String consonant_or_vowel_lead = "a";
        String character = unnoted.name;
        if (character == null) {
            return;
        }
        if (character.equals("A") || character.equals("E") || character.equals("I") || character.equals("O") || character.equals("U")) {
            consonant_or_vowel_lead = "an";
        }
        this.description = "Swap this note at any bank for " + consonant_or_vowel_lead + " " + unnoted.name + ".";
        this.stackable = true;
    }

    public Model get_model(int stack_size) {
        int i;
        Model model;
        if (this.countObj != null && stack_size > 1) {
            int stack_item_id = -1;
            for (int index = 0; index < 10; ++index) {
                if (stack_size < this.countCo[index] || this.countCo[index] == 0) continue;
                stack_item_id = this.countObj[index];
            }
            if (stack_item_id != -1) {
                Model stackModel = ItemDefinition.get(stack_item_id).get_model(1);
                if (stackModel == null) {
                    System.err.println("\u26a0 Missing stacked model for item " + stack_item_id);
                    return null;
                }
                return stackModel;
            }
        }
        if ((model = (Model)model_cache.get(this.id)) != null) {
            return model;
        }
        model = Model.get(this.inventoryModel, true);
        if (model == null || this.id == -1) {
            return null;
        }
        ItemDefinition.applyTexture(model, this.id);
        if (this.resizeX != 128 || this.resizeY != 128 || this.resizeZ != 128) {
            model.scale(this.resizeX, this.resizeZ, this.resizeY);
        }
        if (this.colorFind != null && this.colorReplace != null && this.colorFind.length == this.colorReplace.length) {
            for (i = 0; i < this.colorFind.length; ++i) {
                model.recolor(this.colorFind[i], this.colorReplace[i]);
            }
        }
        if (this.textureFind != null && this.textureReplace != null) {
            for (i = 0; i < this.textureFind.length; ++i) {
                model.retexture(this.textureFind[i], this.textureReplace[i]);
            }
        }
        model_cache.put(model, this.id);
        if (this.modelCustomColor > 0) {
            model.completelyRecolor(this.modelCustomColor);
        }
        if (this.modelCustomColor2 != 0) {
            model.shadingRecolor(this.modelCustomColor2);
        }
        if (this.modelCustomColor3 != 0) {
            model.shadingRecolor2(this.modelCustomColor3);
        }
        if (this.modelCustomColor4 != 0) {
            model.shadingRecolor4(this.modelCustomColor4);
        }
        if (this.modelSetColor != 0) {
            model.shadingRecolor3(this.modelSetColor);
        }
        model.light(64 + this.ambient, 768 + this.contrast, -50, -10, -50, true);
        model.singleTile = true;
        return model;
    }

    public Model get_widget_model(int stack_size) {
        Model widget_model;
        int index;
        if (this.countObj != null && stack_size > 1) {
            int stack_item_id = -1;
            for (index = 0; index < 10; ++index) {
                if (stack_size < this.countCo[index] || this.countCo[index] == 0) continue;
                stack_item_id = this.countObj[index];
            }
            if (stack_item_id != -1) {
                return ItemDefinition.get(stack_item_id).get_widget_model(1);
            }
        }
        if ((widget_model = Model.get(this.inventoryModel, true)) == null) {
            return null;
        }
        if (this.colorFind != null) {
            for (index = 0; index < this.colorFind.length; ++index) {
                widget_model.recolor(this.colorFind[index], this.colorReplace[index]);
            }
        }
        if (this.textureFind != null) {
            for (index = 0; index < this.textureFind.length; ++index) {
                widget_model.retexture(this.textureFind[index], this.textureReplace[index]);
            }
        }
        if (this.modelCustomColor > 0) {
            widget_model.completelyRecolor(this.modelCustomColor);
        }
        if (this.modelCustomColor2 != 0) {
            widget_model.shadingRecolor(this.modelCustomColor2);
        }
        if (this.modelCustomColor3 != 0) {
            widget_model.shadingRecolor2(this.modelCustomColor3);
        }
        if (this.modelCustomColor4 != 0) {
            widget_model.shadingRecolor4(this.modelCustomColor4);
        }
        if (this.modelSetColor != 0) {
            widget_model.shadingRecolor3(this.modelSetColor);
        }
        widget_model.light(64 + this.ambient, 768 + this.contrast, -50, -10, -50, true);
        return widget_model;
    }

    public Model get_equipped_model(int gender) {
        int main = this.maleModel0;
        int attatchment = this.maleModel1;
        int emblem = this.maleModel2;
        if (gender == 1) {
            main = this.femaleModel0;
            attatchment = this.femaleModel1;
            emblem = this.femaleModel2;
        }
        if (main == -1) {
            return null;
        }
        Model equipped_model = Model.get(main);
        if (equipped_model == null) {
            return null;
        }
        if (attatchment != -1) {
            Model attachment_model;
            if (emblem != -1) {
                attachment_model = Model.get(attatchment);
                Model emblem_model = Model.get(emblem);
                Model[] list = new Model[]{equipped_model, attachment_model, emblem_model};
                equipped_model = new Model(3, list);
            } else {
                attachment_model = Model.get(attatchment);
                Model[] list = new Model[]{equipped_model, attachment_model};
                equipped_model = new Model(2, list);
            }
        }
        if (gender == 0 && this.maleOffset != 0) {
            equipped_model.translate(0, this.maleOffset, 0);
        }
        if (gender == 1 && this.femaleOffset != 0) {
            equipped_model.translate(0, this.femaleOffset, 0);
        }
        if (this.colorFind != null) {
            for (int index = 0; index < this.colorFind.length; ++index) {
                equipped_model.recolor(this.colorFind[index], this.colorReplace[index]);
            }
        }
        if (this.textureFind != null) {
            for (int index = 0; index < this.textureFind.length; ++index) {
                equipped_model.retexture(this.textureFind[index], this.textureReplace[index]);
            }
        }
        ItemDefinition.applyTexture(equipped_model, this.id);
        if (this.modelCustomColor > 0) {
            equipped_model.completelyRecolor(this.modelCustomColor);
        }
        if (this.modelCustomColor2 != 0) {
            equipped_model.shadingRecolor(this.modelCustomColor2);
        }
        if (this.modelCustomColor3 != 0) {
            equipped_model.shadingRecolor2(this.modelCustomColor3);
        }
        if (this.modelCustomColor4 != 0) {
            equipped_model.shadingRecolor4(this.modelCustomColor4);
        }
        if (this.modelSetColor != 0) {
            equipped_model.shadingRecolor3(this.modelSetColor);
        }
        return equipped_model;
    }

    public boolean equipped_model_cached(int gender) {
        int main = this.maleModel0;
        int attachment = this.maleModel1;
        int emblem = this.maleModel2;
        if (gender == 1) {
            main = this.femaleModel0;
            attachment = this.femaleModel1;
            emblem = this.femaleModel2;
        }
        if (main == -1) {
            return true;
        }
        boolean cached = true;
        if (!Model.cached(main)) {
            cached = false;
        }
        if (attachment != -1 && !Model.cached(attachment)) {
            cached = false;
        }
        if (emblem != -1 && !Model.cached(emblem)) {
            cached = false;
        }
        return cached;
    }

    public Model get_equipped_dialogue_model(int gender) {
        int head_model = this.maleHeadModel;
        int equipped_headgear = this.maleHeadModel2;
        if (gender == 1) {
            head_model = this.femaleHeadModel;
            equipped_headgear = this.femaleHeadModel2;
        }
        if (head_model == -1) {
            return null;
        }
        Model dialogue_model = Model.get(head_model);
        if (equipped_headgear != -1) {
            Model headgear = Model.get(equipped_headgear);
            Model[] list = new Model[]{dialogue_model, headgear};
            dialogue_model = new Model(2, list);
        }
        if (this.colorFind != null) {
            for (int index = 0; index < this.colorFind.length; ++index) {
                dialogue_model.recolor(this.colorFind[index], this.colorReplace[index]);
            }
        }
        ItemDefinition.applyTexture(dialogue_model, this.id);
        if (this.textureFind != null) {
            for (int index = 0; index < this.textureFind.length; ++index) {
                dialogue_model.retexture(this.textureFind[index], this.textureReplace[index]);
            }
        }
        return dialogue_model;
    }

    public boolean dialogue_model_cached(int gender) {
        int head_model = this.maleHeadModel;
        int equipped_headgear = this.maleHeadModel2;
        if (gender == 1) {
            head_model = this.femaleHeadModel;
            equipped_headgear = this.femaleHeadModel2;
        }
        if (head_model == -1) {
            return true;
        }
        boolean cached = true;
        if (!Model.cached(head_model)) {
            cached = false;
        }
        if (equipped_headgear != -1 && !Model.cached(equipped_headgear)) {
            cached = false;
        }
        return cached;
    }

    public static void applyTexture(Model model, int itemID) {
        if (model == null || model.proceduralTextured) {
            return;
        }
        switch (itemID) {
            case 10538: {
                model.setTextureOld(149, 0, new int[]{5281, 7362, 8361, 8377}, 81);
                break;
            }
            case 10530: {
                model.setTextureOld(66, 0, new int[]{5281, 7362, 8361, 8377}, 73);
                break;
            }
            case 30170: {
                model.setTextureOld(125, 0, new int[]{6439}, 67);
                break;
            }
            case 30171: {
                model.setTextureOld(76, 0, new int[]{6439}, 42);
                break;
            }
            case 30172: {
                model.setTextureOld(125, 0, new int[]{6439}, 76);
                break;
            }
            case 30173: {
                model.setTextureOld(125, 0, new int[]{6439}, 72);
                break;
            }
            case 31065: {
                model.setTexture(150, 0, new int[]{19870, 20118, 20242});
                break;
            }
            case 31066: {
                model.setTexture(42, 0, new int[]{19870, 20118, 20242});
                break;
            }
            case 31067: {
                model.setTexture(76, 0, new int[]{19870, 20118, 20242});
                break;
            }
            case 31068: {
                model.setTexture(72, 0, new int[]{19870, 20118, 20242});
                break;
            }
            case 31060: {
                model.setTextureOld(67, 1, new int[]{21844, 21958, 21964, 21968}, 89);
                break;
            }
            case 31061: {
                model.setTextureOld(42, 1, new int[]{21844, 21958, 21964, 21968}, 89);
                break;
            }
            case 31062: {
                model.setTextureOld(76, 1, new int[]{21844, 21958, 21964, 21968}, 89);
                break;
            }
            case 31063: {
                model.setTextureOld(72, 1, new int[]{21844, 21958, 21964, 21968}, 89);
                break;
            }
            case 10522: {
                model.setTextureOld(98, 0, new int[]{7582, 7706}, 73);
                break;
            }
            case 16452: {
                model.setTextureOld(88, 0, new int[]{30918, 32916, 32922, 32931, 32974, 8503}, 89);
                break;
            }
            case 16451: {
                model.setTextureOld(88, 0, new int[]{13248, 43059}, 89);
                break;
            }
            case 16454: {
                model.setTextureOld(88, 2, new int[]{7093, 4502, 24, 4510}, 89);
                break;
            }
            case 28751: {
                model.setTexture(67, 0, new int[]{22410});
                model.setTexture(61, 0, new int[]{2999});
                break;
            }
            case 28334: {
                model.setTexture(73, 0, new int[]{53150});
                break;
            }
            case 7774: {
                model.setTextureOld(105, 0, new int[]{9164, 6742, 6604}, 73);
                break;
            }
            case 7777: {
                model.setTextureOld(98, 0, new int[]{9164, 6742, 6604}, 73);
                break;
            }
            case 14031: {
                break;
            }
            case 30235: 
            case 30236: 
            case 30237: 
            case 30238: {
                model.setTexture(103, 0);
                break;
            }
            case 30242: 
            case 32236: 
            case 32237: 
            case 32238: 
            case 32239: {
                model.setTexture(85, 0);
                break;
            }
            case 30106: {
                model.setTextureOld(79, 0, new int[]{5285, 5289, 5640, 8487, 8512, 8524, 10304}, 53);
                break;
            }
            case 30105: {
                model.setTextureOld(53, 0, new int[]{5388, 5293, 5297, 8497, 10291, 5268, 10299, 8507}, 79);
                break;
            }
            case 26388: 
            case 26389: {
                model.setTextureOld(74, 0, new int[0], 74);
                break;
            }
            case 30107: {
                model.setTextureOld(74, 0, new int[]{16, 18, 20, 22, 12, 26}, 76);
                break;
            }
            case 30005: {
                model.setTextureOld(79, 0, new int[]{33, 5056, 8125}, 53);
                break;
            }
            case 30100: {
                model.setTextureOld(79, 0, new int[]{43111, 43098, 8650, 43086}, 85);
                break;
            }
            case 6857: {
                model.setTextureOld(85, 0, new int[]{6067, 24}, 79);
                break;
            }
            case 30108: {
                model.setTextureOld(85, 0, new int[]{29923, 8757, 38119}, 79);
                break;
            }
            case 30188: {
                model.setTextureOld(85, 2, new int[]{7093, 4502, 24, 4510}, 79);
                break;
            }
            case 30301: {
                model.setTexture(74, 1, new int[]{49, 61, 78, 536, 784, 790, 796});
                break;
            }
            case 30420: {
                int[] all = new int[30000];
                for (int i = 0; i < all.length; ++i) {
                    all[i] = i;
                }
                model.setTexture(74, 1, all);
                break;
            }
            case 30421: {
                int[] all = new int[30000];
                for (int i = 0; i < all.length; ++i) {
                    all[i] = i;
                }
                model.setTexture(74, 1, all);
                break;
            }
            case 30422: {
                int[] all = new int[30000];
                for (int i = 0; i < all.length; ++i) {
                    all[i] = i;
                }
                model.setTexture(74, 1, all);
                break;
            }
            case 30423: {
                int[] all = new int[30000];
                for (int i = 0; i < all.length; ++i) {
                    all[i] = i;
                }
                model.setTexture(74, 1, all);
                break;
            }
            case 30424: {
                int[] all = new int[30000];
                for (int i = 0; i < all.length; ++i) {
                    all[i] = i;
                }
                model.setTexture(74, 1, all);
                break;
            }
            case 298: {
                model.setTexture(100, 0);
                break;
            }
            case 30239: {
                model.setTextureOld(79, 0, new int[]{6594, 5524, 5799, 5559}, 53);
                break;
            }
            case 15550: {
                model.setTextureOld(74, 1, new int[]{14499, 14490, 14494}, 73);
                break;
            }
            case 15551: {
                model.setTextureOld(74, 1, new int[]{16652, 10396}, 73);
                break;
            }
            case 30113: {
                model.setTextureOld(74, 0, new int[]{18, 20, 933, 12, 15, 32906}, 73);
                break;
            }
            case 30112: {
                model.setTextureOld(74, 0, new int[]{933}, 73);
                break;
            }
            case 21260: {
                model.setTextureOld(73, 0, new int[]{933}, 74);
                break;
            }
            case 15552: {
                model.setTextureOld(74, 1, new int[]{10388, 10396}, 73);
                break;
            }
            case 15553: {
                model.setTextureOld(74, 1, new int[]{49, 8722, 10529}, 73);
                break;
            }
            case 15554: {
                model.setTextureOld(74, 1, new int[]{10413}, 73);
                break;
            }
            case 15555: {
                model.setTextureOld(74, 1, new int[]{10413}, 73);
                break;
            }
            case 15556: {
                model.setTextureOld(74, 1, new int[]{10291, 10299}, 73);
                break;
            }
            case 15557: {
                model.setTextureOld(74, 1, new int[]{10512, 8656, 10760, 8664, 41, 6554, 138, 268}, 73);
                break;
            }
            case 15558: {
                model.setTextureOld(74, 1, new int[]{41, 138, 268, 6554, 8656, 8664}, 73);
            }
        }
    }

    public static void release() {
        model_cache = null;
        ItemSpriteFactory.itemSpriteCache = null;
        pos = null;
        cache = null;
        data_buffer = null;
    }

    private ItemDefinition() {
    }

    public static int setInventoryModel(int id) {
        ItemDefinition definition = ItemDefinition.get(id);
        return definition.inventoryModel;
    }

    public static String setItemName(int id) {
        ItemDefinition definition = ItemDefinition.get(id);
        return definition.name;
    }

    public static int setMaleEquipmentId(int id) {
        ItemDefinition definition = ItemDefinition.get(id);
        return definition.maleModel0;
    }

    public static int setFemaleEquipmentId(int id) {
        ItemDefinition definition = ItemDefinition.get(id);
        return definition.femaleModel0;
    }

    public static int setModelZoom(int id) {
        ItemDefinition definition = ItemDefinition.get(id);
        return definition.zoom2d;
    }

    public static int setRotationX(int id) {
        ItemDefinition definition = ItemDefinition.get(id);
        return definition.yan2d;
    }

    public static int setRotationY(int id) {
        ItemDefinition definition = ItemDefinition.get(id);
        return definition.xan2d;
    }

    public static int setTranslateX(int id) {
        ItemDefinition definition = ItemDefinition.get(id);
        return definition.xOffset2d;
    }

    public static int setTranslateY(int id) {
        ItemDefinition definition = ItemDefinition.get(id);
        return definition.yOffset2d;
    }

    static {
        model_cache = new TempCache(50);
    }
}

