/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.def;

import com.hazy.Client;
import com.hazy.cache.Archive;
import com.hazy.cache.anim.SeqDefinition;
import com.hazy.cache.anim.SeqFrame;
import com.hazy.cache.config.VariableBits;
import com.hazy.cache.def.impl.NpcManager;
import com.hazy.cache.def.impl.npcs.CustomBosses;
import com.hazy.cache.def.impl.npcs.CustomPets;
import com.hazy.cache.def.impl.npcs.MemberNpcs;
import com.hazy.collection.TempCache;
import com.hazy.entity.model.Model;
import com.hazy.io.Buffer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.runelite.api.HeadIcon;
import net.runelite.api.IterableHashTable;
import net.runelite.rs.api.RSIterableNodeHashTable;
import net.runelite.rs.api.RSNPCComposition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NpcDefinition
implements RSNPCComposition {
    private static final Logger log = LoggerFactory.getLogger(NpcDefinition.class);
    public static int totalNPCs;
    public int height = -1;
    public int[] stats = new int[]{1, 1, 1, 1, 1, 1};
    private static final boolean dump = false;
    public boolean rotationFlag = true;
    public int rotateLeftAnimation = -1;
    public int rotateRightAnimation = -1;
    public boolean isFollower;
    private int category;
    public boolean lowPriorityFollowerOps;
    public int modelCustomColor = 0;
    public int modelCustomColor2 = 0;
    public int modelCustomColor3 = 0;
    public int modelCustomColor4 = 0;
    public int modelSetColor = 0;
    public int quarterAnticlockwiseTurnAnimation = -1;
    public static int cache_index;
    public int varbitId = -1;
    public int rotate180Animation = -1;
    public int varpIndex = -1;
    public static Buffer buffer;
    public int combatLevel = -1;
    public boolean largeHpBar;
    public final int anInt64;
    public String name;
    public String[] actions = new String[5];
    public int walkingAnimation = -1;
    public int occupied_tiles = 1;
    public short[] recolorToReplace;
    public static int[] offsets;
    public int[] chatheadModels;
    public int headIcon = -1;
    public short[] retextureToFind;
    public short[] retextureToReplace;
    public short[] recolorToFind;
    public int standingAnimation = -1;
    public long interfaceType = -1L;
    public int rotationSpeed = 32;
    public static NpcDefinition[] cache;
    public static Client clientInstance;
    public int quarterClockwiseTurnAnimation = -1;
    public boolean isClickable = true;
    public int ambient;
    public int heightScale = 128;
    public boolean isMinimapVisible = true;
    public boolean pet;
    public int[] configs;
    public String description;
    public int widthScale = 128;
    public int contrast;
    public boolean hasRenderPriority = false;
    public int[] models;
    public boolean clickable;
    public int[] headIconArchiveIds;
    public short[] headIconSpriteIndex;
    public int runRotate180Animation = -1;
    public int runRotateLeftAnimation = -1;
    public int runRotateRightAnimation = -1;
    public int crawlAnimation = -1;
    public int crawlRotate180Animation = -1;
    public int runAnimation = -1;
    public int crawlRotateLeftAnimation = -1;
    public int crawlRotateRightAnimation = -1;
    public int defaultHeadIconArchive = -1;
    public int interfaceZoom = 0;
    public int id;
    public static TempCache model_cache;
    private Map<Integer, Object> params = null;
    public static final int REV_210_NPC_ARCHIVE_REV = 1493;
    private boolean rev210HeadIcons = true;
    public boolean isInteractable = true;
    public int size = 1;

    public static void init(Archive streamLoader) {
        int size;
        buffer = new Buffer(streamLoader.get("npc.dat"));
        Buffer idx = new Buffer(streamLoader.get("npc.idx"));
        int highestFileId = idx.readUnsignedShort();
        offsets = new int[highestFileId + 1 + 20000];
        int offset = 0;
        for (int i = 0; i < highestFileId && (size = idx.readUnsignedShort()) != -1 && size != 65535; ++i) {
            NpcDefinition.offsets[i] = offset;
            offset += size;
        }
        cache = new NpcDefinition[20];
        for (int k = 0; k < 20; ++k) {
            NpcDefinition.cache[k] = new NpcDefinition();
        }
    }

    public static void applyTexture(Model model, int id) {
        switch (id) {
            case 9013: {
                model.setTexture(125, 0, new int[]{39892});
                model.setTexture(67, 0, new int[]{39386, 32889});
                break;
            }
            case 9014: {
                model.getColors();
                model.setTexture(125, 0, new int[]{39892});
                model.setTexture(42, 0, new int[]{39386, 32889});
                break;
            }
            case 9015: {
                model.getColors();
                model.setTexture(125, 0, new int[]{39892});
                model.setTexture(76, 0, new int[]{39386, 32889});
                break;
            }
            case 9016: {
                model.getColors();
                model.setTexture(125, 0, new int[]{39892});
                model.setTexture(72, 0, new int[]{39386, 32889});
                break;
            }
            case 2001: 
            case 9010: {
                model.setTexture(42, 0, new int[]{19870, 20118, 20242});
                break;
            }
            case 2002: 
            case 9011: {
                model.setTexture(76, 0, new int[]{19870, 20118, 20242});
                break;
            }
            case 2003: 
            case 9012: {
                model.setTexture(72, 0, new int[]{19870, 20118, 20242});
                break;
            }
            case 2000: 
            case 5923: {
                model.setTexture(150, 0, new int[]{19870, 20118, 20242});
                break;
            }
            case 6716: {
                model.setTexture(75, 1, new int[]{908, 910, 912, 918, 1938});
                break;
            }
            case 5300: {
                model.setTexture(85, 1, new int[]{8252, 25, 38, 7216, 7219, 63380, 7222, 8250});
                model.setTexture(53, 1, new int[]{34, 63372, 45, 41});
                break;
            }
            case 1350: {
                model.setTexture(81, 1, new int[]{23392, 45103});
                model.setTexture(149, 1, new int[]{47332, 50281, 51315, 51323});
                model.setTexture(149, 1, new int[]{45000, 45016, 45018});
                break;
            }
            case 11280: {
                model.setTexture(66, 1, new int[]{50081, 35724, 35724, 54105, 50081, 50101, 54394, 54398, 55244, 59307, 59315, 60346, 60350, 60366, 60540});
                break;
            }
            case 16008: {
                model.setTexture(75, 2, new int[]{960, 11200, 4, 6069, 955, 1981, 4029, 7101, 957, 7101, 957, 9149, 5053, 8125});
                break;
            }
            case 4736: 
            case 4737: 
            case 4738: 
            case 4739: 
            case 4740: 
            case 4741: 
            case 4742: 
            case 4743: {
                model.setTexture(7, 2);
                break;
            }
            case 16009: {
                model.setTextureOld(67, 2, new int[]{129, 1027, 1029, 1031, 1033, 1035, 1037, 1039, 1041, 1043}, 73);
                break;
            }
            case 16010: {
                model.setTextureOld(67, 2, new int[]{129, 1027, 1029, 1031, 1033, 1035, 1037, 1039, 1041, 1043}, 73);
                break;
            }
            case 16011: {
                model.setTexture(106, 2, new int[]{131, 800, 10563, 143, 10567, 32936, 7380, 8404, 10423, 8408, 10431, 123, 637});
                break;
            }
            case 16006: {
                model.setTexture(74, 1, new int[]{33, 11140});
                break;
            }
            case 16007: {
                model.setTexture(118, 2, new int[]{47892, 47896, 70});
                break;
            }
            case 16005: {
                model.setTexture(66, 2, new int[]{0, 5524, 10283, 5293, 7343, 10287, 5297, 10291, 5301, 10295, 37089});
            }
        }
    }

    public static int getModelIds(int id, int models) {
        NpcDefinition npcDefinition = NpcDefinition.get(id);
        return npcDefinition.models[models];
    }

    public static int getadditionalModels(int id, int models) {
        NpcDefinition npcDefinition = NpcDefinition.get(id);
        return npcDefinition.chatheadModels[models];
    }

    public static int getModelColorIds(int id, int color) {
        NpcDefinition npcDefinition = NpcDefinition.get(id);
        return npcDefinition.recolorToFind[color];
    }

    public static int getStandAnim(int id) {
        NpcDefinition npcDefinition = NpcDefinition.get(id);
        return npcDefinition.standingAnimation;
    }

    public static int getWalkAnim(int id) {
        NpcDefinition entityDef = NpcDefinition.get(id);
        return entityDef.walkingAnimation;
    }

    public static int getHalfTurnAnimation(int id) {
        NpcDefinition entityDef = NpcDefinition.get(id);
        return entityDef.rotate180Animation;
    }

    public static int getQuarterClockwiseTurnAnimation(int id) {
        NpcDefinition entityDef = NpcDefinition.get(id);
        return entityDef.quarterClockwiseTurnAnimation;
    }

    public static int getQuarterAnticlockwiseTurnAnimation(int id) {
        NpcDefinition entityDef = NpcDefinition.get(id);
        return entityDef.quarterAnticlockwiseTurnAnimation;
    }

    public static NpcDefinition get(int id) {
        for (int i = 0; i < 20; ++i) {
            if (NpcDefinition.cache[i].interfaceType != (long)id) continue;
            return cache[i];
        }
        cache_index = (cache_index + 1) % 20;
        NpcDefinition npcDefinition = NpcDefinition.cache[NpcDefinition.cache_index] = new NpcDefinition();
        NpcDefinition.buffer.pos = offsets[id];
        npcDefinition.id = id;
        npcDefinition.interfaceType = id;
        npcDefinition.decode(buffer);
        if (id == 13391) {
            npcDefinition.name = "Mini donator boss";
            npcDefinition.models = new int[]{34163};
            npcDefinition.occupied_tiles = 5;
            npcDefinition.standingAnimation = 90;
            npcDefinition.walkingAnimation = 79;
            npcDefinition.rotate180Animation = 79;
            npcDefinition.quarterClockwiseTurnAnimation = 79;
            npcDefinition.quarterAnticlockwiseTurnAnimation = 79;
            npcDefinition.actions = new String[]{null, "Attack", null, null, null, null};
            npcDefinition.combatLevel = 135;
            npcDefinition.ambient = 40;
            npcDefinition.contrast = 40;
            npcDefinition.recolorToFind = new short[]{0, -22431, -22438, -22429, 163, -22446, 5219, -27417, -22450};
            npcDefinition.recolorToReplace = new short[]{-31412, -31412, -31412, -31412, -31412, -31412, -31412, -31412, -31412};
        }
        if (id == 11280) {
            npcDefinition.name = "Elder Nex";
            npcDefinition.actions = new String[]{null, "Attack", null, null, null, null};
            npcDefinition.modelCustomColor4 = 119641;
            npcDefinition.widthScale = 180;
            npcDefinition.heightScale = 180;
        }
        if (id == 8637) {
            npcDefinition.name = "Donator boss";
            npcDefinition.actions = new String[]{null, "Attack", null, null, null, null};
            npcDefinition.combatLevel = 135;
            npcDefinition.size = 450;
        }
        if (id == 9019) {
            npcDefinition.name = "Mending Superior revenant";
            npcDefinition.models = new int[]{34163};
            npcDefinition.occupied_tiles = 5;
            npcDefinition.standingAnimation = 90;
            npcDefinition.walkingAnimation = 79;
            npcDefinition.rotate180Animation = 79;
            npcDefinition.quarterClockwiseTurnAnimation = 79;
            npcDefinition.quarterAnticlockwiseTurnAnimation = 79;
            npcDefinition.actions = new String[]{null, "Attack", null, null, null, null};
            npcDefinition.combatLevel = 135;
            npcDefinition.ambient = 40;
            npcDefinition.contrast = 40;
            npcDefinition.recolorToFind = new short[]{0, -22431, -22438, -22429, 163, -22446, 5219, -27417, -22450};
            npcDefinition.recolorToReplace = new short[]{21397, 21397, 21397, 21397, 21397, 21397, 21397, 21397, 21397};
        }
        if (id == 4736) {
            NpcDefinition.copy(npcDefinition, 7584);
            npcDefinition.name = "Ice demon";
            npcDefinition.actions = new String[]{null, null, null, null, null};
            npcDefinition.combatLevel = 230;
            npcDefinition.ambient = 130;
            npcDefinition.contrast = 130;
        }
        if (id == 4737) {
            NpcDefinition.copy(npcDefinition, 6503);
            npcDefinition.actions = new String[]{null, null, null, null, null};
        }
        if (id == 4738) {
            NpcDefinition.copy(npcDefinition, 6504);
            npcDefinition.actions = new String[]{null, null, null, null, null};
        }
        if (id == 4739) {
            NpcDefinition.copy(npcDefinition, 6342);
            npcDefinition.actions = new String[]{null, null, null, null, null};
        }
        if (id == 4740) {
            NpcDefinition.copy(npcDefinition, 6611);
            npcDefinition.actions = new String[]{null, null, null, null, null};
        }
        if (id == 4741) {
            NpcDefinition.copy(npcDefinition, 6615);
            npcDefinition.actions = new String[]{null, null, null, null, null};
        }
        if (id == 4742) {
            NpcDefinition.copy(npcDefinition, 2054);
            npcDefinition.actions = new String[]{null, null, null, null, null};
        }
        if (id == 4743) {
            NpcDefinition.copy(npcDefinition, 239);
            npcDefinition.actions = new String[]{null, null, null, null, null};
        }
        if (id == 5300) {
            NpcDefinition.copy(npcDefinition, 763);
            npcDefinition.name = "Winter Skeletal Roc";
            npcDefinition.models = new int[]{69823};
            npcDefinition.widthScale = 180;
            npcDefinition.heightScale = 180;
            npcDefinition.standingAnimation = 5022;
        }
        if (id == 2616) {
            npcDefinition.actions = new String[]{null, "Attack", null, null, null, null};
            npcDefinition.name = "Mending Revenant Ork";
            npcDefinition.models = new int[]{34154};
            npcDefinition.occupied_tiles = 3;
            npcDefinition.standingAnimation = 4318;
            npcDefinition.walkingAnimation = 4319;
            npcDefinition.rotate180Animation = 4319;
            npcDefinition.quarterClockwiseTurnAnimation = 4319;
            npcDefinition.quarterAnticlockwiseTurnAnimation = 4319;
            npcDefinition.chatheadModels = new int[]{16214};
            npcDefinition.combatLevel = 105;
            npcDefinition.widthScale = 176;
            npcDefinition.heightScale = 176;
            npcDefinition.ambient = 60;
            npcDefinition.contrast = 60;
            npcDefinition.recolorToFind = new short[]{24, 16, 45, 33, 37, -22436, -22450, -22427, 8286};
            npcDefinition.recolorToReplace = new short[]{21397, 21397, 21397, 21397, 21397, 21397, 21397, 21397, 21397};
        }
        if (id == 6799) {
            npcDefinition.name = "Wilderness slayer master";
            npcDefinition.actions = new String[]{"Assignment", null, null, "Trade", null, null};
        }
        if (id == 6797) {
            npcDefinition.name = "Normal slayer master";
            npcDefinition.actions = new String[]{"Assignment", null, null, "Trade", "Rewards", null};
        }
        if (id == 2617) {
            npcDefinition.name = "Mending Revenant knight";
            npcDefinition.models = new int[]{34145};
            npcDefinition.standingAnimation = 813;
            npcDefinition.walkingAnimation = 1205;
            npcDefinition.rotate180Animation = 1206;
            npcDefinition.quarterClockwiseTurnAnimation = 1207;
            npcDefinition.quarterAnticlockwiseTurnAnimation = 1208;
            npcDefinition.actions = new String[]{null, "Attack", null, null, null, null};
            npcDefinition.combatLevel = 126;
            npcDefinition.ambient = 75;
            npcDefinition.contrast = 75;
            npcDefinition.recolorToFind = new short[]{-22456, -22450, -22464, 20, 272, -22436, -22479, -22483, 4626, -22491, -22475, 47, 30, 30, 0};
            npcDefinition.recolorToReplace = new short[]{21397, 21397, 21397, 21397, 21397, 21397, 21397, 21397, 21397, 21397, 21397, 21397, 21397, 21397, 21397};
        }
        NpcManager.unpack(id);
        CustomPets.unpack(id);
        CustomBosses.unpack(id);
        MemberNpcs.unpack(id);
        return npcDefinition;
    }

    public static void dump() {
        if (offsets == null || buffer == null) {
            System.out.println("NPC cache not loaded.");
            return;
        }
        File f = new File(System.getProperty("user.home") + "/Desktop/npcs.txt");
        int count = offsets.length;
        System.out.println("Dumping " + count + " NPCs...");
        try (BufferedWriter bf = new BufferedWriter(new FileWriter(f));){
            for (int id = 0; id < count; ++id) {
                NpcDefinition d;
                try {
                    d = NpcDefinition.get(id);
                }
                catch (Exception e) {
                    continue;
                }
                if (d == null) continue;
                bf.write("case " + id + ":");
                bf.newLine();
                if (d.name != null && !d.name.isEmpty()) {
                    bf.write("definition[id].name = \"" + d.name + "\";");
                    bf.newLine();
                }
                if (d.models != null) {
                    bf.write("definition[id].models = new int[] " + Arrays.toString(d.models).replace("[", "{").replace("]", "}") + ";");
                    bf.newLine();
                }
                if (d.occupied_tiles != 1) {
                    bf.write("definition[id].occupied_tiles = " + d.occupied_tiles + ";");
                    bf.newLine();
                }
                if (d.standingAnimation != -1) {
                    bf.write("definition[id].standingAnimation = " + d.standingAnimation + ";");
                    bf.newLine();
                }
                if (d.walkingAnimation != -1) {
                    bf.write("definition[id].walkingAnimation = " + d.walkingAnimation + ";");
                    bf.newLine();
                }
                if (d.rotate180Animation != -1) {
                    bf.write("definition[id].rotate180Animation = " + d.rotate180Animation + ";");
                    bf.newLine();
                }
                if (d.quarterClockwiseTurnAnimation != -1) {
                    bf.write("definition[id].quarterClockwiseTurnAnimation = " + d.quarterClockwiseTurnAnimation + ";");
                    bf.newLine();
                }
                if (d.quarterAnticlockwiseTurnAnimation != -1) {
                    bf.write("definition[id].quarterAnticlockwiseTurnAnimation = " + d.quarterAnticlockwiseTurnAnimation + ";");
                    bf.newLine();
                }
                if (d.runAnimation != -1) {
                    bf.write("definition[id].runAnimation = " + d.runAnimation + ";");
                    bf.newLine();
                }
                if (d.actions != null) {
                    bf.write("definition[id].actions = new String[] " + Arrays.toString(d.actions).replace("[", "{").replace("]", "}") + ";");
                    bf.newLine();
                }
                if (d.recolorToFind != null) {
                    bf.write("definition[id].recolorToFind = new short[] " + Arrays.toString(d.recolorToFind).replace("[", "{").replace("]", "}") + ";");
                    bf.newLine();
                }
                if (d.recolorToReplace != null) {
                    bf.write("definition[id].recolorToReplace = new short[] " + Arrays.toString(d.recolorToReplace).replace("[", "{").replace("]", "}") + ";");
                    bf.newLine();
                }
                if (d.retextureToFind != null) {
                    bf.write("definition[id].retextureToFind = new short[] " + Arrays.toString(d.retextureToFind).replace("[", "{").replace("]", "}") + ";");
                    bf.newLine();
                }
                if (d.retextureToReplace != null) {
                    bf.write("definition[id].retextureToReplace = new short[] " + Arrays.toString(d.retextureToReplace).replace("[", "{").replace("]", "}") + ";");
                    bf.newLine();
                }
                if (d.chatheadModels != null) {
                    bf.write("definition[id].chatheadModels = new int[] " + Arrays.toString(d.chatheadModels).replace("[", "{").replace("]", "}") + ";");
                    bf.newLine();
                }
                if (d.combatLevel != -1) {
                    bf.write("definition[id].combatLevel = " + d.combatLevel + ";");
                    bf.newLine();
                }
                if (d.widthScale != 128) {
                    bf.write("definition[id].widthScale = " + d.widthScale + ";");
                    bf.newLine();
                }
                if (d.heightScale != 128) {
                    bf.write("definition[id].heightScale = " + d.heightScale + ";");
                    bf.newLine();
                }
                if (d.hasRenderPriority) {
                    bf.write("definition[id].hasRenderPriority = true;");
                    bf.newLine();
                }
                if (d.ambient != -1) {
                    bf.write("definition[id].ambient = " + d.ambient + ";");
                    bf.newLine();
                }
                if (d.contrast != -1) {
                    bf.write("definition[id].contrast = " + d.contrast + ";");
                    bf.newLine();
                }
                if (d.headIcon != -1) {
                    bf.write("definition[id].headIcon = " + d.headIcon + ";");
                    bf.newLine();
                }
                if (d.rotationSpeed != 32) {
                    bf.write("definition[id].rotationSpeed = " + d.rotationSpeed + ";");
                    bf.newLine();
                }
                if (d.varbitId != -1) {
                    bf.write("definition[id].varbitId = " + d.varbitId + ";");
                    bf.newLine();
                }
                if (d.varpIndex != -1) {
                    bf.write("definition[id].varpIndex = " + d.varpIndex + ";");
                    bf.newLine();
                }
                if (d.configs != null) {
                    bf.write("definition[id].configs = new int[] " + Arrays.toString(d.configs).replace("[", "{").replace("]", "}") + ";");
                    bf.newLine();
                }
                bf.write("break;");
                bf.newLine();
                bf.newLine();
            }
            bf.flush();
            System.out.println("NPC dump complete.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copy(NpcDefinition definition, int id) {
        NpcDefinition copy2 = NpcDefinition.get(id);
        definition.occupied_tiles = copy2.occupied_tiles;
        definition.rotationSpeed = copy2.rotationSpeed;
        definition.standingAnimation = copy2.standingAnimation;
        definition.walkingAnimation = copy2.walkingAnimation;
        definition.rotate180Animation = copy2.rotate180Animation;
        definition.quarterClockwiseTurnAnimation = copy2.quarterClockwiseTurnAnimation;
        definition.quarterAnticlockwiseTurnAnimation = copy2.quarterAnticlockwiseTurnAnimation;
        definition.varbitId = copy2.varbitId;
        definition.varpIndex = copy2.varpIndex;
        definition.combatLevel = copy2.combatLevel;
        definition.name = copy2.name;
        definition.description = copy2.description;
        definition.headIcon = copy2.headIcon;
        definition.isClickable = copy2.isClickable;
        definition.ambient = copy2.ambient;
        definition.heightScale = copy2.heightScale;
        definition.widthScale = copy2.widthScale;
        definition.isMinimapVisible = copy2.isMinimapVisible;
        definition.contrast = copy2.contrast;
        definition.actions = new String[copy2.actions.length];
        System.arraycopy(copy2.actions, 0, definition.actions, 0, definition.actions.length);
        definition.models = new int[copy2.models.length];
        System.arraycopy(copy2.models, 0, definition.models, 0, definition.models.length);
        definition.hasRenderPriority = copy2.hasRenderPriority;
    }

    public Model get_dialogue_model() {
        if (this.configs != null) {
            NpcDefinition entityDef = this.get_configs();
            if (entityDef == null) {
                return null;
            }
            return entityDef.get_dialogue_model();
        }
        if (this.chatheadModels == null) {
            return null;
        }
        boolean cached = false;
        for (int index = 0; index < this.chatheadModels.length; ++index) {
            if (Model.cached(this.chatheadModels[index])) continue;
            cached = true;
        }
        if (cached) {
            return null;
        }
        Model[] head_model = new Model[this.chatheadModels.length];
        for (int index = 0; index < this.chatheadModels.length; ++index) {
            head_model[index] = Model.get(this.chatheadModels[index]);
        }
        Model dialogue_model = head_model.length == 1 ? head_model[0] : new Model(head_model.length, head_model);
        if (this.modelCustomColor > 0) {
            dialogue_model.completelyRecolor(this.modelCustomColor);
        }
        if (this.modelCustomColor2 != 0) {
            dialogue_model.shadingRecolor(this.modelCustomColor2);
        }
        if (this.modelCustomColor3 != 0) {
            dialogue_model.shadingRecolor2(this.modelCustomColor3);
        }
        if (this.modelCustomColor4 != 0) {
            dialogue_model.shadingRecolor4(this.modelCustomColor4);
        }
        if (this.modelSetColor != 0) {
            dialogue_model.shadingRecolor3(this.modelSetColor);
        }
        if (this.recolorToFind != null) {
            for (int k = 0; k < this.recolorToFind.length; ++k) {
                dialogue_model.recolor(this.recolorToFind[k], this.recolorToReplace[k]);
            }
        }
        if (this.retextureToFind != null) {
            for (int index = 0; index < this.retextureToFind.length; ++index) {
                dialogue_model.retexture(this.retextureToFind[index], this.retextureToReplace[index]);
            }
        }
        NpcDefinition.applyTexture(dialogue_model, this.id);
        return dialogue_model;
    }

    public NpcDefinition get_configs() {
        try {
            int j = -1;
            if (this.varbitId != -1) {
                VariableBits varBit = VariableBits.cache[this.varbitId];
                int k = varBit.configId;
                int l = varBit.leastSignificantBit;
                int i1 = varBit.mostSignificantBit;
                int j1 = Client.BIT_MASKS[i1 - l];
                j = NpcDefinition.clientInstance.settings[k] >> l & j1;
            } else if (this.varpIndex != -1) {
                j = NpcDefinition.clientInstance.settings[this.varpIndex];
            }
            if (j < 0 || j >= this.configs.length || this.configs[j] == -1) {
                return null;
            }
            return NpcDefinition.get(this.configs[j]);
        }
        catch (Exception e) {
            System.err.println("There was an error getting configs for NPC " + this.id);
            e.printStackTrace();
            return null;
        }
    }

    public static void clear() {
        model_cache = null;
        offsets = null;
        cache = null;
        buffer = null;
    }

    public Model get_animated_model(int animation, int current, int[] label) {
        Model model;
        if (this.configs != null) {
            NpcDefinition def = this.get_configs();
            if (def == null) {
                return null;
            }
            try {
                return def.get_animated_model(animation, current, label);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((model = (Model)model_cache.get(this.interfaceType)) == null) {
            int index;
            boolean cached = false;
            if (this.models == null) {
                return null;
            }
            for (int i : this.models) {
                if (Model.cached(i)) continue;
                cached = true;
            }
            if (cached) {
                return null;
            }
            Model[] models = new Model[this.models.length];
            for (index = 0; index < this.models.length; ++index) {
                models[index] = Model.get(this.models[index]);
            }
            model = models.length == 1 ? models[0] : new Model(models.length, models);
            if (this.recolorToFind != null) {
                for (int k1 = 0; k1 < this.recolorToFind.length; ++k1) {
                    model.recolor(this.recolorToFind[k1], this.recolorToReplace[k1]);
                }
            }
            if (this.retextureToFind != null) {
                for (index = 0; index < this.retextureToFind.length; ++index) {
                    model.retexture(this.retextureToFind[index], this.retextureToReplace[index]);
                }
            }
            if (this.modelCustomColor > 0) {
                model.completelyRecolor(this.modelCustomColor);
            }
            if (this.modelCustomColor2 != 0) {
                model.shadingRecolor(this.modelCustomColor2);
            }
            if (this.modelCustomColor3 != 0) {
                model.shadingRecolor2(this.modelCustomColor3);
            }
            if (this.modelCustomColor4 != 0) {
                model.shadingRecolor4(this.modelCustomColor4);
            }
            if (this.modelSetColor != 0) {
                model.shadingRecolor3(this.modelSetColor);
            }
            NpcDefinition.applyTexture(model, this.id);
            model.generateBones();
            model.light(84 + this.ambient, 1000 + this.contrast, -90, -580, -90, true);
            model_cache.put(model, this.interfaceType);
        }
        Model animated_model = Model.EMPTY_MODEL;
        animated_model.replace(model, SeqFrame.noAnimationInProgress(current) & SeqFrame.noAnimationInProgress(animation));
        if (current != -1 && animation != -1) {
            animated_model.mix(label, animation, current);
        } else if (current != -1) {
            animated_model.interpolate(current);
        }
        if (this.widthScale != 128 || this.heightScale != 128) {
            animated_model.scale(this.widthScale, this.heightScale, this.widthScale);
        }
        animated_model.calc_diagonals();
        animated_model.faceGroups = null;
        animated_model.groupedTriangleLabels = null;
        if (this.occupied_tiles == 1) {
            animated_model.singleTile = true;
        }
        return animated_model;
    }

    public Model getAnimatedModelSkeletal(SeqDefinition primary, SeqDefinition secondary, int primaryTick, int secondaryTick) {
        if (this.configs != null) {
            NpcDefinition def = this.get_configs();
            if (def == null) {
                return null;
            }
            return this.getAnimatedModelSkeletal(primary, secondary, primaryTick, secondaryTick);
        }
        Model model = (Model)model_cache.get(this.interfaceType);
        if (model == null) {
            int index;
            boolean cached = false;
            if (this.models == null) {
                return null;
            }
            for (int i : this.models) {
                if (Model.cached(i)) continue;
                cached = true;
            }
            if (cached) {
                return null;
            }
            Model[] models = new Model[this.models.length];
            for (index = 0; index < this.models.length; ++index) {
                models[index] = Model.get(this.models[index]);
            }
            model = models.length == 1 ? models[0] : new Model(models.length, models);
            if (this.recolorToFind != null) {
                for (int k1 = 0; k1 < this.recolorToFind.length; ++k1) {
                    model.recolor(this.recolorToFind[k1], this.recolorToReplace[k1]);
                }
            }
            if (this.retextureToFind != null) {
                for (index = 0; index < this.retextureToFind.length; ++index) {
                    model.retexture(this.retextureToFind[index], this.retextureToReplace[index]);
                }
            }
            NpcDefinition.applyTexture(model, this.id);
            if (this.modelCustomColor > 0) {
                model.completelyRecolor(this.modelCustomColor);
            }
            if (this.modelCustomColor2 != 0) {
                model.shadingRecolor(this.modelCustomColor2);
            }
            if (this.modelCustomColor3 != 0) {
                model.shadingRecolor2(this.modelCustomColor3);
            }
            if (this.modelCustomColor4 != 0) {
                model.shadingRecolor4(this.modelCustomColor4);
            }
            if (this.modelSetColor != 0) {
                model.shadingRecolor3(this.modelSetColor);
            }
            model.generateBones();
            model.light(84 + this.ambient, 1000 + this.contrast, -90, -580, -90, true);
            model_cache.put(model, this.interfaceType);
        }
        Model animated_model = Model.EMPTY_MODEL;
        animated_model.replace(model, false);
        if (primary != null && secondary != null) {
            animated_model.playSkeletalDouble(primary, secondary, primaryTick, secondaryTick);
        } else if (primary != null) {
            animated_model.playSkeletal(primary, primaryTick);
        } else if (secondary != null) {
            animated_model.playSkeletal(secondary, secondaryTick);
        }
        if (this.widthScale != 128 || this.heightScale != 128) {
            animated_model.scale(this.widthScale, this.heightScale, this.widthScale);
        }
        animated_model.calc_diagonals();
        animated_model.faceGroups = null;
        animated_model.groupedTriangleLabels = null;
        if (this.occupied_tiles == 1) {
            animated_model.singleTile = true;
        }
        return animated_model;
    }

    void decode(Buffer buffer) {
        int op;
        while ((op = buffer.readUnsignedByte()) != 0) {
            this.decodeValues(op, buffer);
        }
    }

    private void decodeValues(int opcode, Buffer stream) {
        if (opcode == 1) {
            int length = stream.readUnsignedByte();
            this.models = new int[length];
            for (int index = 0; index < length; ++index) {
                this.models[index] = stream.readUnsignedShort();
            }
        } else if (opcode == 2) {
            this.name = stream.readStringCp1252NullTerminated();
        } else if (opcode == 12) {
            this.occupied_tiles = stream.readUnsignedByte();
        } else if (opcode == 13) {
            this.standingAnimation = stream.readUnsignedShort();
        } else if (opcode == 14) {
            this.walkingAnimation = stream.readUnsignedShort();
        } else if (opcode == 15) {
            this.rotateLeftAnimation = stream.readUnsignedShort();
        } else if (opcode == 16) {
            this.rotateRightAnimation = stream.readUnsignedShort();
        } else if (opcode == 17) {
            this.walkingAnimation = stream.readUnsignedShort();
            this.rotate180Animation = stream.readUnsignedShort();
            this.rotateLeftAnimation = stream.readUnsignedShort();
            this.rotateRightAnimation = stream.readUnsignedShort();
            if (this.walkingAnimation == 65535) {
                this.walkingAnimation = -1;
            }
            if (this.rotate180Animation == 65535) {
                this.rotate180Animation = -1;
            }
            if (this.quarterClockwiseTurnAnimation == 65535) {
                this.quarterClockwiseTurnAnimation = -1;
            }
            if (this.quarterAnticlockwiseTurnAnimation == 65535) {
                this.quarterAnticlockwiseTurnAnimation = -1;
            }
        } else if (opcode == 18) {
            this.category = stream.readUnsignedShort();
        } else if (opcode >= 30 && opcode < 35) {
            this.actions[opcode - 30] = stream.readStringCp1252NullTerminated();
            if (this.actions[opcode - 30].equalsIgnoreCase("Hidden")) {
                this.actions[opcode - 30] = null;
            }
        } else if (opcode == 40) {
            int length = stream.readUnsignedByte();
            this.recolorToFind = new short[length];
            this.recolorToReplace = new short[length];
            for (int index = 0; index < length; ++index) {
                this.recolorToFind[index] = (short)stream.readUnsignedShort();
                this.recolorToReplace[index] = (short)stream.readUnsignedShort();
            }
        } else if (opcode == 41) {
            int length = stream.readUnsignedByte();
            this.retextureToFind = new short[length];
            this.retextureToReplace = new short[length];
            for (int index = 0; index < length; ++index) {
                this.retextureToFind[index] = (short)stream.readUnsignedShort();
                this.retextureToReplace[index] = (short)stream.readUnsignedShort();
            }
        } else if (opcode == 60) {
            int length = stream.readUnsignedByte();
            this.chatheadModels = new int[length];
            for (int index = 0; index < length; ++index) {
                this.chatheadModels[index] = stream.readUnsignedShort();
            }
        } else if (opcode == 74) {
            this.stats[0] = stream.readUnsignedShort();
        } else if (opcode == 75) {
            this.stats[1] = stream.readUnsignedShort();
        } else if (opcode == 76) {
            this.stats[2] = stream.readUnsignedShort();
        } else if (opcode == 77) {
            this.stats[3] = stream.readUnsignedShort();
        } else if (opcode == 78) {
            this.stats[4] = stream.readUnsignedShort();
        } else if (opcode == 79) {
            this.stats[5] = stream.readUnsignedShort();
        } else if (opcode == 93) {
            this.isMinimapVisible = false;
        } else if (opcode == 95) {
            this.combatLevel = stream.readUnsignedShort();
        } else if (opcode == 97) {
            this.widthScale = stream.readUnsignedShort();
        } else if (opcode == 98) {
            this.heightScale = stream.readUnsignedShort();
        } else if (opcode == 99) {
            this.hasRenderPriority = true;
        } else if (opcode == 100) {
            this.ambient = stream.readByte();
        } else if (opcode == 101) {
            this.contrast = stream.readByte();
        } else if (opcode == 102) {
            if (!this.rev210HeadIcons) {
                this.headIconArchiveIds = new int[]{this.defaultHeadIconArchive};
                this.headIconSpriteIndex = new short[]{(short)stream.readUnsignedShort()};
            } else {
                int bitfield = stream.readUnsignedByte();
                int len = 0;
                for (int var5 = bitfield; var5 != 0; var5 >>= 1) {
                    ++len;
                }
                this.headIconArchiveIds = new int[len];
                this.headIconSpriteIndex = new short[len];
                for (int i = 0; i < len; ++i) {
                    if ((bitfield & 1 << i) == 0) {
                        this.headIconArchiveIds[i] = -1;
                        this.headIconSpriteIndex[i] = -1;
                        continue;
                    }
                    this.headIconArchiveIds[i] = stream.readBigSmart2();
                    this.headIconSpriteIndex[i] = (short)stream.readUnsignedShortSmartMinusOne();
                }
            }
        } else if (opcode == 103) {
            this.rotationSpeed = stream.readUnsignedShort();
        } else if (opcode == 106) {
            this.varbitId = stream.readUnsignedShort();
            if (this.varbitId == 65535) {
                this.varbitId = -1;
            }
            this.varpIndex = stream.readUnsignedShort();
            if (this.varpIndex == 65535) {
                this.varpIndex = -1;
            }
            int length = stream.readUnsignedByte();
            this.configs = new int[length + 2];
            for (int index = 0; index <= length; ++index) {
                this.configs[index] = stream.readUnsignedShort();
                if (this.configs[index] != 65535) continue;
                this.configs[index] = -1;
            }
            this.configs[length + 1] = -1;
        } else if (opcode == 107) {
            this.isClickable = false;
        } else if (opcode == 109) {
            this.rotationFlag = false;
        } else if (opcode == 111) {
            this.isFollower = true;
            this.lowPriorityFollowerOps = true;
        } else if (opcode == 114) {
            this.runAnimation = stream.readUnsignedShort();
        } else if (opcode == 115) {
            this.runAnimation = stream.readUnsignedShort();
            this.runRotate180Animation = stream.readUnsignedShort();
            this.runRotateLeftAnimation = stream.readUnsignedShort();
            this.runRotateRightAnimation = stream.readUnsignedShort();
        } else if (opcode == 116) {
            this.crawlAnimation = stream.readUnsignedShort();
        } else if (opcode == 117) {
            this.crawlAnimation = stream.readUnsignedShort();
            this.crawlRotate180Animation = stream.readUnsignedShort();
            this.crawlRotateLeftAnimation = stream.readUnsignedShort();
            this.crawlRotateRightAnimation = stream.readUnsignedShort();
        } else if (opcode == 118) {
            int var;
            this.varbitId = stream.readUnsignedShort();
            if (this.varbitId == 65535) {
                this.varbitId = -1;
            }
            this.varpIndex = stream.readUnsignedShort();
            if (this.varpIndex == 65535) {
                this.varpIndex = -1;
            }
            if ((var = stream.readUnsignedShort()) == 65535) {
                var = -1;
            }
            int length = stream.readUnsignedByte();
            this.configs = new int[length + 2];
            for (int index = 0; index <= length; ++index) {
                this.configs[index] = stream.readUnsignedShort();
                if (this.configs[index] != 65535) continue;
                this.configs[index] = -1;
            }
            this.configs[length + 1] = var;
        } else if (opcode == 122) {
            this.isFollower = true;
        } else if (opcode == 123) {
            this.lowPriorityFollowerOps = true;
        } else if (opcode == 124) {
            this.height = stream.readUnsignedShort();
        } else if (opcode == 249) {
            int length = stream.readUnsignedByte();
            this.params = new HashMap<Integer, Object>(length);
            for (int i = 0; i < length; ++i) {
                boolean isString = stream.readUnsignedByte() == 1;
                int key = stream.read24BitInt();
                Object value = isString ? stream.readStringCp1252NullTerminated() : Integer.valueOf(stream.readInt());
                this.params.put(key, value);
            }
        } else {
            log.warn("Unrecognized opcode {}", (Object)opcode);
        }
    }

    public NpcDefinition() {
        this.anInt64 = 1834;
    }

    @Override
    public void setIndex(int npcIndex) {
    }

    @Override
    public HeadIcon getOverheadIcon() {
        return null;
    }

    @Override
    public int getIntValue(int paramID) {
        return 0;
    }

    @Override
    public void setValue(int paramID, int value) {
    }

    @Override
    public String getStringValue(int paramID) {
        return null;
    }

    @Override
    public void setValue(int paramID, String value) {
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public int[] getModels() {
        return new int[0];
    }

    @Override
    public String[] getActions() {
        return new String[0];
    }

    @Override
    public boolean isSmoothWalk() {
        return false;
    }

    @Override
    public boolean isFollower() {
        return false;
    }

    @Override
    public boolean isInteractible() {
        return false;
    }

    @Override
    public boolean isMinimapVisible() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public int getCombatLevel() {
        return 0;
    }

    @Override
    public int[] getConfigs() {
        return new int[0];
    }

    @Override
    public RSNPCComposition transform() {
        return null;
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public int getRsOverheadIcon() {
        return 0;
    }

    @Override
    public RSIterableNodeHashTable getParams() {
        return null;
    }

    @Override
    public void setParams(IterableHashTable params) {
    }

    @Override
    public void setParams(RSIterableNodeHashTable params) {
    }

    static {
        model_cache = new TempCache(30);
    }
}

