/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.def;

import com.hazy.cache.def.NpcPreviewCanvas;
import com.hazy.cache.def.NpcPreviewController;
import com.hazy.cache.def.NpcPreviewModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;

public final class NpcEditorFrame
extends JFrame {
    private final NpcPreviewModel previewModel;
    private final NpcPreviewController controller;
    private final NpcPreviewCanvas canvas;

    public NpcEditorFrame() {
        this.setTitle("NPC 3D Editor");
        this.setSize(900, 600);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.previewModel = new NpcPreviewModel();
        this.controller = new NpcPreviewController(this.previewModel);
        this.canvas = new NpcPreviewCanvas(this.previewModel);
        this.add((Component)this.canvas, "Center");
        this.add((Component)this.buildControls(), "South");
        new Timer(16, e -> {
            this.previewModel.update();
            this.canvas.repaint();
        }).start();
    }

    private JPanel buildControls() {
        JPanel panel = new JPanel(new FlowLayout());
        JButton load = new JButton("Load NPC");
        load.addActionListener(e -> this.onLoadNpc());
        panel.add(load);
        return panel;
    }

    private void onLoadNpc() {
        String input = JOptionPane.showInputDialog(this, (Object)"NPC ID");
        if (input == null || input.isEmpty()) {
            return;
        }
        try {
            int id = Integer.parseInt(input);
            this.controller.loadNpc(id);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, "Invalid NPC ID");
        }
    }
}

