/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.def;

import com.hazy.cache.def.NpcPreviewModel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public final class NpcPreviewCanvas
extends JPanel {
    private final NpcPreviewModel preview;
    private int lastX;
    private int lastY;

    public NpcPreviewCanvas(final NpcPreviewModel preview) {
        this.preview = preview;
        this.setBackground(Color.BLACK);
        this.setFocusable(true);
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int dx = e.getX() - NpcPreviewCanvas.this.lastX;
                int dy = e.getY() - NpcPreviewCanvas.this.lastY;
                preview.addYaw(dx * 4);
                preview.addPitch(-dy * 2);
                NpcPreviewCanvas.this.lastX = e.getX();
                NpcPreviewCanvas.this.lastY = e.getY();
                NpcPreviewCanvas.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                NpcPreviewCanvas.this.lastX = e.getX();
                NpcPreviewCanvas.this.lastY = e.getY();
            }
        });
        this.addMouseWheelListener(e -> {
            preview.addZoom(-e.getWheelRotation() * 50);
            this.repaint();
        });
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        this.preview.render(this.getWidth(), this.getHeight());
    }
}

