/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.def;

import com.hazy.cache.def.NpcDefinition;
import com.hazy.cache.def.NpcPreviewModel;

public final class NpcPreviewController {
    private NpcDefinition workingCopy;
    private final NpcPreviewModel previewModel;

    public NpcPreviewController(NpcPreviewModel previewModel) {
        this.previewModel = previewModel;
    }

    public void loadNpc(int id) {
        NpcDefinition original = NpcDefinition.get(id);
        if (original == null) {
            throw new IllegalArgumentException("NPC " + id + " not found");
        }
        this.workingCopy = original;
        this.rebuild();
    }

    public void setRecolor(short[] find, short[] replace) {
        if (!this.ensureLoaded()) {
            return;
        }
        this.workingCopy.recolorToFind = find;
        this.workingCopy.recolorToReplace = replace;
        this.rebuild();
    }

    public void setTexture(short[] find, short[] replace) {
        if (!this.ensureLoaded()) {
            return;
        }
        this.workingCopy.retextureToFind = find;
        this.workingCopy.retextureToReplace = replace;
        this.rebuild();
    }

    public void setCustomColor4(int color) {
        if (!this.ensureLoaded()) {
            return;
        }
        this.workingCopy.modelCustomColor4 = color;
        this.rebuild();
    }

    public NpcDefinition getDefinition() {
        return this.workingCopy;
    }

    private void rebuild() {
        this.previewModel.rebuild(this.workingCopy);
    }

    private boolean ensureLoaded() {
        return this.workingCopy != null;
    }
}

