/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.def;

import com.hazy.cache.def.NpcDefinition;
import com.hazy.draw.Rasterizer3D;
import com.hazy.entity.model.Model;

public final class NpcPreviewModel {
    private Model model;
    private int pitch = 256;
    private int yaw = 1024;
    private int rotation = 0;
    private int zoom = 300;

    public void update() {
        this.rotation = this.rotation + 8 & 0x7FF;
    }

    public void rebuild(NpcDefinition def) {
        int i;
        Model m4;
        if (def == null || def.models == null) {
            return;
        }
        Model[] parts = new Model[def.models.length];
        for (int i2 = 0; i2 < def.models.length; ++i2) {
            parts[i2] = Model.get(def.models[i2]);
            if (parts[i2] != null) continue;
            return;
        }
        Model model = m4 = parts.length == 1 ? parts[0] : new Model(parts.length, parts);
        if (def.recolorToFind != null) {
            for (i = 0; i < def.recolorToFind.length; ++i) {
                m4.recolor(def.recolorToFind[i], def.recolorToReplace[i]);
            }
        }
        if (def.retextureToFind != null) {
            for (i = 0; i < def.retextureToFind.length; ++i) {
                m4.retexture(def.retextureToFind[i], def.retextureToReplace[i]);
            }
        }
        if (def.modelCustomColor > 0) {
            m4.completelyRecolor(def.modelCustomColor);
        }
        if (def.modelCustomColor2 != 0) {
            m4.shadingRecolor(def.modelCustomColor2);
        }
        if (def.modelCustomColor3 != 0) {
            m4.shadingRecolor2(def.modelCustomColor3);
        }
        if (def.modelCustomColor4 != 0) {
            m4.shadingRecolor4(def.modelCustomColor4);
        }
        if (def.modelSetColor != 0) {
            m4.shadingRecolor3(def.modelSetColor);
        }
        NpcDefinition.applyTexture(m4, def.id);
        m4.generateBones();
        m4.light(84 + def.ambient, 1000 + def.contrast, -90, -580, -90, true);
        this.model = m4;
    }

    public void render(int width, int height) {
        if (this.model == null) {
            return;
        }
        Rasterizer3D.originViewX = width / 2;
        Rasterizer3D.originViewY = height / 2;
        this.model.calc_diagonals();
        int pitchSin = Model.SINE[this.pitch];
        int pitchCos = Model.COSINE[this.pitch];
        int yawSin = Model.SINE[this.yaw];
        int yawCos = Model.COSINE[this.yaw];
        this.model.renderAtPoint(this.rotation, pitchSin, pitchCos, yawSin, yawCos, 0, 0, this.zoom, 0L);
    }

    public void addYaw(int d) {
        this.yaw = this.yaw + d & 0x7FF;
    }

    public void addPitch(int d) {
        this.pitch = Math.max(128, Math.min(384, this.pitch + d));
    }

    public void addZoom(int d) {
        this.zoom = Math.max(50, this.zoom + d);
    }
}

