/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.def;

import com.hazy.Client;
import com.hazy.cache.Archive;
import com.hazy.cache.anim.SeqFrame;
import com.hazy.cache.config.VariableBits;
import com.hazy.cache.def.impl.ObjectManager;
import com.hazy.collection.TempCache;
import com.hazy.entity.model.Model;
import com.hazy.io.Buffer;
import com.hazy.net.requester.ResourceProvider;
import java.util.HashMap;
import java.util.Map;
import net.runelite.api.IterableHashTable;
import net.runelite.rs.api.RSBuffer;
import net.runelite.rs.api.RSIterableNodeHashTable;
import net.runelite.rs.api.RSObjectComposition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectDefinition
implements RSObjectComposition {
    private static final Logger log = LoggerFactory.getLogger(ObjectDefinition.class);
    public static final int REV_220_OBJ_ARCHIVE_REV = 1673;
    private boolean rev220SoundData = true;
    private boolean deferAnimChange;
    private int ambientSoundRetain;
    private int category;
    private int ambientSoundId;
    private int int2083;
    private int ambientSoundChangeTicksMin;
    private int ambientSoundChangeTicksMax;
    private int ambientSoundDistance;
    public int[] ambientSoundIds;
    private boolean randomizeAnimStart;
    private Map<Integer, Object> params = null;
    public static int length;
    public static int cache_index;
    public static boolean low_detail;
    public static Buffer data_buffer;
    public static ObjectDefinition[] cache;
    public static int[] stream_indices;
    public static final Model[] models;
    public static TempCache model_cache;
    public static TempCache animated_model_cache;
    public int id = -1;
    public int width;
    public int height;
    public int animationID;
    public int blockingMask;
    public int scaleX;
    public int modelSizeHeight;
    public int scaleZ;
    public int translateX;
    public int translateY;
    public int translateZ;
    public int mapAreaId;
    public int mapsceneID;
    public int wallOrDoor;
    public int decorDisplacement;
    public int supportsItems;
    public int varpID;
    public int varbitID;
    public int[] objectModels;
    public int[] configChangeDest;
    public int[] objectTypes;
    public int[] recolorToFind;
    public int[] recolorToReplace;
    public short[] retextureToFind;
    public short[] textureToReplace;
    public String name;
    public String description;
    public String[] scene_actions;
    public int contrast;
    public int ambient;
    public boolean rotated;
    public boolean blocksProjectile;
    public boolean contouredGround;
    public boolean aBool2111;
    public boolean hollow;
    public int interactType;
    public boolean shadow;
    public boolean mergeNormals;
    public boolean obstructsGround;
    int opcode_78_1 = 2019882883;
    int opcode_79_1 = 0;
    int opcode_79_2 = 0;
    int opcode_78_and_79 = 0;
    int[] opcode_79_3;

    public static void init(Archive archive) {
        int size;
        data_buffer = new Buffer(archive.get("loc.dat"));
        Buffer idx = new Buffer(archive.get("loc.idx"));
        int highestFileId = idx.readUnsignedShort();
        stream_indices = new int[highestFileId + 1];
        int i = 0;
        for (int j = 0; j <= highestFileId && (size = idx.readUnsignedShort()) != -1 && size != 65535; ++j) {
            ObjectDefinition.stream_indices[j] = i;
            i += size;
        }
        cache = new ObjectDefinition[20];
        for (int index = 0; index < 20; ++index) {
            ObjectDefinition.cache[index] = new ObjectDefinition();
        }
    }

    public void post_decode() {
        if (this.wallOrDoor == -1) {
            this.wallOrDoor = 0;
            if (this.objectModels != null && (this.objectTypes == null || this.objectTypes[0] == 10)) {
                this.wallOrDoor = 1;
            }
            for (int index = 0; index < 5; ++index) {
                if (this.scene_actions[index] == null) continue;
                this.wallOrDoor = 1;
            }
        }
        if (this.supportsItems == -1) {
            this.supportsItems = this.interactType != 0 ? 1 : 0;
        }
    }

    void decode(Buffer buffer) {
        int op;
        while ((op = buffer.readUnsignedByte()) != 0) {
            this.processOp(op, buffer);
        }
    }

    private void processOp(int opcode, Buffer is) {
        if (opcode == 1) {
            int length = is.readUnsignedByte();
            if (length > 0) {
                int[] objectTypes = new int[length];
                int[] objectModels = new int[length];
                for (int index = 0; index < length; ++index) {
                    objectModels[index] = is.readUnsignedShort();
                    objectTypes[index] = is.readUnsignedByte();
                }
                this.setObjectTypes(objectTypes);
                this.setObjectModels(objectModels);
            }
        } else if (opcode == 2) {
            this.setName(is.readStringCp1252NullTerminated());
        } else if (opcode == 5) {
            int length = is.readUnsignedByte();
            if (length > 0) {
                this.setObjectTypes(null);
                int[] objectModels = new int[length];
                for (int index = 0; index < length; ++index) {
                    objectModels[index] = is.readUnsignedShort();
                }
                this.setObjectModels(objectModels);
            }
        } else if (opcode == 14) {
            this.setWidth(is.readUnsignedByte());
        } else if (opcode == 15) {
            this.setHeight(is.readUnsignedByte());
        } else if (opcode == 17) {
            this.setInteractType(0);
            this.setBlocksProjectile(false);
        } else if (opcode == 18) {
            this.setBlocksProjectile(false);
        } else if (opcode == 19) {
            this.setWallOrDoor(is.readUnsignedByte());
        } else if (opcode == 21) {
            this.setContouredGround(true);
        } else if (opcode == 22) {
            this.setMergeNormals(true);
        } else if (opcode == 23) {
            this.setABool2111(true);
        } else if (opcode == 24) {
            this.setAnimationId(is.readUnsignedShort());
            if (this.getAnimationId() == 65535) {
                this.setAnimationId(-1);
            }
        } else if (opcode == 27) {
            this.setInteractType(1);
        } else if (opcode == 28) {
            this.setDecorDisplacement(is.readUnsignedByte());
        } else if (opcode == 29) {
            this.setAmbient(is.readByte());
        } else if (opcode == 39) {
            this.setContrast(is.readByte() * 25);
        } else if (opcode >= 30 && opcode < 35) {
            String[] actions = this.getActions();
            actions[opcode - 30] = is.readStringCp1252NullTerminated();
            if (actions[opcode - 30].equalsIgnoreCase("Hidden")) {
                actions[opcode - 30] = null;
            }
        } else if (opcode == 40) {
            int length = is.readUnsignedByte();
            int[] recolorToFind = new int[length];
            int[] recolorToReplace = new int[length];
            for (int index = 0; index < length; ++index) {
                recolorToFind[index] = (short)is.readShort();
                recolorToReplace[index] = (short)is.readShort();
            }
            this.setRecolorToFind(recolorToFind);
            this.setRecolorToReplace(recolorToReplace);
        } else if (opcode == 41) {
            int length = is.readUnsignedByte();
            short[] retextureToFind = new short[length];
            short[] textureToReplace = new short[length];
            for (int index = 0; index < length; ++index) {
                retextureToFind[index] = (short)is.readShort();
                textureToReplace[index] = (short)is.readShort();
            }
            this.setRetextureToFind(retextureToFind);
            this.setTextureToReplace(textureToReplace);
        } else if (opcode == 61) {
            this.setCategory(is.readUnsignedShort());
        } else if (opcode == 62) {
            this.setRotated(true);
        } else if (opcode == 64) {
            this.setShadow(false);
        } else if (opcode == 65) {
            this.setScaleX(is.readUnsignedShort());
        } else if (opcode == 66) {
            this.setModelSizeHeight(is.readUnsignedShort());
        } else if (opcode == 67) {
            this.setScaleZ(is.readUnsignedShort());
        } else if (opcode == 68) {
            this.setMapSceneId(is.readUnsignedShort());
        } else if (opcode == 69) {
            this.setBlockingMask(is.readByte());
        } else if (opcode == 70) {
            this.setTranslateX(is.readUnsignedShort());
        } else if (opcode == 71) {
            this.setTranslateY(is.readUnsignedShort());
        } else if (opcode == 72) {
            this.setTranslateZ(is.readUnsignedShort());
        } else if (opcode == 73) {
            this.setObstructsGround(true);
        } else if (opcode == 74) {
            this.setHollow(true);
        } else if (opcode == 75) {
            this.setSupportsItems(is.readUnsignedByte());
        } else if (opcode == 77) {
            int varpID = is.readUnsignedShort();
            if (varpID == 65535) {
                varpID = -1;
            }
            this.setVarbitID(varpID);
            int configId = is.readUnsignedShort();
            if (configId == 65535) {
                configId = -1;
            }
            this.setVarpID(configId);
            int length = is.readUnsignedByte();
            int[] configChangeDest = new int[length + 2];
            for (int index = 0; index <= length; ++index) {
                configChangeDest[index] = is.readUnsignedShort();
                if (65535 != configChangeDest[index]) continue;
                configChangeDest[index] = -1;
            }
            configChangeDest[length + 1] = -1;
            this.setConfigChangeDest(configChangeDest);
        } else if (opcode == 78) {
            this.setAmbientSoundId(is.readUnsignedShort());
            this.setAmbientSoundDistance(is.readUnsignedByte());
            if (this.rev220SoundData) {
                this.setAmbientSoundRetain(is.readUnsignedByte());
            }
        } else if (opcode == 79) {
            this.setAmbientSoundChangeTicksMin(is.readUnsignedShort());
            this.setAmbientSoundChangeTicksMax(is.readUnsignedShort());
            this.setAmbientSoundDistance(is.readUnsignedByte());
            if (this.rev220SoundData) {
                this.setAmbientSoundRetain(is.readUnsignedByte());
            }
            int length = is.readUnsignedByte();
            int[] ambientSoundIds = new int[length];
            for (int index = 0; index < length; ++index) {
                ambientSoundIds[index] = is.readUnsignedShort();
            }
            this.setAmbientSoundIds(ambientSoundIds);
        } else if (opcode == 81) {
            is.readUnsignedByte();
        } else if (opcode == 82) {
            this.setMapAreaId(is.readUnsignedShort());
        } else if (opcode == 89) {
            this.setRandomizeAnimStart(true);
        } else if (opcode == 90) {
            this.setDeferAnimChange(true);
        } else if (opcode == 92) {
            int varpID = is.readUnsignedShort();
            if (varpID == 65535) {
                varpID = -1;
            }
            this.setVarbitID(varpID);
            int configId = is.readUnsignedShort();
            if (configId == 65535) {
                configId = -1;
            }
            this.setVarpID(configId);
            int var = is.readUnsignedShort();
            if (var == 65535) {
                var = -1;
            }
            int length = is.readUnsignedByte();
            int[] configChangeDest = new int[length + 2];
            for (int index = 0; index <= length; ++index) {
                configChangeDest[index] = is.readUnsignedShort();
                if (65535 != configChangeDest[index]) continue;
                configChangeDest[index] = -1;
            }
            configChangeDest[length + 1] = var;
            this.setConfigChangeDest(configChangeDest);
        } else if (opcode == 249) {
            int length = is.readUnsignedByte();
            HashMap<Integer, Object> params = new HashMap<Integer, Object>(length);
            for (int i = 0; i < length; ++i) {
                boolean isString = is.readUnsignedByte() == 1;
                int key = is.read24BitInt();
                Object value = isString ? is.readStringCp1252NullTerminated() : Integer.valueOf(is.readInt());
                params.put(key, value);
            }
        } else {
            log.warn("Unrecognized opcode {}", (Object)opcode);
        }
    }

    public static ObjectDefinition get(int id) {
        if (id > stream_indices.length) {
            id = stream_indices.length - 1;
        }
        for (int j = 0; j < 20; ++j) {
            if (ObjectDefinition.cache[j].id != id) continue;
            return cache[j];
        }
        cache_index = (cache_index + 1) % 20;
        ObjectDefinition def = cache[cache_index];
        ObjectDefinition.data_buffer.pos = stream_indices[id];
        def.id = id;
        def.set_defaults();
        def.decode(data_buffer);
        def.post_decode();
        if (def.id == 29308) {
            def.mergeNormals = false;
        }
        if (def.id >= 29167 && def.id <= 29225) {
            def.width = 1;
            def.interactType = 0;
            def.scene_actions = new String[]{"Take", null, null, null, null};
        }
        if (def.id == 34683) {
            def.interactType = 0;
            def.scene_actions = new String[]{"Teleport", null, null, null, null};
        }
        if (def.id == 40780) {
            def.interactType = 0;
            def.scene_actions = new String[]{null, null, null, "Feed tokens", null};
        }
        if (id == 8151) {
            def.scene_actions = new String[]{null, null, "Rake", null, null};
        }
        if (id == 26749) {
            def.name = "Wildy slayer spawner";
            def.scene_actions = new String[]{"Spawn", null, null, null, null};
        }
        if (id == 33441) {
            def.name = "Monster instance";
            def.scene_actions = new String[]{"Spawn", null, null, null, null};
        }
        if (def.id == 47419) {
            def.interactType = 0;
            def.scene_actions = new String[]{"Open", null, null, null, null};
        }
        if (def.id == 70000) {
            def.name = "Summer Pool";
            def.scene_actions = new String[]{"Sacrifice", null, null, null, null};
            def.objectModels = new int[]{69842};
        }
        if (def.id == 13322) {
            def.interactType = 0;
        }
        if (def.id == 14924) {
            def.width = 1;
        }
        if (def.id == 45360) {
            def.scene_actions = new String[]{null, null, null, null, null};
        }
        if (def.blocksProjectile) {
            def.interactType = 0;
            def.blocksProjectile = false;
        }
        ObjectManager.get(id);
        return def;
    }

    public void set_defaults() {
        this.objectModels = null;
        this.objectTypes = null;
        this.name = null;
        this.description = null;
        this.recolorToFind = null;
        this.recolorToReplace = null;
        this.textureToReplace = null;
        this.retextureToFind = null;
        this.width = 1;
        this.height = 1;
        this.interactType = 2;
        this.blocksProjectile = true;
        this.wallOrDoor = -1;
        this.contouredGround = false;
        this.mergeNormals = false;
        this.aBool2111 = false;
        this.animationID = -1;
        this.decorDisplacement = 16;
        this.ambient = 0;
        this.contrast = 0;
        this.mapAreaId = -1;
        this.mapsceneID = -1;
        this.rotated = false;
        this.shadow = true;
        this.scaleX = 128;
        this.modelSizeHeight = 128;
        this.scaleZ = 128;
        this.scene_actions = new String[5];
        this.blockingMask = 0;
        this.translateX = 0;
        this.translateY = 0;
        this.translateZ = 0;
        this.obstructsGround = false;
        this.hollow = false;
        this.supportsItems = -1;
        this.varbitID = -1;
        this.varpID = -1;
        this.configChangeDest = null;
    }

    public void passive_request_load(ResourceProvider provider) {
        if (this.objectModels == null) {
            return;
        }
        for (int index = 0; index < this.objectModels.length; ++index) {
            provider.passive_request(this.objectModels[index] & 0xFFFF, 0);
        }
    }

    public Model modelAt(int type2, int orientation, int aY, int bY, int cY, int dY, int frameId) {
        Model model = this.model(type2, frameId, orientation);
        if (model == null) {
            return null;
        }
        if (this.contouredGround || this.mergeNormals) {
            model = new Model(this.contouredGround, this.mergeNormals, model);
        }
        if (this.contouredGround) {
            int y = (aY + bY + cY + dY) / 4;
            int vertex = 0;
            while (vertex < model.verticesCount) {
                int x = model.verticesX[vertex];
                int z = model.verticesZ[vertex];
                int l2 = aY + (bY - aY) * (x + 64) / 128;
                int i3 = dY + (cY - dY) * (x + 64) / 128;
                int j3 = l2 + (i3 - l2) * (z + 64) / 128;
                int n = vertex++;
                model.verticesY[n] = model.verticesY[n] + (j3 - y);
            }
            model.normalise();
            model.resetBounds();
        }
        return model;
    }

    public boolean group_cached(int type2) {
        if (this.objectTypes == null) {
            if (this.objectModels == null) {
                return true;
            }
            if (type2 != 10) {
                return true;
            }
            boolean cached = true;
            for (int index = 0; index < this.objectModels.length; ++index) {
                cached &= Model.cached(this.objectModels[index]);
            }
            return cached;
        }
        for (int index = 0; index < this.objectTypes.length; ++index) {
            if (this.objectTypes[index] != type2) continue;
            return Model.cached(this.objectModels[index]);
        }
        return true;
    }

    public boolean cached() {
        if (this.objectModels == null) {
            return true;
        }
        boolean cached = true;
        for (int model_id : this.objectModels) {
            cached &= Model.cached(model_id);
        }
        return cached;
    }

    public ObjectDefinition get_configs() {
        int setting_id = -1;
        if (this.varbitID != -1) {
            VariableBits bit = VariableBits.cache[this.varbitID];
            int setting = bit.configId;
            int low = bit.leastSignificantBit;
            int high = bit.mostSignificantBit;
            int mask = Client.BIT_MASKS[high - low];
            setting_id = Client.instance.settings[setting] >> low & mask;
        } else if (this.varpID != -1) {
            setting_id = Client.instance.settings[this.varpID];
        }
        if (setting_id < 0 || setting_id >= this.configChangeDest.length || this.configChangeDest[setting_id] == -1) {
            return null;
        }
        return ObjectDefinition.get(this.configChangeDest[setting_id]);
    }

    public Model model(int j, int k, int l) {
        int k2;
        long l1;
        Model model = null;
        if (this.objectTypes == null) {
            if (j != 10) {
                return null;
            }
            l1 = (long)((this.id << 6) + l) + ((long)(k + 1) << 32);
            Model model_1 = (Model)model_cache.get(l1);
            if (model_1 != null) {
                return model_1;
            }
            if (this.objectModels == null) {
                return null;
            }
            boolean flag1 = this.rotated ^ l > 3;
            int k1 = this.objectModels.length;
            for (int i2 = 0; i2 < k1; ++i2) {
                int l2 = this.objectModels[i2];
                if (flag1) {
                    l2 += 65536;
                }
                if ((model = (Model)animated_model_cache.get(l2)) == null) {
                    model = Model.get(l2 & 0xFFFF);
                    if (model == null) {
                        return null;
                    }
                    if (flag1) {
                        model.invert();
                    }
                    animated_model_cache.put(model, l2);
                }
                if (k1 <= 1) continue;
                ObjectDefinition.models[i2] = model;
            }
            if (k1 > 1) {
                model = new Model(k1, models);
            }
        } else {
            int i1 = -1;
            for (int j1 = 0; j1 < this.objectTypes.length; ++j1) {
                if (this.objectTypes[j1] != j) continue;
                i1 = j1;
                break;
            }
            if (i1 == -1) {
                return null;
            }
            l1 = (long)((this.id << 8) + (i1 << 3) + l) + ((long)(k + 1) << 32);
            Model model_2 = (Model)model_cache.get(l1);
            if (model_2 != null) {
                return model_2;
            }
            if (this.objectModels == null) {
                return null;
            }
            int j2 = this.objectModels[i1];
            boolean flag3 = this.rotated ^ l > 3;
            if (flag3) {
                j2 += 65536;
            }
            if ((model = (Model)animated_model_cache.get(j2)) == null) {
                model = Model.get(j2 & 0xFFFF);
                if (model == null) {
                    return null;
                }
                if (flag3) {
                    model.invert();
                }
                animated_model_cache.put(model, j2);
            }
        }
        boolean flag = this.scaleX != 128 || this.modelSizeHeight != 128 || this.scaleZ != 128;
        boolean flag2 = this.translateX != 0 || this.translateY != 0 || this.translateZ != 0;
        Model model_3 = new Model(this.recolorToFind == null, SeqFrame.noAnimationInProgress(k), l == 0 && k == -1 && !flag && !flag2, this.retextureToFind == null, model);
        if (k != -1) {
            model_3.generateBones();
            model_3.interpolate(k);
            model_3.faceGroups = null;
            model_3.groupedTriangleLabels = null;
        }
        while (l-- > 0) {
            model_3.rotate_90();
        }
        if (this.recolorToFind != null) {
            for (k2 = 0; k2 < this.recolorToFind.length; ++k2) {
                model_3.recolor(this.recolorToFind[k2], this.recolorToReplace[k2]);
            }
        }
        if (this.retextureToFind != null) {
            for (k2 = 0; k2 < this.retextureToFind.length; ++k2) {
                model_3.retexture(this.retextureToFind[k2], this.textureToReplace[k2]);
            }
        }
        if (flag) {
            model_3.scale(this.scaleX, this.scaleZ, this.modelSizeHeight);
        }
        if (flag2) {
            model_3.translate(this.translateX, this.translateY, this.translateZ);
        }
        model_3.light(85 + this.ambient, 768 + this.contrast, -50, -10, -50, !this.mergeNormals);
        if (this.supportsItems == 1) {
            model_3.itemDropHeight = model_3.modelBaseY;
        }
        animated_model_cache.put(model_3, l1);
        return model_3;
    }

    public static void release() {
        model_cache = null;
        animated_model_cache = null;
        stream_indices = null;
        cache = null;
        data_buffer = null;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String[] getActions() {
        return this.scene_actions;
    }

    @Override
    public int getMapSceneId() {
        return this.mapsceneID;
    }

    @Override
    public int getMapIconId() {
        return this.mapAreaId;
    }

    @Override
    public int[] getImpostorIds() {
        return this.configChangeDest;
    }

    @Override
    public RSObjectComposition getImpostor() {
        return this.get_configs();
    }

    @Override
    public int getAccessBitMask() {
        return 0;
    }

    @Override
    public RSIterableNodeHashTable getParams() {
        return (RSIterableNodeHashTable)((Object)this.params);
    }

    @Override
    public int getIntValue(int paramID) {
        return 0;
    }

    @Override
    public void setValue(int paramID, int value) {
    }

    @Override
    public String getStringValue(int paramID) {
        return "";
    }

    @Override
    public void setValue(int paramID, String value) {
    }

    @Override
    public void setParams(IterableHashTable params) {
    }

    @Override
    public void setParams(RSIterableNodeHashTable params) {
    }

    @Override
    public void decodeNext(RSBuffer buffer, int opcode) {
    }

    @Override
    public int[] getModelIds() {
        return this.objectModels;
    }

    @Override
    public void setModelIds(int[] modelIds) {
        this.objectModels = modelIds;
    }

    @Override
    public int[] getModels() {
        return this.objectTypes;
    }

    @Override
    public void setModels(int[] models) {
        this.objectTypes = models;
    }

    @Override
    public boolean getObjectDefinitionIsLowDetail() {
        return false;
    }

    @Override
    public int getSizeX() {
        return this.scaleX;
    }

    @Override
    public void setSizeX(int sizeX) {
        this.scaleX = sizeX;
    }

    @Override
    public int getSizeY() {
        return this.modelSizeHeight;
    }

    @Override
    public void setSizeY(int sizeY) {
        this.modelSizeHeight = sizeY;
    }

    @Override
    public int getInteractType() {
        return this.interactType;
    }

    @Override
    public void setInteractType(int interactType) {
        this.interactType = interactType;
    }

    @Override
    public boolean getBoolean1() {
        return this.blocksProjectile;
    }

    @Override
    public void setBoolean1(boolean boolean1) {
        this.blocksProjectile = boolean1;
    }

    @Override
    public int getInt1() {
        return this.wallOrDoor;
    }

    @Override
    public void setInt1(int int1) {
        this.wallOrDoor = int1;
    }

    @Override
    public int getInt2() {
        return this.decorDisplacement;
    }

    @Override
    public void setInt2(int int2) {
        this.decorDisplacement = int2;
    }

    @Override
    public int getClipType() {
        return 0;
    }

    @Override
    public void setClipType(int clipType) {
    }

    @Override
    public boolean getNonFlatShading() {
        return this.mergeNormals;
    }

    @Override
    public void setNonFlatShading(boolean nonFlatShading) {
        this.mergeNormals = nonFlatShading;
    }

    @Override
    public void setModelClipped(boolean modelClipped) {
        this.aBool2111 = modelClipped;
    }

    @Override
    public boolean getModelClipped() {
        return this.aBool2111;
    }

    @Override
    public int getAnimationId() {
        return this.animationID;
    }

    @Override
    public void setAnimationId(int animationId) {
        this.animationID = animationId;
    }

    @Override
    public int getAmbient() {
        return this.ambient;
    }

    @Override
    public void setAmbient(int ambient) {
        this.ambient = ambient;
    }

    @Override
    public int getContrast() {
        return this.contrast;
    }

    @Override
    public void setContrast(int contrast) {
        this.contrast = contrast;
    }

    @Override
    public int[] getRecolorFrom() {
        return this.recolorToFind;
    }

    @Override
    public void setRecolorFrom(short[] recolorFrom) {
    }

    @Override
    public short[] getRecolorTo() {
        return new short[0];
    }

    @Override
    public void setRecolorTo(short[] recolorTo) {
    }

    @Override
    public short[] getRetextureFrom() {
        return new short[0];
    }

    @Override
    public void setRetextureFrom(short[] retextureFrom) {
    }

    @Override
    public short[] getRetextureTo() {
        return new short[0];
    }

    @Override
    public void setRetextureTo(short[] retextureTo) {
    }

    @Override
    public void setIsRotated(boolean rotated) {
    }

    @Override
    public boolean getIsRotated() {
        return false;
    }

    @Override
    public void setClipped(boolean clipped) {
    }

    @Override
    public boolean getClipped() {
        return false;
    }

    @Override
    public void setMapSceneId(int mapSceneId) {
    }

    @Override
    public void setModelSizeX(int modelSizeX) {
    }

    @Override
    public int getModelSizeX() {
        return 0;
    }

    @Override
    public void setModelHeight(int modelHeight) {
    }

    @Override
    public void setModelSizeY(int modelSizeY) {
    }

    @Override
    public void setOffsetX(int modelSizeY) {
    }

    @Override
    public void setOffsetHeight(int offsetHeight) {
    }

    @Override
    public void setOffsetY(int offsetY) {
    }

    @Override
    public void setInt3(int int3) {
    }

    @Override
    public void setInt5(int int5) {
    }

    @Override
    public void setInt6(int int6) {
    }

    @Override
    public void setInt7(int int7) {
    }

    @Override
    public void setBoolean2(boolean boolean2) {
    }

    @Override
    public void setIsSolid(boolean isSolid) {
    }

    @Override
    public void setAmbientSoundId(int ambientSoundId) {
    }

    @Override
    public void setSoundEffectIds(int[] soundEffectIds) {
    }

    @Override
    public int[] getSoundEffectIds() {
        return new int[0];
    }

    @Override
    public void setMapIconId(int mapIconId) {
    }

    @Override
    public void setBoolean3(boolean boolean3) {
    }

    @Override
    public void setTransformVarbit(int transformVarbit) {
    }

    @Override
    public int getTransformVarbit() {
        return 0;
    }

    @Override
    public void setTransformVarp(int transformVarp) {
    }

    @Override
    public int getTransformVarp() {
        return 0;
    }

    @Override
    public void setTransforms(int[] transforms) {
    }

    @Override
    public int[] getTransforms() {
        return new int[0];
    }

    public void setRev220SoundData(boolean rev220SoundData) {
        this.rev220SoundData = rev220SoundData;
    }

    public void setDeferAnimChange(boolean deferAnimChange) {
        this.deferAnimChange = deferAnimChange;
    }

    public void setAmbientSoundRetain(int ambientSoundRetain) {
        this.ambientSoundRetain = ambientSoundRetain;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public void setInt2083(int int2083) {
        this.int2083 = int2083;
    }

    public void setAmbientSoundChangeTicksMin(int ambientSoundChangeTicksMin) {
        this.ambientSoundChangeTicksMin = ambientSoundChangeTicksMin;
    }

    public void setAmbientSoundChangeTicksMax(int ambientSoundChangeTicksMax) {
        this.ambientSoundChangeTicksMax = ambientSoundChangeTicksMax;
    }

    public void setAmbientSoundDistance(int ambientSoundDistance) {
        this.ambientSoundDistance = ambientSoundDistance;
    }

    public void setAmbientSoundIds(int[] ambientSoundIds) {
        this.ambientSoundIds = ambientSoundIds;
    }

    public void setRandomizeAnimStart(boolean randomizeAnimStart) {
        this.randomizeAnimStart = randomizeAnimStart;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setBlockingMask(int blockingMask) {
        this.blockingMask = blockingMask;
    }

    public void setScaleX(int scaleX) {
        this.scaleX = scaleX;
    }

    public void setModelSizeHeight(int modelSizeHeight) {
        this.modelSizeHeight = modelSizeHeight;
    }

    public void setScaleZ(int scaleZ) {
        this.scaleZ = scaleZ;
    }

    public void setTranslateX(int translateX) {
        this.translateX = translateX;
    }

    public void setTranslateY(int translateY) {
        this.translateY = translateY;
    }

    public void setTranslateZ(int translateZ) {
        this.translateZ = translateZ;
    }

    public void setMapAreaId(int mapAreaId) {
        this.mapAreaId = mapAreaId;
    }

    public void setWallOrDoor(int wallOrDoor) {
        this.wallOrDoor = wallOrDoor;
    }

    public void setDecorDisplacement(int decorDisplacement) {
        this.decorDisplacement = decorDisplacement;
    }

    public void setSupportsItems(int supportsItems) {
        this.supportsItems = supportsItems;
    }

    public void setVarpID(int varpID) {
        this.varpID = varpID;
    }

    public void setVarbitID(int varbitID) {
        this.varbitID = varbitID;
    }

    public void setObjectModels(int[] objectModels) {
        this.objectModels = objectModels;
    }

    public void setConfigChangeDest(int[] configChangeDest) {
        this.configChangeDest = configChangeDest;
    }

    public void setObjectTypes(int[] objectTypes) {
        this.objectTypes = objectTypes;
    }

    public void setRecolorToFind(int[] recolorToFind) {
        this.recolorToFind = recolorToFind;
    }

    public void setRecolorToReplace(int[] recolorToReplace) {
        this.recolorToReplace = recolorToReplace;
    }

    public void setRetextureToFind(short[] retextureToFind) {
        this.retextureToFind = retextureToFind;
    }

    public void setTextureToReplace(short[] textureToReplace) {
        this.textureToReplace = textureToReplace;
    }

    public void setDescription(String description2) {
        this.description = description2;
    }

    public void setScene_actions(String[] scene_actions) {
        this.scene_actions = scene_actions;
    }

    public void setRotated(boolean rotated) {
        this.rotated = rotated;
    }

    public void setBlocksProjectile(boolean blocksProjectile) {
        this.blocksProjectile = blocksProjectile;
    }

    public void setContouredGround(boolean contouredGround) {
        this.contouredGround = contouredGround;
    }

    public void setABool2111(boolean aBool2111) {
        this.aBool2111 = aBool2111;
    }

    public void setHollow(boolean hollow) {
        this.hollow = hollow;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    public void setMergeNormals(boolean mergeNormals) {
        this.mergeNormals = mergeNormals;
    }

    public void setObstructsGround(boolean obstructsGround) {
        this.obstructsGround = obstructsGround;
    }

    public void setOpcode_78_1(int opcode_78_1) {
        this.opcode_78_1 = opcode_78_1;
    }

    public void setOpcode_79_1(int opcode_79_1) {
        this.opcode_79_1 = opcode_79_1;
    }

    public void setOpcode_79_2(int opcode_79_2) {
        this.opcode_79_2 = opcode_79_2;
    }

    public void setOpcode_78_and_79(int opcode_78_and_79) {
        this.opcode_78_and_79 = opcode_78_and_79;
    }

    public void setOpcode_79_3(int[] opcode_79_3) {
        this.opcode_79_3 = opcode_79_3;
    }

    static {
        low_detail = false;
        models = new Model[4];
        model_cache = new TempCache(500);
        animated_model_cache = new TempCache(30);
    }
}

