/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.factory;

import com.hazy.cache.def.ItemDefinition;
import com.hazy.cache.graphics.SimpleImage;
import com.hazy.draw.Rasterizer2D;
import com.hazy.draw.Rasterizer3D;
import com.hazy.entity.model.Model;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;

public class ItemSpriteFactory {
    public static Long2ObjectMap<SimpleImage> itemSpriteCache = new Long2ObjectOpenHashMap<SimpleImage>();
    private static final Long2ObjectMap<SimpleImage> chatItemSpriteCache = new Long2ObjectOpenHashMap<SimpleImage>();

    public static long packCacheKey(int itemId, int thickness, double scale) {
        int scaleInt = (int)(scale * 65536.0) & 0xFFFFFF;
        return (long)itemId << 48 | (long)thickness << 24 | (long)scaleInt;
    }

    public static int unpackCacheKeyItemId(long key) {
        return (int)(key >> 48);
    }

    public static int unpackCacheKeyThickness(long key) {
        return (int)(key >> 24) & 0xFFFFFF;
    }

    public static double unpackCacheKeyScale(long key) {
        int scaleInt = (int)(key & 0xFFFFFFL);
        return (double)scaleInt / 65536.0;
    }

    private static int[] getOpaqueBounds(SimpleImage img) {
        int[] nArray;
        int minX = img.width;
        int minY = img.height;
        int maxX = 0;
        int maxY = 0;
        boolean found = false;
        for (int y = 0; y < img.height; ++y) {
            for (int x = 0; x < img.width; ++x) {
                if (img.myPixels[x + y * img.width] >>> 24 == 0) continue;
                found = true;
                if (x < minX) {
                    minX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y <= maxY) continue;
                maxY = y;
            }
        }
        if (found) {
            int[] nArray2 = new int[4];
            nArray2[0] = minX;
            nArray2[1] = minY;
            nArray2[2] = maxX + 1;
            nArray = nArray2;
            nArray2[3] = maxY + 1;
        } else {
            nArray = null;
        }
        return nArray;
    }

    public static SimpleImage get_chat_item_sprite(int itemId, int stackSize, int border, int targetSizePx) {
        ItemDefinition def = ItemDefinition.get(itemId);
        if (def == null) {
            return null;
        }
        if (def.countObj == null) {
            stackSize = -1;
        } else if (stackSize > 1) {
            int stackItemId = -1;
            for (int i = 0; i < 10; ++i) {
                if (stackSize < def.countCo[i] || def.countCo[i] == 0) continue;
                stackItemId = def.countObj[i];
            }
            if (stackItemId != -1) {
                def = ItemDefinition.get(stackItemId);
            }
        }
        long key = (long)itemId << 32 | (long)targetSizePx & 0xFFFFFFFFL;
        SimpleImage cached = (SimpleImage)chatItemSpriteCache.get(key);
        if (cached != null) {
            return cached;
        }
        int BASE_SIZE = 9;
        double scale = (double)targetSizePx / 9.0;
        int zoom2d = (int)((double)def.zoom2d * scale);
        if (border == -1) {
            zoom2d = (int)((double)zoom2d * 1.5);
        } else if (border > 0) {
            zoom2d = (int)((double)zoom2d * 1.04);
        }
        int canvas = Math.max(32, targetSizePx + 8);
        SimpleImage image = new SimpleImage(canvas, canvas);
        int cx = Rasterizer3D.originViewX;
        int cy = Rasterizer3D.originViewY;
        int[] scan = Rasterizer3D.scanOffsets;
        int[] pixels = Rasterizer2D.pixels;
        float[] depth = Rasterizer2D.depth_buffer;
        int w = Rasterizer2D.width;
        int h2 = Rasterizer2D.height;
        int lx = Rasterizer2D.leftX;
        int rx = Rasterizer2D.bottomX;
        int ty = Rasterizer2D.topY;
        int by = Rasterizer2D.bottomY;
        Rasterizer3D.world = false;
        Rasterizer3D.mapped = false;
        Rasterizer2D.init(canvas, canvas, image.myPixels, new float[canvas * canvas]);
        Rasterizer2D.clear();
        Rasterizer3D.useViewport();
        Model model = def.get_model(1);
        if (model == null) {
            model = def.get_widget_model(0);
        }
        if (model == null) {
            return null;
        }
        int modelWidth = model.maxX - model.minX;
        int sine = Rasterizer3D.SINE[def.xan2d] * zoom2d >> 16;
        int cosine = Rasterizer3D.COSINE[def.xan2d] * zoom2d >> 16;
        Rasterizer3D.renderOnGpu = true;
        model.renderModel(def.yan2d, def.zan2d, def.xan2d, def.xOffset2d - (modelWidth >> 3), sine + model.modelBaseY / 2 + def.yOffset2d, cosine + def.yOffset2d);
        Rasterizer3D.renderOnGpu = false;
        Rasterizer3D.lowMem = true;
        image.outline(1);
        Rasterizer2D.init(w, h2, pixels, depth);
        Rasterizer2D.set_clip(lx, ty, rx, by);
        Rasterizer3D.originViewX = cx;
        Rasterizer3D.originViewY = cy;
        Rasterizer3D.scanOffsets = scan;
        Rasterizer3D.world = true;
        Rasterizer3D.mapped = true;
        image.max_width = targetSizePx;
        image.max_height = targetSizePx;
        chatItemSpriteCache.put(key, image);
        return image;
    }

    public static SimpleImage get_item_sprite_zoomed(int itemId, int stackSize, int border, int targetSizePx) {
        try {
            ItemDefinition def = ItemDefinition.get(itemId);
            if (def == null) {
                return null;
            }
            if (def.countObj == null) {
                stackSize = -1;
            } else if (stackSize > 1) {
                int stackItemId = -1;
                for (int i = 0; i < 10; ++i) {
                    if (stackSize < def.countCo[i] || def.countCo[i] == 0) continue;
                    stackItemId = def.countObj[i];
                }
                if (stackItemId != -1) {
                    def = ItemDefinition.get(stackItemId);
                }
            }
            Model model = def.get_model(1);
            if (model == null) {
                model = def.get_widget_model(0);
            }
            if (model == null) {
                return null;
            }
            int BASE_SIZE = 8;
            double scale = (double)targetSizePx / 8.0;
            int zoom2d = (int)((double)def.zoom2d * scale);
            if (border == -1) {
                zoom2d = (int)((double)zoom2d * 1.5);
            } else if (border > 0) {
                zoom2d = (int)((double)zoom2d * 1.04);
            }
            int canvasSize = Math.max(32, targetSizePx + 8);
            long key = (long)itemId << 32 | (long)targetSizePx & 0xFFFFFFFFL;
            SimpleImage cached = (SimpleImage)itemSpriteCache.get(key);
            if (cached != null) {
                return cached;
            }
            SimpleImage image = new SimpleImage(canvasSize, canvasSize);
            int cx = Rasterizer3D.originViewX;
            int cy = Rasterizer3D.originViewY;
            int[] scan = Rasterizer3D.scanOffsets;
            int[] pixels = Rasterizer2D.pixels;
            float[] depth = Rasterizer2D.depth_buffer;
            int w = Rasterizer2D.width;
            int h2 = Rasterizer2D.height;
            int lx = Rasterizer2D.leftX;
            int rx = Rasterizer2D.bottomX;
            int ty = Rasterizer2D.topY;
            int by = Rasterizer2D.bottomY;
            Rasterizer3D.world = false;
            Rasterizer3D.mapped = false;
            Rasterizer2D.init(canvasSize, canvasSize, image.myPixels, new float[canvasSize * canvasSize]);
            Rasterizer2D.clear();
            Rasterizer3D.useViewport();
            int sine = Rasterizer3D.SINE[def.xan2d] * zoom2d >> 16;
            int cosine = Rasterizer3D.COSINE[def.xan2d] * zoom2d >> 16;
            Rasterizer3D.renderOnGpu = true;
            model.calculateBoundsCylinder();
            model.renderModel(def.yan2d, def.zan2d, def.xan2d, def.xOffset2d, sine + model.modelBaseY / 2 + def.yOffset2d, cosine + def.yOffset2d);
            Rasterizer3D.renderOnGpu = false;
            Rasterizer3D.lowMem = true;
            image.outline(1);
            if (border == 0xFFFFFF) {
                image.outline(0xFFFFFF);
            } else if (border >= 0) {
                image.shadow(0x302020);
            }
            Rasterizer2D.init(w, h2, pixels, depth);
            Rasterizer2D.set_clip(lx, ty, rx, by);
            Rasterizer3D.originViewX = cx;
            Rasterizer3D.originViewY = cy;
            Rasterizer3D.scanOffsets = scan;
            Rasterizer3D.world = true;
            Rasterizer3D.mapped = true;
            image.max_width = canvasSize;
            image.max_height = stackSize;
            itemSpriteCache.put(key, image);
            return image;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SimpleImage get_sized_item_sprite(int itemIdForCache, int stack_size, int border, int w, int h2, boolean dumpImages) {
        try {
            Model model;
            long key;
            SimpleImage sprite;
            boolean ignoreCache = false;
            ItemDefinition def = ItemDefinition.get(itemIdForCache);
            if (def == null) {
                return null;
            }
            int zoom2d = def.zoom2d;
            if (border == -1) {
                zoom2d = (int)((double)zoom2d * 1.5);
            }
            if (border > 0) {
                zoom2d = (int)((double)zoom2d * 1.04);
            }
            if (!ignoreCache && (sprite = (SimpleImage)itemSpriteCache.get(key = ItemSpriteFactory.packCacheKey(itemIdForCache, border, zoom2d))) != null) {
                return sprite;
            }
            if (def.countObj == null) {
                stack_size = -1;
            }
            if (stack_size > 1) {
                int stack_item_id = -1;
                for (int index = 0; index < 10; ++index) {
                    if (stack_size < def.countCo[index] || def.countCo[index] == 0) continue;
                    stack_item_id = def.countObj[index];
                }
                if (stack_item_id != -1) {
                    def = ItemDefinition.get(stack_item_id);
                }
            }
            if ((model = def.get_model(1)) == null) {
                return null;
            }
            SimpleImage noted_sprite = null;
            if (def.notedTemplate != -1 && (noted_sprite = ItemSpriteFactory.get_item_sprite(def.notedID, 10, -1)) == null) {
                return null;
            }
            SimpleImage image = new SimpleImage(w, h2);
            int center_x = Rasterizer3D.originViewX;
            int center_y = Rasterizer3D.originViewY;
            int[] line_offsets = Rasterizer3D.scanOffsets;
            int[] pixels = Rasterizer2D.pixels;
            float[] depthBuffer = Rasterizer2D.depth_buffer;
            int width = Rasterizer2D.width;
            int height = Rasterizer2D.height;
            int viewport_left = Rasterizer2D.leftX;
            int viewport_right = Rasterizer2D.bottomX;
            int viewport_top = Rasterizer2D.topY;
            int viewport_bottom = Rasterizer2D.bottomY;
            Rasterizer3D.world = false;
            Rasterizer3D.mapped = false;
            Rasterizer2D.init(w, h2, image.myPixels, new float[w * h2]);
            Rasterizer2D.draw_filled_rect(0, 0, w, h2, 0);
            Rasterizer2D.clear();
            Rasterizer3D.useViewport();
            int sine = Rasterizer3D.SINE[def.xan2d] * zoom2d >> 16;
            int cosine = Rasterizer3D.COSINE[def.xan2d] * zoom2d >> 16;
            Rasterizer3D.renderOnGpu = true;
            model.calculateBoundsCylinder();
            model.renderModel(def.yan2d, def.zan2d, def.xan2d, def.xOffset2d, sine + model.modelBaseY / 2 + def.yOffset2d, cosine + def.yOffset2d);
            Rasterizer3D.lowMem = true;
            Rasterizer3D.renderOnGpu = false;
            if (def.notedID != -1) {
                image.drawAdvancedSprite(0, 0);
            }
            image.outline(1);
            if (border == 0xFFFFFF) {
                image.outline(0xFFFFFF);
            } else if (border < 1 && border != -1) {
                image.shadow(0x302020);
            }
            Rasterizer2D.init(w, h2, image.myPixels, new float[w * h2]);
            if (def.notedTemplate != -1) {
                int old_w = noted_sprite.max_width;
                int old_h = noted_sprite.max_height;
                noted_sprite.max_width = w;
                noted_sprite.max_height = h2;
                noted_sprite.drawSprite(0, 0);
                noted_sprite.max_width = old_w;
                noted_sprite.max_height = old_h;
            }
            Rasterizer2D.init(width, height, pixels, depthBuffer);
            Rasterizer2D.set_clip(viewport_left, viewport_top, viewport_right, viewport_bottom);
            Rasterizer3D.originViewX = center_x;
            Rasterizer3D.originViewY = center_y;
            Rasterizer3D.scanOffsets = line_offsets;
            Rasterizer3D.world = true;
            Rasterizer3D.mapped = true;
            image.max_width = def.stackable ? w + 1 : w;
            image.max_height = stack_size;
            if (!ignoreCache) {
                long key2 = ItemSpriteFactory.packCacheKey(itemIdForCache, border, zoom2d);
                itemSpriteCache.put(key2, image);
            }
            return image;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw new NullPointerException("Error generating item sprite! [ItemSpriteFactory -> get_item_sprite()]");
        }
    }

    public static SimpleImage get_item_sprite(int id, int stack_size, int highlight) {
        try {
            long key;
            SimpleImage sprite;
            ItemDefinition def = ItemDefinition.get(id);
            if (def == null) {
                System.out.println("[ERROR] ItemSpriteFactory get_item_sprite - def == null! " + id);
                return null;
            }
            if (def.countObj == null) {
                stack_size = -1;
            }
            if (stack_size > 1) {
                int stack_item_id = -1;
                for (int index = 0; index < 10; ++index) {
                    if (stack_size < def.countCo[index] || def.countCo[index] == 0) continue;
                    stack_item_id = def.countObj[index];
                }
                if (stack_item_id != -1) {
                    def = ItemDefinition.get(stack_item_id);
                }
            }
            if (def == null) {
                throw new RuntimeException("def == null");
            }
            Model model = def.get_model(1);
            if (model == null) {
                return null;
            }
            int zoom = def.zoom2d;
            if (highlight == -1) {
                zoom = (int)((double)zoom * 1.5);
            }
            if (highlight > 0) {
                zoom = (int)((double)zoom * 1.04);
            }
            if ((sprite = (SimpleImage)itemSpriteCache.get(key = ItemSpriteFactory.packCacheKey(id, highlight, zoom))) != null) {
                return sprite;
            }
            SimpleImage noted_sprite = null;
            if (def.notedTemplate != -1 && (noted_sprite = ItemSpriteFactory.get_item_sprite(def.notedID, 10, -1)) == null) {
                return null;
            }
            sprite = new SimpleImage(32, 32);
            int center_x = Rasterizer3D.originViewX;
            int center_y = Rasterizer3D.originViewY;
            int[] line_offsets = Rasterizer3D.scanOffsets;
            int[] pixels = Rasterizer2D.pixels;
            float[] depth = Rasterizer2D.depth_buffer;
            int width = Rasterizer2D.width;
            int height = Rasterizer2D.height;
            int viewport_left = Rasterizer2D.leftX;
            int viewport_right = Rasterizer2D.bottomX;
            int viewport_top = Rasterizer2D.topY;
            int viewport_bottom = Rasterizer2D.bottomY;
            Rasterizer3D.world = false;
            Rasterizer3D.mapped = false;
            Rasterizer2D.init(32, 32, sprite.myPixels, new float[1024]);
            Rasterizer2D.clear();
            Rasterizer2D.draw_filled_rect(0, 0, 32, 32, 0);
            Rasterizer3D.useViewport();
            int sine = Rasterizer3D.SINE[def.xan2d] * zoom >> 16;
            int cosine = Rasterizer3D.COSINE[def.xan2d] * zoom >> 16;
            Rasterizer3D.renderOnGpu = true;
            model.calculateBoundsCylinder();
            model.renderModel(def.yan2d, def.zan2d, def.xan2d, def.xOffset2d, sine + model.modelBaseY / 2 + def.yOffset2d, cosine + def.yOffset2d);
            Rasterizer3D.lowMem = true;
            Rasterizer3D.renderOnGpu = true;
            if (def.notedID != -1) {
                sprite.drawAdvancedSprite(0, 0);
            }
            sprite.outline(1);
            if (highlight == 0xFFFFFF) {
                sprite.outline(0xFFFFFF);
            } else if (highlight < 1 && highlight != -1) {
                sprite.shadow(0x302020);
            }
            Rasterizer2D.init(32, 32, sprite.myPixels, new float[1024]);
            if (def.notedTemplate != -1) {
                int old_w = noted_sprite.max_width;
                int old_h = noted_sprite.max_height;
                noted_sprite.max_width = 32;
                noted_sprite.max_height = 32;
                noted_sprite.drawSprite(0, 0);
                noted_sprite.max_width = old_w;
                noted_sprite.max_height = old_h;
            }
            Rasterizer2D.init(width, height, pixels, depth);
            Rasterizer2D.set_clip(viewport_left, viewport_top, viewport_right, viewport_bottom);
            Rasterizer3D.originViewX = center_x;
            Rasterizer3D.originViewY = center_y;
            Rasterizer3D.scanOffsets = line_offsets;
            Rasterizer3D.world = true;
            Rasterizer3D.mapped = true;
            sprite.max_width = def.stackable ? 33 : 32;
            sprite.max_height = stack_size;
            return sprite;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw new NullPointerException("Error generating item sprite! [ItemSpriteFactory -> get_item_sprite()]");
        }
    }
}

