/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.graphics;

import com.hazy.cache.graphics.SimpleImage;
import com.hazy.sign.SignLink;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public final class CustomSpriteLoader {
    private static final String BATTLEPASS_FOLDER = "Customsprite/";
    private static final Map<Integer, SimpleImage> battlepassSprites = new HashMap<Integer, SimpleImage>();
    private static boolean initialized = false;

    public static void init() {
        if (initialized) {
            return;
        }
        String cacheDir = SignLink.findCacheDir();
        File battlepassDir = new File(cacheDir + BATTLEPASS_FOLDER);
        if (!battlepassDir.exists()) {
            System.out.println("Custom folder not found: " + battlepassDir.getAbsolutePath());
            return;
        }
        if (!battlepassDir.isDirectory()) {
            System.err.println("Custom path is not a directory: " + battlepassDir.getAbsolutePath());
            return;
        }
        File[] files = battlepassDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".png"));
        if (files == null) {
            System.err.println("Could not list files in Custom directory");
            return;
        }
        System.out.println("Loading " + files.length + " Custom sprites...");
        for (File file : files) {
            try {
                String fileName = file.getName();
                String idStr = fileName.substring(0, fileName.lastIndexOf(46));
                int spriteId = Integer.parseInt(idStr);
                SimpleImage sprite = CustomSpriteLoader.loadSpriteFromFile(file);
                if (sprite == null) continue;
                battlepassSprites.put(spriteId, sprite);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid sprite filename (not a number): " + file.getName());
            }
            catch (Exception e) {
                System.err.println("Error loading Custom sprite from " + file.getName() + ": " + e.getMessage());
            }
        }
        System.out.println("Successfully loaded " + battlepassSprites.size() + " Custom sprites");
        initialized = true;
    }

    private static SimpleImage loadSpriteFromFile(File file) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(file);
        if (bufferedImage == null) {
            throw new IOException("Could not read image from file: " + file.getName());
        }
        if (bufferedImage.getType() != 2) {
            BufferedImage converted = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
            converted.getGraphics().drawImage(bufferedImage, 0, 0, null);
            bufferedImage = converted;
        }
        int[] pixels = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        return new SimpleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 0, 0, pixels);
    }

    public static SimpleImage get(int id) {
        if (!initialized) {
            CustomSpriteLoader.init();
        }
        return battlepassSprites.get(id);
    }

    public static boolean contains(int id) {
        if (!initialized) {
            CustomSpriteLoader.init();
        }
        return battlepassSprites.containsKey(id);
    }

    public static int size() {
        if (!initialized) {
            CustomSpriteLoader.init();
        }
        return battlepassSprites.size();
    }

    public static void clear() {
        battlepassSprites.clear();
        initialized = false;
    }

    public static void reload() {
        CustomSpriteLoader.clear();
        CustomSpriteLoader.init();
    }
}

