/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.graphics;

import com.hazy.cache.Archive;
import com.hazy.cache.def.SpriteDefinition;
import com.hazy.draw.Rasterizer2D;
import com.hazy.io.Buffer;

public final class IndexedImage
extends Rasterizer2D {
    public byte[] palettePixels;
    public final int[] palette;
    public int width;
    public int height;
    public int drawOffsetX;
    public int drawOffsetY;
    public int subWidth;
    public int subHeight;
    public int[] pixels;

    public void setTransparency(int transRed, int transGreen, int transBlue) {
        for (int index = 0; index < this.palette.length; ++index) {
            if ((this.palette[index] >> 16 & 0xFF) != transRed || (this.palette[index] >> 8 & 0xFF) != transGreen || (this.palette[index] & 0xFF) != transBlue) continue;
            this.palette[index] = 0;
        }
    }

    public void normalize() {
        if (this.subWidth != this.width || this.subHeight != this.height) {
            byte[] pixels = new byte[this.width * this.height];
            int var2 = 0;
            for (int var3 = 0; var3 < this.subHeight; ++var3) {
                for (int var4 = 0; var4 < this.subWidth; ++var4) {
                    pixels[var4 + (var3 + this.drawOffsetY) * this.width + this.drawOffsetX] = this.palettePixels[var2++];
                }
            }
            this.palettePixels = pixels;
            this.subWidth = this.width;
            this.subHeight = this.height;
            this.drawOffsetX = 0;
            this.drawOffsetY = 0;
        }
    }

    public IndexedImage(SpriteDefinition definition) {
        this.palettePixels = definition.getPixelIdx();
        this.palette = definition.getPalette();
        this.width = definition.getWidth();
        this.height = definition.getHeight();
        this.drawOffsetX = definition.getOffsetX();
        this.drawOffsetY = definition.getOffsetY();
        this.subWidth = definition.getMaxWidth();
        this.subHeight = definition.getMaxHeight();
        this.pixels = definition.getPixels();
    }

    public IndexedImage(Archive archive, String s2, int i) {
        block6: {
            int type2;
            Buffer image;
            block5: {
                image = new Buffer(archive.get(s2 + ".dat"));
                Buffer meta = new Buffer(archive.get("index.dat"));
                meta.pos = image.readUnsignedShort();
                this.subWidth = meta.readUnsignedShort();
                this.subHeight = meta.readUnsignedShort();
                int colorLength = meta.readUnsignedByte();
                this.palette = new int[colorLength];
                for (int index = 0; index < colorLength - 1; ++index) {
                    this.palette[index + 1] = meta.readTriByte();
                }
                for (int l = 0; l < i; ++l) {
                    meta.pos += 2;
                    image.pos += meta.readUnsignedShort() * meta.readUnsignedShort();
                    ++meta.pos;
                }
                this.drawOffsetX = meta.readUnsignedByte();
                this.drawOffsetY = meta.readUnsignedByte();
                this.width = meta.readUnsignedShort();
                this.height = meta.readUnsignedShort();
                type2 = meta.readUnsignedByte();
                int pixels = this.width * this.height;
                this.palettePixels = new byte[pixels];
                if (type2 != 0) break block5;
                for (int index = 0; index < pixels; ++index) {
                    this.palettePixels[index] = image.readSignedByte();
                }
                break block6;
            }
            if (type2 != 1) break block6;
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    this.palettePixels[x + y * this.width] = image.readSignedByte();
                }
            }
        }
    }

    public void scale_half() {
        this.subWidth /= 2;
        this.subHeight /= 2;
        byte[] raster = new byte[this.subWidth * this.subHeight];
        int sourceIndex = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                raster[(x + this.drawOffsetX >> 1) + (y + this.drawOffsetY >> 1) * this.subWidth] = raster[sourceIndex++];
            }
        }
        this.palettePixels = raster;
        this.width = this.subWidth;
        this.height = this.subHeight;
        this.drawOffsetX = 0;
        this.drawOffsetY = 0;
    }

    public void scale_full() {
        if (this.width == this.subWidth && this.height == this.subHeight) {
            return;
        }
        byte[] raster = new byte[this.subWidth * this.subHeight];
        int i = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                raster[x + this.drawOffsetX + (y + this.drawOffsetY) * this.subWidth] = raster[i++];
            }
        }
        this.palettePixels = raster;
        this.width = this.subWidth;
        this.height = this.subHeight;
        this.drawOffsetX = 0;
        this.drawOffsetY = 0;
    }

    public void flipHorizontally() {
        byte[] raster = new byte[this.width * this.height];
        int pixel = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = this.width - 1; x >= 0; --x) {
                raster[pixel++] = raster[x + y * this.width];
            }
        }
        this.palettePixels = raster;
        this.drawOffsetX = this.subWidth - this.width - this.drawOffsetX;
    }

    public void flipVertically() {
        byte[] raster = new byte[this.width * this.height];
        int pixel = 0;
        for (int y = this.height - 1; y >= 0; --y) {
            for (int x = 0; x < this.width; ++x) {
                raster[pixel++] = raster[x + y * this.width];
            }
        }
        this.palettePixels = raster;
        this.drawOffsetY = this.subHeight - this.height - this.drawOffsetY;
    }

    public void offsetColor(int redOffset, int greenOffset, int blueOffset) {
        for (int index = 0; index < this.palette.length; ++index) {
            int red = this.palette[index] >> 16 & 0xFF;
            if ((red += redOffset) < 0) {
                red = 0;
            } else if (red > 255) {
                red = 255;
            }
            int green = this.palette[index] >> 8 & 0xFF;
            if ((green += greenOffset) < 0) {
                green = 0;
            } else if (green > 255) {
                green = 255;
            }
            int blue = this.palette[index] & 0xFF;
            if ((blue += blueOffset) < 0) {
                blue = 0;
            } else if (blue > 255) {
                blue = 255;
            }
            this.palette[index] = (red << 16) + (green << 8) + blue;
        }
    }

    public void draw(int x, int y) {
        int destOffset = (x += this.drawOffsetX) + (y += this.drawOffsetY) * Rasterizer2D.width;
        int sourceOffset = 0;
        int height = this.height;
        int width = this.width;
        int destStep = Rasterizer2D.width - width;
        int sourceStep = 0;
        if (y < Rasterizer2D.topY) {
            int dy = Rasterizer2D.topY - y;
            height -= dy;
            y = Rasterizer2D.topY;
            sourceOffset += dy * width;
            destOffset += dy * Rasterizer2D.width;
        }
        if (y + height > Rasterizer2D.bottomY) {
            height -= y + height - Rasterizer2D.bottomY;
        }
        if (x < Rasterizer2D.leftX) {
            int k2 = Rasterizer2D.leftX - x;
            width -= k2;
            x = Rasterizer2D.leftX;
            sourceOffset += k2;
            destOffset += k2;
            sourceStep += k2;
            destStep += k2;
        }
        if (x + width > Rasterizer2D.bottomX) {
            int dx = x + width - Rasterizer2D.bottomX;
            width -= dx;
            sourceStep += dx;
            destStep += dx;
        }
        if (width > 0 && height > 0) {
            this.draw(height, Rasterizer2D.pixels, this.palettePixels, destStep, destOffset, width, sourceOffset, this.palette, sourceStep);
        }
    }

    private void draw(int i, int[] raster, byte[] image, int destStep, int destIndex, int width, int sourceIndex, int[] ai1, int sourceStep) {
        int minX = -(width >> 2);
        width = -(width & 3);
        for (int y = -i; y < 0; ++y) {
            byte pixel;
            int x;
            for (x = minX; x < 0; ++x) {
                if ((pixel = image[sourceIndex++]) != 0) {
                    raster[destIndex++] = ai1[pixel & 0xFF];
                } else {
                    ++destIndex;
                }
                pixel = image[sourceIndex++];
                if (pixel != 0) {
                    raster[destIndex++] = ai1[pixel & 0xFF];
                } else {
                    ++destIndex;
                }
                pixel = image[sourceIndex++];
                if (pixel != 0) {
                    raster[destIndex++] = ai1[pixel & 0xFF];
                } else {
                    ++destIndex;
                }
                pixel = image[sourceIndex++];
                if (pixel != 0) {
                    raster[destIndex++] = ai1[pixel & 0xFF];
                    continue;
                }
                ++destIndex;
            }
            for (x = width; x < 0; ++x) {
                if ((pixel = image[sourceIndex++]) != 0) {
                    raster[destIndex++] = ai1[pixel & 0xFF];
                    continue;
                }
                ++destIndex;
            }
            destIndex += destStep;
            sourceIndex += sourceStep;
        }
    }
}

