/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.graphics;

import com.hazy.cache.Archive;
import com.hazy.cache.graphics.SimpleImage;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.imageio.ImageIO;

public class MapFunctionLoader
implements Closeable {
    public static SimpleImage[] cache;
    private ByteBuffer dataBuffer;
    private ByteBuffer metaBuffer;

    public void init(Archive archive, String dataFile, String metaFile) throws IOException {
        byte[] dataBytes = archive.get(dataFile);
        byte[] metaBytes = archive.get(metaFile);
        this.metaBuffer = ByteBuffer.wrap(metaBytes);
        this.dataBuffer = ByteBuffer.wrap(dataBytes);
        int spriteCount = metaBytes.length / 10;
        cache = new SimpleImage[spriteCount];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SimpleImage get(int id) {
        try {
            if (this.contains(id)) {
                return cache[id];
            }
            if (this.dataBuffer == null || this.metaBuffer == null) {
                System.err.println("Sprite buffers are not initialized!");
                return null;
            }
            int entries = this.metaBuffer.capacity() / 10;
            if (id > entries) {
                return null;
            }
            this.metaBuffer.position(id * 10);
            ByteBuffer metaBuf = this.metaBuffer.slice();
            metaBuf.limit(10);
            int pos = (metaBuf.get() & 0xFF) << 16 | (metaBuf.get() & 0xFF) << 8 | metaBuf.get() & 0xFF;
            int len = (metaBuf.get() & 0xFF) << 16 | (metaBuf.get() & 0xFF) << 8 | metaBuf.get() & 0xFF;
            int offsetX = metaBuf.getShort() & 0xFFFF;
            int offsetY = metaBuf.getShort() & 0xFFFF;
            this.dataBuffer.position(pos);
            ByteBuffer dataBuf = this.dataBuffer.slice();
            dataBuf.limit(len);
            try (ByteArrayInputStream is = new ByteArrayInputStream(dataBuf.array());){
                SimpleImage sprite;
                BufferedImage bimage = ImageIO.read(is);
                if (bimage == null) {
                    System.err.printf("Could not read image at %d%n", id);
                    SimpleImage simpleImage = null;
                    return simpleImage;
                }
                if (bimage.getType() != 2) {
                    bimage = MapFunctionLoader.convert(bimage);
                }
                int[] pixels = ((DataBufferInt)bimage.getRaster().getDataBuffer()).getData();
                MapFunctionLoader.cache[id] = sprite = new SimpleImage(bimage.getWidth(), bimage.getHeight(), offsetX, offsetY, pixels);
                SimpleImage simpleImage = sprite;
                return simpleImage;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.printf("No sprite found for id=%d%n", id);
            return null;
        }
    }

    public void draw(int id, int x, int y) {
        this.draw(id, x, y, false);
    }

    public void draw(int id, int x, int y, int alpha, boolean advanced) {
        SimpleImage sprite = this.get(id);
        if (sprite != null) {
            if (advanced) {
                sprite.drawAdvancedSprite(x, y, alpha);
            } else {
                sprite.drawSprite(x, y, alpha);
            }
        }
    }

    public void draw(int id, int x, int y, boolean advanced) {
        SimpleImage sprite = this.get(id);
        if (sprite != null) {
            if (advanced) {
                sprite.drawAdvancedSprite(x, y);
            } else {
                sprite.drawSprite(x, y);
            }
        }
    }

    public boolean contains(int id) {
        return id < cache.length && cache[id] != null;
    }

    public void set(int id, SimpleImage sprite) {
        if (!this.contains(id)) {
            return;
        }
        MapFunctionLoader.cache[id] = sprite;
    }

    public void clear() {
        Arrays.fill(cache, null);
    }

    private static BufferedImage convert(BufferedImage bimage) {
        BufferedImage converted = new BufferedImage(bimage.getWidth(), bimage.getHeight(), 2);
        converted.getGraphics().drawImage(bimage, 0, 0, null);
        return converted;
    }

    @Override
    public void close() throws IOException {
    }
}

