/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.graphics;

import com.hazy.cache.Archive;
import com.hazy.cache.graphics.IndexedImage;
import com.hazy.draw.Rasterizer2D;
import com.hazy.engine.impl.MouseHandler;
import com.hazy.io.Buffer;
import com.hazy.sign.SignLink;
import com.hazy.util.FileUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RGBImageFilter;
import java.io.ByteArrayInputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import net.runelite.rs.api.RSSpritePixels;

public final class SimpleImage
extends Rasterizer2D
implements RSSpritePixels {
    public static SimpleImage EMPTY_SPRITE = new SimpleImage();
    public int[] myPixels;
    public int width;
    public int height;
    public int y_offset;
    public int max_width;
    public int max_height;
    public int x_offset;
    private int identifier;
    private String name;
    private Image image;

    public Image getImage() {
        return this.image;
    }

    public SimpleImage(URL url) {
        try {
            BufferedImage image = ImageIO.read(url);
            ImageIcon sprite = new ImageIcon(image);
            this.width = sprite.getIconWidth();
            this.height = sprite.getIconHeight();
            this.max_width = this.width;
            this.max_height = this.height;
            this.myPixels = new int[this.width * this.height];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.myPixels, 0, this.width);
            pixelgrabber.grabPixels();
            this.setTransparency(255, 0, 255);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SimpleImage(Image image) {
        ImageIcon imageicon = new ImageIcon(image);
        imageicon.getIconHeight();
        imageicon.getIconWidth();
        try {
            this.width = imageicon.getIconWidth();
            this.height = imageicon.getIconHeight();
            this.max_width = this.width;
            this.max_height = this.height;
            this.x_offset = 0;
            this.y_offset = 0;
            this.myPixels = new int[this.width * this.height];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.myPixels, 0, this.width);
            pixelgrabber.grabPixels();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SimpleImage(byte[] spriteData, float width, int height) {
        try {
            this.image = Toolkit.getDefaultToolkit().createImage(spriteData);
            ImageIcon sprite = new ImageIcon(this.image);
            this.width = (int)width;
            this.height = height;
            this.max_width = this.width;
            this.max_height = this.height;
            this.x_offset = 0;
            this.y_offset = 0;
            this.myPixels = new int[this.width * this.height];
            PixelGrabber pixelgrabber = new PixelGrabber(this.image, 0, 0, this.width, this.height, this.myPixels, 0, this.width);
            pixelgrabber.grabPixels();
            this.image = null;
            this.setTransparency(255, 0, 255);
        }
        catch (Exception _ex) {
            System.err.println(_ex);
        }
    }

    public SimpleImage(int width, int height, int offsetX, int offsetY, int[] pixels) {
        this.width = width;
        this.height = height;
        this.x_offset = offsetX;
        this.y_offset = offsetY;
        this.myPixels = pixels;
        Color color = Color.MAGENTA;
        this.setTransparency(color.getRed(), color.getGreen(), color.getBlue());
    }

    public SimpleImage(byte[] data2, int file) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(data2);
            BufferedImage image = ImageIO.read(is);
            this.width = image.getWidth();
            this.height = image.getHeight();
            this.max_width = this.width;
            this.max_height = this.height;
            this.x_offset = 0;
            this.y_offset = 0;
            this.myPixels = new int[this.width * this.height];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.myPixels, 0, this.width);
            pixelgrabber.grabPixels();
            Color color = Color.MAGENTA;
            this.setTransparency(color.getRed(), color.getGreen(), color.getBlue());
        }
        catch (Exception _ex) {
            System.out.println("Could not load Image: " + file);
            _ex.printStackTrace();
        }
    }

    public SimpleImage(int i, int j) {
        this.myPixels = new int[i * j];
        this.width = this.max_width = i;
        this.height = this.max_height = j;
        this.y_offset = 0;
        this.x_offset = 0;
    }

    public SimpleImage(int index, byte[] spriteData) {
        try {
            Image image = Toolkit.getDefaultToolkit().createImage(spriteData);
            ImageIcon sprite = new ImageIcon(image);
            this.width = sprite.getIconWidth();
            this.height = sprite.getIconHeight();
            this.max_width = this.width;
            this.max_height = this.height;
            this.x_offset = 0;
            this.y_offset = 0;
            this.myPixels = new int[this.width * this.height];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.myPixels, 0, this.width);
            pixelgrabber.grabPixels();
            image = null;
            this.setTransparency(255, 0, 255);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SimpleImage(byte[] data2, Component component) {
        try {
            Image image = Toolkit.getDefaultToolkit().createImage(data2);
            MediaTracker mediatracker = new MediaTracker(component);
            mediatracker.addImage(image, 0);
            mediatracker.waitForAll();
            this.width = image.getWidth(component);
            this.height = image.getHeight(component);
            this.max_width = this.width;
            this.max_height = this.height;
            this.x_offset = 0;
            this.y_offset = 0;
            this.myPixels = new int[this.width * this.height];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.myPixels, 0, this.width);
            pixelgrabber.grabPixels();
        }
        catch (Exception _ex) {
            System.out.println("Error converting jpg");
        }
    }

    public SimpleImage(String img, int width, int height) {
        try {
            Image image = Toolkit.getDefaultToolkit().createImage(FileUtils.readFile(img));
            this.width = width;
            this.height = height;
            this.max_width = this.width;
            this.max_height = this.height;
            this.x_offset = 0;
            this.y_offset = 0;
            this.myPixels = new int[this.width * this.height];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.myPixels, 0, this.width);
            pixelgrabber.grabPixels();
            image = null;
        }
        catch (Exception _ex) {
            System.out.println(_ex);
        }
    }

    public SimpleImage(SimpleImage sprite, int width, int height) {
        this.width = width;
        this.height = height;
        this.max_width = width;
        this.max_height = height;
        this.x_offset = 0;
        this.y_offset = 0;
        this.myPixels = new int[width * height];
        System.arraycopy(sprite.myPixels, 0, this.myPixels, 0, this.myPixels.length);
    }

    public SimpleImage(String img) {
        try {
            Image image = Toolkit.getDefaultToolkit().getImage(SignLink.findCacheDir() + "Sprites/" + img + ".png");
            ImageIcon sprite = new ImageIcon(image);
            this.width = sprite.getIconWidth();
            this.height = sprite.getIconHeight();
            this.max_width = this.width;
            this.max_height = this.height;
            this.x_offset = 0;
            this.y_offset = 0;
            this.myPixels = new int[this.width * this.height];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.myPixels, 0, this.width);
            pixelgrabber.grabPixels();
            image = null;
            this.setTransparency(255, 0, 255);
        }
        catch (Exception _ex) {
            System.out.println(_ex);
        }
    }

    public SimpleImage(Archive archive, String name, int i) {
        Buffer dataBuffer = new Buffer(archive.get(name + ".dat"));
        Buffer indexBuffer = new Buffer(archive.get("index.dat"));
        indexBuffer.pos = dataBuffer.readUShort();
        this.max_width = indexBuffer.readUShort();
        this.max_height = indexBuffer.readUShort();
        int pixelCount = indexBuffer.readUnsignedByte();
        int[] raster = new int[pixelCount];
        for (int pixel = 0; pixel < pixelCount - 1; ++pixel) {
            raster[pixel + 1] = indexBuffer.readTriByte();
            if (raster[pixel + 1] != 0) continue;
            raster[pixel + 1] = 1;
        }
        for (int index = 0; index < i; ++index) {
            indexBuffer.pos += 2;
            dataBuffer.pos += indexBuffer.readUShort() * indexBuffer.readUShort();
            ++indexBuffer.pos;
        }
        this.x_offset = indexBuffer.readUnsignedByte();
        this.y_offset = indexBuffer.readUnsignedByte();
        this.width = indexBuffer.readUShort();
        this.height = indexBuffer.readUShort();
        int type2 = indexBuffer.readUnsignedByte();
        int spriteSize = this.width * this.height;
        this.myPixels = new int[spriteSize];
        if (type2 == 0) {
            for (int pixel = 0; pixel < spriteSize; ++pixel) {
                this.myPixels[pixel] = raster[dataBuffer.readUnsignedByte()];
            }
            this.setTransparency(255, 0, 255);
            return;
        }
        if (type2 == 1) {
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    this.myPixels[x + y * this.width] = raster[dataBuffer.readUnsignedByte()];
                }
            }
        }
        this.setTransparency(255, 0, 255);
    }

    public SimpleImage(byte[] spriteData) {
        try {
            Image image = Toolkit.getDefaultToolkit().createImage(spriteData);
            ImageIcon sprite = new ImageIcon(image);
            this.width = sprite.getIconWidth();
            this.height = sprite.getIconHeight();
            this.max_width = this.width;
            this.max_height = this.height;
            this.x_offset = 0;
            this.y_offset = 0;
            this.myPixels = new int[this.width * this.height];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.myPixels, 0, this.width);
            pixelgrabber.grabPixels();
            image = null;
            this.setTransparency(255, 0, 255);
        }
        catch (Exception _ex) {
            System.out.println(_ex);
        }
    }

    public SimpleImage() {
    }

    public static Image create(byte[] spriteData) {
        return Toolkit.getDefaultToolkit().createImage(spriteData);
    }

    public void drawHoverSprite(int x, int y, SimpleImage hover) {
        this.drawHoverSprite(x, y, 0, 0, hover);
    }

    public void drawHoverSprite(int x, int y, int offsetX, int offsetY, SimpleImage hover) {
        if (this == EMPTY_SPRITE) {
            return;
        }
        if (MouseHandler.mouseX >= offsetX + x && MouseHandler.mouseX <= offsetX + x + this.width && MouseHandler.mouseY >= offsetY + y && MouseHandler.mouseY <= offsetY + y + this.height) {
            hover.drawAdvancedSprite(x, y);
        } else {
            this.drawAdvancedSprite(x, y);
        }
    }

    public void draw24BitSprite(int x, int y) {
        if (this == EMPTY_SPRITE) {
            return;
        }
        int alpha = 256;
        int destOffset = (x += this.x_offset) + (y += this.y_offset) * Rasterizer2D.width;
        int srcOffset = 0;
        int height = this.height;
        int width = this.width;
        int destStep = Rasterizer2D.width - width;
        int srcStep = 0;
        if (y < Rasterizer2D.topY) {
            int trimHeight = Rasterizer2D.topY - y;
            height -= trimHeight;
            y = Rasterizer2D.topY;
            srcOffset += trimHeight * width;
            destOffset += trimHeight * Rasterizer2D.width;
        }
        if (y + height > Rasterizer2D.bottomY) {
            height -= y + height - Rasterizer2D.bottomY;
        }
        if (x < Rasterizer2D.leftX) {
            int trimLeft = Rasterizer2D.leftX - x;
            width -= trimLeft;
            x = Rasterizer2D.leftX;
            srcOffset += trimLeft;
            destOffset += trimLeft;
            srcStep += trimLeft;
            destStep += trimLeft;
        }
        if (x + width > Rasterizer2D.bottomX) {
            int trimRight = x + width - Rasterizer2D.bottomX;
            width -= trimRight;
            srcStep += trimRight;
            destStep += trimRight;
        }
        if (width > 0 && height > 0) {
            this.set24BitPixels(width, height, Rasterizer2D.pixels, this.myPixels, alpha, destOffset, srcOffset, destStep, srcStep);
        }
    }

    public void drawTransparentSprite(int x, int y, int opacity) {
        if (this == EMPTY_SPRITE) {
            return;
        }
        int k = opacity;
        int i1 = (x += this.x_offset) + (y += this.y_offset) * Rasterizer2D.width;
        int j1 = 0;
        int k1 = this.height;
        int l1 = this.width;
        int i2 = Rasterizer2D.width - l1;
        int j2 = 0;
        if (y < Rasterizer2D.topY) {
            int k2 = Rasterizer2D.topY - y;
            k1 -= k2;
            y = Rasterizer2D.topY;
            j1 += k2 * l1;
            i1 += k2 * Rasterizer2D.width;
        }
        if (y + k1 > Rasterizer2D.bottomY) {
            k1 -= y + k1 - Rasterizer2D.bottomY;
        }
        if (x < Rasterizer2D.leftX) {
            int l2 = Rasterizer2D.leftX - x;
            l1 -= l2;
            x = Rasterizer2D.leftX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (x + l1 > Rasterizer2D.bottomX) {
            int i3 = x + l1 - Rasterizer2D.bottomX;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.method351(j1, l1, Rasterizer2D.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    private void set24BitPixels(int width, int height, int[] destPixels, int[] srcPixels, int srcAlpha, int destOffset, int srcOffset, int destStep, int srcStep) {
        if (this == EMPTY_SPRITE) {
            return;
        }
        for (int loop = -height; loop < 0; ++loop) {
            for (int loop2 = -width; loop2 < 0; ++loop2) {
                int srcColor;
                srcAlpha = this.myPixels[srcOffset] >> 24 & 0xFF;
                int destAlpha = 256 - srcAlpha;
                if ((srcColor = srcPixels[srcOffset++]) != 0 && srcColor != 0xFFFFFF) {
                    int destColor = destPixels[destOffset];
                    destPixels[destOffset++] = ((srcColor & 0xFF00FF) * srcAlpha + (destColor & 0xFF00FF) * destAlpha & 0xFF00FF00) + ((srcColor & 0xFF00) * srcAlpha + (destColor & 0xFF00) * destAlpha & 0xFF0000) >> 8;
                    continue;
                }
                ++destOffset;
            }
            destOffset += destStep;
            srcOffset += srcStep;
        }
    }

    public void setTransparency(int transRed, int transGreen, int transBlue) {
        if (this == EMPTY_SPRITE) {
            return;
        }
        for (int index = 0; index < this.myPixels.length; ++index) {
            if ((this.myPixels[index] >> 16 & 0xFF) != transRed || (this.myPixels[index] >> 8 & 0xFF) != transGreen || (this.myPixels[index] & 0xFF) != transBlue) continue;
            this.myPixels[index] = 0;
        }
    }

    public void init() {
        Rasterizer2D.initDrawingArea(this.height, this.width, this.myPixels, null);
    }

    public void method344(int i, int j, int k) {
        if (this == EMPTY_SPRITE) {
            return;
        }
        for (int i1 = 0; i1 < this.myPixels.length; ++i1) {
            int j1 = this.myPixels[i1];
            if (j1 == 0) continue;
            int k1 = j1 >> 16 & 0xFF;
            if ((k1 += i) < 1) {
                k1 = 1;
            } else if (k1 > 255) {
                k1 = 255;
            }
            int l1 = j1 >> 8 & 0xFF;
            if ((l1 += j) < 1) {
                l1 = 1;
            } else if (l1 > 255) {
                l1 = 255;
            }
            int i2 = j1 & 0xFF;
            if ((i2 += k) < 1) {
                i2 = 1;
            } else if (i2 > 255) {
                i2 = 255;
            }
            this.myPixels[i1] = (k1 << 16) + (l1 << 8) + i2;
        }
    }

    public void method345() {
        int[] ai = new int[this.max_width * this.max_height];
        for (int j = 0; j < this.height; ++j) {
            System.arraycopy(this.myPixels, j * this.width, ai, j + this.y_offset * this.max_width + this.x_offset, this.width);
        }
        this.myPixels = ai;
        this.width = this.max_width;
        this.height = this.max_height;
        this.x_offset = 0;
        this.y_offset = 0;
    }

    public void method346(int x, int y) {
        if (this == EMPTY_SPRITE) {
            return;
        }
        int l = (x += this.x_offset) + (y += this.y_offset) * Rasterizer2D.width;
        int i1 = 0;
        int height = this.height;
        int width = this.width;
        int l1 = Rasterizer2D.width - width;
        int i2 = 0;
        if (y < Rasterizer2D.topY) {
            int j2 = Rasterizer2D.topY - y;
            height -= j2;
            y = Rasterizer2D.topY;
            i1 += j2 * width;
            l += j2 * Rasterizer2D.width;
        }
        if (y + height > Rasterizer2D.bottomY) {
            height -= y + height - Rasterizer2D.bottomY;
        }
        if (x < Rasterizer2D.leftX) {
            int k2 = Rasterizer2D.leftX - x;
            width -= k2;
            x = Rasterizer2D.leftX;
            i1 += k2;
            l += k2;
            i2 += k2;
            l1 += k2;
        }
        if (x + width > Rasterizer2D.bottomX) {
            int l2 = x + width - Rasterizer2D.bottomX;
            width -= l2;
            i2 += l2;
            l1 += l2;
        }
        if (width > 0 && height > 0) {
            this.method347(l, width, height, i2, i1, l1, this.myPixels, Rasterizer2D.pixels);
        }
    }

    private void method347(int i, int j, int k, int l, int i1, int k1, int[] ai, int[] ai1) {
        int l1 = -(j >> 2);
        j = -(j & 3);
        for (int i2 = -k; i2 < 0; ++i2) {
            int val;
            for (int j2 = l1; j2 < 0; ++j2) {
                val = ai[i1++];
                SimpleImage.drawAlpha(ai1, i++, val, 255);
                val = ai[i1++];
                SimpleImage.drawAlpha(ai1, i++, val, 255);
                val = ai[i1++];
                SimpleImage.drawAlpha(ai1, i++, val, 255);
                val = ai[i1++];
                SimpleImage.drawAlpha(ai1, i++, val, 255);
            }
            for (int k2 = j; k2 < 0; ++k2) {
                val = ai[i1++];
                SimpleImage.drawAlpha(ai1, i++, val, 255);
            }
            i += k1;
            i1 += l;
        }
    }

    public void drawSprite1(int i, int j) {
        this.drawSprite1(i, j, 128);
    }

    public void drawSprite1(int i, int j, int k, boolean overrideCanvas) {
        if (this == EMPTY_SPRITE) {
            return;
        }
        int i1 = (i += this.x_offset) + (j += this.y_offset) * Rasterizer2D.width;
        int j1 = 0;
        int k1 = this.height;
        int l1 = this.width;
        int i2 = Rasterizer2D.width - l1;
        int j2 = 0;
        if (!(overrideCanvas && j > 0 || j >= Rasterizer2D.topY)) {
            int k2 = Rasterizer2D.topY - j;
            k1 -= k2;
            j = Rasterizer2D.topY;
            j1 += k2 * l1;
            i1 += k2 * Rasterizer2D.width;
        }
        if (j + k1 > Rasterizer2D.bottomY) {
            k1 -= j + k1 - Rasterizer2D.bottomY;
        }
        if (!overrideCanvas && i < Rasterizer2D.leftX) {
            int l2 = Rasterizer2D.leftX - i;
            l1 -= l2;
            i = Rasterizer2D.leftX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > Rasterizer2D.bottomX) {
            int i3 = i + l1 - Rasterizer2D.bottomX;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.method351(j1, l1, Rasterizer2D.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    public void drawSprite1(int i, int j, int k) {
        if (this == EMPTY_SPRITE) {
            return;
        }
        int i1 = (i += this.x_offset) + (j += this.y_offset) * Rasterizer2D.width;
        int j1 = 0;
        int k1 = this.height;
        int l1 = this.width;
        int i2 = Rasterizer2D.width - l1;
        int j2 = 0;
        if (j < Rasterizer2D.topY) {
            int k2 = Rasterizer2D.topY - j;
            k1 -= k2;
            j = Rasterizer2D.topY;
            j1 += k2 * l1;
            i1 += k2 * Rasterizer2D.width;
        }
        if (j + k1 > Rasterizer2D.bottomY) {
            k1 -= j + k1 - Rasterizer2D.bottomY;
        }
        if (i < Rasterizer2D.leftX) {
            int l2 = Rasterizer2D.leftX - i;
            l1 -= l2;
            i = Rasterizer2D.leftX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > Rasterizer2D.bottomX) {
            int i3 = i + l1 - Rasterizer2D.bottomX;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.method351(j1, l1, Rasterizer2D.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    public void drawSprite(int x, int y) {
        int dx;
        if (this == EMPTY_SPRITE) {
            return;
        }
        int rasterClip = (x += this.x_offset) + (y += this.y_offset) * Rasterizer2D.width;
        int imageClip = 0;
        int height = this.height;
        int width = this.width;
        int rasterOffset = Rasterizer2D.width - width;
        int imageOffset = 0;
        if (y < Rasterizer2D.topY) {
            int dy = Rasterizer2D.topY - y;
            height -= dy;
            y = Rasterizer2D.topY;
            imageClip += dy * width;
            rasterClip += dy * Rasterizer2D.width;
        }
        if (y + height > Rasterizer2D.bottomY) {
            height -= y + height - Rasterizer2D.bottomY;
        }
        if (x < Rasterizer2D.leftX) {
            dx = Rasterizer2D.leftX - x;
            width -= dx;
            x = Rasterizer2D.leftX;
            imageClip += dx;
            rasterClip += dx;
            imageOffset += dx;
            rasterOffset += dx;
        }
        if (x + width > Rasterizer2D.bottomX) {
            dx = x + width - Rasterizer2D.bottomX;
            width -= dx;
            imageOffset += dx;
            rasterOffset += dx;
        }
        if (width > 0 && height > 0) {
            this.method349(Rasterizer2D.pixels, this.myPixels, imageClip, rasterClip, width, height, rasterOffset, imageOffset);
        }
    }

    public void drawSprite(int i, int k, int color) {
        int y;
        int x;
        int tempWidth = this.width + 2;
        int tempHeight = this.height + 2;
        int[] tempArray = new int[tempWidth * tempHeight];
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                if (this.myPixels[x + y * this.width] == 0) continue;
                tempArray[x + 1 + (y + 1) * tempWidth] = this.myPixels[x + y * this.width];
            }
        }
        for (x = 0; x < tempWidth; ++x) {
            for (y = 0; y < tempHeight; ++y) {
                if (tempArray[x + y * tempWidth] != 0) continue;
                if (x < tempWidth - 1 && tempArray[x + 1 + y * tempWidth] > 0 && tempArray[x + 1 + y * tempWidth] != 0xFFFFFF) {
                    SimpleImage.drawAlpha(tempArray, x + y * tempWidth, color, 255);
                }
                if (x > 0 && tempArray[x - 1 + y * tempWidth] > 0 && tempArray[x - 1 + y * tempWidth] != 0xFFFFFF) {
                    SimpleImage.drawAlpha(tempArray, x + y * tempWidth, color, 255);
                }
                if (y < tempHeight - 1 && tempArray[x + (y + 1) * tempWidth] > 0 && tempArray[x + (y + 1) * tempWidth] != 0xFFFFFF) {
                    SimpleImage.drawAlpha(tempArray, x + y * tempWidth, color, 255);
                }
                if (y <= 0 || tempArray[x + (y - 1) * tempWidth] <= 0 || tempArray[x + (y - 1) * tempWidth] == 0xFFFFFF) continue;
                SimpleImage.drawAlpha(tempArray, x + y * tempWidth, color, 255);
            }
        }
        --i;
        --k;
        int l = (i += this.x_offset) + (k += this.y_offset) * Rasterizer2D.width;
        int i1 = 0;
        int j1 = tempHeight;
        int k1 = tempWidth;
        int l1 = Rasterizer2D.width - k1;
        int i2 = 0;
        if (k < Rasterizer2D.topY) {
            int j2 = Rasterizer2D.topY - k;
            j1 -= j2;
            k = Rasterizer2D.topY;
            i1 += j2 * k1;
            l += j2 * Rasterizer2D.width;
        }
        if (k + j1 > Rasterizer2D.bottomY) {
            j1 -= k + j1 - Rasterizer2D.bottomY;
        }
        if (i < Rasterizer2D.leftX) {
            int k2 = Rasterizer2D.leftX - i;
            k1 -= k2;
            i = Rasterizer2D.leftX;
            i1 += k2;
            l += k2;
            i2 += k2;
            l1 += k2;
        }
        if (i + k1 > Rasterizer2D.bottomX) {
            int l2 = i + k1 - Rasterizer2D.bottomX;
            k1 -= l2;
            i2 += l2;
            l1 += l2;
        }
        if (k1 > 0 && j1 > 0) {
            this.method349(Rasterizer2D.pixels, tempArray, i1, l, k1, j1, l1, i2);
        }
    }

    public void drawSprite2(int i, int j) {
        if (this == EMPTY_SPRITE) {
            return;
        }
        int k = 225;
        int i1 = (i += this.x_offset) + (j += this.y_offset) * Rasterizer2D.width;
        int j1 = 0;
        int k1 = this.height;
        int l1 = this.width;
        int i2 = Rasterizer2D.width - l1;
        int j2 = 0;
        if (j < Rasterizer2D.topY) {
            int k2 = Rasterizer2D.topY - j;
            k1 -= k2;
            j = Rasterizer2D.topY;
            j1 += k2 * l1;
            i1 += k2 * Rasterizer2D.width;
        }
        if (j + k1 > Rasterizer2D.bottomY) {
            k1 -= j + k1 - Rasterizer2D.bottomY;
        }
        if (i < Rasterizer2D.leftX) {
            int l2 = Rasterizer2D.leftX - i;
            l1 -= l2;
            i = Rasterizer2D.leftX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > Rasterizer2D.bottomX) {
            int i3 = i + l1 - Rasterizer2D.bottomX;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.method351(j1, l1, Rasterizer2D.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    private void method349(int[] ai, int[] ai1, int j, int k, int l, int i1, int j1, int k1) {
        int l1 = -(l >> 2);
        l = -(l & 3);
        for (int i2 = -i1; i2 < 0; ++i2) {
            int i;
            for (int j2 = l1; j2 < 0; ++j2) {
                if ((i = ai1[j++]) != 0 && i != -1) {
                    SimpleImage.drawAlpha(ai, k++, i, 255);
                } else {
                    ++k;
                }
                i = ai1[j++];
                if (i != 0 && i != -1) {
                    SimpleImage.drawAlpha(ai, k++, i, 255);
                } else {
                    ++k;
                }
                i = ai1[j++];
                if (i != 0 && i != -1) {
                    SimpleImage.drawAlpha(ai, k++, i, 255);
                } else {
                    ++k;
                }
                i = ai1[j++];
                if (i != 0 && i != -1) {
                    SimpleImage.drawAlpha(ai, k++, i, 255);
                    continue;
                }
                ++k;
            }
            for (int k2 = l; k2 < 0; ++k2) {
                if ((i = ai1[j++]) != 0 && i != -1) {
                    SimpleImage.drawAlpha(ai, k++, i, 255);
                    continue;
                }
                ++k;
            }
            k += j1;
            j += k1;
        }
    }

    private void method351(int i, int j, int[] ai, int[] ai1, int l, int i1, int j1, int k1, int l1) {
        int j2 = 256 - k1;
        for (int k2 = -i1; k2 < 0; ++k2) {
            for (int l2 = -j; l2 < 0; ++l2) {
                int k;
                if ((k = ai1[i++]) != 0) {
                    int i3 = ai[l1];
                    SimpleImage.drawAlpha(ai, l1++, ((k & 0xFF00FF) * k1 + (i3 & 0xFF00FF) * j2 & 0xFF00FF00) + ((k & 0xFF00) * k1 + (i3 & 0xFF00) * j2 & 0xFF0000) >> 8, k1);
                    continue;
                }
                ++l1;
            }
            l1 += j1;
            i += l;
        }
    }

    public void rotate(int i, int j, int[] ai, int k, int[] ai1, int i1, int j1, int k1, int l1, int i2) {
        try {
            int j2 = -l1 / 2;
            int k2 = -i / 2;
            int l2 = (int)(Math.sin((double)j / 326.11) * 65536.0);
            int i3 = (int)(Math.cos((double)j / 326.11) * 65536.0);
            l2 = l2 * k >> 8;
            i3 = i3 * k >> 8;
            int j3 = (i2 << 16) + (k2 * l2 + j2 * i3);
            int k3 = (i1 << 16) + (k2 * i3 - j2 * l2);
            int l3 = k1 + j1 * Rasterizer2D.width;
            for (j1 = 0; j1 < i; ++j1) {
                int i4 = ai1[j1];
                int j4 = l3 + i4;
                int k4 = j3 + i3 * i4;
                int l4 = k3 - l2 * i4;
                for (k1 = -ai[j1]; k1 < 0; ++k1) {
                    int x1 = k4 >> 16;
                    int y1 = l4 >> 16;
                    int x2 = x1 + 1;
                    int y2 = y1 + 1;
                    int c1 = this.myPixels[x1 + y1 * this.width];
                    int c2 = this.myPixels[x2 + y1 * this.width];
                    int c3 = this.myPixels[x1 + y2 * this.width];
                    int c4 = this.myPixels[x2 + y2 * this.width];
                    int u1 = (k4 >> 8) - (x1 << 8);
                    int v1 = (l4 >> 8) - (y1 << 8);
                    int u2 = (x2 << 8) - (k4 >> 8);
                    int v2 = (y2 << 8) - (l4 >> 8);
                    int a1 = u2 * v2;
                    int a2 = u1 * v2;
                    int a3 = u2 * v1;
                    int a4 = u1 * v1;
                    int r = (c1 >> 16 & 0xFF) * a1 + (c2 >> 16 & 0xFF) * a2 + (c3 >> 16 & 0xFF) * a3 + (c4 >> 16 & 0xFF) * a4 & 0xFF0000;
                    int g2 = (c1 >> 8 & 0xFF) * a1 + (c2 >> 8 & 0xFF) * a2 + (c3 >> 8 & 0xFF) * a3 + (c4 >> 8 & 0xFF) * a4 >> 8 & 0xFF00;
                    int b = (c1 & 0xFF) * a1 + (c2 & 0xFF) * a2 + (c3 & 0xFF) * a3 + (c4 & 0xFF) * a4 >> 16;
                    SimpleImage.drawAlpha(Rasterizer2D.pixels, j4++, r | g2 | b, 255);
                    k4 += i3;
                    l4 -= l2;
                }
                j3 += l2;
                k3 += i3;
                l3 += Rasterizer2D.width;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void method353(int i, double d, int l1) {
        int j = 15;
        int k = 20;
        int l = 15;
        int j1 = 256;
        int k1 = 20;
        try {
            int i2 = -k / 2;
            int j2 = -k1 / 2;
            int k2 = (int)(Math.sin(d) * 65536.0);
            int l2 = (int)(Math.cos(d) * 65536.0);
            k2 = k2 * j1 >> 8;
            l2 = l2 * j1 >> 8;
            int i3 = (l << 16) + (j2 * k2 + i2 * l2);
            int j3 = (j << 16) + (j2 * l2 - i2 * k2);
            int k3 = l1 + i * Rasterizer2D.width;
            for (i = 0; i < k1; ++i) {
                int l3 = k3;
                int i4 = i3;
                int j4 = j3;
                for (l1 = -k; l1 < 0; ++l1) {
                    int k4 = this.myPixels[(i4 >> 16) + (j4 >> 16) * this.width];
                    if (k4 != 0) {
                        SimpleImage.drawAlpha(Rasterizer2D.pixels, l3++, k4, 255);
                    } else {
                        ++l3;
                    }
                    i4 += l2;
                    j4 -= k2;
                }
                i3 += k2;
                j3 += l2;
                k3 += Rasterizer2D.width;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void method354(IndexedImage background, int i, int j) {
        if (this == EMPTY_SPRITE) {
            return;
        }
        int k = (j += this.x_offset) + (i += this.y_offset) * Rasterizer2D.width;
        int l = 0;
        int i1 = this.height;
        int j1 = this.width;
        int k1 = Rasterizer2D.width - j1;
        int l1 = 0;
        if (i < Rasterizer2D.topY) {
            int i2 = Rasterizer2D.topY - i;
            i1 -= i2;
            i = Rasterizer2D.topY;
            l += i2 * j1;
            k += i2 * Rasterizer2D.width;
        }
        if (i + i1 > Rasterizer2D.bottomY) {
            i1 -= i + i1 - Rasterizer2D.bottomY;
        }
        if (j < Rasterizer2D.leftX) {
            int j2 = Rasterizer2D.leftX - j;
            j1 -= j2;
            j = Rasterizer2D.leftX;
            l += j2;
            k += j2;
            l1 += j2;
            k1 += j2;
        }
        if (j + j1 > Rasterizer2D.bottomX) {
            int k2 = j + j1 - Rasterizer2D.bottomX;
            j1 -= k2;
            l1 += k2;
            k1 += k2;
        }
        if (j1 > 0 && i1 > 0) {
            this.method355(this.myPixels, j1, background.palettePixels, i1, Rasterizer2D.pixels, 0, k1, k, l1, l);
        }
    }

    public void drawAdvancedSprite(int xPos, int yPos) {
        this.drawAdvancedSprite(xPos, yPos, 255);
    }

    public void drawAdvancedSprite(int xPos, int yPos, int alpha) {
        if (this == EMPTY_SPRITE) {
            return;
        }
        int alphaValue = alpha;
        int i1 = (xPos += this.x_offset) + (yPos += this.y_offset) * Rasterizer2D.width;
        int j1 = 0;
        int spriteHeight = this.height;
        int spriteWidth = this.width;
        int i2 = Rasterizer2D.width - spriteWidth;
        int j2 = 0;
        if (yPos < Rasterizer2D.topY) {
            int k2 = Rasterizer2D.topY - yPos;
            spriteHeight -= k2;
            yPos = Rasterizer2D.topY;
            j1 += k2 * spriteWidth;
            i1 += k2 * Rasterizer2D.width;
        }
        if (yPos + spriteHeight > Rasterizer2D.bottomY) {
            spriteHeight -= yPos + spriteHeight - Rasterizer2D.bottomY;
        }
        if (xPos < Rasterizer2D.leftX) {
            int l2 = Rasterizer2D.leftX - xPos;
            spriteWidth -= l2;
            xPos = Rasterizer2D.leftX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (xPos + spriteWidth > Rasterizer2D.bottomX) {
            int i3 = xPos + spriteWidth - Rasterizer2D.bottomX;
            spriteWidth -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (spriteWidth > 0 && spriteHeight > 0) {
            this.renderARGBPixels(spriteWidth, spriteHeight, this.myPixels, Rasterizer2D.pixels, i1, alphaValue, j1, j2, i2);
        }
    }

    private void renderARGBPixels(int spriteWidth, int spriteHeight, int[] spritePixels, int[] renderAreaPixels, int pixel, int alphaValue, int i, int l, int j1) {
        if (this == EMPTY_SPRITE) {
            return;
        }
        int alpha = alphaValue;
        for (int height = -spriteHeight; height < 0; ++height) {
            for (int width = -spriteWidth; width < 0; ++width) {
                int pixelColor;
                alphaValue = this.myPixels[i] >> 24 & alpha - 1;
                int alphaLevel = 256 - alphaValue;
                if (alphaLevel > 256) {
                    alphaValue = 0;
                }
                if (alpha == 0) {
                    alphaLevel = 256;
                    alphaValue = 0;
                }
                if ((pixelColor = spritePixels[i++]) != 0) {
                    int pixelValue = renderAreaPixels[pixel];
                    SimpleImage.drawAlpha(renderAreaPixels, pixel++, ((pixelColor & 0xFF00FF) * alphaValue + (pixelValue & 0xFF00FF) * alphaLevel & 0xFF00FF00) + ((pixelColor & 0xFF00) * alphaValue + (pixelValue & 0xFF00) * alphaLevel & 0xFF0000) >> 8, alphaValue);
                    continue;
                }
                ++pixel;
            }
            pixel += j1;
            i += l;
        }
    }

    private void method355(int[] ai, int i, byte[] abyte0, int j, int[] ai1, int k, int l, int i1, int j1, int k1) {
        int l1 = -(i >> 2);
        i = -(i & 3);
        for (int j2 = -j; j2 < 0; ++j2) {
            for (int k2 = l1; k2 < 0; ++k2) {
                if ((k = ai[k1++]) != 0 && abyte0[i1] == 0) {
                    SimpleImage.drawAlpha(ai1, i1++, k, 255);
                } else {
                    ++i1;
                }
                k = ai[k1++];
                if (k != 0 && abyte0[i1] == 0) {
                    SimpleImage.drawAlpha(ai1, i1++, k, 255);
                } else {
                    ++i1;
                }
                k = ai[k1++];
                if (k != 0 && abyte0[i1] == 0) {
                    SimpleImage.drawAlpha(ai1, i1++, k, 255);
                } else {
                    ++i1;
                }
                k = ai[k1++];
                if (k != 0 && abyte0[i1] == 0) {
                    SimpleImage.drawAlpha(ai1, i1++, k, 255);
                    continue;
                }
                ++i1;
            }
            for (int l2 = i; l2 < 0; ++l2) {
                if ((k = ai[k1++]) != 0 && abyte0[i1] == 0) {
                    SimpleImage.drawAlpha(ai1, i1++, k, 255);
                    continue;
                }
                ++i1;
            }
            i1 += l;
            k1 += j1;
        }
    }

    public void cutR(int neww) {
        if (this == EMPTY_SPRITE) {
            return;
        }
        for (int k = 0; k < this.height; ++k) {
            int dd;
            if (this.width * (k + 1) < this.myPixels.length) {
                for (dd = 0; dd < neww; ++dd) {
                    if (this.width * (k + 1) - dd < 0) continue;
                    this.myPixels[this.width * (k + 1) - dd] = 0;
                }
                continue;
            }
            for (dd = 1; dd < neww; ++dd) {
                if (this.width * (k + 1) - dd < 0) continue;
                this.myPixels[this.width * (k + 1) - dd] = 0;
            }
        }
    }

    public void outline(int color) {
        if (this == EMPTY_SPRITE) {
            return;
        }
        int[] raster = new int[this.width * this.height];
        int start = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int outline = this.myPixels[start];
                if (outline == 0) {
                    if (x > 0 && this.myPixels[start - 1] != 0) {
                        outline = color;
                    } else if (y > 0 && this.myPixels[start - this.width] != 0) {
                        outline = color;
                    } else if (x < this.width - 1 && this.myPixels[start + 1] != 0) {
                        outline = color;
                    } else if (y < this.height - 1 && this.myPixels[start + this.width] != 0) {
                        outline = color;
                    }
                }
                raster[start++] = outline;
            }
        }
        this.myPixels = raster;
    }

    public void shadow(int color) {
        if (this == EMPTY_SPRITE) {
            return;
        }
        for (int y = this.height - 1; y > 0; --y) {
            int pos = y * this.width;
            for (int x = this.width - 1; x > 0; --x) {
                if (this.myPixels[x + pos] != 0 || this.myPixels[x + pos - 1 - this.width] == 0) continue;
                this.myPixels[x + pos] = color;
            }
        }
    }

    public void cutL(int neww) {
        if (this == EMPTY_SPRITE) {
            return;
        }
        for (int k = 0; k < this.height; ++k) {
            int dd;
            if (k * (this.height * this.width) + neww < this.myPixels.length) {
                for (dd = 0; dd < neww; ++dd) {
                    if (k * this.width + dd < 0) continue;
                    this.myPixels[k * this.width + dd] = 0;
                }
                continue;
            }
            for (dd = 0; dd < neww - 1; ++dd) {
                if (k * this.width + dd < 0) continue;
                this.myPixels[k * this.width + dd] = 0;
            }
        }
    }

    public Image convertToImage() {
        if (this == EMPTY_SPRITE) {
            return null;
        }
        BufferedImage bufferedimage = new BufferedImage(this.width, this.height, 1);
        bufferedimage.setRGB(0, 0, this.width, this.height, this.myPixels, 0, this.width);
        RGBImageFilter filter = new RGBImageFilter(){
            public int markerRGB = Color.BLACK.getRGB() | 0xFF000000;

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(bufferedimage.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    public int getId() {
        return this.identifier;
    }

    public void setId(int id) {
        this.identifier = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int[] getMyPixels() {
        return this.myPixels;
    }

    public void setMyPixels(int[] myPixels) {
        this.myPixels = myPixels;
    }

    public int getMyWidth() {
        return this.width;
    }

    public void setMyWidth(int myWidth) {
        this.width = myWidth;
    }

    public int getMyHeight() {
        return this.height;
    }

    public void setMyHeight(int myHeight) {
        this.height = myHeight;
    }

    public int getDrawOffsetX() {
        return this.x_offset;
    }

    public void setDrawOffsetX(int drawOffsetX) {
        this.x_offset = drawOffsetX;
    }

    public int getDrawOffsetY() {
        return this.y_offset;
    }

    public void setDrawOffsetY(int drawOffsetY) {
        this.y_offset = drawOffsetY;
    }

    @Override
    public void drawAt(int x, int y) {
        this.drawSprite(x, y);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getMaxWidth() {
        return this.max_width;
    }

    @Override
    public int getMaxHeight() {
        return this.max_height;
    }

    @Override
    public int getOffsetX() {
        return this.x_offset;
    }

    @Override
    public int getOffsetY() {
        return this.y_offset;
    }

    @Override
    public void setMaxWidth(int maxWidth) {
        this.max_width = maxWidth;
    }

    @Override
    public void setMaxHeight(int maxHeight) {
        this.max_height = maxHeight;
    }

    @Override
    public void setOffsetX(int offsetX) {
        this.x_offset = offsetX;
    }

    @Override
    public void setOffsetY(int offsetY) {
        this.y_offset = offsetY;
    }

    @Override
    public int[] getPixels() {
        return this.myPixels;
    }

    @Override
    public void setRaster() {
        this.init();
    }

    @Override
    public BufferedImage toBufferedImage() {
        BufferedImage image = new BufferedImage(this.width, this.height, 2);
        this.toBufferedImage(image);
        return image;
    }

    @Override
    public void toBufferedImage(BufferedImage img) throws IllegalArgumentException {
        int width = this.getWidth();
        int height = this.getHeight();
        int[] pixels = this.getPixels();
        int[] palette = new int[pixels.length];
        for (int pixel = 0; pixel < pixels.length; ++pixel) {
            if (pixels[pixel] == 0) continue;
            palette[pixel] = pixels[pixel] | 0xFF000000;
        }
        img.setRGB(0, 0, width, height, palette, 0, width);
    }

    @Override
    public BufferedImage toBufferedOutline(Color color) {
        BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.toBufferedOutline(img, color.getRGB());
        return img;
    }

    @Override
    public void toBufferedOutline(BufferedImage img, int color) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (img.getWidth() != width || img.getHeight() != height) {
            throw new IllegalArgumentException("Image bounds do not match Sprite");
        }
        int[] pixels = this.getPixels();
        int[] newPixels = new int[width * height];
        int pixelIndex = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = pixels[pixelIndex];
                if (pixel == 0xFFFFFF || pixel == 0) {
                    if (x > 0 && pixels[pixelIndex - 1] != 0) {
                        pixel = color;
                    } else if (y > 0 && pixels[pixelIndex - width] != 0) {
                        pixel = color;
                    } else if (x < width - 1 && pixels[pixelIndex + 1] != 0) {
                        pixel = color;
                    } else if (y < height - 1 && pixels[pixelIndex + width] != 0) {
                        pixel = color;
                    }
                    newPixels[pixelIndex] = pixel;
                }
                ++pixelIndex;
            }
        }
        img.setRGB(0, 0, width, height, newPixels, 0, width);
    }

    public void drawShadedSprite(int xPos, int yPos, int shade) {
        int shadeValue = shade;
        int i1 = (xPos += this.x_offset) + (yPos += this.y_offset) * Rasterizer2D.width;
        int j1 = 0;
        int spriteHeight = this.height;
        int spriteWidth = this.width;
        int i2 = Rasterizer2D.width - spriteWidth;
        int j2 = 0;
        if (yPos < Rasterizer2D.topY) {
            int k2 = Rasterizer2D.topY - yPos;
            spriteHeight -= k2;
            yPos = Rasterizer2D.topY;
            j1 += k2 * spriteWidth;
            i1 += k2 * Rasterizer2D.width;
        }
        if (yPos + spriteHeight > Rasterizer2D.bottomY) {
            spriteHeight -= yPos + spriteHeight - Rasterizer2D.bottomY;
        }
        if (xPos < Rasterizer2D.leftX) {
            int l2 = Rasterizer2D.leftX - xPos;
            spriteWidth -= l2;
            xPos = Rasterizer2D.leftX;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (xPos + spriteWidth > Rasterizer2D.bottomX) {
            int i3 = xPos + spriteWidth - Rasterizer2D.bottomX;
            spriteWidth -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (spriteWidth > 0 && spriteHeight > 0) {
            this.renderShadedARGBPixels(spriteWidth, spriteHeight, this.myPixels, Rasterizer2D.pixels, i1, shadeValue, j1, j2, i2);
        }
        this.drawAdvancedSprite(xPos, yPos, shade);
    }

    private void renderShadedARGBPixels(int spriteWidth, int spriteHeight, int[] spritePixels, int[] renderAreaPixels, int pixel, int alphaValue, int i, int l, int j1) {
        int alpha = alphaValue;
        for (int height = -spriteHeight; height < 0; ++height) {
            for (int width = -spriteWidth; width < 0; ++width) {
                int pixelColor;
                alphaValue = this.myPixels[i] >> 24 & alpha - 1;
                int alphaLevel = 256 - alphaValue;
                if (alphaLevel > 256) {
                    alphaValue = 0;
                }
                if (alpha == 0) {
                    alphaLevel = 256;
                    alphaValue = 0;
                }
                if ((pixelColor = spritePixels[i++]) != 0) {
                    int pixelValue = renderAreaPixels[pixel];
                    renderAreaPixels[pixel++] = 0;
                    continue;
                }
                ++pixel;
            }
            pixel += j1;
            i += l;
        }
    }

    public void draw_transparent(int x, int y, int alpha) {
        this.drawTransparentSprite(x, y, alpha);
    }
}

