/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.graphics;

import com.hazy.cache.Archive;
import com.hazy.cache.graphics.SimpleImage;
import com.hazy.io.Buffer;
import com.hazy.sign.SignLink;
import com.hazy.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.zip.GZIPInputStream;

public final class SpecialBarSpriteLoader {
    public static SpecialBarSpriteLoader[] cache;
    private static SimpleImage[] sprites;
    public String name = "Unknown";
    public int id = -1;
    public int drawOffsetX = 0;
    public int drawOffsetY = 0;
    public byte[] spriteData = null;
    private static boolean DUMP_SPRITES;

    public static void loadSprites(Archive archive) {
        try {
            Buffer index = new Buffer(archive.get("special_bar_sprite.idx"));
            Buffer data2 = new Buffer(archive.get("special_bar_sprite.dat"));
            DataInputStream indexFile = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(index.payload)));
            DataInputStream dataFile = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(data2.payload)));
            int totalSprites = indexFile.readInt();
            if (cache == null) {
                cache = new SpecialBarSpriteLoader[totalSprites];
                sprites = new SimpleImage[totalSprites];
            }
            for (int sprite_index = 0; sprite_index < totalSprites; ++sprite_index) {
                int id = indexFile.readInt();
                if (cache[id] == null) {
                    SpecialBarSpriteLoader.cache[id] = new SpecialBarSpriteLoader();
                }
                cache[id].readValues(indexFile, dataFile);
                SpecialBarSpriteLoader.createSprite(cache[id]);
            }
            indexFile.close();
            dataFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readValues(DataInputStream index, DataInputStream data2) throws IOException {
        byte opcode;
        while ((opcode = data2.readByte()) != 0) {
            if (opcode == 1) {
                this.id = data2.readShort();
                continue;
            }
            if (opcode == 2) {
                this.name = data2.readUTF();
                continue;
            }
            if (opcode == 3) {
                this.drawOffsetX = data2.readShort();
                continue;
            }
            if (opcode == 4) {
                this.drawOffsetY = data2.readShort();
                continue;
            }
            if (opcode != 5) continue;
            int indexLength = index.readInt();
            byte[] data_read = new byte[indexLength];
            data2.readFully(data_read);
            this.spriteData = data_read;
        }
    }

    private static void createSprite(SpecialBarSpriteLoader sprite) {
        if (DUMP_SPRITES) {
            File directory = new File(SignLink.findCacheDir() + "sprites_dump");
            if (!directory.exists()) {
                directory.mkdir();
            }
            FileUtils.writeFile(new File(directory.getAbsolutePath() + System.getProperty("file.separator") + sprite.id + ".png"), sprite.spriteData);
        }
        SpecialBarSpriteLoader.sprites[sprite.id] = new SimpleImage(sprite.spriteData);
        SpecialBarSpriteLoader.sprites[sprite.id].x_offset = sprite.drawOffsetX;
        SpecialBarSpriteLoader.sprites[sprite.id].y_offset = sprite.drawOffsetY;
    }

    public static SimpleImage[] getSprites() {
        return sprites;
    }

    static {
        sprites = null;
        DUMP_SPRITES = false;
    }
}

