/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.graphics;

import com.hazy.cache.graphics.BattlepassSpriteLoader;
import com.hazy.cache.graphics.CustomSpriteLoader;
import com.hazy.cache.graphics.SimpleImage;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;

public final class SpriteCache
implements Closeable {
    public static SimpleImage[] cache;
    private byte[] dataBytes;
    private byte[] metaBytes;

    public void init(byte[] dataBytes, byte[] metaBytes) throws IOException {
        if (dataBytes == null || metaBytes == null) {
            throw new IllegalArgumentException("Data and meta bytes must not be null.");
        }
        this.dataBytes = dataBytes;
        this.metaBytes = metaBytes;
        int spriteCount = metaBytes.length / 10;
        cache = new SimpleImage[spriteCount];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SimpleImage get(int id) {
        if (id == -1) {
            return null;
        }
        SimpleImage battlepassSprite = BattlepassSpriteLoader.get(id);
        if (battlepassSprite != null) {
            return battlepassSprite;
        }
        SimpleImage customSprite = CustomSpriteLoader.get(id);
        if (customSprite != null) {
            return customSprite;
        }
        try {
            if (this.contains(id)) {
                return cache[id];
            }
            if (this.dataBytes == null || this.metaBytes == null) {
                System.err.println("Sprite data or meta bytes are null!");
                return null;
            }
            int entries = this.metaBytes.length / 10;
            if (id > entries) {
                return null;
            }
            int metaPos = id * 10;
            int pos = (this.metaBytes[metaPos++] & 0xFF) << 16 | (this.metaBytes[metaPos++] & 0xFF) << 8 | this.metaBytes[metaPos++] & 0xFF;
            int len = (this.metaBytes[metaPos++] & 0xFF) << 16 | (this.metaBytes[metaPos++] & 0xFF) << 8 | this.metaBytes[metaPos++] & 0xFF;
            int offsetX = this.metaBytes[metaPos++] & 0xFF;
            int offsetY = this.metaBytes[metaPos] & 0xFF;
            byte[] dataBuf = Arrays.copyOfRange(this.dataBytes, pos, pos + len);
            try (ByteArrayInputStream is = new ByteArrayInputStream(dataBuf);){
                SimpleImage sprite;
                BufferedImage bimage = ImageIO.read(is);
                if (bimage == null) {
                    System.err.printf("Could not read image at %d%n", id);
                    SimpleImage simpleImage = null;
                    return simpleImage;
                }
                if (bimage.getType() != 2) {
                    bimage = SpriteCache.convert(bimage);
                }
                int[] pixels = ((DataBufferInt)bimage.getRaster().getDataBuffer()).getData();
                SpriteCache.cache[id] = sprite = new SimpleImage(bimage.getWidth(), bimage.getHeight(), offsetX, offsetY, pixels);
                SimpleImage simpleImage = sprite;
                return simpleImage;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.printf("No sprite found for id=%d%n", id);
            return null;
        }
    }

    public SimpleImage get(SimpleImage id) {
        return null;
    }

    public boolean contains(int id) {
        if (BattlepassSpriteLoader.contains(id)) {
            return true;
        }
        return id < cache.length && cache[id] != null;
    }

    public void set(int id, SimpleImage sprite) {
        if (!this.contains(id)) {
            return;
        }
        SpriteCache.cache[id] = sprite;
    }

    public void clear() {
        Arrays.fill(cache, null);
    }

    private static BufferedImage convert(BufferedImage bimage) {
        BufferedImage converted = new BufferedImage(bimage.getWidth(), bimage.getHeight(), 2);
        converted.getGraphics().drawImage(bimage, 0, 0, null);
        return converted;
    }

    @Override
    public void close() {
    }
}

