/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.graphics.fading_screen;

import com.hazy.Client;
import com.hazy.cache.graphics.SimpleImage;
import com.hazy.cache.graphics.fading_screen.FadingScreen;
import com.hazy.cache.graphics.font.AdvancedFont;
import com.hazy.draw.Rasterizer2D;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class FadingScreenImage
extends FadingScreen {
    SimpleImage background;
    private int width;
    private int height;

    public FadingScreenImage(AdvancedFont font, String text, byte state, byte seconds, int x, int y, int maximumWidth) {
        super(font, text, state, seconds, x, y, maximumWidth);
        this.width = maximumWidth + 10;
        this.height = 16 + this.wrapped.length * 20;
        SimpleImage[] resources = Client.fadingScreenImages;
        BufferedImage image = new BufferedImage(this.width, this.height, 2);
        Graphics2D graphics = image.createGraphics();
        graphics.setComposite(AlphaComposite.Clear);
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setComposite(AlphaComposite.Src);
        for (int xOffset = 0; xOffset < this.width; xOffset += 8) {
            graphics.drawImage(resources[1].getImage(), xOffset, 0, null);
            graphics.drawImage(resources[7].getImage(), xOffset, this.height - 8, null);
        }
        for (int yOffset = 0; yOffset < this.height; yOffset += 8) {
            graphics.drawImage(resources[6].getImage(), 0, yOffset, null);
            graphics.drawImage(resources[5].getImage(), this.width - 8, yOffset, null);
        }
        graphics.drawImage(resources[0].getImage(), 0, 0, null);
        graphics.drawImage(resources[4].getImage(), 0, this.height - 8, null);
        graphics.drawImage(resources[2].getImage(), this.width - 8, 0, null);
        graphics.drawImage(resources[3].getImage(), this.width - 8, this.height - 8, null);
        this.background = new SimpleImage(image);
    }

    @Override
    public void draw() {
        if (this.state == 0) {
            return;
        }
        long end = this.watch.getStartTime() + 1000L * (long)this.seconds;
        long increment = (end - this.watch.getStartTime()) / 100L;
        if (increment > 0L) {
            long percentile = this.watch.getTime() / increment;
            int opacity = (int)((double)percentile * 2.55);
            if (this.state < 0) {
                opacity = 255 - opacity;
            }
            if (percentile > -1L && percentile <= 100L) {
                Rasterizer2D.set_clip(this.x, this.y, this.x + this.width, this.y + this.height);
                Rasterizer2D.drawAlphaBox(this.x + 4, this.y + 4, this.width - 8, this.height - 8, 0, opacity);
                this.background.drawAdvancedSprite(this.x, this.y, opacity);
                int textYOffset = 22;
                for (String sentence : this.wrapped) {
                    this.font.draw_centered(sentence, this.x + this.width / 2, this.y + textYOffset, 0xFFFFFF, 0, opacity);
                    textYOffset += 18;
                }
                if (percentile >= 100L) {
                    this.watch.stop();
                    this.state = 0;
                }
            }
        } else {
            this.watch.stop();
            this.state = 0;
        }
    }
}

