/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.graphics.font;

import com.google.common.io.ByteStreams;
import com.hazy.Client;
import com.hazy.cache.Archive;
import com.hazy.cache.factory.ItemSpriteFactory;
import com.hazy.cache.graphics.SimpleImage;
import com.hazy.draw.Rasterizer2D;
import com.hazy.io.Buffer;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class AdvancedFont
extends Rasterizer2D {
    private static final int CHAT_ITEM_PADDING = 3;
    public boolean lastLineHadItem;
    public double pcOpacity;
    public boolean maxOpacity;
    public int base_char_height = 0;
    public int anInt4142;
    public int anInt4144;
    public int[] kerning_y;
    public int[] glyph_height;
    public int[] kerning_x;
    public int[] glyph_width;
    public byte[] byte_unknown;
    public byte[][] glyph_pixels = new byte[256][];
    public int[] glyph_display_width;
    public static SimpleImage[] chat_emblems;
    public static SimpleImage[] clan_emblems;
    public static String nbsp_string;
    public static String set_transparency;
    public static String set_default_shadow;
    public static String close_shadow;
    public static String gt_string;
    public static String close_strikethrough;
    public static String euro_string;
    public static String set_color;
    public static String line_break;
    public static String set_strikethrough;
    public static String close_color;
    public static String set_image;
    public static String set_clan;
    public static String close_underline;
    public static String set_default_strikethrough;
    public static String set_shadow;
    public static String lt_string;
    public static String shy_string;
    public static String copy_string;
    public static String close_transparency;
    public static String times_string;
    public static String set_underline;
    public static String set_default_underline;
    public static String reg_string;
    public static int default_color;
    public static int shadow_color;
    public static int strikethrough_color;
    public static int default_trans;
    public static int anInt4175;
    public static int underline_color;
    public static int default_shad;
    public static int anInt4178;
    public static int opacity;
    public static int font_color;
    public static String set_item;

    private SimpleImage getChatItemSprite(int itemId, int requestedSize) {
        return ItemSpriteFactory.get_item_sprite_zoomed(itemId, 1, 0, requestedSize);
    }

    public AdvancedFont(boolean monospace, String name, Archive archive) {
        this.glyph_width = new int[256];
        this.glyph_height = new int[256];
        this.kerning_x = new int[256];
        this.kerning_y = new int[256];
        this.glyph_display_width = new int[256];
        Buffer data2 = new Buffer(archive.get(name + ".dat"));
        Buffer idx = new Buffer(archive.get("index.dat"));
        idx.pos = data2.readUnsignedShort() + 4;
        int pos = idx.readUnsignedByte();
        if (pos > 0) {
            idx.pos += 3 * (pos - 1);
        }
        for (int index = 0; index < 256; ++index) {
            int y;
            int pixels;
            this.kerning_x[index] = idx.readUnsignedByte();
            this.kerning_y[index] = idx.readUnsignedByte();
            int width = this.glyph_width[index] = idx.readUnsignedShort();
            int height = this.glyph_height[index] = idx.readUnsignedShort();
            int opcode = idx.readUnsignedByte();
            int area = width * height;
            this.glyph_pixels[index] = new byte[area];
            if (opcode == 0) {
                for (pixels = 0; pixels < area; ++pixels) {
                    this.glyph_pixels[index][pixels] = data2.readSignedByte();
                }
            } else if (opcode == 1) {
                for (int x = 0; x < width; ++x) {
                    for (y = 0; y < height; ++y) {
                        this.glyph_pixels[index][x + y * width] = data2.readSignedByte();
                    }
                }
            }
            if (height > this.base_char_height && index < 128) {
                this.base_char_height = height;
            }
            this.kerning_x[index] = 1;
            this.glyph_display_width[index] = width + 2;
            pixels = 0;
            for (y = height / 7; y < height; ++y) {
                pixels += this.glyph_pixels[index][y * width];
            }
            if (pixels <= height / 7) {
                int n = index;
                this.glyph_display_width[n] = this.glyph_display_width[n] - 1;
                this.kerning_x[index] = 0;
            }
            pixels = 0;
            for (y = height / 7; y < height; ++y) {
                pixels += this.glyph_pixels[index][width - 1 + y * width];
            }
            if (pixels > height / 7) continue;
            int n = index;
            this.glyph_display_width[n] = this.glyph_display_width[n] - 1;
        }
        this.glyph_display_width[32] = monospace ? this.glyph_display_width[73] : this.glyph_display_width[105];
    }

    public AdvancedFont(boolean monospace, String name) throws IOException {
        this.glyph_width = new int[256];
        this.glyph_height = new int[256];
        this.kerning_x = new int[256];
        this.kerning_y = new int[256];
        this.glyph_display_width = new int[256];
        InputStream in = Client.class.getResource(name + ".dat").openStream();
        InputStream in1 = Client.class.getResource("index.dat").openStream();
        Buffer data2 = new Buffer(ByteStreams.toByteArray(in));
        Buffer idx = new Buffer(ByteStreams.toByteArray(in1));
        idx.pos = data2.readUnsignedShort() + 4;
        int pos = idx.readUnsignedByte();
        if (pos > 0) {
            idx.pos += 3 * (pos - 1);
        }
        for (int index = 0; index < 256; ++index) {
            int y;
            int pixels;
            this.kerning_x[index] = idx.readUnsignedByte();
            this.kerning_y[index] = idx.readUnsignedByte();
            int width = this.glyph_width[index] = idx.readUnsignedShort();
            int height = this.glyph_height[index] = idx.readUnsignedShort();
            int opcode = idx.readUnsignedByte();
            int area = width * height;
            this.glyph_pixels[index] = new byte[area];
            if (opcode == 0) {
                for (pixels = 0; pixels < area; ++pixels) {
                    this.glyph_pixels[index][pixels] = data2.readSignedByte();
                }
            } else if (opcode == 1) {
                for (int x = 0; x < width; ++x) {
                    for (y = 0; y < height; ++y) {
                        this.glyph_pixels[index][x + y * width] = data2.readSignedByte();
                    }
                }
            }
            if (height > this.base_char_height && index < 128) {
                this.base_char_height = height;
            }
            this.kerning_x[index] = 1;
            this.glyph_display_width[index] = width + 2;
            pixels = 0;
            for (y = height / 7; y < height; ++y) {
                pixels += this.glyph_pixels[index][y * width];
            }
            if (pixels <= height / 7) {
                int n = index;
                this.glyph_display_width[n] = this.glyph_display_width[n] - 1;
                this.kerning_x[index] = 0;
            }
            pixels = 0;
            for (y = height / 7; y < height; ++y) {
                pixels += this.glyph_pixels[index][width - 1 + y * width];
            }
            if (pixels > height / 7) continue;
            int n = index;
            this.glyph_display_width[n] = this.glyph_display_width[n] - 1;
        }
        this.glyph_display_width[32] = monospace ? this.glyph_display_width[73] : this.glyph_display_width[105];
    }

    public static void init_sprites(SimpleImage[] chat, SimpleImage[] clan, SimpleImage[] tag) {
        chat_emblems = chat;
        clan_emblems = clan;
    }

    public int get_glyph_width(int index) {
        return this.glyph_display_width[index & 0xFF];
    }

    public void set_defaults(int color, int shadow) {
        strikethrough_color = -1;
        underline_color = -1;
        shadow_color = default_shad = shadow;
        font_color = default_color = color;
        default_trans = 256;
        opacity = 256;
        anInt4178 = 0;
        anInt4175 = 0;
    }

    public void set_defaults(int shadow, int color, int trans) {
        shadow_color = default_shad = shadow;
        font_color = default_color = color;
        opacity = default_trans = trans;
    }

    public void set_adv_defaults(int color, int shadow, int trans) {
        strikethrough_color = -1;
        underline_color = -1;
        shadow_color = default_shad = shadow;
        font_color = default_color = color;
        opacity = default_trans = trans;
        anInt4178 = 0;
        anInt4175 = 0;
    }

    public String[] wrap(String text, int maximumWidth) {
        String[] words = text.split(" ");
        if (words.length == 0) {
            return new String[]{text};
        }
        ArrayList<String> lines = new ArrayList<String>();
        String line = new String();
        int lineWidth = 0;
        int spaceWidth = this.get_width(" ");
        for (String word : words) {
            if (word.isEmpty()) continue;
            int wordWidth = this.get_width(word);
            boolean isLastWord = word.equals(words[words.length - 1]);
            if (wordWidth + lineWidth >= maximumWidth && !isLastWord) {
                lines.add(line.trim());
                line = new String(word.concat(" "));
                lineWidth = wordWidth + spaceWidth;
                continue;
            }
            if (isLastWord) {
                if (wordWidth + lineWidth > maximumWidth) {
                    lines.add(line.trim());
                    lines.add(word);
                    continue;
                }
                lines.add(line.concat(word));
                continue;
            }
            line = line.concat(word).concat(" ");
            lineWidth += wordWidth + spaceWidth;
        }
        return lines.toArray(new String[lines.size()]);
    }

    public void draw_centered(String string2, int width, int height) {
        if (string2 != null) {
            this.draw(string2, width - this.get_width(string2) / 2, height);
        }
    }

    private static int getVisibleWidth(SimpleImage img) {
        int w = img.width;
        int h2 = img.height;
        int[] px = img.myPixels;
        int minX = w;
        int maxX = 0;
        boolean found = false;
        for (int y = 0; y < h2; ++y) {
            for (int x = 0; x < w; ++x) {
                if (px[x + y * w] >>> 24 == 0) continue;
                found = true;
                if (x < minX) {
                    minX = x;
                }
                if (x <= maxX) continue;
                maxX = x;
            }
        }
        return found ? maxX - minX + 1 : img.max_width;
    }

    public void drawRAString(String string2, int x, int y, int color, int shadow) {
        if (string2 != null) {
            this.set_defaults(color, shadow);
            this.draw(string2, x - this.get_width(string2), y);
        }
    }

    public void draw(String string2, int x, int y) {
        this.lastLineHadItem = false;
        if (string2.contains("<item=")) {
            y -= 2;
        }
        y -= this.base_char_height;
        int index = -1;
        int unknown = -1;
        for (int current = 0; current < string2.length(); ++current) {
            if (string2.charAt(current) == '@' && current + 4 < string2.length() && string2.charAt(current + 4) == '@') {
                int rgb = this.get_color(string2.substring(current + 1, current + 4));
                if (rgb != -1) {
                    font_color = rgb;
                }
                current += 4;
                continue;
            }
            int character = string2.charAt(current);
            if (character > 255) {
                character = 32;
            }
            if (character == 60) {
                index = current;
                continue;
            }
            if (character == 62 && index != -1) {
                String effect = string2.substring(index + 1, current);
                index = -1;
                if (effect.equals(lt_string)) {
                    character = 60;
                } else if (effect.equals(gt_string)) {
                    character = 62;
                } else if (effect.equals(nbsp_string)) {
                    character = 160;
                } else if (effect.equals(shy_string)) {
                    character = 173;
                } else if (effect.equals(times_string)) {
                    character = 215;
                } else if (effect.equals(euro_string)) {
                    character = 128;
                } else if (effect.equals(copy_string)) {
                    character = 169;
                } else if (effect.equals(reg_string)) {
                    character = 174;
                } else {
                    int height_offset;
                    SimpleImage icon;
                    int id;
                    if (effect.startsWith(set_image)) {
                        try {
                            id = Integer.parseInt(effect.substring(4));
                            icon = null;
                            if (id != -1) {
                                icon = Client.spriteCache.get(id);
                            }
                            if (icon == null) {
                                return;
                            }
                            height_offset = icon.height;
                            if (opacity == 256) {
                                icon.drawSprite(x, y + this.base_char_height - height_offset);
                            } else {
                                icon.drawSprite1(x, y + this.base_char_height - height_offset, opacity);
                            }
                            x += icon.width;
                            unknown = -1;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Client.addReportToServer(exception.getMessage());
                        }
                    }
                    if (effect.startsWith(set_item)) {
                        try {
                            int iconY;
                            int textMid;
                            int itemId;
                            this.lastLineHadItem = true;
                            String data2 = effect.substring(5);
                            int size = 12;
                            if (data2.contains(":")) {
                                String[] split = data2.split(":");
                                itemId = Integer.parseInt(split[0]);
                                size = Integer.parseInt(split[1]);
                            } else {
                                itemId = Integer.parseInt(data2);
                            }
                            SimpleImage icon2 = this.getChatItemSprite(itemId, size);
                            if (icon2 == null) continue;
                            int yOffset = icon2.height;
                            if (opacity == 256) {
                                textMid = y + (this.base_char_height >> 1);
                                iconY = textMid - icon2.height / 2;
                                int visibleWidth = icon2.width - 4;
                                icon2.drawSprite(x -= 7, ++iconY);
                                x += visibleWidth;
                            } else {
                                textMid = y + (this.base_char_height >> 1);
                                iconY = textMid - (icon2.height >> 1);
                                icon2.drawSprite1(x, iconY, opacity);
                            }
                            unknown = -1;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (effect.startsWith(set_clan)) {
                        try {
                            id = Integer.parseInt(effect.substring(5));
                            icon = null;
                            if (id != -1) {
                                icon = Client.spriteCache.get(id);
                            }
                            if (icon == null) {
                                return;
                            }
                            height_offset = icon.height + icon.y_offset + 1;
                            if (opacity == 256) {
                                icon.drawSprite(x, y + this.base_char_height - height_offset);
                            } else {
                                icon.drawSprite1(x, y + this.base_char_height - height_offset, opacity);
                            }
                            x += 11;
                            unknown = -1;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Client.addReportToServer(exception.getMessage());
                        }
                        continue;
                    }
                    this.set_effects(effect);
                    continue;
                }
            }
            if (index != -1) continue;
            if (this.byte_unknown != null && unknown != -1) {
                x += this.byte_unknown[(unknown << 8) + character];
            }
            int width = this.glyph_width[character];
            int height = this.glyph_height[character];
            if (character != 32) {
                if (opacity == 256) {
                    if (shadow_color != -1) {
                        this.draw_glyph(character, x + this.kerning_x[character] + 1, y + this.kerning_y[character] + 1, width, height, shadow_color, true);
                    }
                    this.draw_glyph(character, x + this.kerning_x[character], y + this.kerning_y[character], width, height, font_color, false);
                } else {
                    if (shadow_color != -1) {
                        this.draw_transparent_glyph(character, x + this.kerning_x[character] + 1, y + this.kerning_y[character] + 1, width, height, shadow_color, opacity, true);
                    }
                    this.draw_transparent_glyph(character, x + this.kerning_x[character], y + this.kerning_y[character], width, height, font_color, opacity, false);
                }
            } else if (anInt4178 > 0) {
                x += (anInt4175 += anInt4178) >> 8;
                anInt4175 &= 0xFF;
            }
            int final_width = this.glyph_display_width[character];
            if (strikethrough_color != -1) {
                AdvancedFont.draw_line(y + (int)((double)this.base_char_height * 0.7), strikethrough_color, final_width, x);
            }
            if (underline_color != -1) {
                AdvancedFont.draw_line(y + this.base_char_height, underline_color, final_width, x);
            }
            x += final_width;
            unknown = character;
        }
    }

    public void draw_shake(String string2, int x, int y, int color, int shadow, int cycle, int tick) {
        if (string2 != null) {
            this.set_defaults(color, shadow);
            double amp = 7.0 - (double)tick / 8.0;
            if (amp < 0.0) {
                amp = 0.0;
            }
            int[] glyph_y = new int[string2.length()];
            for (int index = 0; index < string2.length(); ++index) {
                glyph_y[index] = (int)(Math.sin((double)index / 1.5 + (double)cycle) * amp);
            }
            this.draw_translated(string2, x - this.get_width(string2) / 2, y, null, glyph_y);
        }
    }

    public void draw_wave(String string2, int x, int y, int color, int shadow, int cycle) {
        if (string2 != null) {
            this.set_defaults(color, shadow);
            int[] glyph_x = new int[string2.length()];
            int[] glyph_y = new int[string2.length()];
            for (int index = 0; index < string2.length(); ++index) {
                glyph_x[index] = (int)(Math.sin((double)index / 5.0 + (double)cycle / 5.0) * 5.0);
                glyph_y[index] = (int)(Math.sin((double)index / 3.0 + (double)cycle / 5.0) * 5.0);
            }
            this.draw_translated(string2, x - this.get_width(string2) / 2, y, glyph_x, glyph_y);
        }
    }

    public void draw_wave2(String string2, int x, int y, int color, int shadow, int cycle) {
        if (string2 != null) {
            this.set_defaults(color, shadow);
            int[] glyph_y = new int[string2.length()];
            for (int index = 0; index < string2.length(); ++index) {
                glyph_y[index] = (int)(Math.sin((double)index / 2.0 + (double)cycle / 5.0) * 5.0);
            }
            this.draw_translated(string2, x - this.get_width(string2) / 2, y, null, glyph_y);
        }
    }

    public void draw_translated(String string2, int x, int y, int[] x_translate, int[] y_translate) {
        y -= this.base_char_height;
        int index = -1;
        int unknown = -1;
        int translate_offset = 0;
        for (int current = 0; current < string2.length(); ++current) {
            int character = string2.charAt(current);
            if (character == 60) {
                index = current;
                continue;
            }
            if (character == 62 && index != -1) {
                String effect = string2.substring(index + 1, current);
                index = -1;
                if (effect.equals(lt_string)) {
                    character = 60;
                } else if (effect.equals(gt_string)) {
                    character = 62;
                } else if (effect.equals(nbsp_string)) {
                    character = 160;
                } else if (effect.equals(shy_string)) {
                    character = 173;
                } else if (effect.equals(times_string)) {
                    character = 215;
                } else if (effect.equals(euro_string)) {
                    character = 128;
                } else if (effect.equals(copy_string)) {
                    character = 169;
                } else if (effect.equals(reg_string)) {
                    character = 174;
                } else {
                    if (effect.startsWith(set_image)) {
                        try {
                            int x_translate_offset = x_translate != null ? x_translate[translate_offset] : 0;
                            int y_translate_offset = y_translate != null ? y_translate[translate_offset] : 0;
                            ++translate_offset;
                            int id = Integer.parseInt(effect.substring(4));
                            SimpleImage chat = chat_emblems[id];
                            int icon_offset_y = chat.height;
                            if (opacity == 256) {
                                chat.drawSprite(x + x_translate_offset, y + this.base_char_height - icon_offset_y + y_translate_offset);
                            } else {
                                chat.drawSprite1(x + x_translate_offset, y + this.base_char_height - icon_offset_y + y_translate_offset, opacity);
                            }
                            x += chat.width;
                            unknown = -1;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Client.addReportToServer(exception.getMessage());
                        }
                        continue;
                    }
                    this.set_effects(effect);
                    continue;
                }
            }
            if (index != -1) continue;
            if (this.byte_unknown != null && unknown != -1) {
                x += this.byte_unknown[(unknown << 8) + character];
            }
            int width = this.glyph_width[character];
            int height = this.glyph_height[character];
            int x_translate_offset = x_translate != null ? x_translate[translate_offset] : 0;
            int y_translate_offset = y_translate != null ? y_translate[translate_offset] : 0;
            ++translate_offset;
            if (character != 32) {
                if (opacity == 256) {
                    if (shadow_color != -1) {
                        this.draw_glyph(character, x + this.kerning_x[character] + 1 + x_translate_offset, y + this.kerning_y[character] + 1 + y_translate_offset, width, height, shadow_color, true);
                    }
                    this.draw_glyph(character, x + this.kerning_x[character] + x_translate_offset, y + this.kerning_y[character] + y_translate_offset, width, height, font_color, false);
                } else {
                    if (shadow_color != -1) {
                        this.draw_transparent_glyph(character, x + this.kerning_x[character] + 1 + x_translate_offset, y + this.kerning_y[character] + 1 + y_translate_offset, width, height, shadow_color, opacity, true);
                    }
                    this.draw_transparent_glyph(character, x + this.kerning_x[character] + x_translate_offset, y + this.kerning_y[character] + y_translate_offset, width, height, font_color, opacity, false);
                }
            } else if (anInt4178 > 0) {
                x += (anInt4175 += anInt4178) >> 8;
                anInt4175 &= 0xFF;
            }
            int final_width = this.glyph_display_width[character];
            if (strikethrough_color != -1) {
                AdvancedFont.draw_line(y + (int)((double)this.base_char_height * 0.7), strikethrough_color, final_width, x);
            }
            if (underline_color != -1) {
                AdvancedFont.draw_line(y + this.base_char_height, underline_color, final_width, x);
            }
            x += final_width;
            unknown = character;
        }
    }

    public void set_effects(String string2) {
        try {
            if (string2.startsWith(set_color)) {
                String color = string2.substring(4);
                font_color = color.length() < 6 ? Color.decode(color).getRGB() : Integer.parseInt(color, 16);
            } else if (string2.equals(close_color)) {
                font_color = default_color;
            } else if (string2.startsWith(set_transparency)) {
                opacity = Integer.valueOf(string2.substring(6));
            } else if (string2.equals(close_transparency)) {
                opacity = default_trans;
            } else if (string2.startsWith(set_strikethrough)) {
                String color = string2.substring(4);
                strikethrough_color = color.length() < 6 ? Color.decode(color).getRGB() : Integer.parseInt(color, 16);
            } else if (string2.equals(set_default_strikethrough)) {
                strikethrough_color = 0x800000;
            } else if (string2.equals(close_strikethrough)) {
                strikethrough_color = -1;
            } else if (string2.startsWith(set_underline)) {
                String color = string2.substring(2);
                underline_color = color.length() < 6 ? Color.decode(color).getRGB() : Integer.parseInt(color, 16);
            } else if (string2.equals(set_default_underline)) {
                underline_color = 0;
            } else if (string2.equals(close_underline)) {
                underline_color = -1;
            } else if (string2.startsWith(set_shadow)) {
                String color = string2.substring(5);
                shadow_color = color.length() < 6 ? Color.decode(color).getRGB() : Integer.parseInt(color, 16);
            } else if (string2.equals(set_default_shadow)) {
                shadow_color = 0;
            } else if (string2.equals(close_shadow)) {
                shadow_color = default_shad;
            } else if (string2.equals(line_break)) {
                this.set_adv_defaults(default_color, default_shad, default_trans);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Client.addReportToServer(exception.getMessage());
        }
    }

    private static int getLeftTrim(SimpleImage img) {
        int w = img.width;
        int h2 = img.height;
        int[] px = img.myPixels;
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h2; ++y) {
                if (px[x + y * w] >>> 24 == 0) continue;
                return x;
            }
        }
        return 0;
    }

    public int get_width(String string2) {
        if (string2 == null) {
            return 0;
        }
        int startIndex = -1;
        int unknown = -1;
        int final_width = 0;
        for (int current = 0; current < string2.length(); ++current) {
            int character = string2.charAt(current);
            if (character > 255) {
                character = 32;
            }
            if (character == 60) {
                startIndex = current;
                continue;
            }
            if (character == 62 && startIndex != -1) {
                String effect = string2.substring(startIndex + 1, current);
                startIndex = -1;
                if (effect.equals(lt_string)) {
                    character = 60;
                } else if (effect.equals(gt_string)) {
                    character = 62;
                } else if (effect.equals(nbsp_string)) {
                    character = 160;
                } else if (effect.equals(shy_string)) {
                    character = 173;
                } else if (effect.equals(times_string)) {
                    character = 215;
                } else if (effect.equals(euro_string)) {
                    character = 128;
                } else if (effect.equals(copy_string)) {
                    character = 169;
                } else if (effect.equals(reg_string)) {
                    character = 174;
                } else {
                    if (effect.startsWith(set_image)) {
                        try {
                            int id = Integer.parseInt(effect.substring(4));
                            if (chat_emblems != null && chat_emblems[id] != null) {
                                final_width += AdvancedFont.chat_emblems[id].width;
                            } else if (Client.spriteCache.get(id) != null && id > 0) {
                                final_width += Client.spriteCache.get((int)id).width;
                            }
                            unknown = -1;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Client.addReportToServer(exception.getMessage());
                        }
                        continue;
                    }
                    if (!effect.startsWith(set_item)) continue;
                    try {
                        int itemId;
                        String data2 = effect.substring(5);
                        int size = this.base_char_height * 2 + 4;
                        if (data2.contains(":")) {
                            String[] split = data2.split(":");
                            itemId = Integer.parseInt(split[0]);
                            size = Integer.parseInt(split[1]);
                        } else {
                            itemId = Integer.parseInt(data2);
                        }
                        SimpleImage icon = this.getChatItemSprite(itemId, size);
                        if (icon != null) {
                            final_width += icon.max_width - icon.x_offset;
                        }
                        unknown = -1;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
            }
            if (startIndex != -1) continue;
            final_width += this.glyph_display_width[character];
            if (this.byte_unknown != null && unknown != -1) {
                final_width += this.byte_unknown[(unknown << 8) + character];
            }
            unknown = character;
        }
        return final_width;
    }

    public void draw(String string2, int x, int y, int color, boolean shadow) {
        if (string2 != null) {
            int shad_color = !shadow ? -1 : 0;
            this.set_defaults(color, shad_color);
            this.draw(string2, x, y);
        }
    }

    public void draw_centered(String string2, int x, int y, int color, boolean shadow) {
        if (string2 != null) {
            int shad_color = !shadow ? -1 : 0;
            this.set_defaults(color, shad_color);
            this.draw(string2, x - this.get_width(string2) / 2, y);
        }
    }

    public void draw(String string2, int x, int y, int color, int shadow) {
        if (string2 != null) {
            this.set_defaults(color, shadow);
            this.draw(string2, x, y);
        }
    }

    public void drawRainbow(String text, int x, int y) {
        if (text == null || text.isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        double cycle = (double)(currentTime % 5000L) / 5000.0;
        double hueShiftPerChar = 0.06666666666666667;
        int startX = x;
        y -= this.base_char_height;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ' ') {
                startX += this.get_glyph_width(32);
                continue;
            }
            float hue = (float)((cycle + (double)i * hueShiftPerChar) % 1.0);
            Color color = Color.getHSBColor(hue, 0.9f, 1.0f);
            int rgb = color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
            this.set_defaults(rgb, -1);
            this.draw(String.valueOf(c), startX, y + this.base_char_height);
            startX += this.get_glyph_width(c);
        }
    }

    public void draw_centered(String string2, int x, int y, int color, int shadow) {
        if (string2 != null) {
            this.set_defaults(color, shadow);
            this.draw(string2, x - this.get_width(string2) / 2, y);
        }
    }

    public void draw(String string2, int x, int y, int color, int shadow, int trans) {
        if (string2 != null) {
            this.set_defaults(color, shadow);
            opacity = default_trans = trans;
            this.draw(string2, x, y);
        }
    }

    public void draw_centered(String s2, int x, int y, int col, int shad, int trans) {
        if (s2 != null) {
            this.set_defaults(col, shad);
            opacity = default_trans = trans;
            this.draw(s2, x - this.get_width(s2) / 2, y);
        }
    }

    public void drawGlowingString(String string2, int x, int y, int color, int startOpacity, double speed) {
        if (this.pcOpacity < (double)startOpacity) {
            this.pcOpacity = startOpacity;
            this.maxOpacity = false;
        }
        if (this.pcOpacity > 255.0) {
            this.pcOpacity = 255.0;
            this.maxOpacity = true;
        }
        if (this.pcOpacity >= (double)startOpacity && !this.maxOpacity) {
            this.pcOpacity += speed;
            if (this.pcOpacity == 255.0) {
                this.maxOpacity = true;
            }
        }
        if (this.pcOpacity <= 255.0 && this.maxOpacity) {
            this.pcOpacity -= speed;
            if (this.pcOpacity == (double)startOpacity) {
                this.maxOpacity = false;
            }
        }
        this.setTransLeaveShadow((int)this.pcOpacity);
        this.draw_centered(string2, x + 19, y, color, false);
    }

    public void setTransLeaveShadow(int alpha) {
        opacity = default_trans = alpha;
    }

    public void draw_left(String string2, int x, int color, int y, int trans, int shadow) {
        if (string2 != null) {
            this.set_defaults(color, shadow);
            opacity = default_trans = trans;
            this.draw(string2, x - this.get_glyph_length(string2), y);
        }
    }

    public int get_glyph_length(String string2) {
        if (string2 == null) {
            return 0;
        }
        int length = 0;
        for (int index = 0; index < string2.length(); ++index) {
            length += this.glyph_display_width[string2.charAt(index)];
        }
        return length;
    }

    public void draw_glyph(int glyph, int x, int y, int width, int height, int color, boolean bool) {
        int size;
        int dst_pos = x + y * Rasterizer2D.width;
        int dst_width = Rasterizer2D.width - width;
        int src_width = 0;
        int src_pos = 0;
        if (y < Rasterizer2D.topY) {
            size = Rasterizer2D.topY - y;
            height -= size;
            y = Rasterizer2D.topY;
            src_pos += size * width;
            dst_pos += size * Rasterizer2D.width;
        }
        if (y + height > Rasterizer2D.bottomY) {
            height -= y + height - Rasterizer2D.bottomY;
        }
        if (x < Rasterizer2D.leftX) {
            size = Rasterizer2D.leftX - x;
            width -= size;
            x = Rasterizer2D.leftX;
            src_pos += size;
            dst_pos += size;
            src_width += size;
            dst_width += size;
        }
        if (x + width > Rasterizer2D.bottomX) {
            size = x + width - Rasterizer2D.bottomX;
            width -= size;
            src_width += size;
            dst_width += size;
        }
        if (width > 0 && height > 0) {
            AdvancedFont.createCharacterPixels(Rasterizer2D.pixels, this.glyph_pixels[glyph], color, src_pos, dst_pos, width, height, dst_width, src_width);
        }
    }

    public void draw_transparent_glyph(int glyph, int x, int y, int width, int height, int color, int alpha, boolean bool) {
        int size;
        int dst_pos = x + y * Rasterizer2D.width;
        int dst_width = Rasterizer2D.width - width;
        int src_width = 0;
        int src_pos = 0;
        if (y < Rasterizer2D.topY) {
            size = Rasterizer2D.topY - y;
            height -= size;
            y = Rasterizer2D.topY;
            src_pos += size * width;
            dst_pos += size * Rasterizer2D.width;
        }
        if (y + height > Rasterizer2D.bottomY) {
            height -= y + height - Rasterizer2D.bottomY;
        }
        if (x < Rasterizer2D.leftX) {
            size = Rasterizer2D.leftX - x;
            width -= size;
            x = Rasterizer2D.leftX;
            src_pos += size;
            dst_pos += size;
            src_width += size;
            dst_width += size;
        }
        if (x + width > Rasterizer2D.bottomX) {
            size = x + width - Rasterizer2D.bottomX;
            width -= size;
            src_width += size;
            dst_width += size;
        }
        if (width > 0 && height > 0) {
            AdvancedFont.createTransparentCharacterPixels(Rasterizer2D.pixels, this.glyph_pixels[glyph], color, src_pos, dst_pos, width, height, dst_width, src_width, alpha);
        }
    }

    public static void createCharacterPixels(int[] is, byte[] is_24_, int i, int i_25_, int i_26_, int i_27_, int i_28_, int i_29_, int i_30_) {
        int i_31_ = -(i_27_ >> 2);
        i_27_ = -(i_27_ & 3);
        for (int i_32_ = -i_28_; i_32_ < 0; ++i_32_) {
            for (int i_33_ = i_31_; i_33_ < 0; ++i_33_) {
                if (is_24_[i_25_++] != 0) {
                    AdvancedFont.drawAlpha(is, i_26_++, i, 255);
                } else {
                    ++i_26_;
                }
                if (is_24_[i_25_++] != 0) {
                    AdvancedFont.drawAlpha(is, i_26_++, i, 255);
                } else {
                    ++i_26_;
                }
                if (is_24_[i_25_++] != 0) {
                    AdvancedFont.drawAlpha(is, i_26_++, i, 255);
                } else {
                    ++i_26_;
                }
                if (is_24_[i_25_++] != 0) {
                    AdvancedFont.drawAlpha(is, i_26_++, i, 255);
                    continue;
                }
                ++i_26_;
            }
            for (int i_34_ = i_27_; i_34_ < 0; ++i_34_) {
                if (is_24_[i_25_++] != 0) {
                    AdvancedFont.drawAlpha(is, i_26_++, i, 255);
                    continue;
                }
                ++i_26_;
            }
            i_26_ += i_29_;
            i_25_ += i_30_;
        }
    }

    private SimpleImage copySprite(SimpleImage src) {
        SimpleImage copy2 = new SimpleImage(src.width, src.height);
        System.arraycopy(src.myPixels, 0, copy2.myPixels, 0, src.myPixels.length);
        copy2.max_width = src.max_width;
        copy2.max_height = src.max_height;
        copy2.x_offset = src.x_offset;
        copy2.y_offset = src.y_offset;
        return copy2;
    }

    public static void createTransparentCharacterPixels(int[] is, byte[] is_0_, int i, int i_1_, int i_2_, int i_3_, int i_4_, int i_5_, int i_6_, int i_7_) {
        i = ((i & 0xFF00FF) * i_7_ & 0xFF00FF00) + ((i & 0xFF00) * i_7_ & 0xFF0000) >> 8;
        i_7_ = 256 - i_7_;
        for (int i_8_ = -i_4_; i_8_ < 0; ++i_8_) {
            for (int i_9_ = -i_3_; i_9_ < 0; ++i_9_) {
                if (is_0_[i_1_++] != 0) {
                    int i_10_ = is[i_2_];
                    AdvancedFont.drawAlpha(is, i_2_++, (((i_10_ & 0xFF00FF) * i_7_ & 0xFF00FF00) + ((i_10_ & 0xFF00) * i_7_ & 0xFF0000) >> 8) + i, 255);
                    continue;
                }
                ++i_2_;
            }
            i_2_ += i_5_;
            i_1_ += i_6_;
        }
    }

    public int get_color(String s2) {
        switch (s2) {
            case "red": {
                return 0xFF0000;
            }
            case "gre": {
                return 65280;
            }
            case "blu": {
                return 255;
            }
            case "yel": {
                return 0xFFFF00;
            }
            case "cya": {
                return 65535;
            }
            case "mag": {
                return 0xFF00FF;
            }
            case "whi": {
                return 0xFFFFFF;
            }
            case "bla": {
                return 0;
            }
            case "lre": {
                return 16748608;
            }
            case "dre": {
                return 0x800000;
            }
            case "dbl": {
                return 128;
            }
            case "or1": {
                return 0xFFB000;
            }
            case "or2": {
                return 0xFF7000;
            }
            case "or3": {
                return 0xFF3000;
            }
            case "gr1": {
                return 0xC0FF00;
            }
            case "gr2": {
                return 0x80FF00;
            }
            case "gr3": {
                return 0x40FF00;
            }
        }
        return -1;
    }

    public static void release() {
        lt_string = null;
        gt_string = null;
        nbsp_string = null;
        shy_string = null;
        times_string = null;
        euro_string = null;
        copy_string = null;
        reg_string = null;
        set_image = null;
        line_break = null;
        set_color = null;
        close_color = null;
        set_transparency = null;
        close_transparency = null;
        set_underline = null;
        set_default_underline = null;
        close_underline = null;
        set_shadow = null;
        set_default_shadow = null;
        close_shadow = null;
        set_strikethrough = null;
        set_default_strikethrough = null;
        close_strikethrough = null;
    }

    static {
        set_transparency = "trans=";
        set_strikethrough = "str=";
        set_default_shadow = "shad";
        set_color = "col=";
        line_break = "br";
        set_default_strikethrough = "str";
        close_underline = "/u";
        set_image = "img=";
        set_item = "item=";
        set_clan = "clan=";
        set_shadow = "shad=";
        set_underline = "u=";
        close_color = "/col";
        set_default_underline = "u";
        close_transparency = "/trans";
        nbsp_string = "nbsp";
        reg_string = "reg";
        times_string = "times";
        shy_string = "shy";
        copy_string = "copy";
        gt_string = "gt";
        euro_string = "euro";
        lt_string = "lt";
        default_trans = 256;
        default_shad = -1;
        anInt4175 = 0;
        shadow_color = -1;
        font_color = 0;
        default_color = 0;
        strikethrough_color = -1;
        underline_color = -1;
        anInt4178 = 0;
        opacity = 256;
        close_shadow = "/shad";
        close_strikethrough = "/str";
    }
}

