/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.graphics.widget;

import com.hazy.Client;
import com.hazy.cache.graphics.SimpleImage;
import com.hazy.cache.graphics.widget.Widget;
import com.hazy.engine.impl.MouseHandler;

public class Slider {
    private final double minValue;
    private final double maxValue;
    private final double length;
    private final SimpleImage[] images = new SimpleImage[2];
    private int position = 86;
    private double value;
    private int x;
    private int y;

    public Slider(SimpleImage icon, SimpleImage background, double minimumValue, double maximumValue) {
        this.images[0] = icon;
        this.images[1] = background;
        this.minValue = this.value = minimumValue;
        this.maxValue = maximumValue;
        this.length = this.images[1].width;
    }

    public static void handleSlider(int mX, int mY) {
        int interfaceId;
        int tabInterfaceId = Client.tabInterfaceIDs[Client.sidebarId];
        if (tabInterfaceId != -1) {
            Widget widget;
            if (tabInterfaceId == 42500) {
                tabInterfaceId = Widget.cache[42500].children[9];
            }
            if ((widget = Widget.cache[tabInterfaceId]) == null || widget.children == null) {
                return;
            }
            for (int childId : widget.children) {
                if (Client.instance.settings[294] == 1) {
                    return;
                }
                Widget child = Widget.cache[childId];
                if (child == null || child.slider == null) continue;
                child.slider.handleClick(mX, mY, 0, 0);
            }
            Client.update_tab_producer = true;
        }
        if ((interfaceId = Client.widget_overlay_id) != -1) {
            Widget widget = Widget.cache[interfaceId];
            if (widget == null || widget.children == null) {
                return;
            }
            for (int childId : widget.children) {
                Widget child = Widget.cache[childId];
                if (child == null || child.slider == null) continue;
                child.slider.handleClick(mX, mY, 4, 4);
            }
        }
    }

    public void draw(int x, int y) {
        this.x = x;
        this.y = y;
        this.images[1].drawSprite(x, y);
        this.images[0].drawSprite(x + this.position - (int)((double)this.position / this.length * (double)this.images[0].width), y - this.images[0].height / 2 + this.images[1].height / 2);
    }

    public void handleClick(int mouseX, int mouseY, int offsetX, int offsetY) {
        if (Client.instance.settings[294] == 1) {
            return;
        }
        int mX = MouseHandler.mouseX;
        int mY = MouseHandler.mouseY;
        if (mX - offsetX >= this.x && (double)(mX - offsetX) <= (double)this.x + this.length && mY - offsetY >= this.y + this.images[1].height / 2 - this.images[0].height / 2 && mY - offsetY <= this.y + this.images[1].height / 2 + this.images[0].height / 2) {
            this.position = mouseX - this.x - offsetX;
            if ((double)this.position >= this.length) {
                this.position = (int)this.length;
            }
            if (this.position <= 0) {
                this.position = 0;
            }
            this.value = this.minValue + (double)this.position / this.length * (this.maxValue - this.minValue);
            if (this.value < this.minValue) {
                this.value = this.minValue;
            }
            if (this.value > this.maxValue) {
                this.value = this.maxValue;
            }
            Client.cameraZoom = (int)(this.minValue + this.maxValue - this.value);
            Client.instance.setting.save();
        }
    }

    public double getPercentage() {
        return (double)this.position / this.length * 100.0;
    }

    public void setValue(double value) {
        if (value < this.minValue) {
            value = this.minValue;
        } else if (value > this.maxValue) {
            value = this.maxValue;
        }
        this.value = value;
        double shift = 1.0 - (value - this.minValue) / (this.maxValue - this.minValue);
        this.position = (int)(this.length * shift);
    }
}

