/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.graphics.widget;

import java.util.ArrayList;
import java.util.List;

public class WidgetBuilder {
    private final int baseId;
    private int nextId;
    private final List<String> lines = new ArrayList<String>();
    private int childIndex = 0;

    public WidgetBuilder(int baseId) {
        this.baseId = baseId;
        this.nextId = baseId + 1;
        this.lines.add("Widget w = addInterface(" + baseId + ");");
        this.lines.add("w.totalChildren(999);");
        this.lines.add("int child = 0;");
    }

    private int newId() {
        return this.nextId++;
    }

    private void addChild(int id, int x, int y) {
        this.lines.add("w.child(child++, " + id + ", " + x + ", " + y + ");");
        ++this.childIndex;
    }

    public WidgetBuilder sprite(String spriteConstant, int x, int y) {
        int id = this.newId();
        this.lines.add("addSpriteLoader(" + id + ", " + spriteConstant + ");");
        this.addChild(id, x, y);
        return this;
    }

    public WidgetBuilder text(String content, int color, int fontIdx, boolean centered, boolean shadow, int width, int y) {
        int id = this.newId();
        this.lines.add("addText(" + id + ", \"" + content + "\", " + color + ", " + centered + ", " + shadow + ", " + width + ", font, " + fontIdx + ");");
        this.addChild(id, width, y);
        return this;
    }

    public WidgetBuilder button(String label, int sprite1, int sprite2, int x, int y) {
        int id = this.newId();
        this.lines.add("configHoverButton(" + id + ", \"" + label + "\", " + sprite1 + ", " + sprite2 + ", " + sprite1 + ", " + sprite2 + ", false, 0);");
        this.addChild(id, x, y);
        return this;
    }

    public WidgetBuilder custom(String rawLine) {
        this.lines.add(rawLine);
        return this;
    }

    public WidgetBuilder childDone() {
        return this;
    }

    public String build() {
        return String.join((CharSequence)"\n", this.lines);
    }
}

