/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.graphics.widget.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RspsInterfaceEditor
extends JFrame {
    private final DefaultListModel<UIElement> listModel = new DefaultListModel();
    private final JList<UIElement> elementList = new JList<UIElement>(this.listModel);
    private UIElement selected;
    private final CanvasPanel canvas;
    private final JSpinner spX = new JSpinner(new SpinnerNumberModel(10, -9999, 9999, 1));
    private final JSpinner spY = new JSpinner(new SpinnerNumberModel(10, -9999, 9999, 1));
    private final JSpinner spW = new JSpinner(new SpinnerNumberModel(100, 1, 4000, 1));
    private final JSpinner spH = new JSpinner(new SpinnerNumberModel(20, 1, 4000, 1));
    private final JTextField txtText = new JTextField("Text");
    private final JSpinner spFontIdx = new JSpinner(new SpinnerNumberModel(0, 0, 20, 1));
    private final JTextField txtColorHex = new JTextField("FFFFFF");
    private final JCheckBox chkCentered = new JCheckBox("Centered", false);
    private final JCheckBox chkShadow = new JCheckBox("Shadow", true);
    private final JTextField txtSpriteId = new JTextField("-1");
    private final JTextField txtSpriteHoverId = new JTextField("-1");
    private final JTextField txtButtonLabel = new JTextField("Button");
    private final JLabel lblSpritePreview = new JLabel("Normal preview", 0);
    private final JLabel lblHoverPreview = new JLabel("Hover preview", 0);
    private final JTextArea exportArea = new JTextArea();
    private int canvasWidth = 512;
    private int canvasHeight = 334;
    private int lastBaseId = 36000;
    private boolean snapToGrid = true;
    private boolean showGrid = true;
    private File currentFile = null;
    private final SpriteManager spriteManager = new SpriteManager();
    private SpriteBrowserPanel spriteBrowser;
    private final JLabel statusLabel = new JLabel("Ready.");

    public static void main(String[] args2) {
        SwingUtilities.invokeLater(() -> {
            RspsInterfaceEditor editor = new RspsInterfaceEditor();
            editor.setVisible(true);
        });
    }

    public RspsInterfaceEditor() {
        super("RSPS Interface Editor - with Spritesdump & Java Import");
        this.setDefaultCloseOperation(3);
        this.setSize(1300, 720);
        this.setLocationRelativeTo(null);
        this.setLayout(new BorderLayout());
        this.setJMenuBar(this.buildMenuBar());
        this.canvas = new CanvasPanel();
        this.canvas.setPreferredSize(new Dimension(this.canvasWidth, this.canvasHeight));
        this.canvas.setBackground(new Color(30, 30, 30));
        JPanel canvasWrapper = new JPanel(new GridBagLayout());
        canvasWrapper.setBackground(new Color(50, 50, 50));
        canvasWrapper.add(this.canvas);
        this.add((Component)canvasWrapper, "Center");
        this.add((Component)this.buildLeftTabs(), "West");
        this.add((Component)this.buildRightPanel(), "East");
        this.add((Component)this.buildStatusBar(), "South");
        this.elementList.setSelectionMode(0);
        this.elementList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof UIElement) {
                    this.setText(index + ": " + value.toString());
                }
                return this;
            }
        });
        this.elementList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.selected = this.elementList.getSelectedValue();
                this.canvas.setSelected(this.selected);
                this.loadPropertiesFromSelection();
            }
        });
        this.hookPropertyListeners();
        this.setMinimumSize(new Dimension(1000, 600));
        SwingUtilities.invokeLater(() -> {
            int res = JOptionPane.showConfirmDialog(this, "Load a spritesdump folder now?\n(This should contain 0.png, 1.png, ...)", "Load sprites?", 0);
            if (res == 0) {
                this.chooseSpriteDir();
            }
        });
    }

    private JMenuBar buildMenuBar() {
        JMenuBar mb = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem miNew = new JMenuItem("New");
        JMenuItem miOpen = new JMenuItem("Open...");
        JMenuItem miSave = new JMenuItem("Save");
        JMenuItem miSaveAs = new JMenuItem("Save As...");
        JMenuItem miExport = new JMenuItem("Export Java...");
        JMenuItem miExit = new JMenuItem("Exit");
        miNew.addActionListener(e -> this.newProject());
        miOpen.addActionListener(e -> this.openProjectDialog());
        miSave.addActionListener(e -> this.saveProject(false));
        miSaveAs.addActionListener(e -> this.saveProject(true));
        miExport.addActionListener(e -> this.doExport());
        miExit.addActionListener(e -> this.dispose());
        fileMenu.add(miNew);
        fileMenu.add(miOpen);
        fileMenu.addSeparator();
        fileMenu.add(miSave);
        fileMenu.add(miSaveAs);
        fileMenu.addSeparator();
        fileMenu.add(miExport);
        fileMenu.addSeparator();
        fileMenu.add(miExit);
        JMenu viewMenu = new JMenu("View");
        JCheckBoxMenuItem miGrid = new JCheckBoxMenuItem("Show grid", this.showGrid);
        JCheckBoxMenuItem miSnap = new JCheckBoxMenuItem("Snap to grid", this.snapToGrid);
        miGrid.addActionListener(e -> {
            this.showGrid = miGrid.isSelected();
            this.canvas.repaint();
        });
        miSnap.addActionListener(e -> {
            this.snapToGrid = miSnap.isSelected();
        });
        viewMenu.add(miGrid);
        viewMenu.add(miSnap);
        JMenu spriteMenu = new JMenu("Sprites");
        JMenuItem miLoadSprites = new JMenuItem("Load spritesdump folder...");
        JMenuItem miClearSprites = new JMenuItem("Clear sprites");
        miLoadSprites.addActionListener(e -> this.chooseSpriteDir());
        miClearSprites.addActionListener(e -> {
            this.spriteManager.clear();
            if (this.spriteBrowser != null) {
                this.spriteBrowser.refreshList();
            }
            this.canvas.repaint();
            this.updateSpritePreviews();
            this.status("Cleared loaded sprites.");
        });
        spriteMenu.add(miLoadSprites);
        spriteMenu.add(miClearSprites);
        JMenu interfacesMenu = new JMenu("Interfaces");
        JMenuItem miImportJava = new JMenuItem("Import from Java...");
        miImportJava.addActionListener(e -> this.importFromJavaDialog());
        interfacesMenu.add(miImportJava);
        JMenu helpMenu = new JMenu("Help");
        JMenuItem miAbout = new JMenuItem("About");
        miAbout.addActionListener(e -> JOptionPane.showMessageDialog(this, "RSPS Interface Editor\n- Drag & drop elements\n- Load sprites from spritesdump\n- Import existing widget impls\n- Export Java widget code.", "About", 1));
        helpMenu.add(miAbout);
        mb.add(fileMenu);
        mb.add(viewMenu);
        mb.add(spriteMenu);
        mb.add(interfacesMenu);
        mb.add(helpMenu);
        return mb;
    }

    private JTabbedPane buildLeftTabs() {
        JTabbedPane tabs = new JTabbedPane();
        tabs.setPreferredSize(new Dimension(280, 700));
        tabs.addTab("Elements", this.buildLeftElementsPanel());
        this.spriteBrowser = new SpriteBrowserPanel(this.spriteManager, this);
        tabs.addTab("Sprites", this.spriteBrowser);
        return tabs;
    }

    private JPanel buildLeftElementsPanel() {
        JPanel left = new JPanel(new BorderLayout());
        JPanel tools = new JPanel(new GridLayout(0, 1, 4, 4));
        tools.setBorder(new TitledBorder("Add element"));
        JButton btnAddText = new JButton("Add Text");
        JButton btnAddSprite = new JButton("Add Sprite");
        JButton btnAddButton = new JButton("Add Button");
        btnAddText.addActionListener(e -> this.addElement(ElementType.TEXT));
        btnAddSprite.addActionListener(e -> this.addElement(ElementType.SPRITE));
        btnAddButton.addActionListener(e -> this.addElement(ElementType.BUTTON));
        tools.add(btnAddText);
        tools.add(btnAddSprite);
        tools.add(btnAddButton);
        left.add((Component)tools, "North");
        JScrollPane scroll = new JScrollPane(this.elementList);
        scroll.setBorder(new TitledBorder("Elements"));
        left.add((Component)scroll, "Center");
        return left;
    }

    private JPanel buildRightPanel() {
        JPanel right = new JPanel(new BorderLayout());
        right.setPreferredSize(new Dimension(460, 700));
        JPanel props = new JPanel();
        props.setLayout(new BoxLayout(props, 1));
        props.setBorder(new TitledBorder("Properties"));
        JPanel posPanel = new JPanel(new GridLayout(2, 4, 4, 4));
        posPanel.setBorder(new TitledBorder("Position / Size"));
        posPanel.add(new JLabel("X:"));
        posPanel.add(this.spX);
        posPanel.add(new JLabel("Y:"));
        posPanel.add(this.spY);
        posPanel.add(new JLabel("Width:"));
        posPanel.add(this.spW);
        posPanel.add(new JLabel("Height:"));
        posPanel.add(this.spH);
        JPanel textPanel = new JPanel(new GridLayout(0, 1, 4, 4));
        textPanel.setBorder(new TitledBorder("Text (for TEXT / BUTTON)"));
        textPanel.add(new JLabel("Text:"));
        textPanel.add(this.txtText);
        textPanel.add(new JLabel("Font index (font[]):"));
        textPanel.add(this.spFontIdx);
        textPanel.add(new JLabel("Color (hex, e.g. FF981F):"));
        textPanel.add(this.txtColorHex);
        textPanel.add(this.chkCentered);
        textPanel.add(this.chkShadow);
        JPanel spritePanel = new JPanel();
        spritePanel.setLayout(new BoxLayout(spritePanel, 1));
        spritePanel.setBorder(new TitledBorder("Sprite (for SPRITE / BUTTON)"));
        JPanel spriteIdsPanel = new JPanel(new GridLayout(0, 1, 4, 4));
        spriteIdsPanel.add(new JLabel("Sprite ID:"));
        spriteIdsPanel.add(this.txtSpriteId);
        spriteIdsPanel.add(new JLabel("Hover Sprite ID (button hover):"));
        spriteIdsPanel.add(this.txtSpriteHoverId);
        this.lblSpritePreview.setPreferredSize(new Dimension(80, 80));
        this.lblHoverPreview.setPreferredSize(new Dimension(80, 80));
        JPanel previewPanel = new JPanel(new GridLayout(1, 2, 4, 4));
        previewPanel.add(this.wrappedPanel(this.lblSpritePreview));
        previewPanel.add(this.wrappedPanel(this.lblHoverPreview));
        spritePanel.add(spriteIdsPanel);
        spritePanel.add(previewPanel);
        JPanel buttonPanel = new JPanel(new GridLayout(0, 1, 4, 4));
        buttonPanel.setBorder(new TitledBorder("Button"));
        buttonPanel.add(new JLabel("Button label:"));
        buttonPanel.add(this.txtButtonLabel);
        props.add(posPanel);
        props.add(textPanel);
        props.add(spritePanel);
        props.add(buttonPanel);
        right.add((Component)props, "North");
        this.exportArea.setFont(new Font("Monospaced", 0, 11));
        this.exportArea.setEditable(false);
        JScrollPane exportScroll = new JScrollPane(this.exportArea);
        exportScroll.setBorder(new TitledBorder("Generated Java"));
        right.add((Component)exportScroll, "Center");
        JPanel bottomButtons = new JPanel(new FlowLayout(2));
        JButton btnClear = new JButton("Clear Elements");
        JButton btnExport = new JButton("Export Java");
        btnClear.addActionListener(e -> {
            this.listModel.clear();
            this.selected = null;
            this.canvas.setSelected(null);
            this.canvas.repaint();
            this.exportArea.setText("");
            this.status("Cleared all elements.");
        });
        btnExport.addActionListener(e -> this.doExport());
        bottomButtons.add(btnClear);
        bottomButtons.add(btnExport);
        right.add((Component)bottomButtons, "South");
        return right;
    }

    private JPanel buildStatusBar() {
        JPanel bar = new JPanel(new BorderLayout());
        bar.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(0, 11.0f));
        bar.add((Component)this.statusLabel, "West");
        return bar;
    }

    private JPanel wrappedPanel(JComponent comp) {
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)comp, "Center");
        return p;
    }

    private void addElement(ElementType type2) {
        UIElement el;
        switch (type2) {
            case TEXT: {
                el = new UIElement(type2, 50, 50, 150, 20);
                el.text = "New text";
                el.textColor = 0xFFFFFF;
                el.fontIndex = 0;
                el.centered = false;
                el.shadow = true;
                break;
            }
            case SPRITE: {
                el = new UIElement(type2, 80, 80, 40, 40);
                el.spriteId = -1;
                break;
            }
            case BUTTON: {
                el = new UIElement(type2, 100, 100, 90, 25);
                el.buttonLabel = "Click";
                el.text = "Click";
                el.spriteId = -1;
                el.spriteHoverId = -1;
                el.textColor = 0xFFFFFF;
                break;
            }
            default: {
                return;
            }
        }
        this.listModel.addElement(el);
        this.selected = el;
        this.elementList.setSelectedValue(el, true);
        this.canvas.setSelected(el);
        this.loadPropertiesFromSelection();
        this.canvas.repaint();
        this.status("Added " + String.valueOf((Object)type2) + ".");
    }

    public void addSpriteFromBrowser(int spriteId) {
        BufferedImage img = this.spriteManager.get(spriteId);
        int w = img != null ? img.getWidth() : 40;
        int h2 = img != null ? img.getHeight() : 40;
        UIElement el = new UIElement(ElementType.SPRITE, 40, 40, w, h2);
        el.spriteId = spriteId;
        this.listModel.addElement(el);
        this.selected = el;
        this.elementList.setSelectedValue(el, true);
        this.canvas.setSelected(el);
        this.loadPropertiesFromSelection();
        this.canvas.repaint();
        this.status("Added sprite ID " + spriteId + " to canvas.");
    }

    private void hookPropertyListeners() {
        ChangeListener commonChange = e -> {
            if (this.selected == null) {
                return;
            }
            this.selected.x = (Integer)this.spX.getValue();
            this.selected.y = (Integer)this.spY.getValue();
            this.selected.width = (Integer)this.spW.getValue();
            this.selected.height = (Integer)this.spH.getValue();
            this.canvas.repaint();
            this.elementList.repaint();
            this.statusSelection();
        };
        this.spX.addChangeListener(commonChange);
        this.spY.addChangeListener(commonChange);
        this.spW.addChangeListener(commonChange);
        this.spH.addChangeListener(commonChange);
        this.txtText.getDocument().addDocumentListener(e -> {
            if (this.selected != null) {
                this.selected.text = this.txtText.getText();
                if (this.selected.type == ElementType.BUTTON) {
                    this.selected.buttonLabel = this.selected.text;
                    this.txtButtonLabel.setText(this.selected.buttonLabel);
                }
                this.canvas.repaint();
            }
        });
        this.spFontIdx.addChangeListener(e -> {
            if (this.selected != null) {
                this.selected.fontIndex = (Integer)this.spFontIdx.getValue();
            }
        });
        this.txtColorHex.getDocument().addDocumentListener(e -> {
            if (this.selected != null) {
                try {
                    String hex = this.txtColorHex.getText().trim();
                    if (!hex.isEmpty()) {
                        this.selected.textColor = Integer.parseInt(hex, 16);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.canvas.repaint();
            }
        });
        this.chkCentered.addActionListener(e -> {
            if (this.selected != null) {
                this.selected.centered = this.chkCentered.isSelected();
                this.canvas.repaint();
            }
        });
        this.chkShadow.addActionListener(e -> {
            if (this.selected != null) {
                this.selected.shadow = this.chkShadow.isSelected();
                this.canvas.repaint();
            }
        });
        this.txtSpriteId.getDocument().addDocumentListener(e -> {
            if (this.selected != null) {
                BufferedImage img;
                try {
                    this.selected.spriteId = Integer.parseInt(this.txtSpriteId.getText().trim());
                }
                catch (Exception ignored) {
                    this.selected.spriteId = -1;
                }
                if (this.selected.spriteId >= 0 && (img = this.spriteManager.get(this.selected.spriteId)) != null) {
                    this.selected.width = img.getWidth();
                    this.selected.height = img.getHeight();
                    this.spW.setValue(this.selected.width);
                    this.spH.setValue(this.selected.height);
                }
                this.canvas.repaint();
                this.updateSpritePreviews();
            }
        });
        this.txtSpriteHoverId.getDocument().addDocumentListener(e -> {
            if (this.selected != null) {
                try {
                    this.selected.spriteHoverId = Integer.parseInt(this.txtSpriteHoverId.getText().trim());
                }
                catch (Exception ignored) {
                    this.selected.spriteHoverId = -1;
                }
                this.updateSpritePreviews();
            }
        });
        this.txtButtonLabel.getDocument().addDocumentListener(e -> {
            if (this.selected != null && this.selected.type == ElementType.BUTTON) {
                this.selected.buttonLabel = this.txtButtonLabel.getText();
                this.canvas.repaint();
            }
        });
    }

    private void loadPropertiesFromSelection() {
        if (this.selected == null) {
            this.updateSpritePreviews();
            return;
        }
        this.spX.setValue(this.selected.x);
        this.spY.setValue(this.selected.y);
        this.spW.setValue(this.selected.width);
        this.spH.setValue(this.selected.height);
        this.txtText.setText(this.selected.text != null ? this.selected.text : "");
        this.spFontIdx.setValue(this.selected.fontIndex);
        this.txtColorHex.setText(String.format("%06X", this.selected.textColor));
        this.chkCentered.setSelected(this.selected.centered);
        this.chkShadow.setSelected(this.selected.shadow);
        this.txtSpriteId.setText(Integer.toString(this.selected.spriteId));
        this.txtSpriteHoverId.setText(Integer.toString(this.selected.spriteHoverId));
        this.txtButtonLabel.setText(this.selected.buttonLabel != null ? this.selected.buttonLabel : "");
        this.updateSpritePreviews();
        this.statusSelection();
    }

    private void updateSpritePreviews() {
        BufferedImage img;
        this.lblSpritePreview.setIcon(null);
        this.lblHoverPreview.setIcon(null);
        if (this.selected == null) {
            return;
        }
        if (this.selected.spriteId >= 0 && (img = this.spriteManager.get(this.selected.spriteId)) != null) {
            this.lblSpritePreview.setIcon(new ImageIcon(img.getScaledInstance(64, 64, 4)));
        }
        if (this.selected.spriteHoverId >= 0 && (img = this.spriteManager.get(this.selected.spriteHoverId)) != null) {
            this.lblHoverPreview.setIcon(new ImageIcon(img.getScaledInstance(64, 64, 4)));
        }
    }

    private void doExport() {
        int baseId;
        if (this.listModel.isEmpty()) {
            this.exportArea.setText("// No elements to export.");
            this.status("Nothing to export.");
            return;
        }
        String baseIdStr = JOptionPane.showInputDialog(this, "Base interface ID (e.g. 36000):", Integer.toString(this.lastBaseId));
        if (baseIdStr == null || baseIdStr.trim().isEmpty()) {
            return;
        }
        try {
            baseId = Integer.parseInt(baseIdStr.trim());
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, "Invalid base ID.", "Error", 0);
            return;
        }
        this.lastBaseId = baseId;
        StringBuilder out = new StringBuilder();
        out.append("// Generated by RspsInterfaceEditor\n");
        out.append("public static final int BASE = ").append(baseId).append(";\n\n");
        out.append("public static void build(AdvancedFont[] font) {\n");
        out.append("    Widget w = addInterface(BASE);\n");
        out.append("    w.totalChildren(").append(this.listModel.getSize()).append(");\n");
        out.append("    int child = 0;\n\n");
        int nextId = baseId + 1;
        block7: for (int i = 0; i < this.listModel.size(); ++i) {
            UIElement el = this.listModel.get(i);
            int id = nextId++;
            switch (el.type) {
                case TEXT: {
                    out.append("    addText(").append(id).append(", \"").append(this.escape(el.text)).append("\", 0x").append(String.format("%06X", el.textColor)).append(", ").append(el.centered).append(", ").append(el.shadow).append(", ").append(el.width).append(", font, ").append(el.fontIndex).append(");\n");
                    out.append("    w.child(child++, ").append(id).append(", ").append(el.x).append(", ").append(el.y).append(");\n\n");
                    continue block7;
                }
                case SPRITE: {
                    out.append("    addSpriteLoader(").append(id).append(", ").append(el.spriteId).append(");\n");
                    out.append("    w.child(child++, ").append(id).append(", ").append(el.x).append(", ").append(el.y).append(");\n\n");
                    continue block7;
                }
                case BUTTON: {
                    out.append("    configHoverButton(").append(id).append(", \"").append(this.escape(el.buttonLabel)).append("\", ").append(el.spriteId).append(", ").append(el.spriteHoverId).append(", ").append(el.spriteId).append(", ").append(el.spriteHoverId).append(", false, 0);\n");
                    out.append("    w.child(child++, ").append(id).append(", ").append(el.x).append(", ").append(el.y).append(");\n\n");
                }
            }
        }
        out.append("}\n");
        this.exportArea.setText(out.toString());
        this.exportArea.setCaretPosition(0);
        this.status("Exported Java for BASE=" + baseId + ".");
    }

    private String escape(String s2) {
        if (s2 == null) {
            return "";
        }
        return s2.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private void newProject() {
        if (!this.confirmDiscardChanges()) {
            return;
        }
        this.listModel.clear();
        this.selected = null;
        this.canvas.setSelected(null);
        this.canvas.repaint();
        this.exportArea.setText("");
        this.currentFile = null;
        this.status("New project.");
    }

    private boolean confirmDiscardChanges() {
        if (this.listModel.isEmpty() && (this.currentFile == null || !this.currentFile.exists())) {
            return true;
        }
        int res = JOptionPane.showConfirmDialog(this, "Discard current layout?", "Confirm", 0);
        return res == 0;
    }

    private void openProjectDialog() {
        if (!this.confirmDiscardChanges()) {
            return;
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Open RSPS Interface Project");
        int result2 = chooser.showOpenDialog(this);
        if (result2 == 0) {
            File f = chooser.getSelectedFile();
            this.loadProject(f);
        }
    }

    private void saveProject(boolean forceChooseFile) {
        if (this.currentFile == null || forceChooseFile) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Save RSPS Interface Project");
            int result2 = chooser.showSaveDialog(this);
            if (result2 != 0) {
                return;
            }
            File f = chooser.getSelectedFile();
            if (!f.getName().toLowerCase().endsWith(".rsi")) {
                f = new File(f.getParentFile(), f.getName() + ".rsi");
            }
            this.currentFile = f;
        }
        this.doSaveProject(this.currentFile);
    }

    private void doSaveProject(File f) {
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));){
            pw.println("RSPS_IFACE_EDITOR_V1");
            pw.println("BASE_ID=" + this.lastBaseId);
            pw.println("CANVAS=" + this.canvasWidth + "," + this.canvasHeight);
            if (this.spriteManager.getSourceDir() != null) {
                pw.println("SPRITEDIR=" + this.spriteManager.getSourceDir().getAbsolutePath());
            }
            for (int i = 0; i < this.listModel.size(); ++i) {
                UIElement el = this.listModel.get(i);
                pw.println("E|" + el.type.name() + "|" + el.x + "|" + el.y + "|" + el.width + "|" + el.height + "|" + String.format("%06X", el.textColor) + "|" + el.fontIndex + "|" + el.centered + "|" + el.shadow + "|" + el.spriteId + "|" + el.spriteHoverId + "|" + this.safe(el.buttonLabel) + "|" + this.safe(el.text));
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Failed to save: " + ex.getMessage(), "Error", 0);
            return;
        }
        this.status("Saved project: " + f.getName());
    }

    private void loadProject(File f) {
        File dir;
        ArrayList<UIElement> loaded = new ArrayList<UIElement>();
        int loadedBaseId = this.lastBaseId;
        int loadedCanvasW = this.canvasWidth;
        int loadedCanvasH = this.canvasHeight;
        String spriteDirPath = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));){
            String line;
            String first = br.readLine();
            if (first == null || !first.startsWith("RSPS_IFACE_EDITOR_")) {
                throw new IOException("Not a RSPS Interface Editor file.");
            }
            while ((line = br.readLine()) != null) {
                String[] parts;
                if (line.startsWith("BASE_ID=")) {
                    loadedBaseId = Integer.parseInt(line.substring("BASE_ID=".length()).trim());
                    continue;
                }
                if (line.startsWith("CANVAS=")) {
                    String rest = line.substring("CANVAS=".length()).trim();
                    String[] parts2 = rest.split(",");
                    if (parts2.length != 2) continue;
                    loadedCanvasW = Integer.parseInt(parts2[0]);
                    loadedCanvasH = Integer.parseInt(parts2[1]);
                    continue;
                }
                if (line.startsWith("SPRITEDIR=")) {
                    spriteDirPath = line.substring("SPRITEDIR=".length()).trim();
                    continue;
                }
                if (!line.startsWith("E|") || (parts = line.split("\\|", -1)).length < 14) continue;
                ElementType type2 = ElementType.valueOf(parts[1]);
                int x = Integer.parseInt(parts[2]);
                int y = Integer.parseInt(parts[3]);
                int w = Integer.parseInt(parts[4]);
                int h2 = Integer.parseInt(parts[5]);
                int col = Integer.parseInt(parts[6], 16);
                int fontIdx = Integer.parseInt(parts[7]);
                boolean centered = Boolean.parseBoolean(parts[8]);
                boolean shadow = Boolean.parseBoolean(parts[9]);
                int spriteId = Integer.parseInt(parts[10]);
                int spriteHoverId = Integer.parseInt(parts[11]);
                String buttonLabel = this.unsafed(parts[12]);
                String text = this.unsafed(parts[13]);
                UIElement el = new UIElement(type2, x, y, w, h2);
                el.textColor = col;
                el.fontIndex = fontIdx;
                el.centered = centered;
                el.shadow = shadow;
                el.spriteId = spriteId;
                el.spriteHoverId = spriteHoverId;
                el.buttonLabel = buttonLabel;
                el.text = text;
                loaded.add(el);
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Failed to load: " + ex.getMessage(), "Error", 0);
            return;
        }
        this.listModel.clear();
        for (UIElement el : loaded) {
            this.listModel.addElement(el);
        }
        this.selected = null;
        this.canvas.setSelected(null);
        this.canvas.repaint();
        this.exportArea.setText("");
        this.currentFile = f;
        this.lastBaseId = loadedBaseId;
        this.canvasWidth = loadedCanvasW;
        this.canvasHeight = loadedCanvasH;
        this.canvas.setPreferredSize(new Dimension(this.canvasWidth, this.canvasHeight));
        this.canvas.revalidate();
        if (spriteDirPath != null && !spriteDirPath.isEmpty() && (dir = new File(spriteDirPath)).isDirectory()) {
            try {
                this.spriteManager.loadFromDir(dir);
                if (this.spriteBrowser != null) {
                    this.spriteBrowser.refreshList();
                }
                this.status("Loaded sprites from: " + dir.getName());
            }
            catch (IOException ex) {
                this.status("Loaded layout, but failed to load sprites: " + ex.getMessage());
            }
        }
        this.status("Loaded project: " + f.getName());
    }

    private String safe(String s2) {
        if (s2 == null) {
            return "";
        }
        return s2.replace("\n", "\\n");
    }

    private String unsafed(String s2) {
        if (s2 == null) {
            return "";
        }
        return s2.replace("\\n", "\n");
    }

    private void chooseSpriteDir() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select your spritesdump folder (with 0.png, 1.png, ...)");
        chooser.setFileSelectionMode(1);
        int result2 = chooser.showOpenDialog(this);
        if (result2 != 0) {
            return;
        }
        File dir = chooser.getSelectedFile();
        this.loadSpritesFromDir(dir);
    }

    private void loadSpritesFromDir(File dir) {
        try {
            this.spriteManager.loadFromDir(dir);
            if (this.spriteBrowser != null) {
                this.spriteBrowser.refreshList();
            }
            this.canvas.repaint();
            this.updateSpritePreviews();
            this.status("Loaded " + this.spriteManager.getSpriteCount() + " sprites from " + dir.getAbsolutePath());
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Failed to load sprites: " + ex.getMessage(), "Error", 0);
        }
    }

    private void importFromJavaDialog() {
        if (!this.confirmDiscardChanges()) {
            return;
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select widget impl Java file (e.g. FactionWidget.java)");
        int result2 = chooser.showOpenDialog(this);
        if (result2 != 0) {
            return;
        }
        File f = chooser.getSelectedFile();
        this.importFromJavaFile(f);
    }

    private void importFromJavaFile(File file) {
        String src;
        try {
            src = RspsInterfaceEditor.readAll(file);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Failed to read file: " + ex.getMessage(), "Error", 0);
            return;
        }
        LinkedHashMap<String, Integer> consts = new LinkedHashMap<String, Integer>();
        Pattern constPattern = Pattern.compile("public\\s+static\\s+final\\s+int\\s+([A-Z0-9_]+)\\s*=\\s*(\\d+)\\s*;", 8);
        Matcher constMatcher = constPattern.matcher(src);
        while (constMatcher.find()) {
            String name = constMatcher.group(1);
            int value = Integer.parseInt(constMatcher.group(2));
            consts.put(name, value);
        }
        if (consts.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No 'public static final int' constants found in file.", "Import error", 0);
            return;
        }
        ArrayList keys2 = new ArrayList(consts.keySet());
        keys2.sort((a, b) -> {
            boolean ab = a.endsWith("_BASE");
            boolean bb = b.endsWith("_BASE");
            if (ab && !bb) {
                return -1;
            }
            if (!ab && bb) {
                return 1;
            }
            return a.compareTo((String)b);
        });
        String baseConst = (String)JOptionPane.showInputDialog(this, "Pick BASE constant to import (e.g. SELECT_BASE, PANEL_BASE, VIEW_BASE):", "Pick BASE", -1, null, keys2.toArray(), keys2.get(0));
        if (baseConst == null) {
            return;
        }
        Integer baseValue = (Integer)consts.get(baseConst);
        if (baseValue == null) {
            JOptionPane.showMessageDialog(this, "Selected base constant not found.", "Import error", 0);
            return;
        }
        this.lastBaseId = baseValue;
        this.status("Importing from " + file.getName() + " using base " + baseConst + " = " + baseValue);
        HashMap<Integer, ImportedElementDef> defs = new HashMap<Integer, ImportedElementDef>();
        HashMap<Integer, Point> positions = new HashMap<Integer, Point>();
        String baseRegex = Pattern.quote(baseConst);
        int flags = 32;
        Pattern textPattern = Pattern.compile("addText\\s*\\(\\s*" + baseRegex + "\\s*\\+\\s*(\\d+)\\s*,\\s*\"([^\"]*)\"\\s*,\\s*(0x[0-9A-Fa-f]+)\\s*,\\s*(true|false)\\s*,\\s*(true|false)\\s*,\\s*(\\d+)\\s*,\\s*font\\s*,\\s*(\\d+)\\s*\\)", flags);
        Matcher textMatcher = textPattern.matcher(src);
        while (textMatcher.find()) {
            int offset = Integer.parseInt(textMatcher.group(1));
            String text = textMatcher.group(2);
            int color = (int)Long.parseLong(textMatcher.group(3).substring(2), 16);
            boolean centered = Boolean.parseBoolean(textMatcher.group(4));
            boolean shadow = Boolean.parseBoolean(textMatcher.group(5));
            int width = Integer.parseInt(textMatcher.group(6));
            int fontIdx = Integer.parseInt(textMatcher.group(7));
            ImportedElementDef d = new ImportedElementDef();
            d.kind = ImportedKind.TEXT;
            d.offset = offset;
            d.text = text;
            d.textColor = color;
            d.centered = centered;
            d.shadow = shadow;
            d.width = width;
            d.fontIndex = fontIdx;
            defs.put(offset, d);
        }
        Pattern spritePattern = Pattern.compile("addSpriteLoader\\s*\\(\\s*" + baseRegex + "\\s*\\+\\s*(\\d+)\\s*,\\s*([A-Za-z0-9_]+)\\s*\\)", flags);
        Matcher spriteMatcher = spritePattern.matcher(src);
        while (spriteMatcher.find()) {
            int spriteId;
            int offset = Integer.parseInt(spriteMatcher.group(1));
            String spriteArg = spriteMatcher.group(2);
            if (consts.containsKey(spriteArg)) {
                spriteId = (Integer)consts.get(spriteArg);
            } else {
                try {
                    spriteId = Integer.parseInt(spriteArg);
                }
                catch (NumberFormatException e) {
                    continue;
                }
            }
            ImportedElementDef d = new ImportedElementDef();
            d.kind = ImportedKind.SPRITE;
            d.offset = offset;
            d.spriteId = spriteId;
            defs.put(offset, d);
        }
        Pattern buttonPattern = Pattern.compile("configHoverButton\\s*\\(\\s*" + baseRegex + "\\s*\\+\\s*(\\d+)\\s*,\\s*\"([^\"]*)\"\\s*,\\s*([A-Za-z0-9_]+)\\s*,\\s*([A-Za-z0-9_]+)\\s*,\\s*([A-Za-z0-9_]+)\\s*,\\s*([A-Za-z0-9_]+)\\s*,\\s*(true|false)", flags);
        Matcher buttonMatcher = buttonPattern.matcher(src);
        while (buttonMatcher.find()) {
            int offset = Integer.parseInt(buttonMatcher.group(1));
            String label = buttonMatcher.group(2);
            String sprite1 = buttonMatcher.group(3);
            String sprite2 = buttonMatcher.group(4);
            int sp1 = RspsInterfaceEditor.resolveConstOrInt(sprite1, consts);
            int sp2 = RspsInterfaceEditor.resolveConstOrInt(sprite2, consts);
            ImportedElementDef d = new ImportedElementDef();
            d.kind = ImportedKind.BUTTON;
            d.offset = offset;
            d.buttonLabel = label;
            d.spriteId = sp1;
            d.spriteHoverId = sp2;
            d.text = label;
            d.textColor = 0xFFFFFF;
            defs.put(offset, d);
        }
        Pattern childPattern = Pattern.compile("w\\.child\\s*\\(\\s*child\\+\\+\\s*,\\s*" + baseRegex + "\\s*\\+\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*\\)", flags);
        Matcher childMatcher = childPattern.matcher(src);
        while (childMatcher.find()) {
            int offset = Integer.parseInt(childMatcher.group(1));
            int x = Integer.parseInt(childMatcher.group(2));
            int y = Integer.parseInt(childMatcher.group(3));
            positions.put(offset, new Point(x, y));
        }
        if (defs.isEmpty() || positions.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No matching elements/children found for base " + baseConst + ".", "Import", 2);
        }
        this.listModel.clear();
        block14: for (Map.Entry e : defs.entrySet()) {
            UIElement el;
            int offset = (Integer)e.getKey();
            ImportedElementDef def = (ImportedElementDef)e.getValue();
            Point pos = (Point)positions.get(offset);
            if (pos == null) continue;
            switch (def.kind) {
                case TEXT: {
                    el = new UIElement(ElementType.TEXT, pos.x, pos.y, def.width > 0 ? def.width : 150, 20);
                    el.text = def.text;
                    el.textColor = def.textColor;
                    el.centered = def.centered;
                    el.shadow = def.shadow;
                    el.fontIndex = def.fontIndex;
                    break;
                }
                case SPRITE: {
                    BufferedImage img = def.spriteId >= 0 ? this.spriteManager.get(def.spriteId) : null;
                    int w = img != null ? img.getWidth() : 40;
                    int h2 = img != null ? img.getHeight() : 40;
                    el = new UIElement(ElementType.SPRITE, pos.x, pos.y, w, h2);
                    el.spriteId = def.spriteId;
                    break;
                }
                case BUTTON: {
                    BufferedImage img = def.spriteId >= 0 ? this.spriteManager.get(def.spriteId) : null;
                    int w = img != null ? img.getWidth() : 80;
                    int h2 = img != null ? img.getHeight() : 24;
                    el = new UIElement(ElementType.BUTTON, pos.x, pos.y, w, h2);
                    el.buttonLabel = def.buttonLabel;
                    el.text = def.buttonLabel;
                    el.spriteId = def.spriteId;
                    el.spriteHoverId = def.spriteHoverId;
                    el.textColor = def.textColor;
                    break;
                }
                default: {
                    continue block14;
                }
            }
            this.listModel.addElement(el);
        }
        this.selected = null;
        this.canvas.setSelected(null);
        this.canvas.repaint();
        this.exportArea.setText("");
        this.currentFile = null;
        this.canvasWidth = 512;
        this.canvasHeight = 334;
        this.canvas.setPreferredSize(new Dimension(this.canvasWidth, this.canvasHeight));
        this.canvas.revalidate();
        this.status("Imported " + this.listModel.size() + " elements from " + file.getName() + " using " + baseConst + " (" + baseValue + ").");
    }

    private static int resolveConstOrInt(String token, Map<String, Integer> consts) {
        Integer v = consts.get(token);
        if (v != null) {
            return v;
        }
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static String readAll(File f) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));){
            int len;
            char[] buf = new char[8192];
            while ((len = br.read(buf)) != -1) {
                sb.append(buf, 0, len);
            }
        }
        return sb.toString();
    }

    private void status(String msg) {
        this.statusLabel.setText(msg);
    }

    private void statusSelection() {
        if (this.selected == null) {
            this.status("No selection.");
        } else {
            this.status(String.valueOf((Object)this.selected.type) + " @(" + this.selected.x + "," + this.selected.y + ") size " + this.selected.width + "x" + this.selected.height);
        }
    }

    private class CanvasPanel
    extends JPanel {
        private UIElement selectedElement;
        private UIElement dragging;
        private int dragOffsetX;
        private int dragOffsetY;
        private final int gridSize = 16;

        public CanvasPanel() {
            MouseAdapter ma = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    UIElement hit;
                    CanvasPanel.this.selectedElement = hit = CanvasPanel.this.hitTest(e.getX(), e.getY());
                    RspsInterfaceEditor.this.selected = hit;
                    RspsInterfaceEditor.this.elementList.setSelectedValue(hit, true);
                    RspsInterfaceEditor.this.loadPropertiesFromSelection();
                    CanvasPanel.this.repaint();
                    if (hit != null && SwingUtilities.isLeftMouseButton(e)) {
                        CanvasPanel.this.dragging = hit;
                        CanvasPanel.this.dragOffsetX = e.getX() - hit.x;
                        CanvasPanel.this.dragOffsetY = e.getY() - hit.y;
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    CanvasPanel.this.dragging = null;
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (CanvasPanel.this.dragging != null) {
                        int newX = e.getX() - CanvasPanel.this.dragOffsetX;
                        int newY = e.getY() - CanvasPanel.this.dragOffsetY;
                        if (RspsInterfaceEditor.this.snapToGrid) {
                            newX = Math.round((float)newX / 16.0f) * 16;
                            newY = Math.round((float)newY / 16.0f) * 16;
                        }
                        CanvasPanel.this.dragging.x = newX;
                        CanvasPanel.this.dragging.y = newY;
                        RspsInterfaceEditor.this.spX.setValue(CanvasPanel.this.dragging.x);
                        RspsInterfaceEditor.this.spY.setValue(CanvasPanel.this.dragging.y);
                        CanvasPanel.this.repaint();
                        RspsInterfaceEditor.this.elementList.repaint();
                        RspsInterfaceEditor.this.statusSelection();
                    }
                }
            };
            this.addMouseListener(ma);
            this.addMouseMotionListener(ma);
        }

        public void setSelected(UIElement el) {
            this.selectedElement = el;
            this.repaint();
        }

        private UIElement hitTest(int x, int y) {
            for (int i = RspsInterfaceEditor.this.listModel.getSize() - 1; i >= 0; --i) {
                UIElement el = RspsInterfaceEditor.this.listModel.get(i);
                if (x < el.x || x > el.x + el.width || y < el.y || y > el.y + el.height) continue;
                return el;
            }
            return null;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(RspsInterfaceEditor.this.canvasWidth, RspsInterfaceEditor.this.canvasHeight);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            Graphics2D g22 = (Graphics2D)g2;
            g22.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (RspsInterfaceEditor.this.showGrid) {
                g22.setColor(new Color(60, 60, 60));
                for (int x = 0; x < this.getWidth(); x += 16) {
                    g22.drawLine(x, 0, x, this.getHeight());
                }
                for (int y = 0; y < this.getHeight(); y += 16) {
                    g22.drawLine(0, y, this.getWidth(), y);
                }
            }
            for (int i = 0; i < RspsInterfaceEditor.this.listModel.getSize(); ++i) {
                UIElement el;
                this.drawElement(g22, el, (el = RspsInterfaceEditor.this.listModel.get(i)) == this.selectedElement);
            }
        }

        private void drawElement(Graphics2D g2, UIElement el, boolean isSelected) {
            switch (el.type) {
                case TEXT: {
                    g2.setColor(new Color(0, 0, 0, 100));
                    g2.fillRect(el.x, el.y, el.width, el.height);
                    g2.setColor(new Color(200, 200, 200, 220));
                    g2.drawRect(el.x, el.y, el.width, el.height);
                    String text = el.text != null ? el.text : "";
                    g2.setColor(new Color(el.textColor));
                    Font font = g2.getFont().deriveFont(0, 12.0f);
                    g2.setFont(font);
                    FontMetrics fm = g2.getFontMetrics();
                    int textX = el.x + 3;
                    if (el.centered) {
                        textX = el.x + (el.width - fm.stringWidth(text)) / 2;
                    }
                    int textY = el.y + (el.height + fm.getAscent() - fm.getDescent()) / 2;
                    if (el.shadow) {
                        g2.setColor(Color.BLACK);
                        g2.drawString(text, textX + 1, textY + 1);
                        g2.setColor(new Color(el.textColor));
                    }
                    g2.drawString(text, textX, textY);
                    break;
                }
                case SPRITE: {
                    BufferedImage img;
                    BufferedImage bufferedImage = img = el.spriteId >= 0 ? RspsInterfaceEditor.this.spriteManager.get(el.spriteId) : null;
                    if (img != null) {
                        g2.drawImage((Image)img, el.x, el.y, null);
                        el.width = img.getWidth();
                        el.height = img.getHeight();
                        g2.setColor(new Color(255, 255, 255, 60));
                        g2.drawRect(el.x, el.y, el.width, el.height);
                        break;
                    }
                    g2.setColor(new Color(0, 90, 200, 120));
                    g2.fillRect(el.x, el.y, el.width, el.height);
                    g2.setColor(Color.CYAN);
                    g2.drawRect(el.x, el.y, el.width, el.height);
                    g2.setColor(Color.WHITE);
                    g2.drawString("Sprite " + el.spriteId, el.x + 4, el.y + 14);
                    break;
                }
                case BUTTON: {
                    BufferedImage btnImg;
                    BufferedImage bufferedImage = btnImg = el.spriteId >= 0 ? RspsInterfaceEditor.this.spriteManager.get(el.spriteId) : null;
                    if (btnImg != null) {
                        g2.drawImage((Image)btnImg, el.x, el.y, null);
                        el.width = btnImg.getWidth();
                        el.height = btnImg.getHeight();
                    } else {
                        g2.setColor(new Color(70, 70, 70));
                        g2.fillRoundRect(el.x, el.y, el.width, el.height, 10, 10);
                        g2.setColor(new Color(200, 200, 200));
                        g2.drawRoundRect(el.x, el.y, el.width, el.height, 10, 10);
                    }
                    String label = el.buttonLabel != null ? el.buttonLabel : "";
                    g2.setColor(new Color(el.textColor));
                    FontMetrics fmBtn = g2.getFontMetrics();
                    int tx = el.x + (el.width - fmBtn.stringWidth(label)) / 2;
                    int ty = el.y + (el.height + fmBtn.getAscent() - fmBtn.getDescent()) / 2;
                    g2.drawString(label, tx, ty);
                    g2.setColor(Color.GRAY);
                    g2.drawString("[" + el.spriteId + "/" + el.spriteHoverId + "]", el.x + 4, el.y + el.height - 4);
                    break;
                }
            }
            if (isSelected) {
                g2.setColor(Color.YELLOW);
                g2.drawRect(el.x - 2, el.y - 2, el.width + 4, el.height + 4);
            }
        }
    }

    private static class ImportedElementDef {
        ImportedKind kind;
        int offset;
        String text;
        int textColor;
        boolean centered;
        boolean shadow;
        int fontIndex;
        int width;
        int spriteId = -1;
        int spriteHoverId = -1;
        String buttonLabel;

        private ImportedElementDef() {
        }
    }

    private static enum ImportedKind {
        TEXT,
        SPRITE,
        BUTTON;

    }

    private static class SpriteBrowserPanel
    extends JPanel {
        private final SpriteManager spriteManager;
        private final RspsInterfaceEditor editor;
        private final JTextField searchField = new JTextField();
        private final DefaultListModel<SpriteEntry> model = new DefaultListModel();
        private final JList<SpriteEntry> list = new JList<SpriteEntry>(this.model);

        public SpriteBrowserPanel(SpriteManager manager, RspsInterfaceEditor editor) {
            super(new BorderLayout());
            this.spriteManager = manager;
            this.editor = editor;
            this.build();
        }

        private void build() {
            JPanel top = new JPanel(new BorderLayout(4, 4));
            top.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            top.add((Component)new JLabel("Search ID:"), "West");
            top.add((Component)this.searchField, "Center");
            this.searchField.getDocument().addDocumentListener(new SimpleDocumentListener(){

                @Override
                public void update(DocumentEvent e) {
                    this.filter();
                }
            });
            this.list.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> jList, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(jList, value, index, isSelected, cellHasFocus);
                    if (value instanceof SpriteEntry) {
                        SpriteEntry entry = (SpriteEntry)value;
                        this.setText("ID " + entry.id);
                        if (entry.img != null) {
                            if (entry.icon32 == null) {
                                entry.icon32 = new ImageIcon(entry.img.getScaledInstance(32, 32, 4));
                            }
                            this.setIcon(entry.icon32);
                        } else {
                            this.setIcon(null);
                        }
                    }
                    return this;
                }
            });
            this.list.setSelectionMode(0);
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SpriteEntry entry;
                    if (e.getClickCount() == 2 && (entry = list.getSelectedValue()) != null) {
                        editor.addSpriteFromBrowser(entry.id);
                    }
                }
            });
            JScrollPane scroll = new JScrollPane(this.list);
            scroll.setBorder(new TitledBorder("Spritesdump"));
            this.add((Component)top, "North");
            this.add((Component)scroll, "Center");
        }

        public void refreshList() {
            this.model.clear();
            for (int id : this.spriteManager.getSpriteIds()) {
                BufferedImage img = this.spriteManager.get(id);
                this.model.addElement(new SpriteEntry(id, img));
            }
        }

        private void filter() {
            String q = this.searchField.getText().trim();
            this.model.clear();
            if (q.isEmpty()) {
                this.refreshList();
                return;
            }
            int numeric = -1;
            try {
                numeric = Integer.parseInt(q);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            for (int id : this.spriteManager.getSpriteIds()) {
                if (numeric != -1) {
                    if (id != numeric && !String.valueOf(id).startsWith(q)) continue;
                    this.model.addElement(new SpriteEntry(id, this.spriteManager.get(id)));
                    continue;
                }
                if (!String.valueOf(id).contains(q)) continue;
                this.model.addElement(new SpriteEntry(id, this.spriteManager.get(id)));
            }
        }
    }

    private static class SpriteEntry {
        public final int id;
        public final BufferedImage img;
        public ImageIcon icon32;

        public SpriteEntry(int id, BufferedImage img) {
            this.id = id;
            this.img = img;
        }

        public String toString() {
            return String.valueOf(this.id);
        }
    }

    private static class SpriteManager {
        private final Map<Integer, BufferedImage> sprites = new HashMap<Integer, BufferedImage>();
        private final List<Integer> spriteIds = new ArrayList<Integer>();
        private File sourceDir;

        private SpriteManager() {
        }

        public void clear() {
            this.sprites.clear();
            this.spriteIds.clear();
            this.sourceDir = null;
        }

        public void loadFromDir(File dir) throws IOException {
            this.clear();
            if (dir == null || !dir.isDirectory()) {
                throw new IOException("Not a directory: " + String.valueOf(dir));
            }
            this.sourceDir = dir;
            File[] files = dir.listFiles();
            if (files == null) {
                return;
            }
            for (File f : files) {
                int id;
                String name;
                if (!f.isFile() || !(name = f.getName().toLowerCase()).endsWith(".png")) continue;
                String base = name.substring(0, name.length() - 4);
                try {
                    id = Integer.parseInt(base);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                BufferedImage img = ImageIO.read(f);
                if (img == null) continue;
                this.sprites.put(id, img);
                this.spriteIds.add(id);
            }
            Collections.sort(this.spriteIds);
        }

        public BufferedImage get(int id) {
            return this.sprites.get(id);
        }

        public List<Integer> getSpriteIds() {
            return Collections.unmodifiableList(this.spriteIds);
        }

        public int getSpriteCount() {
            return this.spriteIds.size();
        }

        public File getSourceDir() {
            return this.sourceDir;
        }
    }

    private static interface SimpleDocumentListener
    extends DocumentListener {
        public void update(DocumentEvent var1);

        @Override
        default public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        default public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        default public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }
    }

    public static class UIElement {
        public ElementType type;
        public int x;
        public int y;
        public int width;
        public int height;
        public String text = "Text";
        public int textColor = 0xFFFFFF;
        public int fontIndex = 0;
        public boolean centered = false;
        public boolean shadow = true;
        public int spriteId = -1;
        public int spriteHoverId = -1;
        public String buttonLabel = "Button";

        public UIElement(ElementType type2, int x, int y, int w, int h2) {
            this.type = type2;
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h2;
        }

        public String toString() {
            return String.valueOf((Object)this.type) + " @(" + this.x + "," + this.y + ")";
        }
    }

    public static enum ElementType {
        TEXT,
        SPRITE,
        BUTTON;

    }
}

