/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.cache.textures;

import com.hazy.cache.Archive;
import com.hazy.cache.textures.Texture;
import com.hazy.cache.textures.TextureLoader;
import com.hazy.collection.Deque;
import com.hazy.draw.TextureAnimationData;
import com.hazy.io.Buffer;
import net.runelite.rs.api.RSTexture;
import net.runelite.rs.api.RSTextureProvider;

public class TextureProvider
implements RSTextureProvider,
TextureLoader {
    private final Texture[] textures;
    private Deque deque = new Deque();
    private int capacity;
    private int remaining;
    private double brightness;
    private int textureSize;
    private final Archive archive;

    public TextureProvider(Archive textureArchive, Archive configArchive, int capacity, int textureSize) {
        int var9;
        this.archive = textureArchive;
        this.remaining = this.capacity = capacity;
        this.textureSize = textureSize;
        Buffer stream = new Buffer(configArchive.get("textures.dat"));
        int textureCount = 60;
        int customTextures = 120;
        this.textures = new Texture[textureCount + customTextures];
        for (var9 = 0; var9 < textureCount; ++var9) {
            Texture text;
            this.textures[text.id] = text = new Texture(stream);
        }
        for (var9 = textureCount; var9 < this.textures.length; ++var9) {
            Texture text;
            TextureAnimationData data2 = TextureAnimationData.getById(var9);
            int speed = data2 == null ? 0 : data2.getSpeed();
            int direction = data2 == null ? 0 : data2.getDirection();
            this.textures[text.id] = text = new Texture(var9, false, var9, speed, direction, 0);
        }
        this.setMaxSize(128);
        this.setSize(128);
    }

    @Override
    public double getBrightness() {
        return this.brightness;
    }

    @Override
    public void setBrightness(double brightness) {
        this.brightness = brightness;
        this.clear();
    }

    public void setTextureSize(int textureSize) {
        this.textureSize = textureSize;
        this.clear();
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.capacity = maxSize;
    }

    @Override
    public void setSize(int size) {
        this.remaining = size;
    }

    @Override
    public RSTexture[] getTextures() {
        return this.textures;
    }

    @Override
    public int[] load(int textureId) {
        return this.getTexturePixels(textureId);
    }

    @Override
    public int[] getTexturePixels(int textureID) {
        Texture texture = this.textures[textureID];
        if (texture != null) {
            if (texture.pixels != null) {
                this.deque.insertTail(texture);
                texture.isLoaded = true;
                return texture.pixels;
            }
            boolean hasLoaded = texture.load(this.brightness, this.textureSize, this.archive);
            if (hasLoaded) {
                if (this.remaining == 0) {
                    Texture currentTexture = (Texture)this.deque.popHead();
                    currentTexture.reset();
                } else {
                    --this.remaining;
                }
                this.deque.insertTail(texture);
                texture.isLoaded = true;
                return texture.pixels;
            }
        }
        return null;
    }

    @Override
    public int getAverageTextureRGB(int textureID) {
        return this.textures[textureID] != null ? this.textures[textureID].averageRGB : 0;
    }

    @Override
    public boolean isTransparent(int textureID) {
        return this.textures[textureID].isTransparent;
    }

    @Override
    public boolean isLowDetail(int textureID) {
        return this.textureSize == 64;
    }

    public void clear() {
        for (Texture texture : this.textures) {
            if (texture == null) continue;
            texture.reset();
        }
        this.deque = new Deque();
        this.remaining = this.capacity;
    }

    public void animate(int textureID) {
        for (Texture texture : this.textures) {
            if (texture == null || texture.animationDirection == 0 || !texture.isLoaded) continue;
            texture.animate(textureID);
            texture.isLoaded = false;
        }
    }
}

