/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.collection;

import com.hazy.collection.Node;

public final class HashTable {
    private final int size;
    private final Node[] cache;

    public HashTable() {
        this.size = 1024;
        this.cache = new Node[this.size];
        for (int index = 0; index < this.size; ++index) {
            Node node;
            node.prev = node = (this.cache[index] = new Node());
            node.next = node;
        }
    }

    public Node get(long key) {
        Node bucket = this.cache[(int)(key & (long)(this.size - 1))];
        Node node = bucket.prev;
        while (node != bucket) {
            if (node.key == key) {
                return node;
            }
            node = node.prev;
        }
        return null;
    }

    public void clear() {
        for (int id = 0; id < this.size; ++id) {
            Node next2;
            Node link = this.cache[id];
            while (link != (next2 = link.next)) {
                next2.remove();
            }
        }
    }

    public void put(Node node, long key) {
        if (node.next != null) {
            node.remove();
        }
        Node bucket = this.cache[(int)(key & (long)(this.size - 1))];
        node.next = bucket.next;
        node.prev = bucket;
        node.next.prev = node;
        node.prev.next = node;
        node.key = key;
    }
}

