/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.collection;

import com.hazy.collection.Node;
import java.util.Iterator;
import net.runelite.rs.api.RSNode;
import net.runelite.rs.api.RSNodeDeque;

public final class LinkedList
implements RSNodeDeque {
    public final Node head;
    private Node current;

    public void transfer(LinkedList list) {
        Node start = this.head.prev;
        Node prev = this.head.next;
        this.head.next = start.next;
        start.next.prev = this.head;
        if (this.head == start) {
            return;
        }
        start.next = list.head.next;
        start.next.prev = start;
        prev.prev = list.head;
        list.head.next = prev;
    }

    public LinkedList() {
        this.head.prev = this.head = new Node();
        this.head.next = this.head;
    }

    public void insertBack(Node node) {
        if (node.next != null) {
            node.remove();
        }
        node.next = this.head.next;
        node.prev = this.head;
        node.next.prev = node;
        node.prev.next = node;
    }

    public void addFirst(Node node) {
        if (node == null) {
            return;
        }
        if (node.next != null) {
            node.remove();
        }
        node.next = this.head;
        node.prev = this.head.prev;
        node.next.prev = node;
        node.prev.next = node;
    }

    public void insert(Node node) {
        if (node.prev != null) {
            node.remove();
        }
        node.prev = this.head.prev;
        node.next = this.head;
        node.prev.next = node;
        node.next.prev = node;
    }

    public Node get() {
        Node node = this.head.next;
        if (node == this.head) {
            return null;
        }
        node.remove();
        return node;
    }

    public Node pop() {
        Node node = this.head.prev;
        if (node == this.head) {
            return null;
        }
        node.remove();
        return node;
    }

    public Node first() {
        Node node = this.head.prev;
        if (node == this.head) {
            this.current = null;
            return null;
        }
        this.current = node.prev;
        return node;
    }

    @Override
    public RSNode getCurrent() {
        return this.current;
    }

    @Override
    public RSNode getSentinel() {
        return this.head;
    }

    @Override
    public Node last() {
        Node node = this.head.next;
        if (node == this.head) {
            this.current = null;
            return null;
        }
        this.current = node.next;
        return node;
    }

    public Node next() {
        Node node = this.current;
        if (node == this.head) {
            this.current = null;
            return null;
        }
        this.current = node.prev;
        return node;
    }

    @Override
    public Node previous() {
        Node node = this.current;
        if (node == this.head) {
            this.current = null;
            return null;
        }
        this.current = node.next;
        return node;
    }

    @Override
    public void addFirst(RSNode val) {
    }

    @Override
    public RSNode removeLast() {
        return null;
    }

    @Override
    public void clear() {
        if (this.head.prev == this.head) {
            return;
        }
        Node node;
        while ((node = this.head.prev) != this.head) {
            node.remove();
        }
        return;
    }

    public Node reverseGetFirst() {
        Node node = this.head.next;
        if (node == this.head) {
            this.current = null;
            return null;
        }
        this.current = node.next;
        return node;
    }

    public Node reverseGetNext() {
        Node node = this.current;
        if (node == this.head) {
            this.current = null;
            return null;
        }
        this.current = node.next;
        return node;
    }

    @Override
    public Iterator iterator() {
        return null;
    }
}

