/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.collection;

import com.hazy.collection.Cacheable;
import com.hazy.collection.HashTable;
import com.hazy.collection.Queue;
import com.hazy.sign.SignLink;

public final class TempCache {
    private final Cacheable empty = new Cacheable();
    private final int capacity;
    private int spaceLeft;
    private final HashTable table;
    private final Queue references = new Queue();

    public TempCache(int i) {
        this.capacity = i;
        this.spaceLeft = i;
        this.table = new HashTable();
    }

    public Cacheable get(long key) {
        Cacheable cacheable = (Cacheable)this.table.get(key);
        if (cacheable != null) {
            this.references.insertHead(cacheable);
        }
        return cacheable;
    }

    public void put(Cacheable node, long key) {
        try {
            if (this.spaceLeft == 0) {
                Cacheable front = this.references.popTail();
                front.remove();
                front.unlinkCacheable();
                if (front == this.empty) {
                    front = this.references.popTail();
                    front.remove();
                    front.unlinkCacheable();
                }
            } else {
                --this.spaceLeft;
            }
            this.table.put(node, key);
            this.references.insertHead(node);
            return;
        }
        catch (RuntimeException runtimeexception) {
            SignLink.reporterror("47547, " + String.valueOf(node) + ", " + key + ", 2, " + runtimeexception.toString());
            throw new RuntimeException();
        }
    }

    public void clear() {
        Cacheable front;
        while ((front = this.references.popTail()) != null) {
            front.remove();
            front.unlinkCacheable();
        }
        this.spaceLeft = this.capacity;
    }
}

