/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.draw;

import com.hazy.Client;
import com.hazy.draw.AbstractRasterProvider;
import com.hazy.draw.Rasterizer2D;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import net.runelite.rs.api.RSRasterProvider;

public class ProducingGraphicsBuffer
extends AbstractRasterProvider
implements RSRasterProvider {
    private Component component;
    private Image image;

    public ProducingGraphicsBuffer(int width, int height, Component component, boolean pixelsFloat) {
        this.width = width;
        this.height = height;
        this.pixels = new int[height * width + 1];
        this.pixelsFloat = new float[width * height + 1];
        DataBufferInt var4 = new DataBufferInt(this.pixels, this.pixels.length);
        DirectColorModel var5 = new DirectColorModel(32, 0xFF0000, 65280, 255);
        WritableRaster var6 = Raster.createWritableRaster(var5.createCompatibleSampleModel(this.width, this.height), var4, null);
        this.image = new BufferedImage(var5, var6, false, new Hashtable());
        this.init();
        this.setComponent(component);
        this.init(this.width, this.height, component, pixelsFloat);
    }

    public void init(int width, int height, Component canvas, boolean pixelsFloat) {
        if (!Client.instance.isGpu()) {
            return;
        }
        int[] pixels = this.getPixels();
        DataBufferInt dataBufferInt = new DataBufferInt(pixels, pixels.length);
        DirectColorModel directColorModel = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
        WritableRaster writableRaster = Raster.createWritableRaster(directColorModel.createCompatibleSampleModel(width, height), dataBufferInt, null);
        BufferedImage bufferedImage = new BufferedImage(directColorModel, writableRaster, true, new Hashtable());
        this.setImage(bufferedImage);
    }

    public final void setComponent(Component var1) {
        this.component = var1;
    }

    public void draw(int var1, int var2) {
        this.drawFull0(this.component.getGraphics(), var1, var2);
    }

    @Override
    public final void drawFull(int var1, int var2) {
        this.drawFull0(this.component.getGraphics(), var1, var2);
    }

    @Override
    public final void draw(int var1, int var2, int var3, int var4) {
        this.draw0(this.component.getGraphics(), var1, var2, var3, var4);
    }

    private final void drawFull0(Graphics var1, int var2, int var3) {
        Client.instance.getCallbacks().draw(this, var1, var2, var3);
    }

    final void draw0(Graphics var1, int var2, int var3, int var4, int var5) {
        try {
            Shape var6 = var1.getClip();
            var1.clipRect(var2, var3, var4, var5);
            var1.drawImage(this.image, 0, 0, this.component);
            var1.setClip(var6);
        }
        catch (Exception var7) {
            this.component.repaint();
        }
    }

    @Override
    public int[] getPixels() {
        return this.pixels;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setRaster() {
        Rasterizer2D.initDrawingArea(this.height, this.width, this.pixels, this.pixelsFloat);
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    @Override
    public void setImage(Image image) {
        this.image = image;
    }

    @Override
    public Component getCanvas() {
        return this.component;
    }
}

