/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.draw;

import com.hazy.Client;
import com.hazy.cache.graphics.SimpleImage;
import com.hazy.collection.Cacheable;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.util.Arrays;
import java.util.Hashtable;

public class Rasterizer2D
extends Cacheable {
    private static final ColorModel COLOR_MODEL = new DirectColorModel(32, 0xFF0000, 65280, 255);
    public static int[] pixels;
    public static int width;
    public static int height;
    public static int topY;
    public static int bottomY;
    public static int leftX;
    public static int bottomX;
    public static int lastX;
    public static int viewportCenterX;
    public static int viewportCenterY;
    public static float[] depth_buffer;

    public static void fillCircleAlpha(int centerX, int centerY, int radius, int color, int alpha) {
        int rSquared = radius * radius;
        int startY = Math.max(centerY - radius, topY);
        int endY = Math.min(centerY + radius, bottomY);
        for (int y = startY; y < endY; ++y) {
            int dy = y - centerY;
            int dxLimit = (int)Math.sqrt(rSquared - dy * dy);
            int startX = Math.max(centerX - dxLimit, leftX);
            int endX = Math.min(centerX + dxLimit, bottomX);
            int index = startX + y * width;
            for (int x = startX; x < endX; ++x) {
                Rasterizer2D.drawAlpha(pixels, index++, color, alpha);
            }
        }
    }

    public static void drawProgressBarRainbow(int x, int y, int width, int height, int currentPercent, float rotationPercent, boolean reversed) {
        currentPercent = Math.max(0, Math.min(100, currentPercent));
        rotationPercent = Math.max(-100.0f, Math.min(100.0f, rotationPercent));
        double theta = Math.toRadians((double)rotationPercent * 0.45);
        double m4 = Math.tan(theta);
        if (reversed) {
            m4 = -m4;
        }
        int pad = (int)Math.ceil(Math.abs(m4 * (double)width)) + 4;
        int imgW = width + 4;
        int imgH = height + pad * 2;
        BufferedImage img = new BufferedImage(imgW, imgH, 2);
        Graphics2D g2 = img.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int baseY = pad;
        int x0 = 0;
        int x1 = width;
        int y0_top = baseY;
        int y0_bot = baseY + height;
        int dy = (int)Math.round(m4 * (double)width);
        int y1_top = y0_top - dy;
        int y1_bot = y0_bot - dy;
        Polygon bg = new Polygon(new int[]{x0, x1, x1, x0}, new int[]{y0_bot, y1_bot, y1_top, y0_top}, 4);
        g2.setComposite(AlphaComposite.Src);
        g2.setColor(new Color(30, 30, 30));
        g2.fill(bg);
        g2.setComposite(AlphaComposite.SrcOver);
        g2.setColor(new Color(0, 0, 0, 180));
        g2.setStroke(new BasicStroke(1.5f));
        g2.draw(bg);
        int fillWidth = (int)Math.round((double)width * ((double)currentPercent / 100.0));
        if (fillWidth > 0) {
            int rightEdge;
            int leftEdge;
            if (!reversed) {
                leftEdge = x0;
                rightEdge = x0 + fillWidth;
            } else {
                leftEdge = x1 - fillWidth;
                rightEdge = x1;
            }
            int leftDy = (int)Math.round(m4 * (double)(leftEdge - x0));
            int rightDy = (int)Math.round(m4 * (double)(rightEdge - x0));
            Polygon fillShape = new Polygon(new int[]{leftEdge, rightEdge, rightEdge, leftEdge}, new int[]{y0_bot - leftDy, y0_bot - rightDy, y0_top - rightDy, y0_top - leftDy}, 4);
            long t2 = System.currentTimeMillis();
            float hue = (float)(t2 % 5000L) / 5000.0f;
            Color c1 = Color.getHSBColor(hue, 0.9f, 1.0f);
            Color c2 = Color.getHSBColor((hue + 0.15f) % 1.0f, 0.9f, 1.0f);
            GradientPaint gp = new GradientPaint(leftEdge, y0_top - leftDy, c1, rightEdge, y0_top - rightDy, c2, false);
            g2.setComposite(AlphaComposite.Src);
            g2.setPaint(gp);
            g2.fill(fillShape);
            g2.setComposite(AlphaComposite.SrcOver);
            float phase = (float)(t2 % 1600L) / 1600.0f;
            int sx = Math.round((float)leftEdge + (float)(rightEdge - leftEdge) * phase);
            int sy = Math.round((float)(y0_top - leftDy) + (float)(y0_top - rightDy - (y0_top - leftDy)) * phase);
            double dx = rightEdge - leftEdge;
            double dySlope = y0_top - rightDy - (y0_top - leftDy);
            double len = Math.sqrt(dx * dx + dySlope * dySlope);
            double nx = dx / len;
            double ny = dySlope / len;
            GradientPaint shimmer = new GradientPaint((float)((double)sx - nx * 40.0), (float)((double)sy - ny * 40.0), new Color(255, 255, 255, 80), (float)((double)sx + nx * 40.0), (float)((double)sy + ny * 40.0), new Color(255, 255, 255, 0), false);
            g2.setPaint(shimmer);
            g2.fill(fillShape);
        }
        g2.dispose();
        int[] offscreen = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        int screenW = Rasterizer2D.width;
        int srcIndex = 0;
        for (int yy = 0; yy < imgH; ++yy) {
            int destY = y + yy - pad;
            if (destY < 0 || destY >= Rasterizer2D.height) continue;
            int dest = destY * screenW + x;
            for (int xx = 0; xx < imgW; ++xx) {
                int argb;
                int destX = x + xx;
                if (destX < 0 || destX >= screenW || (argb = offscreen[srcIndex++]) >>> 24 == 0) continue;
                Rasterizer2D.pixels[dest + xx] = argb | 0xFF000000;
            }
        }
    }

    private static void fillPolygon(int[] xPoints, int[] yPoints, int nPoints, int color, int alpha) {
        if (nPoints < 3) {
            return;
        }
        int minY = yPoints[0];
        int maxY = yPoints[0];
        for (int i = 1; i < nPoints; ++i) {
            if (yPoints[i] < minY) {
                minY = yPoints[i];
            }
            if (yPoints[i] <= maxY) continue;
            maxY = yPoints[i];
        }
        for (int y = minY; y <= maxY; ++y) {
            int intersections = 0;
            int[] nodeX = new int[nPoints];
            int i = 0;
            int j = nPoints - 1;
            while (i < nPoints) {
                if (yPoints[i] < y && yPoints[j] >= y || yPoints[j] < y && yPoints[i] >= y) {
                    nodeX[intersections++] = xPoints[i] + (y - yPoints[i]) * (xPoints[j] - xPoints[i]) / (yPoints[j] - yPoints[i]);
                }
                j = i++;
            }
            Arrays.sort(nodeX, 0, intersections);
            for (i = 0; i < intersections && i + 1 < intersections; i += 2) {
                int x1 = nodeX[i];
                int x2 = nodeX[i + 1];
                Rasterizer2D.drawHorizontalLine(x1, y, x2 - x1, color, alpha);
            }
        }
    }

    public static void drawBox(int leftX, int topY, int width, int height, int rgbColour) {
        if (leftX < Rasterizer2D.leftX) {
            width -= Rasterizer2D.leftX - leftX;
            leftX = Rasterizer2D.leftX;
        }
        if (topY < Rasterizer2D.topY) {
            height -= Rasterizer2D.topY - topY;
            topY = Rasterizer2D.topY;
        }
        if (leftX + width > bottomX) {
            width = bottomX - leftX;
        }
        if (topY + height > bottomY) {
            height = bottomY - topY;
        }
        int leftOver = Rasterizer2D.width - width;
        int pixelIndex = leftX + topY * Rasterizer2D.width;
        for (int rowIndex = 0; rowIndex < height; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < width; ++columnIndex) {
                Rasterizer2D.drawAlpha(pixels, pixelIndex++, rgbColour, 255);
            }
            pixelIndex += leftOver;
        }
    }

    public static void drawAlpha(int[] pixels, int index, int value) {
        Rasterizer2D.drawAlpha(pixels, index, value, 255);
    }

    public static void drawAlpha(int[] pixels, int index, int value, int alpha) {
        if (!Client.instance.isGpu() || pixels != Client.instance.getBufferProvider().getPixels()) {
            pixels[index] = value;
            return;
        }
        int outAlpha = alpha + ((pixels[index] >>> 24) * (255 - alpha) * 32897 >>> 23);
        pixels[index] = value & 0xFFFFFF | outAlpha << 24;
    }

    public static void setDrawingArea(int bottomY, int leftX, int rightX, int topY) {
        if (leftX < 0) {
            leftX = 0;
        }
        if (topY < 0) {
            topY = 0;
        }
        if (rightX > width) {
            rightX = width;
        }
        if (bottomY > height) {
            bottomY = height;
        }
        Rasterizer2D.leftX = leftX;
        Rasterizer2D.topY = topY;
        bottomX = rightX;
        Rasterizer2D.bottomY = bottomY;
        lastX = bottomX;
        viewportCenterX = bottomX / 2;
        viewportCenterY = Rasterizer2D.bottomY / 2;
    }

    public static void initDrawingArea(int height, int width, int[] pixels, float[] depth) {
        depth_buffer = depth;
        Rasterizer2D.pixels = pixels;
        Rasterizer2D.width = width;
        Rasterizer2D.height = height;
        Rasterizer2D.setDrawingArea(height, 0, width, 0);
    }

    public static void init(int width, int height, int[] pixels, float[] depth) {
        Rasterizer2D.initDrawingArea(height, width, pixels, depth);
    }

    public static void draw_arc(int x, int y, int width, int height, int stroke, int start, int sweep, int color, int alpha, int closure, boolean fill) {
        Graphics2D graphics = SimpleImage.createGraphics(pixels, Rasterizer2D.width, Rasterizer2D.height);
        graphics.setColor(new Color(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, alpha >= 256 || alpha < 0 ? 255 : alpha));
        RenderingHints render2 = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        render2.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics.setRenderingHints(render2);
        graphics.setComposite(AlphaComposite.getInstance(3, 1.0f));
        if (!fill) {
            graphics.setStroke(new BasicStroke(stroke < 1 ? 1 : stroke));
        }
        Arc2D.Double arc = new Arc2D.Double(x + stroke, y + stroke, width, height, start, sweep, closure);
        if (fill) {
            graphics.fill(arc);
        } else {
            graphics.draw(arc);
        }
    }

    public static Graphics2D createGraphics(boolean renderingHints) {
        Graphics2D g2d = Rasterizer2D.createGraphics(pixels, width, height);
        if (renderingHints) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        return g2d;
    }

    public static Graphics2D createGraphics(int[] pixels, int width, int height) {
        return new BufferedImage(COLOR_MODEL, Raster.createWritableRaster(COLOR_MODEL.createCompatibleSampleModel(width, height), new DataBufferInt(pixels, width * height), null), false, new Hashtable()).createGraphics();
    }

    public static Shape createSector(int x, int y, int r, int angle) {
        return new Arc2D.Double(x, y, r, r, 90.0, -angle, 2);
    }

    public static Shape createCircle(int x, int y, int r) {
        return new Ellipse2D.Double(x, y, r, r);
    }

    public static void drawTransparentGradientBox(int leftX, int topY, int width, int height, int topColour, int bottomColour, int opacity) {
        int gradientProgress = 0;
        int progressPerPixel = 65536 / height;
        if (leftX < Rasterizer2D.leftX) {
            width -= Rasterizer2D.leftX - leftX;
            leftX = Rasterizer2D.leftX;
        }
        if (topY < Rasterizer2D.topY) {
            gradientProgress += (Rasterizer2D.topY - topY) * progressPerPixel;
            height -= Rasterizer2D.topY - topY;
            topY = Rasterizer2D.topY;
        }
        if (leftX + width > bottomX) {
            width = bottomX - leftX;
        }
        if (topY + height > bottomY) {
            height = bottomY - topY;
        }
        int leftOver = Rasterizer2D.width - width;
        int transparency = 256 - opacity;
        int pixelIndex = leftX + topY * Rasterizer2D.width;
        for (int rowIndex = 0; rowIndex < height; ++rowIndex) {
            int gradient = 65536 - gradientProgress >> 8;
            int inverseGradient = gradientProgress >> 8;
            int gradientColour = ((topColour & 0xFF00FF) * gradient + (bottomColour & 0xFF00FF) * inverseGradient & 0xFF00FF00) + ((topColour & 0xFF00) * gradient + (bottomColour & 0xFF00) * inverseGradient & 0xFF0000) >>> 8;
            int transparentPixel = ((gradientColour & 0xFF00FF) * opacity >> 8 & 0xFF00FF) + ((gradientColour & 0xFF00) * opacity >> 8 & 0xFF00);
            for (int columnIndex = 0; columnIndex < width; ++columnIndex) {
                int backgroundPixel = pixels[pixelIndex];
                backgroundPixel = ((backgroundPixel & 0xFF00FF) * transparency >> 8 & 0xFF00FF) + ((backgroundPixel & 0xFF00) * transparency >> 8 & 0xFF00);
                Rasterizer2D.drawAlpha(pixels, pixelIndex++, transparentPixel + backgroundPixel, opacity);
            }
            pixelIndex += leftOver;
            gradientProgress += progressPerPixel;
        }
    }

    public static void set_clip(int x, int y, int width, int height) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (width > Rasterizer2D.width) {
            width = Rasterizer2D.width;
        }
        if (height > Rasterizer2D.height) {
            height = Rasterizer2D.height;
        }
        leftX = x;
        topY = y;
        bottomX = width;
        bottomY = height;
        lastX = bottomX;
        viewportCenterX = bottomX / 2;
        viewportCenterY = bottomY / 2;
    }

    public static void clear() {
        int size = width * height;
        for (int coordinates = 0; coordinates < size; ++coordinates) {
            Rasterizer2D.pixels[coordinates] = 0;
            Rasterizer2D.depth_buffer[coordinates] = Float.MAX_VALUE;
        }
    }

    public static void draw_filled_rect(int x, int y, int width, int height, int color) {
        Rasterizer2D.drawTransparentBox(x, y, width, height, color, 255);
    }

    public static void drawBoxOutline(int leftX, int topY, int width, int height, int rgbColour) {
        Rasterizer2D.drawHorizontalLine(leftX, topY, width, rgbColour);
        Rasterizer2D.drawHorizontalLine(leftX, topY + height - 1, width, rgbColour);
        Rasterizer2D.drawVerticalLine(leftX, topY, height, rgbColour);
        Rasterizer2D.drawVerticalLine(leftX + width - 1, topY, height, rgbColour);
    }

    public static void drawTransparentBox(int leftX, int topY, int width, int height, int rgbColour, int opacity) {
        if (leftX < Rasterizer2D.leftX) {
            width -= Rasterizer2D.leftX - leftX;
            leftX = Rasterizer2D.leftX;
        }
        if (topY < Rasterizer2D.topY) {
            height -= Rasterizer2D.topY - topY;
            topY = Rasterizer2D.topY;
        }
        if (leftX + width > bottomX) {
            width = bottomX - leftX;
        }
        if (topY + height > bottomY) {
            height = bottomY - topY;
        }
        int transparency = 256 - opacity;
        int red = (rgbColour >> 16 & 0xFF) * opacity;
        int green = (rgbColour >> 8 & 0xFF) * opacity;
        int blue = (rgbColour & 0xFF) * opacity;
        int leftOver = Rasterizer2D.width - width;
        int pixelIndex = leftX + topY * Rasterizer2D.width;
        for (int rowIndex = 0; rowIndex < height; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < width; ++columnIndex) {
                int otherRed = (pixels[pixelIndex] >> 16 & 0xFF) * transparency;
                int otherGreen = (pixels[pixelIndex] >> 8 & 0xFF) * transparency;
                int otherBlue = (pixels[pixelIndex] & 0xFF) * transparency;
                int transparentColour = (red + otherRed >> 8 << 16) + (green + otherGreen >> 8 << 8) + (blue + otherBlue >> 8);
                Rasterizer2D.drawAlpha(pixels, pixelIndex++, transparentColour, opacity);
            }
            pixelIndex += leftOver;
        }
    }

    public static void drawPixels(int height, int posY, int posX, int color, int width) {
        if (posX < leftX) {
            width -= leftX - posX;
            posX = leftX;
        }
        if (posY < topY) {
            height -= topY - posY;
            posY = topY;
        }
        if (posX + width > bottomX) {
            width = bottomX - posX;
        }
        if (posY + height > bottomY) {
            height = bottomY - posY;
        }
        int k1 = Rasterizer2D.width - width;
        int l1 = posX + posY * Rasterizer2D.width;
        for (int i2 = -height; i2 < 0; ++i2) {
            for (int j2 = -width; j2 < 0; ++j2) {
                Rasterizer2D.drawAlpha(pixels, l1++, color);
            }
            l1 += k1;
        }
    }

    public static void draw_rect_outline(int x, int y, int width, int height, int rgbColour) {
        Rasterizer2D.drawHorizontalLine(x, y, width, rgbColour);
        Rasterizer2D.drawHorizontalLine(x, y + height - 1, width, rgbColour);
        Rasterizer2D.drawVerticalLine(x, y, height, rgbColour);
        Rasterizer2D.drawVerticalLine(x + width - 1, y, height, rgbColour);
    }

    public static void drawHorizontalLine(int xPosition, int yPosition, int width, int rgbColour) {
        if (yPosition < topY || yPosition >= bottomY) {
            return;
        }
        if (xPosition < leftX) {
            width -= leftX - xPosition;
            xPosition = leftX;
        }
        if (xPosition + width > bottomX) {
            width = bottomX - xPosition;
        }
        int pixelIndex = xPosition + yPosition * Rasterizer2D.width;
        for (int i = 0; i < width; ++i) {
            Rasterizer2D.drawAlpha(pixels, pixelIndex + i, rgbColour, 255);
        }
    }

    public static void drawStroke(int xPos, int yPos, int width, int height, int color, int strokeWidth) {
        Rasterizer2D.drawVerticalStrokeLine(xPos, yPos, height, color, strokeWidth);
        Rasterizer2D.drawVerticalStrokeLine(xPos + width - strokeWidth, yPos, height, color, strokeWidth);
        Rasterizer2D.drawHorizontalStrokeLine(xPos, yPos, width, color, strokeWidth);
        Rasterizer2D.drawHorizontalStrokeLine(xPos, yPos + height - strokeWidth, width, color, strokeWidth);
    }

    public static void drawHorizontalStrokeLine(int xPos, int yPos, int w, int hexColor, int strokeWidth) {
        if (yPos < topY || yPos >= bottomY) {
            return;
        }
        if (xPos < leftX) {
            w -= leftX - xPos;
            xPos = leftX;
        }
        if (xPos + w > bottomX) {
            w = bottomX - xPos;
        }
        int index = xPos + yPos * width;
        int leftWidth = width - w;
        for (int x = 0; x < strokeWidth; ++x) {
            for (int y = 0; y < w; ++y) {
                Rasterizer2D.drawAlpha(pixels, index++, hexColor);
            }
            index += leftWidth;
        }
    }

    public static void drawVerticalStrokeLine(int xPosition, int yPosition, int height, int hexColor, int strokeWidth) {
        if (xPosition < leftX || xPosition >= bottomX) {
            return;
        }
        if (yPosition < topY) {
            height -= topY - yPosition;
            yPosition = topY;
        }
        if (yPosition + height > bottomY) {
            height = bottomY - yPosition;
        }
        int pixelIndex = xPosition + yPosition * width;
        for (int rowIndex = 0; rowIndex < height; ++rowIndex) {
            for (int x = 0; x < strokeWidth; ++x) {
                Rasterizer2D.drawAlpha(pixels, pixelIndex + x + rowIndex * width, hexColor);
            }
        }
    }

    public static void drawVerticalLine(int xPosition, int yPosition, int height, int rgbColour) {
        if (xPosition < leftX || xPosition >= bottomX) {
            return;
        }
        if (yPosition < topY) {
            height -= topY - yPosition;
            yPosition = topY;
        }
        if (yPosition + height > bottomY) {
            height = bottomY - yPosition;
        }
        int pixelIndex = xPosition + yPosition * width;
        for (int rowIndex = 0; rowIndex < height; ++rowIndex) {
            Rasterizer2D.drawAlpha(pixels, pixelIndex + rowIndex * width, rgbColour, 255);
        }
    }

    public static void drawHorizontalLine(int x, int y, int length, int color, int alpha) {
        if (y < topY || y >= bottomY) {
            return;
        }
        if (x < leftX) {
            length -= leftX - x;
            x = leftX;
        }
        if (x + length > bottomX) {
            length = bottomX - x;
        }
        int j1 = 256 - alpha;
        int k1 = (color >> 16 & 0xFF) * alpha;
        int l1 = (color >> 8 & 0xFF) * alpha;
        int i2 = (color & 0xFF) * alpha;
        int i3 = x + y * width;
        for (int j3 = 0; j3 < length; ++j3) {
            int j2 = (pixels[i3] >> 16 & 0xFF) * j1;
            int k2 = (pixels[i3] >> 8 & 0xFF) * j1;
            int l2 = (pixels[i3] & 0xFF) * j1;
            int k3 = (k1 + j2 >> 8 << 16) + (l1 + k2 >> 8 << 8) + (i2 + l2 >> 8);
            Rasterizer2D.drawAlpha(pixels, i3++, k3, alpha);
        }
    }

    public static void draw_line(int i, int j, int k, int l) {
        if (i < topY || i >= bottomY) {
            return;
        }
        if (l < leftX) {
            k -= leftX - l;
            l = leftX;
        }
        if (l + k > bottomX) {
            k = bottomX - l;
        }
        int i1 = l + i * width;
        for (int j1 = 0; j1 < k; ++j1) {
            Rasterizer2D.drawAlpha(pixels, i1 + j1, j, 255);
        }
    }

    public static void drawAlphaBox(int x, int y, int lineWidth, int lineHeight, int color, int alpha) {
        Rasterizer2D.drawTransparentBox(x, y, lineWidth, lineHeight, color, alpha);
    }

    public static void drawTransparentBoxOutline(int leftX, int topY, int width, int height, int rgbColour, int opacity) {
        Rasterizer2D.drawTransparentHorizontalLine(leftX, topY, width, rgbColour, opacity);
        Rasterizer2D.drawTransparentHorizontalLine(leftX, topY + height - 1, width, rgbColour, opacity);
        if (height >= 3) {
            Rasterizer2D.drawTransparentVerticalLine(leftX, topY + 1, height - 2, rgbColour, opacity);
            Rasterizer2D.drawTransparentVerticalLine(leftX + width - 1, topY + 1, height - 2, rgbColour, opacity);
        }
    }

    public static void drawTransparentHorizontalLine(int xPosition, int yPosition, int width, int rgbColour, int opacity) {
        if (yPosition < topY || yPosition >= bottomY) {
            return;
        }
        if (xPosition < leftX) {
            width -= leftX - xPosition;
            xPosition = leftX;
        }
        if (xPosition + width > bottomX) {
            width = bottomX - xPosition;
        }
        int transparency = 256 - opacity;
        int red = (rgbColour >> 16 & 0xFF) * opacity;
        int green = (rgbColour >> 8 & 0xFF) * opacity;
        int blue = (rgbColour & 0xFF) * opacity;
        int pixelIndex = xPosition + yPosition * Rasterizer2D.width;
        for (int i = 0; i < width; ++i) {
            int otherRed = (pixels[pixelIndex] >> 16 & 0xFF) * transparency;
            int otherGreen = (pixels[pixelIndex] >> 8 & 0xFF) * transparency;
            int otherBlue = (pixels[pixelIndex] & 0xFF) * transparency;
            int transparentColour = (red + otherRed >> 8 << 16) + (green + otherGreen >> 8 << 8) + (blue + otherBlue >> 8);
            Rasterizer2D.drawAlpha(pixels, pixelIndex, transparentColour, opacity);
        }
    }

    public static void drawTransparentVerticalLine(int xPosition, int yPosition, int height, int rgbColour, int opacity) {
        if (xPosition < leftX || xPosition >= bottomX) {
            return;
        }
        if (yPosition < topY) {
            height -= topY - yPosition;
            yPosition = topY;
        }
        if (yPosition + height > bottomY) {
            height = bottomY - yPosition;
        }
        int transparency = 256 - opacity;
        int red = (rgbColour >> 16 & 0xFF) * opacity;
        int green = (rgbColour >> 8 & 0xFF) * opacity;
        int blue = (rgbColour & 0xFF) * opacity;
        int pixelIndex = xPosition + yPosition * width;
        for (int i = 0; i < height; ++i) {
            int otherRed = (pixels[pixelIndex] >> 16 & 0xFF) * transparency;
            int otherGreen = (pixels[pixelIndex] >> 8 & 0xFF) * transparency;
            int otherBlue = (pixels[pixelIndex] & 0xFF) * transparency;
            int transparentColour = (red + otherRed >> 8 << 16) + (green + otherGreen >> 8 << 8) + (blue + otherBlue >> 8);
            Rasterizer2D.drawAlpha(pixels, pixelIndex, transparentColour, opacity);
            pixelIndex += width;
        }
    }

    public static void drawRectangle(int x, int y, int width, int height, int color, int alpha) {
        Rasterizer2D.drawHorizontalLine(x, y, width, color, alpha);
        Rasterizer2D.drawHorizontalLine(x, y + height - 1, width, color, alpha);
        if (height >= 3) {
            Rasterizer2D.drawVerticalLine(x, y + 1, height - 2, color, alpha);
            Rasterizer2D.drawVerticalLine(x + width - 1, y + 1, height - 2, color, alpha);
        }
    }

    public static void drawVerticalLine(int x, int y, int length, int color, int alpha) {
        if (x < leftX || x >= bottomX) {
            return;
        }
        if (y < topY) {
            length -= topY - y;
            y = topY;
        }
        if (y + length > bottomY) {
            length = bottomY - y;
        }
        int j1 = 256 - alpha;
        int k1 = (color >> 16 & 0xFF) * alpha;
        int l1 = (color >> 8 & 0xFF) * alpha;
        int i2 = (color & 0xFF) * alpha;
        int i3 = x + y * width;
        for (int j3 = 0; j3 < length; ++j3) {
            int j2 = (pixels[i3] >> 16 & 0xFF) * j1;
            int k2 = (pixels[i3] >> 8 & 0xFF) * j1;
            int l2 = (pixels[i3] & 0xFF) * j1;
            int k3 = (k1 + j2 >> 8 << 16) + (l1 + k2 >> 8 << 8) + (i2 + l2 >> 8);
            Rasterizer2D.drawAlpha(pixels, i3, k3, alpha);
            i3 += width;
        }
    }

    public static void fillRectangle(int x, int y, int w, int h2, int color) {
        if (x < leftX) {
            w -= leftX - x;
            x = leftX;
        }
        if (y < topY) {
            h2 -= topY - y;
            y = topY;
        }
        if (x + w > bottomX) {
            w = bottomX - x;
        }
        if (y + h2 > bottomY) {
            h2 = bottomY - y;
        }
        int k1 = width - w;
        int l1 = x + y * width;
        for (int i2 = -h2; i2 < 0; ++i2) {
            for (int j2 = -w; j2 < 0; ++j2) {
                Rasterizer2D.drawAlpha(pixels, l1++, color);
            }
            l1 += k1;
        }
    }

    public static void fillRectangle(int x, int y, int w, int h2, int color, int alpha) {
        if (x < leftX) {
            w -= leftX - x;
            x = leftX;
        }
        if (y < topY) {
            h2 -= topY - y;
            y = topY;
        }
        if (x + w > bottomX) {
            w = bottomX - x;
        }
        if (y + h2 > bottomY) {
            h2 = bottomY - y;
        }
        int a2 = 256 - alpha;
        int r1 = (color >> 16 & 0xFF) * alpha;
        int g1 = (color >> 8 & 0xFF) * alpha;
        int b1 = (color & 0xFF) * alpha;
        int k3 = width - w;
        int pixel = x + y * width;
        for (int i4 = 0; i4 < h2; ++i4) {
            for (int j4 = -w; j4 < 0; ++j4) {
                int r2 = (pixels[pixel] >> 16 & 0xFF) * a2;
                int g2 = (pixels[pixel] >> 8 & 0xFF) * a2;
                int b2 = (pixels[pixel] & 0xFF) * a2;
                int rgb = (r1 + r2 >> 8 << 16) + (g1 + g2 >> 8 << 8) + (b1 + b2 >> 8);
                Rasterizer2D.drawAlpha(pixels, pixel++, rgb, alpha);
            }
            pixel += k3;
        }
    }

    public static void draw_rectangle_outline(int x, int y, int line_width, int line_height, int color) {
        Rasterizer2D.draw_rect_outline(x, y, line_width, line_height, color);
    }

    public static void draw_vertical_line1(int x, int y, int line_width, int color) {
        Rasterizer2D.drawVerticalLine(x, y, line_width, color);
    }

    public static void draw_horizontal_line1(int x, int y, int line_height, int color) {
        Rasterizer2D.drawHorizontalLine(x, y, line_height, color);
    }

    static {
        topY = 0;
        bottomY = 0;
        leftX = 0;
        bottomX = 0;
    }
}

