/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.draw.flames;

import java.time.Instant;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Random;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;

public enum FlameImages {
    BAT(1919, FlameImages::isHalloween),
    PUMPKIN(1920, FlameImages::isHalloween),
    SKULL(1921, FlameImages::isHalloween),
    MOON(1922, FlameImages::isHalloween),
    SNOWFLAKE(1923, FlameImages::isChristmas),
    HOLLY(1924, FlameImages::isChristmas),
    SNOWMAN(1925, FlameImages::isChristmas),
    ANGEL(1926, FlameImages::isChristmas),
    FIRE_RUNE(1927, FlameImages::isNotHoliday),
    WATER_RUNE(1928, FlameImages::isNotHoliday),
    EARTH_RUNE(1929, FlameImages::isNotHoliday),
    AIR_RUNE(1930, FlameImages::isNotHoliday),
    BODY_RUNE(1931, FlameImages::isNotHoliday),
    WRATH_RUNE(1932, FlameImages::isNotHoliday),
    CHAOS_RUNE(1933, FlameImages::isNotHoliday),
    COSMIC_RUNE(1934, FlameImages::isNotHoliday),
    NATURE_RUNE(1935, FlameImages::isNotHoliday),
    LAW_RUNE(1936, FlameImages::isNotHoliday),
    DEATH_RUNE(1937, FlameImages::isNotHoliday),
    SOUL_RUNE(1938, FlameImages::isNotHoliday);

    private final int id;
    private final BooleanSupplier active;
    private static final int currentYear;
    private static List<FlameImages> flameImages;

    public int getId() {
        return this.id;
    }

    private FlameImages(int id, BooleanSupplier active) {
        this.id = id;
        this.active = active;
    }

    public static boolean isNotHoliday() {
        return !FlameImages.isChristmas() && !FlameImages.isHalloween();
    }

    public static boolean isHalloween() {
        Date dateStart = new GregorianCalendar(currentYear, 9, 21).getTime();
        Date dateEnd = new GregorianCalendar(currentYear, 10, 11).getTime();
        return FlameImages.isWithinRange(dateStart, dateEnd);
    }

    public static boolean isChristmas() {
        Date dateStart = new GregorianCalendar(currentYear, 10, 21).getTime();
        Date dateEnd = new GregorianCalendar(currentYear, 0, 5).getTime();
        return FlameImages.isWithinRange(dateStart, dateEnd);
    }

    private static boolean isWithinRange(Date startDate, Date endDate) {
        Date currentDate = Date.from(Instant.now());
        return !currentDate.before(startDate) && !currentDate.after(endDate);
    }

    public static int getRandomImage() {
        if (flameImages.isEmpty()) {
            flameImages = Arrays.stream(FlameImages.values()).filter(image -> image.active != null && image.active.getAsBoolean()).collect(Collectors.toList());
        }
        return FlameImages.flameImages.get((int)new Random().nextInt((int)FlameImages.flameImages.size())).id;
    }

    static {
        currentYear = Calendar.getInstance().get(1);
        flameImages = Collections.emptyList();
    }
}

